(ns orcl.naive.lib
  (:require [orcl.naive.impl :as impl]
            [orcl.naive.vars :as vars]
    #?(:clj
            [orcl.naive.macro :as macro :refer [defsite sfn]]))
  #?(:cljs (:require-macros
             [orcl.naive.macro :as macro :refer [defsite sfn]])))

(defsite Let (sfn [& args]
                  (case (count args)
                    0 ::impl/signal
                    1 (first args)
                    (vec args))))

(defsite Ift (sfn [x] (if x ::impl/signal ::impl/halt)))

(defsite Iff (sfn [x] (if-not x ::impl/signal ::impl/halt)))

(defsite ^{:site "+"} plus (sfn [a b] (cond
                                        (string? a) (str a b)
                                        (map? a) (merge a b)
                                        :else (+ a b))))
(defsite ^{:site "-"} minus (impl/site-call -))
(defsite ^{:site "0-"} negative (sfn [x] (- x)))
(defsite ^{:site "*"} mult (sfn [a b] (* a b)))
(defsite ^{:site "**"} pow (sfn [base pow] #?(:clj  (Math/pow base pow)
                                              :cljs (.pow js/Math base pow))))
(defsite ^{:site "/"} div (sfn [a b] (/ a b)))
(defsite ^{:site "%"} rem-op (sfn [a b] (rem a b)))
(defsite ^{:site "<:"} less (sfn [a b] (< a b)))
(defsite ^{:site "<="} less-or-eq (sfn [a b] (<= a b)))
(defsite ^{:site ":>"} greater (sfn [a b] (> a b)))
(defsite ^{:site ">="} greater-or-eq (sfn [a b] (>= a b)))
(defsite ^{:site "="} eq (sfn [a b] (= a b)))
(defsite ^{:site "/="} not-eq (sfn [a b] (not= a b)))
(defsite ^{:site "~"} not-op (sfn [a] (not a)))
(defsite ^{:site "&&"} and-op (sfn [a b] (and a b)))
(defsite ^{:site "||"} or-op (sfn [a b] (or a b)))
(defsite ^{:site ":"} cons-op (sfn [x xs] (cons x xs)))

;;  All father stuff should be implemented in stdlib

;(defsite abs (sfn [x] (if (< x 0) (- x) x)))
;(defsite signum (sfn [x] (cond
;                           (< x 0) -1
;                           (= x 0) 0
;                           :else 1)))
;(defsite ^{:site "min"} min-op (sfn [a b] (min a b)))
;(defsite ^{:site "max"} max-op (sfn [a b] (max a b)))
(defsite floor (sfn [x] #?(:clj (long (Math/floor x)) :cljs (.floor js/Math x))))
(defsite ceil (sfn [x] #?(:clj (long (Math/ceil x)) :cljs (.ceil js/Math x))))
(defsite sqrt (sfn [x] (if (< x 0)
                         ::impl/halt
                         #?(:clj (Math/sqrt x) :cljs (.sqrt js/Math x)))))
;(defsite curry (sfn [f] (sfn [x] (fn [y] (f x y)))))
;(defsite curry3 (sfn [f] (sfn [x] (sfn [y] (fn [z] (f x y z))))))
;(defsite uncurry (sfn [f] (fn [x y] ((first (f x)) y))))
;(defsite flip (sfn [f] (fn [x y] (f y x))))
;(defsite constant (sfn [x] (sfn [] x)))
;(defsite ^{:site "defer"} defer-op (sfn [f x] (fn [] (f x))))
;(defsite defer2 (sfn [f x y] (fn [] (f x y))))
;(defsite ignore (sfn [f] (fn [_] (f))))
;(defsite ignore2 (sfn [f] (fn [_ _] (f))))
;(defsite compose (sfn [f g] (fn [x] (f (first (g x))))))
;(defsite ^{:site "while"} while-op
;         (sfn [p f]
;           (fn [x]
;             (loop [[v & tail :as res] (list x)]
;               (let [v1 (first (p v))]
;                 (cond
;                   (= ::impl/pending v1) (conj res ::impl/pending)
;                   v1 (let [v2 (first (f v))]
;                        (if (= ::impl/pending v2)
;                          (reverse (cons ::impl/pending res))
;                          (recur (cons v2 res))))
;                   :else (reverse tail)))))))


(defsite Coeffect
         (sfn [definition]
              (macro/with-counter c
                (let [c' (str c)
                      x (get-in vars/*state* [:realized c'] ::not-found)]
                  (if (= ::not-found x)
                    (do
                      (swap! (:coeffects vars/*state*) conj [c' definition])
                      ::impl/pending)
                    x)))))

(defsite Cell
         (sfn []
              (macro/with-counter c
                {"read"  (sfn [] (impl/internal-block c))
                 "readD" (sfn [] (let [v (get @(:internal vars/*state*) c ::not-found)]
                                   (if (and (= ::not-found v) (= ::impl/pending v))
                                     ::impl/halt
                                     v)))
                 "write" (sfn [v]
                              (let [x (get @(:internal vars/*state*) c ::not-found)]
                                (if (or (= ::not-found x) (= ::impl/pending x))
                                  (do (impl/internal-unblock c v)
                                      ::impl/signal)
                                  ::impl/halt)))})))

(defsite Println (sfn [x] (prn x) ::impl/signal))

(def prelude
  (into {} (for [x (keys @vars/prelude)] [x {:type :site :source {:type :prelude} :definition x}])))