(ns orcl.naive.macro
  (:require [orcl.naive.vars :as vars]))

(defmacro with-counter [binding & body]
  `(let [~binding @(:counter vars/*state*)
         res# (do ~@body)]
     (swap! (:counter vars/*state*) inc)
     res#))

(defmacro defsite [n f]
  `(do
     (def ~n ~f)
     (swap! vars/prelude assoc ~(get (meta n) :site (str n)) ~n)))