(ns orcl.naive.lib
  (:require [orcl.naive.impl :as impl]
            [orcl.naive.vars :as vars]
    #?(:clj
            [orcl.naive.macro :refer [defsite]])
    #?(:clj
            [orcl.naive.macro :as macro]))
  #?(:cljs (:require-macros
             [orcl.naive.macro :refer [defsite]]
             [orcl.naive.macro :as macro])))

(defsite Let (fn
               ([] ::signal)
               ([x] x)
               ([x & xs] (vec (cons x xs)))))

(defsite Ift (fn [x] (if x ::impl/signal ::impl/halt)))

(defsite Iff (fn [x] (if-not x ::impl/signal ::impl/halt)))

(defsite ^{:site "+"} plus (fn [a b] (cond
                                       (string? a) (str a b)
                                       (map? a) (merge a b)
                                       :else (+ a b))))
(defsite ^{:site "-"} minus -)
(defsite ^{:site "0-"} negative -)
(defsite ^{:site "*"} mult *)
(defsite ^{:site "**"} pow (fn [base pow] #?(:clj  (Math/pow base pow)
                                             :cljs (.pow js/Math base pow))))
(defsite ^{:site "/"} div /)
(defsite ^{:site "%"} rem-op rem)
(defsite ^{:site "<:"} less <)
(defsite ^{:site "<="} less-or-eq <=)
(defsite ^{:site ":>"} greater >)
(defsite ^{:site ">="} greater-or-eq >=)
(defsite ^{:site "="} eq =)
(defsite ^{:site "/="} eq not=)
(defsite ^{:site "~"} eq not)
(defsite ^{:site "&&"} and-op (fn [a b] (and a b)))
(defsite ^{:site "||"} or-op (fn [a b] (or a b)))
(defsite ^{:site ":"} cons-op cons)

(defsite Coeffect
  (fn [definition]
    (macro/with-counter c
      (let [x (get-in vars/*state* [:realized c] ::not-found)]
        (if (= ::not-found x)
          (do
            (swap! (:coeffects vars/*state*) conj [c definition])
            ::impl/pending)
          x)))))

(defsite Cell
  (fn []
    (macro/with-counter c
      {"read"  (fn [] [(impl/internal-block c)])
       "readD" (fn [] (let [v (get @(:internal vars/*state*) c ::not-found)]
                        (when-not (and (= ::not-found v) (= ::impl/pending v))
                          v)))
       "write" (fn [v]
                 (let [x (get @(:internal vars/*state*) c ::not-found)]
                   (if (or (= ::not-found x) (= ::impl/pending x))
                     (do (impl/internal-unblock c v)
                         [::impl/signal])
                     nil)))})))

(defsite Println (fn [x] (prn x) ::impl/signal))