/*
 * Decompiled with CFR 0.152.
 */
package orc.values.sites.compatibility;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import orc.error.runtime.ArgumentTypeMismatchException;
import orc.error.runtime.ArityMismatchException;
import orc.error.runtime.InsufficientArgsException;
import orc.error.runtime.JavaException;
import orc.values.Field;

public class Args
implements Serializable {
    private static final long serialVersionUID = -5096125972360848153L;
    Object[] values;

    public Args(List<Object> values) {
        this.values = new Object[values.size()];
        this.values = values.toArray(this.values);
    }

    public int size() {
        return this.values.length;
    }

    public String fieldName() throws ArityMismatchException, ArgumentTypeMismatchException {
        if (this.values.length != 1) {
            throw new ArityMismatchException(1, this.values.length);
        }
        Object v = this.values[0];
        if (v == null) {
            throw new ArgumentTypeMismatchException(0, "message", "null");
        }
        if (v instanceof Field) {
            return ((Field)v).field();
        }
        throw new ArgumentTypeMismatchException(0, "message", v != null ? v.getClass().toString() : "null");
    }

    public Object getArg(int n) throws InsufficientArgsException {
        try {
            return this.values[n];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InsufficientArgsException(n, this.values.length);
        }
    }

    public Object[] asArray() {
        return this.values;
    }

    public int intArg(int n) throws ArgumentTypeMismatchException, InsufficientArgsException {
        Object a = this.getArg(n);
        if (a == null) {
            throw new ArgumentTypeMismatchException(n, "32-bit signed integer", "null");
        }
        try {
            return ((Number)a).intValue();
        }
        catch (ClassCastException e) {
            throw new ArgumentTypeMismatchException(n, "32-bit signed integer", a != null ? a.getClass().toString() : "null");
        }
    }

    public long longArg(int n) throws ArgumentTypeMismatchException, InsufficientArgsException {
        Object a = this.getArg(n);
        if (a == null) {
            throw new ArgumentTypeMismatchException(n, "64-bit signed integer", "null");
        }
        try {
            return ((Number)a).longValue();
        }
        catch (ClassCastException e) {
            throw new ArgumentTypeMismatchException(n, "64-bit signed integer", a != null ? a.getClass().toString() : "null");
        }
    }

    public Number numberArg(int n) throws ArgumentTypeMismatchException, InsufficientArgsException {
        Object a = this.getArg(n);
        if (a == null) {
            throw new ArgumentTypeMismatchException(n, "Number", "null");
        }
        try {
            return (Number)a;
        }
        catch (ClassCastException e) {
            throw new ArgumentTypeMismatchException(n, "Number", a != null ? a.getClass().toString() : "null");
        }
    }

    public boolean boolArg(int n) throws ArgumentTypeMismatchException, InsufficientArgsException {
        Object a = this.getArg(n);
        if (a == null) {
            throw new ArgumentTypeMismatchException(n, "boolean", "null");
        }
        try {
            return (Boolean)a;
        }
        catch (ClassCastException e) {
            throw new ArgumentTypeMismatchException(n, "boolean", a != null ? a.getClass().toString() : "null");
        }
    }

    public String stringArg(int n) throws ArgumentTypeMismatchException, InsufficientArgsException {
        Object a = this.getArg(n);
        if (a == null) {
            throw new ArgumentTypeMismatchException(n, "String", "null");
        }
        try {
            return (String)a;
        }
        catch (ClassCastException e) {
            throw new ArgumentTypeMismatchException(n, "String", a != null ? a.getClass().toString() : "null");
        }
    }

    public static <T> T applyNumericOperator(Number a, Number b, NumericBinaryOperator<T> op) throws JavaException {
        try {
            if (a instanceof BigDecimal) {
                if (b instanceof BigDecimal) {
                    return op.apply((BigDecimal)a, (BigDecimal)b);
                }
                String bStr = b.toString();
                if (bStr.equals("Infinity") || bStr.equals("-Infinity") || bStr.equals("NaN")) {
                    return op.apply(a.doubleValue(), b.doubleValue());
                }
                return op.apply((BigDecimal)a, new BigDecimal(bStr));
            }
            if (b instanceof BigDecimal) {
                if (a instanceof BigDecimal) {
                    return op.apply((BigDecimal)a, (BigDecimal)b);
                }
                String aStr = a.toString();
                if (aStr.equals("Infinity") || aStr.equals("-Infinity") || aStr.equals("NaN")) {
                    return op.apply(a.doubleValue(), b.doubleValue());
                }
                return op.apply(new BigDecimal(a.toString()), (BigDecimal)b);
            }
            if (a instanceof Double || b instanceof Double) {
                return op.apply(a.doubleValue(), b.doubleValue());
            }
            if (a instanceof Float || b instanceof Float) {
                return op.apply(a.floatValue(), b.floatValue());
            }
            if (a instanceof BigInteger) {
                if (b instanceof BigInteger) {
                    return op.apply((BigInteger)a, (BigInteger)b);
                }
                return op.apply((BigInteger)a, new BigInteger(b.toString()));
            }
            if (b instanceof BigInteger) {
                if (a instanceof BigInteger) {
                    return op.apply((BigInteger)a, (BigInteger)b);
                }
                return op.apply(new BigInteger(a.toString()), (BigInteger)b);
            }
            if (a instanceof Long || b instanceof Long) {
                return op.apply(a.longValue(), b.longValue());
            }
            if (a instanceof Integer || b instanceof Integer) {
                return op.apply(a.intValue(), b.intValue());
            }
            if (a instanceof Short || b instanceof Short) {
                return op.apply(a.shortValue(), b.shortValue());
            }
            if (a instanceof Byte || b instanceof Byte) {
                return op.apply(a.byteValue(), b.byteValue());
            }
            throw new JavaException(new IllegalArgumentException("Unexpected Number type in (" + (a != null ? a.getClass().toString() : "null") + ", " + (b != null ? b.getClass().toString() : "null") + ")"));
        }
        catch (ArithmeticException e) {
            throw new JavaException(e);
        }
    }

    public static <T> T applyNumericOperator(Number a, NumericUnaryOperator<T> op) throws JavaException {
        if (a instanceof BigDecimal) {
            return op.apply((BigDecimal)a);
        }
        if (a instanceof Double) {
            return op.apply(a.doubleValue());
        }
        if (a instanceof Float) {
            return op.apply(a.floatValue());
        }
        if (a instanceof BigInteger) {
            return op.apply((BigInteger)a);
        }
        if (a instanceof Long) {
            return op.apply(a.longValue());
        }
        if (a instanceof Integer) {
            return op.apply(a.intValue());
        }
        if (a instanceof Short) {
            return op.apply(a.shortValue());
        }
        if (a instanceof Byte) {
            return op.apply(a.byteValue());
        }
        throw new JavaException(new IllegalArgumentException("Unexpected Number type in (" + (a != null ? a.getClass().toString() : "null") + ")"));
    }

    public static interface NumericBinaryOperator<T> {
        public T apply(BigInteger var1, BigInteger var2);

        public T apply(BigDecimal var1, BigDecimal var2);

        public T apply(int var1, int var2);

        public T apply(long var1, long var3);

        public T apply(byte var1, byte var2);

        public T apply(short var1, short var2);

        public T apply(double var1, double var3);

        public T apply(float var1, float var2);
    }

    public static interface NumericUnaryOperator<T> {
        public T apply(BigInteger var1);

        public T apply(BigDecimal var1);

        public T apply(int var1);

        public T apply(long var1);

        public T apply(byte var1);

        public T apply(short var1);

        public T apply(double var1);

        public T apply(float var1);
    }
}

