/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.state;

import java.util.LinkedList;
import orc.Handle;
import orc.error.runtime.TokenException;
import orc.lib.state.types.SyncChannelType;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.DotSite;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.SiteAdaptor;

public class SyncChannel
extends EvalSite
implements TypedSite {
    @Override
    public Object evaluate(Args args) {
        return new SyncChannelInstance();
    }

    @Override
    public Type orcType() {
        return SyncChannelType.getBuilder();
    }

    private class SenderItem {
        Handle sender;
        Object sent;

        SenderItem(Handle sender, Object sent) {
            this.sender = sender;
            this.sent = sent;
        }
    }

    protected class SyncChannelInstance
    extends DotSite {
        protected final LinkedList<SenderItem> senderQueue = new LinkedList();
        protected final LinkedList<Handle> receiverQueue = new LinkedList();

        SyncChannelInstance() {
        }

        @Override
        protected void addMembers() {
            this.addMember("get", new getMethod());
            this.addMember("put", new putMethod());
        }

        protected class getMethod
        extends SiteAdaptor {
            protected getMethod() {
            }

            @Override
            public void callSite(Args args, Handle receiver) {
                if (SyncChannelInstance.this.senderQueue.isEmpty()) {
                    receiver.setQuiescent();
                    SyncChannelInstance.this.receiverQueue.addLast(receiver);
                } else {
                    SenderItem si = SyncChannelInstance.this.senderQueue.removeFirst();
                    Handle sender = si.sender;
                    Object item = si.sent;
                    receiver.publish(getMethod.object2value(item));
                    sender.publish(getMethod.signal());
                }
            }
        }

        protected class putMethod
        extends SiteAdaptor {
            protected putMethod() {
            }

            @Override
            public void callSite(Args args, Handle sender) throws TokenException {
                Object item = args.getArg(0);
                if (SyncChannelInstance.this.receiverQueue.isEmpty()) {
                    sender.setQuiescent();
                    SyncChannelInstance.this.senderQueue.addLast(new SenderItem(sender, item));
                } else {
                    Handle receiver = SyncChannelInstance.this.receiverQueue.removeFirst();
                    receiver.publish(putMethod.object2value(item));
                    sender.publish(putMethod.signal());
                }
            }
        }
    }
}

