/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.state;

import java.lang.reflect.Array;
import java.util.HashMap;
import orc.error.runtime.ArityMismatchException;
import orc.error.runtime.BadArrayElementTypeException;
import orc.error.runtime.TokenException;
import orc.lib.state.types.ArrayType;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.EvalSite;

public class JavaArray
extends EvalSite
implements TypedSite {
    private static HashMap<String, Class<?>> types = new HashMap();

    static {
        types.put("double", Double.TYPE);
        types.put("float", Float.TYPE);
        types.put("long", Long.TYPE);
        types.put("int", Integer.TYPE);
        types.put("short", Short.TYPE);
        types.put("byte", Byte.TYPE);
        types.put("char", Character.TYPE);
        types.put("boolean", Boolean.TYPE);
    }

    @Override
    public Object evaluate(Args args) throws TokenException {
        if (args.size() == 1) {
            return Array.newInstance(Object.class, args.intArg(0));
        }
        if (args.size() == 2) {
            Class<?> type = types.get(args.stringArg(1));
            if (type == null) {
                throw new BadArrayElementTypeException(args.stringArg(0));
            }
            return Array.newInstance(type, args.intArg(0));
        }
        throw new ArityMismatchException(2, args.size());
    }

    @Override
    public Type orcType() {
        return ArrayType.getBuilder();
    }
}

