/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.state;

import java.math.BigDecimal;
import java.util.LinkedList;
import orc.Handle;
import orc.error.runtime.ArityMismatchException;
import orc.error.runtime.TokenException;
import orc.lib.state.types.CounterType;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.DotSite;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.PartialSite;
import orc.values.sites.compatibility.SiteAdaptor;

public class Counter
extends EvalSite
implements TypedSite {
    @Override
    public Object evaluate(Args args) throws TokenException {
        int init;
        int n = init = args.size() == 0 ? 0 : args.intArg(0);
        if (args.size() > 1) {
            throw new ArityMismatchException(1, args.size());
        }
        return new DotSite(init){
            protected int count;
            protected final LinkedList<Handle> waiters;
            {
                this.count = n;
                this.waiters = new LinkedList();
            }

            @Override
            protected void addMembers() {
                this.addMember("inc", new EvalSite(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object evaluate(Args args) throws TokenException {
                        Counter counter = Counter.this;
                        synchronized (counter) {
                            ++count;
                        }
                        return 1.signal();
                    }
                });
                this.addMember("dec", new PartialSite(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object evaluate(Args args) throws TokenException {
                        Counter counter = Counter.this;
                        synchronized (counter) {
                            if (count > 0) {
                                --count;
                                if (count == 0) {
                                    for (Handle waiter : waiters) {
                                        waiter.publish(2.signal());
                                    }
                                    waiters.clear();
                                }
                                return 2.signal();
                            }
                            return null;
                        }
                    }
                });
                this.addMember("onZero", new SiteAdaptor(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void callSite(Args args, Handle caller) throws TokenException {
                        Counter counter = Counter.this;
                        synchronized (counter) {
                            if (count == 0) {
                                caller.publish(3.signal());
                            } else {
                                caller.setQuiescent();
                                waiters.add(caller);
                            }
                        }
                    }
                });
                this.addMember("value", new EvalSite(){

                    @Override
                    public Object evaluate(Args args) throws TokenException {
                        return BigDecimal.valueOf(count);
                    }
                });
            }
        };
    }

    @Override
    public Type orcType() {
        return CounterType.getBuilder();
    }
}

