/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.state;

import java.util.LinkedList;
import orc.Handle;
import orc.error.runtime.ArityMismatchException;
import orc.error.runtime.TokenException;
import orc.lib.state.types.ChannelType;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.DotSite;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.SiteAdaptor;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;

public class Channel
extends EvalSite
implements TypedSite {
    @Override
    public Object evaluate(Args args) throws TokenException {
        if (args.size() == 0) {
            return new ChannelInstance();
        }
        throw new ArityMismatchException(0, args.size());
    }

    @Override
    public Type orcType() {
        return ChannelType.getBuilder();
    }

    protected class ChannelInstance
    extends DotSite {
        protected final LinkedList<Object> contents = new LinkedList();
        protected final LinkedList<Handle> readers = new LinkedList();
        protected Handle closer;
        protected boolean closed = false;

        ChannelInstance() {
        }

        @Override
        protected void addMembers() {
            this.addMember("get", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle reader) {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        if (ChannelInstance.this.contents.isEmpty()) {
                            if (ChannelInstance.this.closed) {
                                reader.halt();
                            } else {
                                reader.setQuiescent();
                                ChannelInstance.this.readers.addLast(reader);
                            }
                        } else {
                            reader.publish(1.object2value(ChannelInstance.this.contents.removeFirst()));
                            if (ChannelInstance.this.closer != null && ChannelInstance.this.contents.isEmpty()) {
                                ChannelInstance.this.closer.publish(1.signal());
                                ChannelInstance.this.closer = null;
                            }
                        }
                    }
                }
            });
            this.addMember("put", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle writer) throws TokenException {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        Object item = args.getArg(0);
                        if (ChannelInstance.this.closed) {
                            writer.halt();
                            return;
                        }
                        if (ChannelInstance.this.readers.isEmpty()) {
                            ChannelInstance.this.contents.addLast(item);
                        } else {
                            Handle receiver = ChannelInstance.this.readers.removeFirst();
                            receiver.publish(2.object2value(item));
                        }
                        writer.publish(2.signal());
                    }
                }
            });
            this.addMember("getD", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle reader) {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        if (ChannelInstance.this.contents.isEmpty()) {
                            reader.halt();
                        } else {
                            reader.publish(3.object2value(ChannelInstance.this.contents.removeFirst()));
                            if (ChannelInstance.this.closer != null && ChannelInstance.this.contents.isEmpty()) {
                                ChannelInstance.this.closer.publish(3.signal());
                                ChannelInstance.this.closer = null;
                            }
                        }
                    }
                }
            });
            this.addMember("getAll", new EvalSite(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object evaluate(Args args) throws TokenException {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        List out = JavaConversions.collectionAsScalaIterable(ChannelInstance.this.contents).toList();
                        ChannelInstance.this.contents.clear();
                        if (ChannelInstance.this.closer != null) {
                            ChannelInstance.this.closer.publish(4.signal());
                            ChannelInstance.this.closer = null;
                        }
                        return out;
                    }
                }
            });
            this.addMember("isClosed", new EvalSite(){

                @Override
                public Object evaluate(Args args) throws TokenException {
                    return ChannelInstance.this.closed;
                }
            });
            this.addMember("close", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle caller) {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        ChannelInstance.this.closed = true;
                        for (Handle reader : ChannelInstance.this.readers) {
                            reader.halt();
                        }
                        if (ChannelInstance.this.contents.isEmpty()) {
                            caller.publish(6.signal());
                        } else {
                            ChannelInstance.this.closer = caller;
                            ChannelInstance.this.closer.setQuiescent();
                        }
                    }
                }
            });
            this.addMember("closeD", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle caller) {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        ChannelInstance.this.closed = true;
                        for (Handle reader : ChannelInstance.this.readers) {
                            reader.halt();
                        }
                        caller.publish(7.signal());
                    }
                }
            });
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + this.contents.toString();
        }
    }
}

