/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.state;

import java.util.LinkedList;
import java.util.Queue;
import orc.Handle;
import orc.error.runtime.ArityMismatchException;
import orc.error.runtime.TokenException;
import orc.lib.state.types.CellType;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.DotSite;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.SiteAdaptor;

public class Cell
extends EvalSite
implements TypedSite {
    @Override
    public Object evaluate(Args args) throws TokenException {
        if (args.size() == 0) {
            return new CellInstance();
        }
        throw new ArityMismatchException(0, args.size());
    }

    @Override
    public Type orcType() {
        return CellType.getBuilder();
    }

    protected class CellInstance
    extends DotSite {
        protected Queue<Handle> readQueue = new LinkedList<Handle>();
        Object contents = null;

        CellInstance() {
        }

        @Override
        protected void addMembers() {
            this.addMember("read", new readMethod());
            this.addMember("write", new writeMethod());
            this.addMember("readD", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle caller) throws TokenException {
                    CellInstance cellInstance = CellInstance.this;
                    synchronized (cellInstance) {
                        if (CellInstance.this.readQueue != null) {
                            caller.halt();
                        } else {
                            caller.publish(1.object2value(CellInstance.this.contents));
                        }
                    }
                }
            });
        }

        protected class readMethod
        extends SiteAdaptor {
            protected readMethod() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSite(Args args, Handle reader) {
                CellInstance cellInstance = CellInstance.this;
                synchronized (cellInstance) {
                    if (CellInstance.this.readQueue != null) {
                        reader.setQuiescent();
                        CellInstance.this.readQueue.add(reader);
                    } else {
                        reader.publish(readMethod.object2value(CellInstance.this.contents));
                    }
                }
            }
        }

        protected class writeMethod
        extends SiteAdaptor {
            protected writeMethod() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSite(Args args, Handle writer) throws TokenException {
                CellInstance cellInstance = CellInstance.this;
                synchronized (cellInstance) {
                    Object val = args.getArg(0);
                    if (CellInstance.this.readQueue != null) {
                        CellInstance.this.contents = val;
                        for (Handle reader : CellInstance.this.readQueue) {
                            reader.publish(writeMethod.object2value(val));
                        }
                        CellInstance.this.readQueue = null;
                        writer.publish(writeMethod.signal());
                    } else {
                        writer.halt();
                    }
                }
            }
        }
    }
}

