/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.state;

import java.math.BigInteger;
import java.util.LinkedList;
import orc.Handle;
import orc.error.runtime.ArityMismatchException;
import orc.error.runtime.TokenException;
import orc.lib.state.types.BoundedChannelType;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.DotSite;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.SiteAdaptor;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;

public class BoundedChannel
extends EvalSite
implements TypedSite {
    @Override
    public Object evaluate(Args args) throws TokenException {
        if (args.size() == 1) {
            return new ChannelInstance(args.intArg(0));
        }
        throw new ArityMismatchException(1, args.size());
    }

    @Override
    public Type orcType() {
        return BoundedChannelType.getBuilder();
    }

    protected class ChannelInstance
    extends DotSite {
        protected final LinkedList<Object> contents;
        protected final LinkedList<Handle> readers;
        protected final LinkedList<Handle> writers;
        protected Handle closer;
        protected int open;
        protected boolean closed = false;

        ChannelInstance(int bound) {
            this.open = bound;
            this.contents = new LinkedList();
            this.readers = new LinkedList();
            this.writers = new LinkedList();
        }

        @Override
        protected void addMembers() {
            this.addMember("get", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle reader) {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        if (ChannelInstance.this.contents.isEmpty()) {
                            if (ChannelInstance.this.closed) {
                                reader.halt();
                            } else {
                                reader.setQuiescent();
                                ChannelInstance.this.readers.addLast(reader);
                            }
                        } else {
                            reader.publish(1.object2value(ChannelInstance.this.contents.removeFirst()));
                            if (ChannelInstance.this.writers.isEmpty()) {
                                ++ChannelInstance.this.open;
                            } else {
                                Handle writer = ChannelInstance.this.writers.removeFirst();
                                writer.publish(1.signal());
                            }
                            if (ChannelInstance.this.closer != null && ChannelInstance.this.contents.isEmpty()) {
                                ChannelInstance.this.closer.publish(1.signal());
                                ChannelInstance.this.closer = null;
                            }
                        }
                    }
                }
            });
            this.addMember("getD", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle reader) {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        if (ChannelInstance.this.contents.isEmpty()) {
                            reader.halt();
                        } else {
                            reader.publish(2.object2value(ChannelInstance.this.contents.removeFirst()));
                            if (ChannelInstance.this.writers.isEmpty()) {
                                ++ChannelInstance.this.open;
                            } else {
                                Handle writer = ChannelInstance.this.writers.removeFirst();
                                writer.publish(2.signal());
                            }
                            if (ChannelInstance.this.closer != null && ChannelInstance.this.contents.isEmpty()) {
                                ChannelInstance.this.closer.publish(2.signal());
                                ChannelInstance.this.closer = null;
                            }
                        }
                    }
                }
            });
            this.addMember("put", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle writer) throws TokenException {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        Object item = args.getArg(0);
                        if (ChannelInstance.this.closed) {
                            writer.halt();
                        } else if (!ChannelInstance.this.readers.isEmpty()) {
                            Handle reader = ChannelInstance.this.readers.removeFirst();
                            reader.publish(3.object2value(item));
                            writer.publish(3.signal());
                        } else if (ChannelInstance.this.open == 0) {
                            ChannelInstance.this.contents.addLast(item);
                            writer.setQuiescent();
                            ChannelInstance.this.writers.addLast(writer);
                        } else {
                            ChannelInstance.this.contents.addLast(item);
                            --ChannelInstance.this.open;
                            writer.publish(3.signal());
                        }
                    }
                }
            });
            this.addMember("putD", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle writer) throws TokenException {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        Object item = args.getArg(0);
                        if (ChannelInstance.this.closed) {
                            writer.halt();
                        } else if (!ChannelInstance.this.readers.isEmpty()) {
                            Handle reader = ChannelInstance.this.readers.removeFirst();
                            reader.publish(4.object2value(item));
                            writer.publish(4.signal());
                        } else if (ChannelInstance.this.open == 0) {
                            writer.halt();
                        } else {
                            ChannelInstance.this.contents.addLast(item);
                            --ChannelInstance.this.open;
                            writer.publish(4.signal());
                        }
                    }
                }
            });
            this.addMember("getAll", new EvalSite(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object evaluate(Args args) throws TokenException {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        ChannelInstance.this.open += ChannelInstance.this.contents.size() - ChannelInstance.this.writers.size();
                        List out = JavaConversions.collectionAsScalaIterable(ChannelInstance.this.contents).toList();
                        ChannelInstance.this.contents.clear();
                        for (Handle writer : ChannelInstance.this.writers) {
                            writer.publish(5.signal());
                        }
                        ChannelInstance.this.writers.clear();
                        if (ChannelInstance.this.closer != null) {
                            ChannelInstance.this.closer.publish(5.signal());
                            ChannelInstance.this.closer = null;
                        }
                        return out;
                    }
                }
            });
            this.addMember("getOpen", new EvalSite(){

                @Override
                public Object evaluate(Args args) throws TokenException {
                    return BigInteger.valueOf(ChannelInstance.this.open);
                }
            });
            this.addMember("getBound", new EvalSite(){

                @Override
                public Object evaluate(Args args) throws TokenException {
                    return BigInteger.valueOf(ChannelInstance.this.open + ChannelInstance.this.contents.size() - ChannelInstance.this.writers.size());
                }
            });
            this.addMember("isClosed", new EvalSite(){

                @Override
                public Object evaluate(Args args) throws TokenException {
                    return ChannelInstance.this.closed;
                }
            });
            this.addMember("close", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle caller) {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        ChannelInstance.this.closed = true;
                        for (Handle reader : ChannelInstance.this.readers) {
                            reader.halt();
                        }
                        if (ChannelInstance.this.contents.isEmpty()) {
                            caller.publish(9.signal());
                        } else {
                            ChannelInstance.this.closer = caller;
                            ChannelInstance.this.closer.setQuiescent();
                        }
                    }
                }
            });
            this.addMember("closeD", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle caller) {
                    ChannelInstance channelInstance = ChannelInstance.this;
                    synchronized (channelInstance) {
                        ChannelInstance.this.closed = true;
                        for (Handle reader : ChannelInstance.this.readers) {
                            reader.halt();
                        }
                        caller.publish(10.signal());
                    }
                }
            });
        }
    }
}

