/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import orc.error.runtime.TokenException;
import orc.types.CallableType;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.Types;

public class UMinus
extends EvalSite
implements TypedSite {
    private static final MyOperator op = new MyOperator();

    @Override
    public Object evaluate(Args args) throws TokenException {
        return Args.applyNumericOperator(args.numberArg(0), op);
    }

    @Override
    public Type orcType() {
        return Types.overload(Types.function(Types.integer(), Types.integer()), (CallableType)Types.function(Types.number(), Types.number()));
    }

    private static final class MyOperator
    implements Args.NumericUnaryOperator<Number> {
        private MyOperator() {
        }

        @Override
        public Number apply(BigInteger a) {
            return a.negate();
        }

        @Override
        public Number apply(BigDecimal a) {
            return a.negate();
        }

        @Override
        public Number apply(int a) {
            return -a;
        }

        @Override
        public Number apply(long a) {
            return -a;
        }

        @Override
        public Number apply(byte a) {
            return (int)(-a);
        }

        @Override
        public Number apply(short a) {
            return (int)(-a);
        }

        @Override
        public Number apply(double a) {
            return -a;
        }

        @Override
        public Number apply(float a) {
            return Float.valueOf(-a);
        }
    }
}

