/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import orc.error.runtime.TokenException;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.Types;

public class Exponent
extends EvalSite
implements TypedSite {
    private static final MyOperator op = new MyOperator();

    @Override
    public Object evaluate(Args args) throws TokenException {
        return Args.applyNumericOperator(args.numberArg(0), args.numberArg(1), op);
    }

    @Override
    public Type orcType() {
        return Types.function(Types.number(), Types.number(), Types.number());
    }

    private static final class MyOperator
    implements Args.NumericBinaryOperator<Number> {
        private MyOperator() {
        }

        @Override
        public Number apply(BigInteger a, BigInteger b) {
            if (a.signum() == 0) {
                return b.signum() == 0 ? BigInteger.ONE : a;
            }
            if (a.equals(BigInteger.ONE)) {
                return a;
            }
            if (b.bitLength() >= 32) {
                throw new ArithmeticException("Exponent out of range");
            }
            return a.pow(b.intValue());
        }

        @Override
        public Number apply(BigDecimal a, BigDecimal b) {
            try {
                return a.pow(b.intValueExact());
            }
            catch (ArithmeticException e) {
                return Math.pow(a.doubleValue(), b.doubleValue());
            }
        }

        @Override
        public Number apply(int a, int b) {
            return Math.pow(a, b);
        }

        @Override
        public Number apply(long a, long b) {
            return Math.pow(a, b);
        }

        @Override
        public Number apply(byte a, byte b) {
            return Math.pow(a, b);
        }

        @Override
        public Number apply(short a, short b) {
            return Math.pow(a, b);
        }

        @Override
        public Number apply(double a, double b) {
            return Math.pow(a, b);
        }

        @Override
        public Number apply(float a, float b) {
            return Math.pow(a, b);
        }
    }
}

