/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import orc.error.runtime.TokenException;
import orc.lib.math.Floor;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.Types;

public class Ceil
extends EvalSite
implements TypedSite {
    public static BigInteger ceil(BigDecimal d) {
        if (d.signum() >= 0) {
            try {
                return d.toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                return d.add(BigDecimal.ONE).toBigInteger();
            }
        }
        return Floor.floor(d.negate()).negate();
    }

    @Override
    public Object evaluate(Args args) throws TokenException {
        Number n = args.numberArg(0);
        if (n instanceof BigInteger || n instanceof Integer || n instanceof Long || n instanceof Short || n instanceof Byte) {
            return n;
        }
        BigDecimal d = n instanceof BigDecimal ? (BigDecimal)n : new BigDecimal(n.doubleValue());
        return Ceil.ceil(d);
    }

    @Override
    public Type orcType() {
        return Types.function(Types.number(), Types.integer());
    }
}

