/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import orc.error.runtime.ArgumentTypeMismatchException;
import orc.error.runtime.TokenException;
import orc.types.RecordExtensorType;
import orc.types.Type;
import orc.values.Format;
import orc.values.OrcRecord;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.Types;

public class Add
extends EvalSite
implements TypedSite {
    private static final MyOperator op = new MyOperator();

    @Override
    public Object evaluate(Args args) throws TokenException {
        Object a = args.getArg(0);
        Object b = args.getArg(1);
        if (a instanceof Number && b instanceof Number) {
            return Args.applyNumericOperator(args.numberArg(0), args.numberArg(1), op);
        }
        if (a instanceof String) {
            return String.valueOf((String)a) + Format.formatValueR(args.getArg(1), false);
        }
        if (b instanceof String) {
            return String.valueOf(Format.formatValueR(args.getArg(0), false)) + (String)b;
        }
        if (a instanceof OrcRecord || b instanceof OrcRecord) {
            return ((OrcRecord)a).extendWith((OrcRecord)b);
        }
        throw new ArgumentTypeMismatchException(0, "Number, String, or record", a != null ? a.getClass().toString() : "null");
    }

    @Override
    public Type orcType() {
        return Types.overload(Types.function(Types.integer(), Types.integer(), Types.integer()), Types.function(Types.number(), Types.number(), Types.number()), new RecordExtensorType(), Types.function(Types.string(), Types.top(), Types.string()), Types.function(Types.top(), Types.string(), Types.string()));
    }

    private static final class MyOperator
    implements Args.NumericBinaryOperator<Number> {
        private MyOperator() {
        }

        @Override
        public Number apply(BigInteger a, BigInteger b) {
            return a.add(b);
        }

        @Override
        public Number apply(BigDecimal a, BigDecimal b) {
            return a.add(b);
        }

        @Override
        public Number apply(int a, int b) {
            return a + b;
        }

        @Override
        public Number apply(long a, long b) {
            return a + b;
        }

        @Override
        public Number apply(byte a, byte b) {
            return a + b;
        }

        @Override
        public Number apply(short a, short b) {
            return a + b;
        }

        @Override
        public Number apply(double a, double b) {
            return a + b;
        }

        @Override
        public Number apply(float a, float b) {
            return Float.valueOf(a + b);
        }
    }
}

