/*
 * Decompiled with CFR 0.152.
 */
package orc.error.compiletime;

import java.io.PrintWriter;
import orc.ast.AST;
import orc.compile.parse.OrcInputContext;
import orc.compile.parse.OrcSourceRange;
import orc.error.compiletime.CompilationException;
import orc.error.compiletime.CompileLogger;
import scala.Option;

public class PrintWriterCompileLogger
implements CompileLogger {
    private final PrintWriter outWriter;
    private CompileLogger.Severity maxSeverity = CompileLogger.Severity.UNKNOWN;

    public PrintWriterCompileLogger(PrintWriter logToWriter) {
        if (logToWriter == null) {
            throw new NullPointerException("Cannot construct PrintWriterCompileLogger with a null PrintWriter");
        }
        this.outWriter = logToWriter;
    }

    @Override
    public void beginProcessing(OrcInputContext inputContext) {
        if (this.outWriter == null) {
            throw new NullPointerException("Cannot use a options with a null stderr");
        }
        this.maxSeverity = CompileLogger.Severity.UNKNOWN;
    }

    @Override
    public void endProcessing(OrcInputContext inputContext) {
    }

    @Override
    public void beginDependency(OrcInputContext inputContext) {
    }

    @Override
    public void endDependency(OrcInputContext inputContext) {
    }

    @Override
    public void recordMessage(CompileLogger.Severity severity, int code, String message, Option<OrcSourceRange> location, AST astNode, Throwable exception) {
        CompileLogger.Severity severity2 = this.maxSeverity = severity.ordinal() > this.maxSeverity.ordinal() ? severity : this.maxSeverity;
        if (location != null && location.isDefined()) {
            this.outWriter.println(String.valueOf(((OrcSourceRange)location.get()).toString()) + ": " + message + (exception instanceof CompilationException ? " [[OrcWiki:" + exception.getClass().getSimpleName() + "]]" : ""));
            this.outWriter.println(((OrcSourceRange)location.get()).lineContentWithCaret());
        } else {
            this.outWriter.println("<undefined position>: " + message);
        }
    }

    @Override
    public void recordMessage(CompileLogger.Severity severity, int code, String message, Option<OrcSourceRange> location, Throwable exception) {
        this.recordMessage(severity, code, message, location, null, exception);
    }

    @Override
    public void recordMessage(CompileLogger.Severity severity, int code, String message, Option<OrcSourceRange> location, AST astNode) {
        this.recordMessage(severity, code, message, location, astNode, null);
    }

    @Override
    public void recordMessage(CompileLogger.Severity severity, int code, String message) {
        this.recordMessage(severity, code, message, null, null, null);
    }

    @Override
    public CompileLogger.Severity getMaxSeverity() {
        return this.maxSeverity;
    }
}

