/*
 * Decompiled with CFR 0.152.
 */
package orc.error.compiletime;

import orc.error.OrcException;
import orc.error.compiletime.CompileLogger;
import orc.error.compiletime.SeverityDebug;
import orc.error.compiletime.SeverityError;
import orc.error.compiletime.SeverityFatal;
import orc.error.compiletime.SeverityInfo;
import orc.error.compiletime.SeverityInternal;
import orc.error.compiletime.SeverityNotice;
import orc.error.compiletime.SeverityWarning;

public abstract class CompilationException
extends OrcException {
    private static final long serialVersionUID = 3471866878600135322L;

    public CompilationException(String message) {
        super(message);
    }

    public CompilationException(String message, Throwable cause) {
        super(message, cause);
    }

    public CompilationException(Throwable cause) {
        super(cause);
    }

    public CompileLogger.Severity severity() {
        if (this instanceof SeverityInternal) {
            return CompileLogger.Severity.INTERNAL;
        }
        if (this instanceof SeverityFatal) {
            return CompileLogger.Severity.FATAL;
        }
        if (this instanceof SeverityError) {
            return CompileLogger.Severity.ERROR;
        }
        if (this instanceof SeverityWarning) {
            return CompileLogger.Severity.WARNING;
        }
        if (this instanceof SeverityNotice) {
            return CompileLogger.Severity.NOTICE;
        }
        if (this instanceof SeverityInfo) {
            return CompileLogger.Severity.INFO;
        }
        if (this instanceof SeverityDebug) {
            return CompileLogger.Severity.DEBUG;
        }
        return CompileLogger.Severity.UNKNOWN;
    }

    @Override
    public String getMessageAndPositon() {
        if (this.getPosition() != null) {
            return String.valueOf(this.getPosition().toString()) + ": " + this.getLocalizedMessage() + (this.getPosition().lineContentWithCaret().equals("\n^") ? "" : "\n" + this.getPosition().lineContentWithCaret());
        }
        return this.getLocalizedMessage();
    }
}

