/*
 * Decompiled with CFR 0.152.
 */
package orc.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import orc.compile.parse.OrcSourceRange;

public abstract class OrcException
extends Exception {
    private static final long serialVersionUID = -194692912947820229L;
    OrcSourceRange position;

    public OrcException(String message) {
        super(message);
    }

    public OrcException(String message, Throwable cause) {
        super(message, cause);
    }

    public OrcException(Throwable cause) {
        super(cause);
    }

    public String getMessageAndPositon() {
        if (this.position != null) {
            return String.valueOf(this.position.toString()) + ": " + this.getClass().getCanonicalName() + ": " + this.getLocalizedMessage() + (this.position.lineContentWithCaret().equals("\n^") ? "" : "\n" + this.position.lineContentWithCaret());
        }
        return this.getLocalizedMessage();
    }

    public String getMessageAndDiagnostics() {
        return String.valueOf(this.getMessageAndPositon()) + "\n";
    }

    public String getJavaStacktraceAsString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        StringBuffer traceBuf = sw.getBuffer();
        traceBuf.delete(0, traceBuf.indexOf("\n\tat "));
        return traceBuf.toString();
    }

    public OrcSourceRange getPosition() {
        return this.position;
    }

    public void resetPosition(OrcSourceRange newpos) {
        this.position = newpos;
    }

    public OrcException setPosition(OrcSourceRange newpos) {
        if (this.position == null) {
            this.position = newpos;
        }
        return this;
    }
}

