/*
 * Decompiled with CFR 0.152.
 */
package orc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.script.Compilable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import orc.Main;
import orc.OrcOptions;
import orc.error.OrcException;
import orc.error.runtime.JavaException;
import orc.run.OrcDesktopEventAction;
import orc.script.OrcScriptEngine;
import orc.util.CmdLineUsageException;
import orc.util.PrintVersionAndMessageException;
import orc.values.Format$;
import scala.Console$;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

public final class Main$ {
    public static Main$ MODULE$;
    private String orcImplName;
    private String scmRevision;
    private String orcVersion;
    private String orcURL;
    private String orcCopyright;
    private String copyrightYear;
    private Logger orcLogger;
    private final Properties versionProperties;
    private volatile byte bitmap$0;
    private volatile boolean bitmap$init$0;

    static {
        new Main$();
    }

    public void main(String[] args) {
        try {
            OrcScriptEngine.OrcCompiledScript compiledOrc;
            OrcScriptEngine.OrcCompiledScript orcCompiledScript;
            Main.OrcCmdLineOptions options = new Main.OrcCmdLineOptions();
            options.parseCmdLine((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
            this.setupLogging(options);
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("orc");
            if (engine == null) {
                throw new ClassNotFoundException("Unable to load Orc ScriptEngine");
            }
            engine.setBindings(options, 100);
            FileInputStream stream = new FileInputStream(options.filename());
            if (options.runOil()) {
                orcCompiledScript = ((OrcScriptEngine)engine).loadDirectly(stream);
            } else {
                InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
                orcCompiledScript = compiledOrc = (OrcScriptEngine.OrcCompiledScript)((Compilable)((Object)engine)).compile(reader);
            }
            if (options.compileOnly()) {
                if (options.runOil()) {
                    Console$.MODULE$.err().println("Warning: run-oil ignored since compile-only was also set.");
                }
                return;
            }
            OrcDesktopEventAction printPubs = new OrcDesktopEventAction(options){
                private final Main.OrcCmdLineOptions options$1;

                public void published(Object value) {
                    Predef$.MODULE$.println((Object)Format$.MODULE$.formatValue(value));
                    Console$.MODULE$.out().flush();
                }

                public void caught(Throwable e) {
                    Console$.MODULE$.out().flush();
                    Main$.MODULE$.printException(e, Console$.MODULE$.err(), this.options$1.showJavaStackTrace());
                    Console$.MODULE$.err().flush();
                }
                {
                    this.options$1 = options$1;
                }
            };
            compiledOrc.run(printPubs);
            return;
        }
        catch (CmdLineUsageException cmdLineUsageException) {
            Console$.MODULE$.err().println("Orc: " + cmdLineUsageException.getMessage());
            return;
        }
        catch (PrintVersionAndMessageException printVersionAndMessageException) {
            Predef$.MODULE$.println((Object)(this.orcImplName() + " " + this.orcVersion() + "\n" + this.orcURL() + "\n" + this.orcCopyright() + "\n\n" + printVersionAndMessageException.getMessage()));
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Console$.MODULE$.err().println("Orc: File not found: " + fileNotFoundException.getMessage());
            return;
        }
        catch (ScriptException scriptException) {
            if (scriptException.getCause() == null) {
                Console$.MODULE$.err().println(scriptException.getMessage());
                return;
            }
            this.printException(scriptException.getCause(), Console$.MODULE$.err(), false);
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public Properties versionProperties() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prepor/repos/orc/OrcScala/src/orc/Main.scala: 79");
        }
        return this.versionProperties;
    }

    private String orcImplName$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.orcImplName = this.versionProperties().getProperty("orc.title");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.orcImplName;
    }

    public String orcImplName() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.orcImplName$lzycompute();
        }
        return this.orcImplName;
    }

    private String scmRevision$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.scmRevision = this.versionProperties().getProperty("orc.scm-revision");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.scmRevision;
    }

    public String scmRevision() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.scmRevision$lzycompute();
        }
        return this.scmRevision;
    }

    private String orcVersion$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.orcVersion = this.versionProperties().getProperty("orc.version") + " rev. " + this.scmRevision() + " (built " + this.versionProperties().getProperty("orc.build.date") + " " + this.versionProperties().getProperty("orc.build.user") + ")";
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.orcVersion;
    }

    public String orcVersion() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.orcVersion$lzycompute();
        }
        return this.orcVersion;
    }

    private String orcURL$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.orcURL = this.versionProperties().getProperty("orc.url");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.orcURL;
    }

    public String orcURL() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.orcURL$lzycompute();
        }
        return this.orcURL;
    }

    private String orcCopyright$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.orcCopyright = "(c) " + this.copyrightYear() + " " + this.versionProperties().getProperty("orc.vendor");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.orcCopyright;
    }

    public String orcCopyright() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.orcCopyright$lzycompute();
        }
        return this.orcCopyright;
    }

    private String copyrightYear$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.copyrightYear = this.versionProperties().getProperty("orc.copyright-year");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.copyrightYear;
    }

    public String copyrightYear() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.copyrightYear$lzycompute();
        }
        return this.copyrightYear;
    }

    private Logger orcLogger$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.orcLogger = Logger.getLogger("orc");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.orcLogger;
    }

    public Logger orcLogger() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.orcLogger$lzycompute();
        }
        return this.orcLogger;
    }

    public void setupLogging(OrcOptions options) {
        Level logLevel = Level.parse(options.logLevel());
        this.orcLogger().setLevel(logLevel);
        LogRecord testOrcLogRecord = new LogRecord(logLevel, "");
        testOrcLogRecord.setLoggerName(this.orcLogger().getName());
        if (!Main$.willLog$1(this.orcLogger(), testOrcLogRecord)) {
            ConsoleHandler logHandler = new ConsoleHandler();
            logHandler.setLevel(logLevel);
            this.orcLogger().addHandler(logHandler);
            this.orcLogger().warning("No log handler found for 'orc' " + logLevel + " log records, so a ConsoleHandler was added.  This may result in duplicate log records.");
        }
        this.orcLogger().config(this.orcImplName() + " " + this.orcVersion());
        this.orcLogger().config("Orc logging level: " + logLevel);
    }

    public void printException(Throwable e, PrintStream err, boolean showJavaStackTrace) {
        if (e instanceof JavaException) {
            JavaException javaException = (JavaException)e;
            if (!showJavaStackTrace) {
                err.print(javaException.getMessageAndPositon() + "\n" + javaException.getOrcStacktraceAsString());
                return;
            }
        }
        if (e instanceof OrcException) {
            OrcException orcException = (OrcException)e;
            err.print(orcException.getMessageAndDiagnostics());
            return;
        }
        e.printStackTrace(err);
    }

    public static final /* synthetic */ void $anonfun$setupLogging$1(LogRecord testLogRecord$1, Object nonLocalReturnKey1$1, Handler handler) {
        if (handler.isLoggable(testLogRecord$1)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    private static final boolean willLog$1(Logger checkLogger, LogRecord testLogRecord) {
        Object object = new Object();
        try {
            ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkLogger.getHandlers()));
            int foreach_len = foreach_this.length();
            for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
                Handler handler = (Handler)foreach_this.apply(foreach_i);
                Main$.$anonfun$setupLogging$1(testLogRecord, object, handler);
            }
            if (checkLogger.getUseParentHandlers() && checkLogger.getParent() != null) {
                return Main$.willLog$1(checkLogger.getParent(), testLogRecord);
            }
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Main$() {
        void var1_1;
        MODULE$ = this;
        Properties p = new Properties();
        InputStream vp = this.getClass().getResourceAsStream("version.properties");
        if (vp == null) {
            throw new MissingResourceException("Unable to load version.properties resource", "/orc/version.properties", "");
        }
        p.load(vp);
        this.versionProperties = var1_1;
        this.bitmap$init$0 = true;
    }

    public static final /* synthetic */ Object $anonfun$setupLogging$1$adapted(LogRecord testLogRecord$1, Object nonLocalReturnKey1$1, Handler handler) {
        Main$.$anonfun$setupLogging$1(testLogRecord$1, nonLocalReturnKey1$1, handler);
        return BoxedUnit.UNIT;
    }
}

