/*
 * Decompiled with CFR 0.152.
 */
package orc.script;

import java.awt.Dialog;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

class PromptWindowController
implements Runnable {
    private final String title;
    private final String message;
    private String result;
    private JOptionPane pane;
    private JDialog dialog;
    private boolean done;
    private final Icon icon;

    protected PromptWindowController(String dialogTitle, String dialogMessage, Icon dialogIcon) {
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.icon = dialogIcon;
    }

    protected synchronized String getResult() throws InterruptedException {
        while (!this.done) {
            this.wait();
        }
        return this.result;
    }

    protected void startDialog() {
        this.pane = new JOptionPane(this.message, 3, 2, this.icon, null, null);
        this.pane.setWantsInput(true);
        this.pane.setSelectionValues(null);
        this.pane.setInitialSelectionValue(null);
        this.pane.setComponentOrientation(JOptionPane.getRootFrame().getComponentOrientation());
        this.dialog = this.pane.createDialog(this.title);
        this.dialog.setModalityType(Dialog.ModalityType.MODELESS);
        this.dialog.setLocationByPlatform(true);
        this.pane.selectInitialValue();
        this.dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                PromptWindowController.this.endDialog();
            }
        });
        this.dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endDialog() {
        this.dialog.dispose();
        Object value = this.pane.getInputValue();
        this.result = value == JOptionPane.UNINITIALIZED_VALUE ? null : (String)value;
        this.done = true;
        PromptWindowController promptWindowController = this;
        synchronized (promptWindowController) {
            this.notifyAll();
        }
    }

    @Override
    public void run() {
        this.startDialog();
    }
}

