/*
 * Decompiled with CFR 0.152.
 */
package orc.script;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.script.ScriptException;
import orc.compile.parse.OrcSourceRange;
import orc.error.OrcException;

public class OrcScriptException
extends ScriptException {
    private static final long serialVersionUID = 8541712728830055894L;
    private final OrcException orcE;

    public OrcScriptException(OrcException e) {
        super(e);
        this.orcE = e;
    }

    @Override
    public String getFileName() {
        OrcSourceRange pos = this.orcE.getPosition();
        if (pos != null) {
            return pos.start().resource().descr();
        }
        return "";
    }

    @Override
    public int getLineNumber() {
        OrcSourceRange pos = this.orcE.getPosition();
        if (pos != null) {
            return pos.start().line();
        }
        return -1;
    }

    @Override
    public int getColumnNumber() {
        OrcSourceRange pos = this.orcE.getPosition();
        if (pos != null) {
            return pos.start().column();
        }
        return -1;
    }

    @Override
    public String getMessage() {
        return this.orcE.getMessage();
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        throw new UnsupportedOperationException("OrcScriptException.fillInStackTrace is not supported");
    }

    @Override
    public synchronized Throwable getCause() {
        return this.orcE.getCause();
    }

    @Override
    public String getLocalizedMessage() {
        return this.orcE.getLocalizedMessage();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.orcE.getStackTrace();
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        throw new UnsupportedOperationException("OrcScriptException.initCause is not supported");
    }

    @Override
    public void printStackTrace() {
        this.orcE.printStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.orcE.printStackTrace(s);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.orcE.printStackTrace(s);
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        throw new UnsupportedOperationException("OrcScriptException.setStackTrace is not supported");
    }

    @Override
    public String toString() {
        return this.orcE.toString();
    }
}

