/*
 * Decompiled with CFR 0.152.
 */
package orc.script;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import orc.script.OrcScriptEngine;

public class OrcScriptEngineFactory
implements ScriptEngineFactory {
    private static List<String> names = Collections.unmodifiableList(Arrays.asList("orc"));
    private static List<String> extensions = Collections.unmodifiableList(Arrays.asList("orc", "inc"));
    private static List<String> mimeTypes = Collections.unmodifiableList(Arrays.asList(new String[0]));

    @Override
    public String getEngineName() {
        return "Orc";
    }

    @Override
    public String getEngineVersion() {
        return System.getProperty("orc.version");
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public String getLanguageName() {
        return "orc";
    }

    @Override
    public String getLanguageVersion() {
        return System.getProperty("orc.version");
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder buf = new StringBuilder();
        buf.append(obj);
        buf.append(".");
        buf.append(m);
        buf.append("(");
        if (args.length != 0) {
            int i = 0;
            while (i < args.length - 1) {
                buf.append(String.valueOf(args[i]) + ", ");
                ++i;
            }
            buf.append(args[i]);
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder buf = new StringBuilder();
        buf.append("print(\"");
        int len = toDisplay.length();
        int i = 0;
        while (i < len) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            ++i;
        }
        buf.append("\")");
        return buf.toString();
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "STATELESS";
        }
        return null;
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder buf = new StringBuilder();
        if (statements.length != 0) {
            int i = 0;
            while (i < statements.length) {
                buf.append(statements[i]);
                if (i < statements.length - 1) {
                    buf.append("  >>\n");
                }
                ++i;
            }
        }
        return buf.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        OrcScriptEngine engine = new OrcScriptEngine();
        engine.setFactory(this);
        return engine;
    }
}

