/*
 * Decompiled with CFR 0.152.
 */
package orc.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import orc.Backend;
import orc.BackendType;
import orc.CodeSerializer;
import orc.Compiler;
import orc.OrcEvent;
import orc.OrcEventAction;
import orc.Runtime;
import orc.error.OrcException;
import orc.error.loadtime.LoadingException;
import orc.lib.str.PrintEvent;
import orc.run.OrcDesktopEventAction;
import orc.script.Logger;
import orc.script.OrcBindings;
import orc.script.OrcScriptEngineFactory;
import orc.script.OrcScriptException;

public class OrcScriptEngine<CompiledCode>
extends AbstractScriptEngine
implements Compilable {
    private OrcScriptEngineFactory factory;
    private Backend<CompiledCode> _backend;
    private Runtime<CompiledCode> _executor;
    private BackendType backendType;

    public OrcScriptEngine() {
        this(new OrcBindings());
    }

    public OrcScriptEngine(Bindings n) {
        super(n);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        Logger.julLogger().entering(this.getClass().getCanonicalName(), "compile", script);
        try {
            CompiledCode result = this.getCompiler().compile(script, OrcScriptEngine.asOrcBindings(this.getBindings(100)), this.getContext().getErrorWriter());
            if (result == null) {
                throw new ScriptException("Compilation failed");
            }
            Logger.julLogger().exiting(this.getClass().getCanonicalName(), "compile", result);
            return new OrcCompiledScript(result);
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Bindings createBindings() {
        return new OrcBindings();
    }

    @Override
    public Object eval(String script, ScriptContext ctxt) throws ScriptException {
        return this.compile(script).eval(ctxt);
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
        return this.compile(reader).eval(ctxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        OrcScriptEngine orcScriptEngine = this;
        synchronized (orcScriptEngine) {
            if (this.factory == null) {
                this.factory = new OrcScriptEngineFactory();
            }
        }
        return this.factory;
    }

    void setFactory(OrcScriptEngineFactory owningFactory) {
        this.factory = owningFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Backend<CompiledCode> getBackend() {
        OrcScriptEngine orcScriptEngine = this;
        synchronized (orcScriptEngine) {
            OrcBindings b = OrcScriptEngine.asOrcBindings(this.getBindings(100));
            BackendType configBackendType = b.backend();
            if (this._backend == null) {
                this.backendType = configBackendType;
                this._backend = configBackendType.newBackend();
            } else if (configBackendType != this.backendType) {
                throw new UnsupportedOperationException("Backend change after creation is not supported");
            }
        }
        return this._backend;
    }

    Compiler<CompiledCode> getCompiler() {
        return this.getBackend().compiler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runtime<CompiledCode> getExecutor() {
        OrcScriptEngine orcScriptEngine = this;
        synchronized (orcScriptEngine) {
            if (this._executor == null) {
                this._executor = this.getBackend().createRuntime(OrcScriptEngine.asOrcBindings(this.getBindings(100)));
            }
        }
        return this._executor;
    }

    static OrcBindings asOrcBindings(Bindings b) {
        if (b instanceof OrcBindings) {
            return (OrcBindings)b;
        }
        return new OrcBindings(b);
    }

    public OrcCompiledScript loadDirectly(InputStream in) throws LoadingException {
        return new OrcCompiledScript(((CodeSerializer)this.getBackend().serializer().get()).deserialize(in));
    }

    public class OrcCompiledScript
    extends CompiledScript {
        private final CompiledCode code;

        OrcCompiledScript(CompiledCode _code) {
            this.code = _code;
        }

        @Override
        public Object eval(final ScriptContext ctx) throws ScriptException {
            final ArrayList pubs = new ArrayList();
            OrcDesktopEventAction addPubToList = new OrcDesktopEventAction(){

                @Override
                public void published(Object value) {
                    pubs.add(value);
                }

                @Override
                public void caught(Throwable e) {
                    try {
                        ctx.getWriter().flush();
                        if (e instanceof OrcException) {
                            ctx.getErrorWriter().write(((OrcException)e).getMessageAndDiagnostics());
                        } else {
                            e.printStackTrace(new PrintWriter(ctx.getErrorWriter()));
                        }
                        ctx.getErrorWriter().flush();
                    }
                    catch (IOException e1) {
                        throw new AssertionError((Object)e1);
                    }
                }

                @Override
                public void haltedOrKilled() {
                }

                @Override
                public void other(OrcEvent event) throws Exception {
                    if (event instanceof PrintEvent) {
                        try {
                            PrintEvent pe = (PrintEvent)event;
                            ctx.getWriter().write(pe.text());
                            ctx.getWriter().flush();
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    } else {
                        super.other(event);
                    }
                }
            };
            this.run(ctx, addPubToList);
            return pubs;
        }

        public void run(ScriptContext ctx, OrcEventAction pubAct) throws ScriptException {
            Logger.julLogger().entering(this.getClass().getCanonicalName(), "run");
            Runtime exec = OrcScriptEngine.this.getExecutor();
            ctx.setAttribute("context", ctx, 100);
            try {
                try {
                    exec.runSynchronous(this.code, pubAct.asFunction());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    exec.stop();
                    ctx.removeAttribute("context", 100);
                    Logger.julLogger().exiting(this.getClass().getCanonicalName(), "run");
                }
                catch (OrcException e) {
                    throw new OrcScriptException(e);
                }
            }
            finally {
                exec.stop();
                ctx.removeAttribute("context", 100);
                Logger.julLogger().exiting(this.getClass().getCanonicalName(), "run");
            }
        }

        public void run(OrcEventAction pubAct) throws ScriptException {
            this.run(this.getEngine().getContext(), pubAct);
        }

        @Override
        public ScriptEngine getEngine() {
            return OrcScriptEngine.this;
        }
    }
}

