/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.state;

import java.util.LinkedList;
import java.util.Queue;
import orc.Handle;
import orc.error.runtime.ArityMismatchException;
import orc.error.runtime.TokenException;
import orc.lib.state.types.SemaphoreType;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.DotSite;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.SiteAdaptor;

public class Semaphore
extends EvalSite
implements TypedSite {
    @Override
    public Object evaluate(Args args) throws TokenException {
        int initialValue = args.intArg(0);
        if (args.size() != 1) {
            throw new ArityMismatchException(1, args.size());
        }
        if (initialValue >= 0) {
            return new SemaphoreInstance(initialValue);
        }
        throw new IllegalArgumentException("Semaphore requires a non-negative argument");
    }

    @Override
    public Type orcType() {
        return SemaphoreType.getBuilder();
    }

    protected class SemaphoreInstance
    extends DotSite {
        protected final Queue<Handle> waiters = new LinkedList<Handle>();
        protected final Queue<Handle> snoopers = new LinkedList<Handle>();
        protected int n;

        SemaphoreInstance(int n) {
            this.n = n;
        }

        @Override
        protected void addMembers() {
            this.addMember("acquire", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle waiter) {
                    SemaphoreInstance semaphoreInstance = SemaphoreInstance.this;
                    synchronized (semaphoreInstance) {
                        if (SemaphoreInstance.this.n == 0) {
                            waiter.setQuiescent();
                            SemaphoreInstance.this.waiters.offer(waiter);
                            if (!SemaphoreInstance.this.snoopers.isEmpty()) {
                                for (Handle snooper : SemaphoreInstance.this.snoopers) {
                                    snooper.publish(1.signal());
                                }
                                SemaphoreInstance.this.snoopers.clear();
                            }
                        } else {
                            --SemaphoreInstance.this.n;
                            waiter.publish(1.signal());
                        }
                    }
                }
            });
            this.addMember("acquireD", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle waiter) {
                    SemaphoreInstance semaphoreInstance = SemaphoreInstance.this;
                    synchronized (semaphoreInstance) {
                        if (SemaphoreInstance.this.n == 0) {
                            waiter.halt();
                        } else {
                            --SemaphoreInstance.this.n;
                            waiter.publish(2.signal());
                        }
                    }
                }
            });
            this.addMember("release", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle sender) throws TokenException {
                    SemaphoreInstance semaphoreInstance = SemaphoreInstance.this;
                    synchronized (semaphoreInstance) {
                        if (SemaphoreInstance.this.waiters.isEmpty()) {
                            ++SemaphoreInstance.this.n;
                        } else {
                            Handle waiter = SemaphoreInstance.this.waiters.poll();
                            waiter.publish(3.signal());
                        }
                        sender.publish(3.signal());
                    }
                }
            });
            this.addMember("snoop", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle snooper) throws TokenException {
                    SemaphoreInstance semaphoreInstance = SemaphoreInstance.this;
                    synchronized (semaphoreInstance) {
                        if (SemaphoreInstance.this.waiters.isEmpty()) {
                            snooper.setQuiescent();
                            SemaphoreInstance.this.snoopers.offer(snooper);
                        } else {
                            snooper.publish(4.signal());
                        }
                    }
                }
            });
            this.addMember("snoopD", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle caller) throws TokenException {
                    SemaphoreInstance semaphoreInstance = SemaphoreInstance.this;
                    synchronized (semaphoreInstance) {
                        if (SemaphoreInstance.this.waiters.isEmpty()) {
                            caller.halt();
                        } else {
                            caller.publish(5.signal());
                        }
                    }
                }
            });
        }
    }
}

