/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.state;

import java.util.LinkedList;
import java.util.Queue;
import orc.Handle;
import orc.error.runtime.ArityMismatchException;
import orc.error.runtime.TokenException;
import orc.lib.state.types.RefType;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.DotSite;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.SiteAdaptor;

public class Ref
extends EvalSite
implements TypedSite {
    @Override
    public Object evaluate(Args args) throws TokenException {
        if (args.size() == 1) {
            return new RefInstance(args.getArg(0));
        }
        if (args.size() == 0) {
            return new RefInstance();
        }
        throw new ArityMismatchException(1, args.size());
    }

    @Override
    public Type orcType() {
        return RefType.getBuilder();
    }

    public static class RefInstance
    extends DotSite {
        protected Queue<Handle> readQueue;
        Object contents;

        public RefInstance() {
            this.contents = null;
            this.readQueue = new LinkedList<Handle>();
        }

        public RefInstance(Object initial) {
            this.contents = initial;
            this.readQueue = null;
        }

        @Override
        protected void addMembers() {
            this.addMember("read", new readMethod());
            this.addMember("write", new writeMethod());
            this.addMember("readD", new SiteAdaptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callSite(Args args, Handle caller) throws TokenException {
                    RefInstance refInstance = this;
                    synchronized (refInstance) {
                        if (readQueue != null) {
                            caller.halt();
                        } else {
                            caller.publish(1.object2value(contents));
                        }
                    }
                }
            });
        }

        @Override
        public String toString() {
            return "Ref(" + this.contents + ")";
        }

        protected class readMethod
        extends SiteAdaptor {
            protected readMethod() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSite(Args args, Handle reader) {
                RefInstance refInstance = RefInstance.this;
                synchronized (refInstance) {
                    if (RefInstance.this.readQueue != null) {
                        reader.setQuiescent();
                        RefInstance.this.readQueue.add(reader);
                    } else {
                        reader.publish(readMethod.object2value(RefInstance.this.contents));
                    }
                }
            }
        }

        protected class writeMethod
        extends SiteAdaptor {
            protected writeMethod() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void callSite(Args args, Handle writer) throws TokenException {
                RefInstance refInstance = RefInstance.this;
                synchronized (refInstance) {
                    Object val;
                    RefInstance.this.contents = val = args.getArg(0);
                    if (RefInstance.this.readQueue != null) {
                        for (Handle reader : RefInstance.this.readQueue) {
                            reader.publish(writeMethod.object2value(val));
                        }
                        RefInstance.this.readQueue = null;
                    }
                    writer.publish(writeMethod.object2value(writeMethod.signal()));
                }
            }
        }
    }
}

