/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.state;

import java.util.Iterator;
import java.util.NoSuchElementException;
import orc.lib.state.Interval;

public final class Intervals<T extends Comparable>
implements Iterable<Interval<T>> {
    private final DTRCons<T> head;

    private Intervals(DTRCons<T> head) {
        this.head = head;
    }

    public Intervals() {
        this.head = null;
    }

    public Intervals(Interval<T> range) {
        this(new DTRCons<T>(null, range));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Intervals<T> union(Interval<T> interval_) {
        DTRCons tailOut;
        Interval interval = interval_;
        DTRCons headOut = tailOut = new DTRCons(null, null);
        DTRCons<T> it = this.head;
        block5: while (it != null) {
            switch (it.interval.compareTo(interval)) {
                case 0: {
                    interval = interval.union(it.interval);
                    break;
                }
                case -1: {
                    tailOut.next = new DTRCons(null, it.interval);
                    tailOut = tailOut.next;
                    break;
                }
                case 1: {
                    break block5;
                }
            }
            it = it.next;
        }
        tailOut.next = new DTRCons(null, interval);
        tailOut = tailOut.next;
        tailOut.next = it;
        return new Intervals(headOut.next);
    }

    public Intervals<T> intersect(Intervals<T> that) {
        DTRCons tail;
        if (this == that) {
            return this;
        }
        if (this.isEmpty()) {
            return this;
        }
        if (that.isEmpty()) {
            return that;
        }
        DTRCons head = tail = new DTRCons(null, null);
        DTRCons<T> next1 = this.head;
        DTRCons<T> next2 = that.head;
        while (next1 != null && next2 != null) {
            switch (next1.interval.compareTo(next2.interval)) {
                case -1: {
                    next1 = next1.next;
                    break;
                }
                case 1: {
                    next2 = next2.next;
                    break;
                }
                case 0: {
                    if (next1.interval.intersects(next2.interval)) {
                        tail.next = new DTRCons(null, next1.interval.intersect(next2.interval));
                        tail = tail.next;
                    }
                    if (next1.interval.getEnd().compareTo(next2.interval.getEnd()) <= 0) {
                        next1 = next1.next;
                        break;
                    }
                    next2 = next2.next;
                }
            }
        }
        return new Intervals(head.next);
    }

    public boolean spans(T point) {
        for (Interval<T> r : this) {
            if (!r.spans(point)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public Iterator<Interval<T>> iterator() {
        return new MyIterator(this.head);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Iterator<Interval<T>> it = this.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(", " + it.next());
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static class DTRCons<T extends Comparable> {
        protected DTRCons<T> next;
        protected final Interval<T> interval;

        public DTRCons(DTRCons<T> next, Interval<T> range) {
            this.next = next;
            this.interval = range;
        }
    }

    private static class MyIterator<T extends Comparable>
    implements Iterator<Interval<T>> {
        private DTRCons next;

        public MyIterator(DTRCons next) {
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Interval<T> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Interval out = this.next.interval;
            this.next = this.next.next;
            return out;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

