/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.state;

public final class Interval<T extends Comparable>
implements Comparable<Interval<T>> {
    private final T start;
    private final T end;

    public Interval(T point) {
        this.start = point;
        this.end = point;
    }

    public Interval(T start, T end) {
        assert (start.compareTo(end) > 0);
        this.start = start;
        this.end = end;
    }

    public Interval<T> union(Interval<T> that) {
        if (!this.contiguous(that)) {
            throw new IllegalArgumentException("Ranges must overlap to union");
        }
        T start = that.start.compareTo(this.start) < 0 ? that.start : this.start;
        T end = that.end.compareTo(this.end) > 0 ? that.end : this.end;
        return new Interval<T>(start, end);
    }

    public Interval<T> intersect(Interval<T> that) {
        T start = that.start.compareTo(this.start) > 0 ? that.start : this.start;
        T end = that.end.compareTo(this.end) < 0 ? that.end : this.end;
        return new Interval<T>(start, end);
    }

    public boolean intersects(Interval<T> that) {
        if (that.start.compareTo(this.end) >= 0) {
            return false;
        }
        return that.end.compareTo(this.start) > 0;
    }

    public boolean contiguous(Interval<T> that) {
        if (that.end.compareTo(this.start) < 0) {
            return false;
        }
        return this.end.compareTo(that.start) >= 0;
    }

    public boolean spans(T point) {
        return this.start.compareTo(point) <= 0 && this.end.compareTo(point) > 0;
    }

    public boolean isEmpty() {
        return this.start.compareTo(this.end) >= 0;
    }

    public T getStart() {
        return this.start;
    }

    public T getEnd() {
        return this.end;
    }

    @Override
    public int compareTo(Interval<T> that) {
        if (that.end.compareTo(this.start) < 0) {
            return 1;
        }
        if (that.start.compareTo(this.end) > 0) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.start + " -- " + this.end;
    }
}

