/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import orc.error.runtime.TokenException;
import orc.types.CallableType;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.Types;

public class Div
extends EvalSite
implements TypedSite {
    private static final MyOperator op = new MyOperator();

    @Override
    public Object evaluate(Args args) throws TokenException {
        return Args.applyNumericOperator(args.numberArg(0), args.numberArg(1), op);
    }

    @Override
    public Type orcType() {
        return Types.overload(Types.function(Types.integer(), Types.integer(), Types.integer()), (CallableType)Types.function(Types.number(), Types.number(), Types.number()));
    }

    private static final class MyOperator
    implements Args.NumericBinaryOperator<Number> {
        private MyOperator() {
        }

        @Override
        public Number apply(BigInteger a, BigInteger b) {
            return a.divide(b);
        }

        @Override
        public Number apply(BigDecimal a, BigDecimal b) {
            try {
                return a.divide(b);
            }
            catch (ArithmeticException ae) {
                return a.doubleValue() / b.doubleValue();
            }
        }

        @Override
        public Number apply(int a, int b) {
            return a / b;
        }

        @Override
        public Number apply(long a, long b) {
            return a / b;
        }

        @Override
        public Number apply(byte a, byte b) {
            return a / b;
        }

        @Override
        public Number apply(short a, short b) {
            return a / b;
        }

        @Override
        public Number apply(double a, double b) {
            return a / b;
        }

        @Override
        public Number apply(float a, float b) {
            return Float.valueOf(a / b);
        }
    }
}

