/*
 * Decompiled with CFR 0.152.
 */
package orc.lib.comp;

import java.math.BigDecimal;
import java.math.BigInteger;
import orc.error.runtime.ArgumentTypeMismatchException;
import orc.error.runtime.TokenException;
import orc.types.Type;
import orc.values.sites.TypedSite;
import orc.values.sites.compatibility.Args;
import orc.values.sites.compatibility.EvalSite;
import orc.values.sites.compatibility.Types;

public abstract class ComparisonSite
extends EvalSite
implements TypedSite {
    @Override
    public Object evaluate(Args args) throws TokenException {
        Object arg0 = args.getArg(0);
        Object arg1 = args.getArg(1);
        if (arg0 instanceof Number && arg1 instanceof Number) {
            int a = Args.applyNumericOperator((Number)arg0, (Number)arg1, new MyOperator());
            return this.compare(a);
        }
        if (!(arg0 instanceof Comparable)) {
            throw new ArgumentTypeMismatchException(0, "Comparable<Object>", args.getArg(0).getClass().getCanonicalName());
        }
        int a = ((Comparable)arg0).compareTo(arg1);
        return this.compare(a);
    }

    public abstract boolean compare(int var1);

    @Override
    public Type orcType() {
        return Types.function(Types.top(), Types.top(), Types.bool());
    }

    private static class MyOperator
    implements Args.NumericBinaryOperator<Integer> {
        private MyOperator() {
        }

        @Override
        public Integer apply(BigInteger a, BigInteger b) {
            return a.compareTo(b);
        }

        @Override
        public Integer apply(BigDecimal a, BigDecimal b) {
            return a.compareTo(b);
        }

        @Override
        public Integer apply(int a, int b) {
            return a - b;
        }

        @Override
        public Integer apply(long a, long b) {
            return (int)(a - b);
        }

        @Override
        public Integer apply(byte a, byte b) {
            return a - b;
        }

        @Override
        public Integer apply(short a, short b) {
            return a - b;
        }

        @Override
        public Integer apply(double a, double b) {
            return Double.compare(a, b);
        }

        @Override
        public Integer apply(float a, float b) {
            return Float.compare(a, b);
        }
    }
}

