/*
 * Decompiled with CFR 0.152.
 */
package orc.error.runtime;

import orc.compile.parse.OrcSourceRange;
import orc.error.runtime.ExecutionException;

public abstract class TokenException
extends ExecutionException {
    private static final long serialVersionUID = -9019214813154694088L;
    public OrcSourceRange[] backtrace = new OrcSourceRange[0];

    public TokenException(String message) {
        super(message);
    }

    public TokenException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessageAndDiagnostics() {
        return String.valueOf(this.getMessageAndPositon()) + "\n" + this.getOrcStacktraceAsString();
    }

    public String getOrcStacktraceAsString() {
        StringBuilder sb = new StringBuilder();
        OrcSourceRange[] orcSourceRangeArray = this.backtrace;
        int n = this.backtrace.length;
        int n2 = 0;
        while (n2 < n) {
            OrcSourceRange t = orcSourceRangeArray[n2];
            sb.append("\tcalled at " + t + "\n");
            ++n2;
        }
        return sb.toString();
    }

    public void setBacktrace(OrcSourceRange[] backtrace) {
        this.backtrace = backtrace;
    }

    public OrcSourceRange[] getBacktrace() {
        return this.backtrace;
    }
}

