# Doppelganger - Alter ego for `datomic.api`

Doppelganger tracks and caches "companion values" for a Datomic database.
Companion values are values which can be built incrementally from a Datomic
database in an efficient way.  *Efficient* here assumes that it is expensive to
build the values and cheap to cache them, so they are stored in weak hash
tables.

We use this to keep a running Clara Rules session built from the data in a
Datomic database.

## Usage

Use `doppelganger.api` instead of `datomic.api`.  This is done because
doppelganger needs to wrap `d/with` to be aware of its predecessor dbs.

```clojure
(require '[doppelganger.api :as d])

(defn- datom-counter
  [previous-count tx]
  (reduce
   (fn [count [e a v t added?]]
     (if added?
       (inc count)
       (dec count)))
   previous-count
   tx))

(def datom-count (d/make-getter datom-counter 0))

;; ...

(println (str "number of datoms in db: " (datom-count conn db)))
(println (str "number of datoms in a d/with temporary database: "
	      (datom-count conn (:db-after (d/with db [{:db/ident :foo}])))))
```

## License

Copyright © 2018 2U, Inc.

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
