(ns {{name}}.site.home
  (:require [hiccup.core :as hiccup]
            [ring.util.response :as ring-resp]
            [{{name}}.site :as site]
            [{{name}}.auth :as {{name}}.auth]
            [buddy.auth :as auth]
            [ring.util.response :as ring-resp]))

(defn home-page [request]
  (ring-resp/response
   (site/base request
              {{name}}
              [:div.title.is-3
               "{{name}}"]
              (if (auth/authenticated? request)
                "You are logged in"
                "You are not logged in"))))
