-- :name insert-user :! :n
-- :doc Insert a single user returning affected row count
insert into users (email, username, password)
values (:email, :username, :password)

-- :name user-by-username :? :1
-- :doc Get user by username
select * from users
where username = :username

-- :name user-by-email :? :1
-- :doc Get user by email
select * from users
where email = :email

-- :name delete-by-username :? :1
-- :doc Get user by id
select * from users
where username = :username

-- :name delete-by-email :? :1
-- :doc Get user by id
select * from users
where email = :email

-- :name delete-by-username :! :n
-- :doc Delete user as per username
update users set deleted = true
where username = :username

-- :name delete-by-email :! :n
-- :doc Delete user as per email
update users set deleted = true
where username = :username
