(ns {{name}}.auth.site
  (:require [ring.util.response :as ring-resp]
            [{{name}}.site :as site]
            [{{name}}.auth :as auth]
            ))

(defn register-control [request]
  [:div.column.is-one-third.is-offset-one-third
   [:h1.title.has-text-centered "Register"]
   [:form {:method "POST" :action "/register"}
    (site/form-anti-forgery-token request)
    (site/form-control-email "Email" "email")
    (site/form-control-password "Password" "password")
    (site/form-control-password "Confirm password" "confirm-password")
    (site/form-control-button "Submit")]])

(defn login-control []
  [:div.column.is-one-third.is-offset-one-third
   [:h1.title.has-text-centered "Login"]
   [:form {:method "POST" :action "/login"}
    (site/form-control-email "Email" "email")
    (site/form-control-password "Password" "password")
    (site/form-control-button "Submit")]])

(defn login-page [request]
  (ring-resp/response (site/base
                       "Login"
                       (login-control))))

(defn login-post [request]
  (-> (ring-resp/redirect "/")
      (assoc :session {:token "token"})))

(defn register-page [request]
  (ring-resp/response (site/base
                       "Register"
                       (register-control request))))

(defn register-post [request]
  (let [data (:form-params request)]
  (if (= (:password data) (:confirm-password data))
    (auth/new-user data)
    (ring-resp/response "Password doesn't match")
    )
  ))
  ;; (-> (ring-resp/redirect "/")
  ;;     (assoc :session {:token "token"})))
