(ns scala-clj.players
  (:require [aleph.http :as http]
            [clojure.data.json :as json]
            [clj-scala-ds :refer [body->edn ctx]]))

(defn get-current-state-for-a-player [{:keys [status server token apiToken] :as previous} id]
  (if (= status "login.success")
    (let [path (str  "/" ctx "/api/rest/players/" id "/state")
          url (str server path)]
      (try
        (-> @(http/request  {:url url
                             :request-method "get"
                             :headers {:content-type "application/json"
                                       "apiToken" apiToken
                                       "Cookie" (str "token:" token)}})
              body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))

(defn list-players [{:keys [status server token apiToken] :as previous}]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/players")
          url (str server path)]
      (try
        (-> @(http/request  {:url url
                             :request-method "get"
                             :headers {:content-type "application/json"
                                       "apiToken" apiToken
                                       "Cookie" (str "token:" token)}
                             :query-params {"limit" "1000"}})
              body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))

(defn get-player-plans [{:keys [status server token apiToken] :as previous} id]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/players/" id "/plans")
          url (str server path)]
      (try
        (-> @(http/request  {:url url
                             :request-method "get"
                             :headers {:content-type "application/json"
                                       "apiToken" apiToken
                                       "Cookie" (str "token:" token)}})
              body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))

(defn list-players-inventory [{:keys [status server token apiToken] :as previous} id]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/players/" id "/inventory")
          url (str server path)]
      (try
        (-> @(http/request  {:url url
                             :request-method "get"
                             :headers {:content-type "application/json"
                                       "apiToken" apiToken
                                       "Cookie" (str "token:" token)}
                             :query-params {"limit" "1000"}})
            body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))

(defn request-players-logs [{:keys [status server token apiToken] :as previous} uuid]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/players/" uuid "/requestlog")
          url (str server path)]
      (try
        (-> @(http/request  {:url url
                             :request-method "get"
                             :headers {:content-type "application/json"
                                       "apiToken" apiToken
                                       "Cookie" (str "token:" token)}})
            body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))
