(ns clj-scala-ds.health
  (:require [aleph.http :as http]
            [clojure.data.json :as json]
            [clj-scala-ds :refer [body->edn ctx]]))

(defn find-player-health-information-by-id [{:keys [status server token apiToken] :as previous} playerId fields]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/playerhealth/")
          url (str server path playerId)]
      (try
        (-> @(http/request  {:url url
                             :request-method "get"
                             :headers {:content-type "application/json"
                                       "apiToken" apiToken
                                       "Cookie" (str "token:" token)}
                             :query-params {"fields" (apply str (interpose "," fields))}})
            body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))
