(ns clj-scala-ds.util
  (:require [byte-streams :as bs]            
            [clojure.data.json :as json]
            [clojure.java.io :as io]))

(let [resource (io/resource "config.edn")]
  (def config (-> resource slurp read-string))
  (def ctx (get config :context "ContentManager")))

(defn body->edn [response]
  (-> response :body bs/to-string (json/read-str :key-fn keyword)))
