(ns clj-scala-ds.authentication
  (:require [aleph.http :as http]
            [clojure.data.json :as json]
            [clj-scala-ds.util :refer [body->edn ctx]]))

(defn login [{:keys [server username password]}]
  (let [path (str "/" ctx "/api/rest/auth/login")
        url (str server path)]
    (try
      (-> @(http/request  {:url url
                           :request-method "post"
                           :headers {:content-type "application/json"}
                           :body (json/write-str {:username username :password password})})
          body->edn
          (assoc :server server))
      (catch clojure.lang.ExceptionInfo e
        (.printStackTrace e)
        (-> e .getData body->edn (assoc :server server))))))

(defn logout [{:keys [status server token apiToken] :as previous}]
  (if (= status "login.success")
    (let [path (str "/" ctx "/api/rest/auth/logout")
          url (str server path)]
      (try
        (-> @(http/request  {:url url
                             :request-method "post"
                             :headers {:content-type "application/json"
                                       "apiToken" apiToken
                                       "Cookie" (str "token:" token)}})
            body->edn)
        (catch clojure.lang.ExceptionInfo e
          (.printStackTrace e)
          (-> e .getData body->edn))))
    previous))
