/*
 * Decompiled with CFR 0.152.
 */
package code.lucamarrocco.hoptoad;

import code.lucamarrocco.hoptoad.HoptoadNotice;
import code.lucamarrocco.hoptoad.NoticeApi2;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;

public class HoptoadNotifier {
    private void addingProperties(HttpURLConnection connection) throws ProtocolException {
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-type", "text/xml");
        connection.setRequestProperty("Accept", "text/xml, application/xml");
        connection.setRequestMethod("POST");
    }

    private HttpURLConnection createConnection(HoptoadNotice notice) throws IOException {
        String host = notice.getHost() != null ? notice.getHost() : "hoptoadapp.com";
        String port = notice.getPort() != null ? notice.getPort() : "80";
        String protocol = notice.isSecure() ? "https" : "http";
        HttpURLConnection connection = (HttpURLConnection)new URL(protocol + "://" + host + ":" + port + "/notifier_api/v2/notices").openConnection();
        return connection;
    }

    private void err(HoptoadNotice notice, Exception e) {
        System.out.println(notice.toString());
        e.printStackTrace();
    }

    public int notify(HoptoadNotice notice) {
        try {
            HttpURLConnection toHoptoad = this.createConnection(notice);
            this.addingProperties(toHoptoad);
            String toPost = new NoticeApi2(notice).toString();
            return this.send(toPost, toHoptoad);
        }
        catch (Exception e) {
            this.err(notice, e);
            return 0;
        }
    }

    private int send(String yaml, HttpURLConnection connection) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(yaml);
        writer.close();
        int statusCode = connection.getResponseCode();
        return statusCode;
    }
}

