/*
 * Decompiled with CFR 0.152.
 */
package code.lucamarrocco.hoptoad;

import code.lucamarrocco.hoptoad.Backtrace;
import code.lucamarrocco.hoptoad.HoptoadNotice;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoptoadNoticeBuilder {
    private String apiKey;
    private String projectRoot;
    private String environmentName;
    private String errorMessage;
    private Backtrace backtrace = new Backtrace(Arrays.asList("backtrace is empty"));
    private final Map<String, Object> environment = new TreeMap<String, Object>();
    private Map<String, Object> request = new TreeMap<String, Object>();
    private Map<String, Object> session = new TreeMap<String, Object>();
    private final List<String> environmentFilters = new LinkedList<String>();
    private Backtrace backtraceBuilder = new Backtrace();
    private String errorClass;
    private boolean hasRequest = false;
    private String url;
    private String component;
    private String host;
    private String port;
    private boolean secure;

    public HoptoadNoticeBuilder(String apiKey, Backtrace backtraceBuilder, Throwable throwable, String env) {
        this(apiKey, throwable.getMessage(), env);
        this.backtraceBuilder = backtraceBuilder;
        this.errorClass(throwable);
        this.backtrace(throwable);
    }

    public HoptoadNoticeBuilder(String apiKey, String errorMessage) {
        this(apiKey, errorMessage, "test");
    }

    public HoptoadNoticeBuilder(String apiKey, String errorMessage, String env) {
        this.apiKey(apiKey);
        this.errorMessage(errorMessage);
        this.env(env);
    }

    public HoptoadNoticeBuilder(String apiKey, Throwable throwable) {
        this(apiKey, new Backtrace(), throwable, "test");
    }

    public HoptoadNoticeBuilder(String apiKey, Throwable throwable, String env) {
        this(apiKey, new Backtrace(), throwable, env);
    }

    public HoptoadNoticeBuilder(String apiKey, Throwable throwable, String projectRoot, String env) {
        this(apiKey, new Backtrace(), throwable, env);
        this.projectRoot(projectRoot);
    }

    private void apiKey(String apiKey) {
        if (this.notDefined(apiKey)) {
            this.error("The API key for the project this error is from (required). Get this from the project's page in Hoptoad.");
        }
        this.apiKey = apiKey;
    }

    protected void setRequest(String url, String component) {
        this.hasRequest = true;
        this.url = url;
        this.component = component;
    }

    protected void addSessionKey(String key, Object value) {
        this.session.put(key, value);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    protected void backtrace(Backtrace backtrace) {
        this.backtrace = backtrace;
    }

    private void backtrace(Throwable throwable) {
        this.backtrace(this.backtraceBuilder.newBacktrace(throwable));
    }

    protected void ec2EnvironmentFilters() {
        this.environmentFilter("AWS_SECRET");
        this.environmentFilter("EC2_PRIVATE_KEY");
        this.environmentFilter("AWS_ACCESS");
        this.environmentFilter("EC2_CERT");
    }

    protected void projectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    private void env(String env) {
        this.environmentName = env;
    }

    protected void environment(Map<String, Object> environment) {
        this.environment.putAll(environment);
    }

    protected void environment(Properties properties) {
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            this.environment.put(property.getKey().toString(), property.getValue());
        }
    }

    public void environmentFilter(String filter) {
        this.environmentFilters.add(filter);
    }

    private void error(String message) {
        throw new RuntimeException(message);
    }

    private void errorClass(Throwable throwable) {
        this.errorClass = throwable.getClass().getName();
        if (this.errorMessage == null || this.errorMessage.trim().isEmpty()) {
            this.errorMessage = '[' + throwable.getClass().toString() + ']';
        }
    }

    protected boolean errorClassIs(String possibleErrorClass) {
        return this.errorClass.equals(possibleErrorClass);
    }

    private void errorMessage(String errorMessage) {
        this.errorMessage = this.notDefined(errorMessage) ? "" : errorMessage;
    }

    protected void filteredSystemProperties() {
        this.environment(System.getProperties());
        this.standardEnvironmentFilters();
        this.ec2EnvironmentFilters();
    }

    public HoptoadNotice newNotice() {
        return new HoptoadNotice(this.apiKey, this.projectRoot, this.environmentName, this.errorMessage, this.errorClass, this.backtrace, this.request, this.session, this.environment, this.environmentFilters, this.hasRequest, this.url, this.component, this.host, this.port, this.secure);
    }

    private boolean notDefined(Object object) {
        return object == null;
    }

    protected void request(Map<String, Object> request) {
        this.request = request;
    }

    protected void session(Map<String, Object> session) {
        this.session.putAll(session);
    }

    protected void standardEnvironmentFilters() {
        this.environmentFilter("java.awt.*");
        this.environmentFilter("java.vendor.*");
        this.environmentFilter("java.class.path");
        this.environmentFilter("java.vm.specification.*");
    }
}

