/*
 * Decompiled with CFR 0.152.
 */
package code.lucamarrocco.hoptoad;

import code.lucamarrocco.hoptoad.Backtrace;
import code.lucamarrocco.hoptoad.HoptoadNotice;
import code.lucamarrocco.hoptoad.HoptoadNoticeBuilderUsingFilteredSystemProperties;
import code.lucamarrocco.hoptoad.HoptoadNotifier;
import code.lucamarrocco.hoptoad.QuietRubyBacktrace;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class HoptoadAppender
extends AppenderSkeleton {
    private final HoptoadNotifier hoptoadNotifier = new HoptoadNotifier();
    private String apiKey;
    private String env;
    private boolean enabled;
    private Backtrace backtrace = new QuietRubyBacktrace();
    private String host;
    private String port;
    private boolean secure;

    public HoptoadAppender() {
        this.setThreshold((Priority)Level.ERROR);
    }

    public HoptoadAppender(String apiKey) {
        this.setApi_key(apiKey);
    }

    public HoptoadAppender(String apiKey, Backtrace backtrace) {
        this.setApi_key(apiKey);
        this.setBacktrace(backtrace);
    }

    protected void append(LoggingEvent loggingEvent) {
        if (!this.enabled) {
            return;
        }
        if (this.thereIsThrowableIn(loggingEvent)) {
            this.notifyThrowableIn(loggingEvent);
        }
    }

    public void close() {
    }

    public HoptoadNotice newNoticeFor(Throwable throwable) {
        return new HoptoadNoticeBuilderUsingFilteredSystemProperties(this.apiKey, this.backtrace, throwable, this.env, this.host, this.port, this.secure).newNotice();
    }

    private int notifyThrowableIn(LoggingEvent loggingEvent) {
        return this.hoptoadNotifier.notify(this.newNoticeFor(this.throwable(loggingEvent)));
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setApi_key(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setBacktrace(Backtrace backtrace) {
        this.backtrace = backtrace;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    private boolean thereIsThrowableIn(LoggingEvent loggingEvent) {
        return loggingEvent.getThrowableInformation() != null;
    }

    private Throwable throwable(LoggingEvent loggingEvent) {
        return loggingEvent.getThrowableInformation().getThrowable();
    }
}

