/*
 * Decompiled with CFR 0.152.
 */
package code.lucamarrocco.hoptoad;

import java.text.MessageFormat;
import org.apache.commons.lang.StringEscapeUtils;

public class BacktraceLine {
    private final String className;
    private final String fileName;
    private final int lineNumber;
    private final String methodName;

    public BacktraceLine(String line) {
        String classAndMethodName = line.replaceAll("\\(.*", "").replaceAll("^at ", "");
        int periodSepIndex = classAndMethodName.lastIndexOf(".");
        this.className = periodSepIndex > 0 ? classAndMethodName.substring(0, classAndMethodName.lastIndexOf(".")) : classAndMethodName;
        this.fileName = line.replaceAll("^.*\\(", "").replaceAll(":.*", "");
        this.lineNumber = this.lineNumber(line);
        this.methodName = classAndMethodName.substring(classAndMethodName.lastIndexOf(".") + 1);
    }

    public BacktraceLine(String className, String fileName, int lineNumber, String methodName) {
        this.className = className;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.methodName = methodName;
    }

    String className() {
        return this.className;
    }

    String fileName() {
        return this.fileName;
    }

    int lineNumber() {
        return this.lineNumber;
    }

    private int lineNumber(String line) {
        try {
            return Integer.parseInt(line.replaceAll("^.*:", "").replaceAll("\\)", ""));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String methodName() {
        return this.methodName;
    }

    private String toBacktrace(String className, String fileName, int lineNumber, String methodName) {
        return MessageFormat.format("at {0}.{1}({2}:{3})", className, methodName, fileName, lineNumber);
    }

    public String toString() {
        return this.toBacktrace(this.className, this.fileName, this.lineNumber, this.methodName);
    }

    public String toXml() {
        return MessageFormat.format("<line method=\"{0}.{1}\" file=\"{2}\" number=\"{3}\"/>", StringEscapeUtils.escapeXml((String)this.className), StringEscapeUtils.escapeXml((String)this.methodName), StringEscapeUtils.escapeXml((String)this.fileName), this.lineNumber);
    }
}

