// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__20255__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__20255__auto__){
return or__20255__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__20255__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__26010_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__26010_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__26015 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__26016 = null;
var count__26017 = (0);
var i__26018 = (0);
while(true){
if((i__26018 < count__26017)){
var n = cljs.core._nth.call(null,chunk__26016,i__26018);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__26019 = seq__26015;
var G__26020 = chunk__26016;
var G__26021 = count__26017;
var G__26022 = (i__26018 + (1));
seq__26015 = G__26019;
chunk__26016 = G__26020;
count__26017 = G__26021;
i__26018 = G__26022;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__26015);
if(temp__4657__auto__){
var seq__26015__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26015__$1)){
var c__21069__auto__ = cljs.core.chunk_first.call(null,seq__26015__$1);
var G__26023 = cljs.core.chunk_rest.call(null,seq__26015__$1);
var G__26024 = c__21069__auto__;
var G__26025 = cljs.core.count.call(null,c__21069__auto__);
var G__26026 = (0);
seq__26015 = G__26023;
chunk__26016 = G__26024;
count__26017 = G__26025;
i__26018 = G__26026;
continue;
} else {
var n = cljs.core.first.call(null,seq__26015__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__26027 = cljs.core.next.call(null,seq__26015__$1);
var G__26028 = null;
var G__26029 = (0);
var G__26030 = (0);
seq__26015 = G__26027;
chunk__26016 = G__26028;
count__26017 = G__26029;
i__26018 = G__26030;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__26081_26092 = cljs.core.seq.call(null,deps);
var chunk__26082_26093 = null;
var count__26083_26094 = (0);
var i__26084_26095 = (0);
while(true){
if((i__26084_26095 < count__26083_26094)){
var dep_26096 = cljs.core._nth.call(null,chunk__26082_26093,i__26084_26095);
topo_sort_helper_STAR_.call(null,dep_26096,(depth + (1)),state);

var G__26097 = seq__26081_26092;
var G__26098 = chunk__26082_26093;
var G__26099 = count__26083_26094;
var G__26100 = (i__26084_26095 + (1));
seq__26081_26092 = G__26097;
chunk__26082_26093 = G__26098;
count__26083_26094 = G__26099;
i__26084_26095 = G__26100;
continue;
} else {
var temp__4657__auto___26101 = cljs.core.seq.call(null,seq__26081_26092);
if(temp__4657__auto___26101){
var seq__26081_26102__$1 = temp__4657__auto___26101;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26081_26102__$1)){
var c__21069__auto___26103 = cljs.core.chunk_first.call(null,seq__26081_26102__$1);
var G__26104 = cljs.core.chunk_rest.call(null,seq__26081_26102__$1);
var G__26105 = c__21069__auto___26103;
var G__26106 = cljs.core.count.call(null,c__21069__auto___26103);
var G__26107 = (0);
seq__26081_26092 = G__26104;
chunk__26082_26093 = G__26105;
count__26083_26094 = G__26106;
i__26084_26095 = G__26107;
continue;
} else {
var dep_26108 = cljs.core.first.call(null,seq__26081_26102__$1);
topo_sort_helper_STAR_.call(null,dep_26108,(depth + (1)),state);

var G__26109 = cljs.core.next.call(null,seq__26081_26102__$1);
var G__26110 = null;
var G__26111 = (0);
var G__26112 = (0);
seq__26081_26092 = G__26109;
chunk__26082_26093 = G__26110;
count__26083_26094 = G__26111;
i__26084_26095 = G__26112;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__26085){
var vec__26089 = p__26085;
var seq__26090 = cljs.core.seq.call(null,vec__26089);
var first__26091 = cljs.core.first.call(null,seq__26090);
var seq__26090__$1 = cljs.core.next.call(null,seq__26090);
var x = first__26091;
var xs = seq__26090__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__26089,seq__26090,first__26091,seq__26090__$1,x,xs,get_deps__$1){
return (function (p1__26031_SHARP_){
return clojure.set.difference.call(null,p1__26031_SHARP_,x);
});})(vec__26089,seq__26090,first__26091,seq__26090__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__26125 = cljs.core.seq.call(null,provides);
var chunk__26126 = null;
var count__26127 = (0);
var i__26128 = (0);
while(true){
if((i__26128 < count__26127)){
var prov = cljs.core._nth.call(null,chunk__26126,i__26128);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__26129_26137 = cljs.core.seq.call(null,requires);
var chunk__26130_26138 = null;
var count__26131_26139 = (0);
var i__26132_26140 = (0);
while(true){
if((i__26132_26140 < count__26131_26139)){
var req_26141 = cljs.core._nth.call(null,chunk__26130_26138,i__26132_26140);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26141,prov);

var G__26142 = seq__26129_26137;
var G__26143 = chunk__26130_26138;
var G__26144 = count__26131_26139;
var G__26145 = (i__26132_26140 + (1));
seq__26129_26137 = G__26142;
chunk__26130_26138 = G__26143;
count__26131_26139 = G__26144;
i__26132_26140 = G__26145;
continue;
} else {
var temp__4657__auto___26146 = cljs.core.seq.call(null,seq__26129_26137);
if(temp__4657__auto___26146){
var seq__26129_26147__$1 = temp__4657__auto___26146;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26129_26147__$1)){
var c__21069__auto___26148 = cljs.core.chunk_first.call(null,seq__26129_26147__$1);
var G__26149 = cljs.core.chunk_rest.call(null,seq__26129_26147__$1);
var G__26150 = c__21069__auto___26148;
var G__26151 = cljs.core.count.call(null,c__21069__auto___26148);
var G__26152 = (0);
seq__26129_26137 = G__26149;
chunk__26130_26138 = G__26150;
count__26131_26139 = G__26151;
i__26132_26140 = G__26152;
continue;
} else {
var req_26153 = cljs.core.first.call(null,seq__26129_26147__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26153,prov);

var G__26154 = cljs.core.next.call(null,seq__26129_26147__$1);
var G__26155 = null;
var G__26156 = (0);
var G__26157 = (0);
seq__26129_26137 = G__26154;
chunk__26130_26138 = G__26155;
count__26131_26139 = G__26156;
i__26132_26140 = G__26157;
continue;
}
} else {
}
}
break;
}

var G__26158 = seq__26125;
var G__26159 = chunk__26126;
var G__26160 = count__26127;
var G__26161 = (i__26128 + (1));
seq__26125 = G__26158;
chunk__26126 = G__26159;
count__26127 = G__26160;
i__26128 = G__26161;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__26125);
if(temp__4657__auto__){
var seq__26125__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26125__$1)){
var c__21069__auto__ = cljs.core.chunk_first.call(null,seq__26125__$1);
var G__26162 = cljs.core.chunk_rest.call(null,seq__26125__$1);
var G__26163 = c__21069__auto__;
var G__26164 = cljs.core.count.call(null,c__21069__auto__);
var G__26165 = (0);
seq__26125 = G__26162;
chunk__26126 = G__26163;
count__26127 = G__26164;
i__26128 = G__26165;
continue;
} else {
var prov = cljs.core.first.call(null,seq__26125__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__26133_26166 = cljs.core.seq.call(null,requires);
var chunk__26134_26167 = null;
var count__26135_26168 = (0);
var i__26136_26169 = (0);
while(true){
if((i__26136_26169 < count__26135_26168)){
var req_26170 = cljs.core._nth.call(null,chunk__26134_26167,i__26136_26169);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26170,prov);

var G__26171 = seq__26133_26166;
var G__26172 = chunk__26134_26167;
var G__26173 = count__26135_26168;
var G__26174 = (i__26136_26169 + (1));
seq__26133_26166 = G__26171;
chunk__26134_26167 = G__26172;
count__26135_26168 = G__26173;
i__26136_26169 = G__26174;
continue;
} else {
var temp__4657__auto___26175__$1 = cljs.core.seq.call(null,seq__26133_26166);
if(temp__4657__auto___26175__$1){
var seq__26133_26176__$1 = temp__4657__auto___26175__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26133_26176__$1)){
var c__21069__auto___26177 = cljs.core.chunk_first.call(null,seq__26133_26176__$1);
var G__26178 = cljs.core.chunk_rest.call(null,seq__26133_26176__$1);
var G__26179 = c__21069__auto___26177;
var G__26180 = cljs.core.count.call(null,c__21069__auto___26177);
var G__26181 = (0);
seq__26133_26166 = G__26178;
chunk__26134_26167 = G__26179;
count__26135_26168 = G__26180;
i__26136_26169 = G__26181;
continue;
} else {
var req_26182 = cljs.core.first.call(null,seq__26133_26176__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26182,prov);

var G__26183 = cljs.core.next.call(null,seq__26133_26176__$1);
var G__26184 = null;
var G__26185 = (0);
var G__26186 = (0);
seq__26133_26166 = G__26183;
chunk__26134_26167 = G__26184;
count__26135_26168 = G__26185;
i__26136_26169 = G__26186;
continue;
}
} else {
}
}
break;
}

var G__26187 = cljs.core.next.call(null,seq__26125__$1);
var G__26188 = null;
var G__26189 = (0);
var G__26190 = (0);
seq__26125 = G__26187;
chunk__26126 = G__26188;
count__26127 = G__26189;
i__26128 = G__26190;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__26195_26199 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__26196_26200 = null;
var count__26197_26201 = (0);
var i__26198_26202 = (0);
while(true){
if((i__26198_26202 < count__26197_26201)){
var ns_26203 = cljs.core._nth.call(null,chunk__26196_26200,i__26198_26202);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_26203);

var G__26204 = seq__26195_26199;
var G__26205 = chunk__26196_26200;
var G__26206 = count__26197_26201;
var G__26207 = (i__26198_26202 + (1));
seq__26195_26199 = G__26204;
chunk__26196_26200 = G__26205;
count__26197_26201 = G__26206;
i__26198_26202 = G__26207;
continue;
} else {
var temp__4657__auto___26208 = cljs.core.seq.call(null,seq__26195_26199);
if(temp__4657__auto___26208){
var seq__26195_26209__$1 = temp__4657__auto___26208;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26195_26209__$1)){
var c__21069__auto___26210 = cljs.core.chunk_first.call(null,seq__26195_26209__$1);
var G__26211 = cljs.core.chunk_rest.call(null,seq__26195_26209__$1);
var G__26212 = c__21069__auto___26210;
var G__26213 = cljs.core.count.call(null,c__21069__auto___26210);
var G__26214 = (0);
seq__26195_26199 = G__26211;
chunk__26196_26200 = G__26212;
count__26197_26201 = G__26213;
i__26198_26202 = G__26214;
continue;
} else {
var ns_26215 = cljs.core.first.call(null,seq__26195_26209__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_26215);

var G__26216 = cljs.core.next.call(null,seq__26195_26209__$1);
var G__26217 = null;
var G__26218 = (0);
var G__26219 = (0);
seq__26195_26199 = G__26216;
chunk__26196_26200 = G__26217;
count__26197_26201 = G__26218;
i__26198_26202 = G__26219;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__20255__auto__ = goog.require__;
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__26220__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__26220 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__26221__i = 0, G__26221__a = new Array(arguments.length -  0);
while (G__26221__i < G__26221__a.length) {G__26221__a[G__26221__i] = arguments[G__26221__i + 0]; ++G__26221__i;}
  args = new cljs.core.IndexedSeq(G__26221__a,0);
} 
return G__26220__delegate.call(this,args);};
G__26220.cljs$lang$maxFixedArity = 0;
G__26220.cljs$lang$applyTo = (function (arglist__26222){
var args = cljs.core.seq(arglist__26222);
return G__26220__delegate(args);
});
G__26220.cljs$core$IFn$_invoke$arity$variadic = G__26220__delegate;
return G__26220;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__26224 = cljs.core._EQ_;
var expr__26225 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__26224.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__26225))){
var path_parts = ((function (pred__26224,expr__26225){
return (function (p1__26223_SHARP_){
return clojure.string.split.call(null,p1__26223_SHARP_,/[\/\\]/);
});})(pred__26224,expr__26225))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__26224,expr__26225){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e26227){if((e26227 instanceof Error)){
var e = e26227;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e26227;

}
}})());
});
;})(path_parts,sep,root,pred__26224,expr__26225))
} else {
if(cljs.core.truth_(pred__26224.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__26225))){
return ((function (pred__26224,expr__26225){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__26224,expr__26225){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__26224,expr__26225))
);

return deferred.addErrback(((function (deferred,pred__26224,expr__26225){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__26224,expr__26225))
);
});
;})(pred__26224,expr__26225))
} else {
return ((function (pred__26224,expr__26225){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__26224,expr__26225))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__26228,callback){
var map__26231 = p__26228;
var map__26231__$1 = ((((!((map__26231 == null)))?((((map__26231.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26231.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26231):map__26231);
var file_msg = map__26231__$1;
var request_url = cljs.core.get.call(null,map__26231__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__26231,map__26231__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__26231,map__26231__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__23149__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto__){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto__){
return (function (state_26255){
var state_val_26256 = (state_26255[(1)]);
if((state_val_26256 === (7))){
var inst_26251 = (state_26255[(2)]);
var state_26255__$1 = state_26255;
var statearr_26257_26277 = state_26255__$1;
(statearr_26257_26277[(2)] = inst_26251);

(statearr_26257_26277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26256 === (1))){
var state_26255__$1 = state_26255;
var statearr_26258_26278 = state_26255__$1;
(statearr_26258_26278[(2)] = null);

(statearr_26258_26278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26256 === (4))){
var inst_26235 = (state_26255[(7)]);
var inst_26235__$1 = (state_26255[(2)]);
var state_26255__$1 = (function (){var statearr_26259 = state_26255;
(statearr_26259[(7)] = inst_26235__$1);

return statearr_26259;
})();
if(cljs.core.truth_(inst_26235__$1)){
var statearr_26260_26279 = state_26255__$1;
(statearr_26260_26279[(1)] = (5));

} else {
var statearr_26261_26280 = state_26255__$1;
(statearr_26261_26280[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26256 === (6))){
var state_26255__$1 = state_26255;
var statearr_26262_26281 = state_26255__$1;
(statearr_26262_26281[(2)] = null);

(statearr_26262_26281[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26256 === (3))){
var inst_26253 = (state_26255[(2)]);
var state_26255__$1 = state_26255;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26255__$1,inst_26253);
} else {
if((state_val_26256 === (2))){
var state_26255__$1 = state_26255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26255__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_26256 === (11))){
var inst_26247 = (state_26255[(2)]);
var state_26255__$1 = (function (){var statearr_26263 = state_26255;
(statearr_26263[(8)] = inst_26247);

return statearr_26263;
})();
var statearr_26264_26282 = state_26255__$1;
(statearr_26264_26282[(2)] = null);

(statearr_26264_26282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26256 === (9))){
var inst_26239 = (state_26255[(9)]);
var inst_26241 = (state_26255[(10)]);
var inst_26243 = inst_26241.call(null,inst_26239);
var state_26255__$1 = state_26255;
var statearr_26265_26283 = state_26255__$1;
(statearr_26265_26283[(2)] = inst_26243);

(statearr_26265_26283[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26256 === (5))){
var inst_26235 = (state_26255[(7)]);
var inst_26237 = figwheel.client.file_reloading.blocking_load.call(null,inst_26235);
var state_26255__$1 = state_26255;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26255__$1,(8),inst_26237);
} else {
if((state_val_26256 === (10))){
var inst_26239 = (state_26255[(9)]);
var inst_26245 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_26239);
var state_26255__$1 = state_26255;
var statearr_26266_26284 = state_26255__$1;
(statearr_26266_26284[(2)] = inst_26245);

(statearr_26266_26284[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26256 === (8))){
var inst_26241 = (state_26255[(10)]);
var inst_26235 = (state_26255[(7)]);
var inst_26239 = (state_26255[(2)]);
var inst_26240 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_26241__$1 = cljs.core.get.call(null,inst_26240,inst_26235);
var state_26255__$1 = (function (){var statearr_26267 = state_26255;
(statearr_26267[(9)] = inst_26239);

(statearr_26267[(10)] = inst_26241__$1);

return statearr_26267;
})();
if(cljs.core.truth_(inst_26241__$1)){
var statearr_26268_26285 = state_26255__$1;
(statearr_26268_26285[(1)] = (9));

} else {
var statearr_26269_26286 = state_26255__$1;
(statearr_26269_26286[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto__))
;
return ((function (switch__23037__auto__,c__23149__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__23038__auto__ = null;
var figwheel$client$file_reloading$state_machine__23038__auto____0 = (function (){
var statearr_26273 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26273[(0)] = figwheel$client$file_reloading$state_machine__23038__auto__);

(statearr_26273[(1)] = (1));

return statearr_26273;
});
var figwheel$client$file_reloading$state_machine__23038__auto____1 = (function (state_26255){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_26255);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e26274){if((e26274 instanceof Object)){
var ex__23041__auto__ = e26274;
var statearr_26275_26287 = state_26255;
(statearr_26275_26287[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26255);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26274;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26288 = state_26255;
state_26255 = G__26288;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__23038__auto__ = function(state_26255){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__23038__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__23038__auto____1.call(this,state_26255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__23038__auto____0;
figwheel$client$file_reloading$state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__23038__auto____1;
return figwheel$client$file_reloading$state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto__))
})();
var state__23151__auto__ = (function (){var statearr_26276 = f__23150__auto__.call(null);
(statearr_26276[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto__);

return statearr_26276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto__))
);

return c__23149__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__26289,callback){
var map__26292 = p__26289;
var map__26292__$1 = ((((!((map__26292 == null)))?((((map__26292.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26292.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26292):map__26292);
var file_msg = map__26292__$1;
var namespace = cljs.core.get.call(null,map__26292__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__26292,map__26292__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__26292,map__26292__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__26294){
var map__26297 = p__26294;
var map__26297__$1 = ((((!((map__26297 == null)))?((((map__26297.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26297.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26297):map__26297);
var file_msg = map__26297__$1;
var namespace = cljs.core.get.call(null,map__26297__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__20243__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__20243__auto__){
var or__20255__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__20255__auto__)){
return or__20255__auto__;
} else {
var or__20255__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__20255__auto____$1)){
return or__20255__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__20243__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__26299,callback){
var map__26302 = p__26299;
var map__26302__$1 = ((((!((map__26302 == null)))?((((map__26302.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26302.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26302):map__26302);
var file_msg = map__26302__$1;
var request_url = cljs.core.get.call(null,map__26302__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__26302__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__23149__auto___26406 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto___26406,out){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto___26406,out){
return (function (state_26388){
var state_val_26389 = (state_26388[(1)]);
if((state_val_26389 === (1))){
var inst_26362 = cljs.core.seq.call(null,files);
var inst_26363 = cljs.core.first.call(null,inst_26362);
var inst_26364 = cljs.core.next.call(null,inst_26362);
var inst_26365 = files;
var state_26388__$1 = (function (){var statearr_26390 = state_26388;
(statearr_26390[(7)] = inst_26364);

(statearr_26390[(8)] = inst_26363);

(statearr_26390[(9)] = inst_26365);

return statearr_26390;
})();
var statearr_26391_26407 = state_26388__$1;
(statearr_26391_26407[(2)] = null);

(statearr_26391_26407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26389 === (2))){
var inst_26371 = (state_26388[(10)]);
var inst_26365 = (state_26388[(9)]);
var inst_26370 = cljs.core.seq.call(null,inst_26365);
var inst_26371__$1 = cljs.core.first.call(null,inst_26370);
var inst_26372 = cljs.core.next.call(null,inst_26370);
var inst_26373 = (inst_26371__$1 == null);
var inst_26374 = cljs.core.not.call(null,inst_26373);
var state_26388__$1 = (function (){var statearr_26392 = state_26388;
(statearr_26392[(10)] = inst_26371__$1);

(statearr_26392[(11)] = inst_26372);

return statearr_26392;
})();
if(inst_26374){
var statearr_26393_26408 = state_26388__$1;
(statearr_26393_26408[(1)] = (4));

} else {
var statearr_26394_26409 = state_26388__$1;
(statearr_26394_26409[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26389 === (3))){
var inst_26386 = (state_26388[(2)]);
var state_26388__$1 = state_26388;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26388__$1,inst_26386);
} else {
if((state_val_26389 === (4))){
var inst_26371 = (state_26388[(10)]);
var inst_26376 = figwheel.client.file_reloading.reload_js_file.call(null,inst_26371);
var state_26388__$1 = state_26388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26388__$1,(7),inst_26376);
} else {
if((state_val_26389 === (5))){
var inst_26382 = cljs.core.async.close_BANG_.call(null,out);
var state_26388__$1 = state_26388;
var statearr_26395_26410 = state_26388__$1;
(statearr_26395_26410[(2)] = inst_26382);

(statearr_26395_26410[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26389 === (6))){
var inst_26384 = (state_26388[(2)]);
var state_26388__$1 = state_26388;
var statearr_26396_26411 = state_26388__$1;
(statearr_26396_26411[(2)] = inst_26384);

(statearr_26396_26411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26389 === (7))){
var inst_26372 = (state_26388[(11)]);
var inst_26378 = (state_26388[(2)]);
var inst_26379 = cljs.core.async.put_BANG_.call(null,out,inst_26378);
var inst_26365 = inst_26372;
var state_26388__$1 = (function (){var statearr_26397 = state_26388;
(statearr_26397[(12)] = inst_26379);

(statearr_26397[(9)] = inst_26365);

return statearr_26397;
})();
var statearr_26398_26412 = state_26388__$1;
(statearr_26398_26412[(2)] = null);

(statearr_26398_26412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__23149__auto___26406,out))
;
return ((function (switch__23037__auto__,c__23149__auto___26406,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto____0 = (function (){
var statearr_26402 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26402[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto__);

(statearr_26402[(1)] = (1));

return statearr_26402;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto____1 = (function (state_26388){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_26388);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e26403){if((e26403 instanceof Object)){
var ex__23041__auto__ = e26403;
var statearr_26404_26413 = state_26388;
(statearr_26404_26413[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26388);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26403;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26414 = state_26388;
state_26388 = G__26414;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto__ = function(state_26388){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto____1.call(this,state_26388);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto___26406,out))
})();
var state__23151__auto__ = (function (){var statearr_26405 = f__23150__auto__.call(null);
(statearr_26405[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto___26406);

return statearr_26405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto___26406,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__26415,opts){
var map__26419 = p__26415;
var map__26419__$1 = ((((!((map__26419 == null)))?((((map__26419.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26419.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26419):map__26419);
var eval_body = cljs.core.get.call(null,map__26419__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__26419__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__20243__auto__ = eval_body;
if(cljs.core.truth_(and__20243__auto__)){
return typeof eval_body === 'string';
} else {
return and__20243__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e26421){var e = e26421;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__26422_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__26422_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__26431){
var vec__26432 = p__26431;
var k = cljs.core.nth.call(null,vec__26432,(0),null);
var v = cljs.core.nth.call(null,vec__26432,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__26435){
var vec__26436 = p__26435;
var k = cljs.core.nth.call(null,vec__26436,(0),null);
var v = cljs.core.nth.call(null,vec__26436,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__26442,p__26443){
var map__26691 = p__26442;
var map__26691__$1 = ((((!((map__26691 == null)))?((((map__26691.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26691.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26691):map__26691);
var opts = map__26691__$1;
var before_jsload = cljs.core.get.call(null,map__26691__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__26691__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__26691__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__26692 = p__26443;
var map__26692__$1 = ((((!((map__26692 == null)))?((((map__26692.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26692.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26692):map__26692);
var msg = map__26692__$1;
var files = cljs.core.get.call(null,map__26692__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__26692__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__26692__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__23149__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__23150__auto__ = (function (){var switch__23037__auto__ = ((function (c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_26846){
var state_val_26847 = (state_26846[(1)]);
if((state_val_26847 === (7))){
var inst_26708 = (state_26846[(7)]);
var inst_26709 = (state_26846[(8)]);
var inst_26707 = (state_26846[(9)]);
var inst_26706 = (state_26846[(10)]);
var inst_26714 = cljs.core._nth.call(null,inst_26707,inst_26709);
var inst_26715 = figwheel.client.file_reloading.eval_body.call(null,inst_26714,opts);
var inst_26716 = (inst_26709 + (1));
var tmp26848 = inst_26708;
var tmp26849 = inst_26707;
var tmp26850 = inst_26706;
var inst_26706__$1 = tmp26850;
var inst_26707__$1 = tmp26849;
var inst_26708__$1 = tmp26848;
var inst_26709__$1 = inst_26716;
var state_26846__$1 = (function (){var statearr_26851 = state_26846;
(statearr_26851[(11)] = inst_26715);

(statearr_26851[(7)] = inst_26708__$1);

(statearr_26851[(8)] = inst_26709__$1);

(statearr_26851[(9)] = inst_26707__$1);

(statearr_26851[(10)] = inst_26706__$1);

return statearr_26851;
})();
var statearr_26852_26938 = state_26846__$1;
(statearr_26852_26938[(2)] = null);

(statearr_26852_26938[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (20))){
var inst_26749 = (state_26846[(12)]);
var inst_26757 = figwheel.client.file_reloading.sort_files.call(null,inst_26749);
var state_26846__$1 = state_26846;
var statearr_26853_26939 = state_26846__$1;
(statearr_26853_26939[(2)] = inst_26757);

(statearr_26853_26939[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (27))){
var state_26846__$1 = state_26846;
var statearr_26854_26940 = state_26846__$1;
(statearr_26854_26940[(2)] = null);

(statearr_26854_26940[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (1))){
var inst_26698 = (state_26846[(13)]);
var inst_26695 = before_jsload.call(null,files);
var inst_26696 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_26697 = (function (){return ((function (inst_26698,inst_26695,inst_26696,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26439_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__26439_SHARP_);
});
;})(inst_26698,inst_26695,inst_26696,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26698__$1 = cljs.core.filter.call(null,inst_26697,files);
var inst_26699 = cljs.core.not_empty.call(null,inst_26698__$1);
var state_26846__$1 = (function (){var statearr_26855 = state_26846;
(statearr_26855[(13)] = inst_26698__$1);

(statearr_26855[(14)] = inst_26695);

(statearr_26855[(15)] = inst_26696);

return statearr_26855;
})();
if(cljs.core.truth_(inst_26699)){
var statearr_26856_26941 = state_26846__$1;
(statearr_26856_26941[(1)] = (2));

} else {
var statearr_26857_26942 = state_26846__$1;
(statearr_26857_26942[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (24))){
var state_26846__$1 = state_26846;
var statearr_26858_26943 = state_26846__$1;
(statearr_26858_26943[(2)] = null);

(statearr_26858_26943[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (39))){
var inst_26799 = (state_26846[(16)]);
var state_26846__$1 = state_26846;
var statearr_26859_26944 = state_26846__$1;
(statearr_26859_26944[(2)] = inst_26799);

(statearr_26859_26944[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (46))){
var inst_26841 = (state_26846[(2)]);
var state_26846__$1 = state_26846;
var statearr_26860_26945 = state_26846__$1;
(statearr_26860_26945[(2)] = inst_26841);

(statearr_26860_26945[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (4))){
var inst_26743 = (state_26846[(2)]);
var inst_26744 = cljs.core.List.EMPTY;
var inst_26745 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_26744);
var inst_26746 = (function (){return ((function (inst_26743,inst_26744,inst_26745,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26440_SHARP_){
var and__20243__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__26440_SHARP_);
if(cljs.core.truth_(and__20243__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__26440_SHARP_));
} else {
return and__20243__auto__;
}
});
;})(inst_26743,inst_26744,inst_26745,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26747 = cljs.core.filter.call(null,inst_26746,files);
var inst_26748 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_26749 = cljs.core.concat.call(null,inst_26747,inst_26748);
var state_26846__$1 = (function (){var statearr_26861 = state_26846;
(statearr_26861[(17)] = inst_26745);

(statearr_26861[(18)] = inst_26743);

(statearr_26861[(12)] = inst_26749);

return statearr_26861;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_26862_26946 = state_26846__$1;
(statearr_26862_26946[(1)] = (16));

} else {
var statearr_26863_26947 = state_26846__$1;
(statearr_26863_26947[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (15))){
var inst_26733 = (state_26846[(2)]);
var state_26846__$1 = state_26846;
var statearr_26864_26948 = state_26846__$1;
(statearr_26864_26948[(2)] = inst_26733);

(statearr_26864_26948[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (21))){
var inst_26759 = (state_26846[(19)]);
var inst_26759__$1 = (state_26846[(2)]);
var inst_26760 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_26759__$1);
var state_26846__$1 = (function (){var statearr_26865 = state_26846;
(statearr_26865[(19)] = inst_26759__$1);

return statearr_26865;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26846__$1,(22),inst_26760);
} else {
if((state_val_26847 === (31))){
var inst_26844 = (state_26846[(2)]);
var state_26846__$1 = state_26846;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26846__$1,inst_26844);
} else {
if((state_val_26847 === (32))){
var inst_26799 = (state_26846[(16)]);
var inst_26804 = inst_26799.cljs$lang$protocol_mask$partition0$;
var inst_26805 = (inst_26804 & (64));
var inst_26806 = inst_26799.cljs$core$ISeq$;
var inst_26807 = (cljs.core.PROTOCOL_SENTINEL === inst_26806);
var inst_26808 = (inst_26805) || (inst_26807);
var state_26846__$1 = state_26846;
if(cljs.core.truth_(inst_26808)){
var statearr_26866_26949 = state_26846__$1;
(statearr_26866_26949[(1)] = (35));

} else {
var statearr_26867_26950 = state_26846__$1;
(statearr_26867_26950[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (40))){
var inst_26821 = (state_26846[(20)]);
var inst_26820 = (state_26846[(2)]);
var inst_26821__$1 = cljs.core.get.call(null,inst_26820,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_26822 = cljs.core.get.call(null,inst_26820,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_26823 = cljs.core.not_empty.call(null,inst_26821__$1);
var state_26846__$1 = (function (){var statearr_26868 = state_26846;
(statearr_26868[(20)] = inst_26821__$1);

(statearr_26868[(21)] = inst_26822);

return statearr_26868;
})();
if(cljs.core.truth_(inst_26823)){
var statearr_26869_26951 = state_26846__$1;
(statearr_26869_26951[(1)] = (41));

} else {
var statearr_26870_26952 = state_26846__$1;
(statearr_26870_26952[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (33))){
var state_26846__$1 = state_26846;
var statearr_26871_26953 = state_26846__$1;
(statearr_26871_26953[(2)] = false);

(statearr_26871_26953[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (13))){
var inst_26719 = (state_26846[(22)]);
var inst_26723 = cljs.core.chunk_first.call(null,inst_26719);
var inst_26724 = cljs.core.chunk_rest.call(null,inst_26719);
var inst_26725 = cljs.core.count.call(null,inst_26723);
var inst_26706 = inst_26724;
var inst_26707 = inst_26723;
var inst_26708 = inst_26725;
var inst_26709 = (0);
var state_26846__$1 = (function (){var statearr_26872 = state_26846;
(statearr_26872[(7)] = inst_26708);

(statearr_26872[(8)] = inst_26709);

(statearr_26872[(9)] = inst_26707);

(statearr_26872[(10)] = inst_26706);

return statearr_26872;
})();
var statearr_26873_26954 = state_26846__$1;
(statearr_26873_26954[(2)] = null);

(statearr_26873_26954[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (22))){
var inst_26759 = (state_26846[(19)]);
var inst_26767 = (state_26846[(23)]);
var inst_26762 = (state_26846[(24)]);
var inst_26763 = (state_26846[(25)]);
var inst_26762__$1 = (state_26846[(2)]);
var inst_26763__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26762__$1);
var inst_26764 = (function (){var all_files = inst_26759;
var res_SINGLEQUOTE_ = inst_26762__$1;
var res = inst_26763__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_26759,inst_26767,inst_26762,inst_26763,inst_26762__$1,inst_26763__$1,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26441_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__26441_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_26759,inst_26767,inst_26762,inst_26763,inst_26762__$1,inst_26763__$1,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26765 = cljs.core.filter.call(null,inst_26764,inst_26762__$1);
var inst_26766 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_26767__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26766);
var inst_26768 = cljs.core.not_empty.call(null,inst_26767__$1);
var state_26846__$1 = (function (){var statearr_26874 = state_26846;
(statearr_26874[(23)] = inst_26767__$1);

(statearr_26874[(24)] = inst_26762__$1);

(statearr_26874[(25)] = inst_26763__$1);

(statearr_26874[(26)] = inst_26765);

return statearr_26874;
})();
if(cljs.core.truth_(inst_26768)){
var statearr_26875_26955 = state_26846__$1;
(statearr_26875_26955[(1)] = (23));

} else {
var statearr_26876_26956 = state_26846__$1;
(statearr_26876_26956[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (36))){
var state_26846__$1 = state_26846;
var statearr_26877_26957 = state_26846__$1;
(statearr_26877_26957[(2)] = false);

(statearr_26877_26957[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (41))){
var inst_26821 = (state_26846[(20)]);
var inst_26825 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_26826 = cljs.core.map.call(null,inst_26825,inst_26821);
var inst_26827 = cljs.core.pr_str.call(null,inst_26826);
var inst_26828 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_26827)].join('');
var inst_26829 = figwheel.client.utils.log.call(null,inst_26828);
var state_26846__$1 = state_26846;
var statearr_26878_26958 = state_26846__$1;
(statearr_26878_26958[(2)] = inst_26829);

(statearr_26878_26958[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (43))){
var inst_26822 = (state_26846[(21)]);
var inst_26832 = (state_26846[(2)]);
var inst_26833 = cljs.core.not_empty.call(null,inst_26822);
var state_26846__$1 = (function (){var statearr_26879 = state_26846;
(statearr_26879[(27)] = inst_26832);

return statearr_26879;
})();
if(cljs.core.truth_(inst_26833)){
var statearr_26880_26959 = state_26846__$1;
(statearr_26880_26959[(1)] = (44));

} else {
var statearr_26881_26960 = state_26846__$1;
(statearr_26881_26960[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (29))){
var inst_26759 = (state_26846[(19)]);
var inst_26767 = (state_26846[(23)]);
var inst_26762 = (state_26846[(24)]);
var inst_26799 = (state_26846[(16)]);
var inst_26763 = (state_26846[(25)]);
var inst_26765 = (state_26846[(26)]);
var inst_26795 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_26798 = (function (){var all_files = inst_26759;
var res_SINGLEQUOTE_ = inst_26762;
var res = inst_26763;
var files_not_loaded = inst_26765;
var dependencies_that_loaded = inst_26767;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26759,inst_26767,inst_26762,inst_26799,inst_26763,inst_26765,inst_26795,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26797){
var map__26882 = p__26797;
var map__26882__$1 = ((((!((map__26882 == null)))?((((map__26882.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26882.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26882):map__26882);
var namespace = cljs.core.get.call(null,map__26882__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26759,inst_26767,inst_26762,inst_26799,inst_26763,inst_26765,inst_26795,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26799__$1 = cljs.core.group_by.call(null,inst_26798,inst_26765);
var inst_26801 = (inst_26799__$1 == null);
var inst_26802 = cljs.core.not.call(null,inst_26801);
var state_26846__$1 = (function (){var statearr_26884 = state_26846;
(statearr_26884[(28)] = inst_26795);

(statearr_26884[(16)] = inst_26799__$1);

return statearr_26884;
})();
if(inst_26802){
var statearr_26885_26961 = state_26846__$1;
(statearr_26885_26961[(1)] = (32));

} else {
var statearr_26886_26962 = state_26846__$1;
(statearr_26886_26962[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (44))){
var inst_26822 = (state_26846[(21)]);
var inst_26835 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_26822);
var inst_26836 = cljs.core.pr_str.call(null,inst_26835);
var inst_26837 = [cljs.core.str("not required: "),cljs.core.str(inst_26836)].join('');
var inst_26838 = figwheel.client.utils.log.call(null,inst_26837);
var state_26846__$1 = state_26846;
var statearr_26887_26963 = state_26846__$1;
(statearr_26887_26963[(2)] = inst_26838);

(statearr_26887_26963[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (6))){
var inst_26740 = (state_26846[(2)]);
var state_26846__$1 = state_26846;
var statearr_26888_26964 = state_26846__$1;
(statearr_26888_26964[(2)] = inst_26740);

(statearr_26888_26964[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (28))){
var inst_26765 = (state_26846[(26)]);
var inst_26792 = (state_26846[(2)]);
var inst_26793 = cljs.core.not_empty.call(null,inst_26765);
var state_26846__$1 = (function (){var statearr_26889 = state_26846;
(statearr_26889[(29)] = inst_26792);

return statearr_26889;
})();
if(cljs.core.truth_(inst_26793)){
var statearr_26890_26965 = state_26846__$1;
(statearr_26890_26965[(1)] = (29));

} else {
var statearr_26891_26966 = state_26846__$1;
(statearr_26891_26966[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (25))){
var inst_26763 = (state_26846[(25)]);
var inst_26779 = (state_26846[(2)]);
var inst_26780 = cljs.core.not_empty.call(null,inst_26763);
var state_26846__$1 = (function (){var statearr_26892 = state_26846;
(statearr_26892[(30)] = inst_26779);

return statearr_26892;
})();
if(cljs.core.truth_(inst_26780)){
var statearr_26893_26967 = state_26846__$1;
(statearr_26893_26967[(1)] = (26));

} else {
var statearr_26894_26968 = state_26846__$1;
(statearr_26894_26968[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (34))){
var inst_26815 = (state_26846[(2)]);
var state_26846__$1 = state_26846;
if(cljs.core.truth_(inst_26815)){
var statearr_26895_26969 = state_26846__$1;
(statearr_26895_26969[(1)] = (38));

} else {
var statearr_26896_26970 = state_26846__$1;
(statearr_26896_26970[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (17))){
var state_26846__$1 = state_26846;
var statearr_26897_26971 = state_26846__$1;
(statearr_26897_26971[(2)] = recompile_dependents);

(statearr_26897_26971[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (3))){
var state_26846__$1 = state_26846;
var statearr_26898_26972 = state_26846__$1;
(statearr_26898_26972[(2)] = null);

(statearr_26898_26972[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (12))){
var inst_26736 = (state_26846[(2)]);
var state_26846__$1 = state_26846;
var statearr_26899_26973 = state_26846__$1;
(statearr_26899_26973[(2)] = inst_26736);

(statearr_26899_26973[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (2))){
var inst_26698 = (state_26846[(13)]);
var inst_26705 = cljs.core.seq.call(null,inst_26698);
var inst_26706 = inst_26705;
var inst_26707 = null;
var inst_26708 = (0);
var inst_26709 = (0);
var state_26846__$1 = (function (){var statearr_26900 = state_26846;
(statearr_26900[(7)] = inst_26708);

(statearr_26900[(8)] = inst_26709);

(statearr_26900[(9)] = inst_26707);

(statearr_26900[(10)] = inst_26706);

return statearr_26900;
})();
var statearr_26901_26974 = state_26846__$1;
(statearr_26901_26974[(2)] = null);

(statearr_26901_26974[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (23))){
var inst_26759 = (state_26846[(19)]);
var inst_26767 = (state_26846[(23)]);
var inst_26762 = (state_26846[(24)]);
var inst_26763 = (state_26846[(25)]);
var inst_26765 = (state_26846[(26)]);
var inst_26770 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_26772 = (function (){var all_files = inst_26759;
var res_SINGLEQUOTE_ = inst_26762;
var res = inst_26763;
var files_not_loaded = inst_26765;
var dependencies_that_loaded = inst_26767;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26759,inst_26767,inst_26762,inst_26763,inst_26765,inst_26770,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26771){
var map__26902 = p__26771;
var map__26902__$1 = ((((!((map__26902 == null)))?((((map__26902.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26902.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26902):map__26902);
var request_url = cljs.core.get.call(null,map__26902__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26759,inst_26767,inst_26762,inst_26763,inst_26765,inst_26770,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26773 = cljs.core.reverse.call(null,inst_26767);
var inst_26774 = cljs.core.map.call(null,inst_26772,inst_26773);
var inst_26775 = cljs.core.pr_str.call(null,inst_26774);
var inst_26776 = figwheel.client.utils.log.call(null,inst_26775);
var state_26846__$1 = (function (){var statearr_26904 = state_26846;
(statearr_26904[(31)] = inst_26770);

return statearr_26904;
})();
var statearr_26905_26975 = state_26846__$1;
(statearr_26905_26975[(2)] = inst_26776);

(statearr_26905_26975[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (35))){
var state_26846__$1 = state_26846;
var statearr_26906_26976 = state_26846__$1;
(statearr_26906_26976[(2)] = true);

(statearr_26906_26976[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (19))){
var inst_26749 = (state_26846[(12)]);
var inst_26755 = figwheel.client.file_reloading.expand_files.call(null,inst_26749);
var state_26846__$1 = state_26846;
var statearr_26907_26977 = state_26846__$1;
(statearr_26907_26977[(2)] = inst_26755);

(statearr_26907_26977[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (11))){
var state_26846__$1 = state_26846;
var statearr_26908_26978 = state_26846__$1;
(statearr_26908_26978[(2)] = null);

(statearr_26908_26978[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (9))){
var inst_26738 = (state_26846[(2)]);
var state_26846__$1 = state_26846;
var statearr_26909_26979 = state_26846__$1;
(statearr_26909_26979[(2)] = inst_26738);

(statearr_26909_26979[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (5))){
var inst_26708 = (state_26846[(7)]);
var inst_26709 = (state_26846[(8)]);
var inst_26711 = (inst_26709 < inst_26708);
var inst_26712 = inst_26711;
var state_26846__$1 = state_26846;
if(cljs.core.truth_(inst_26712)){
var statearr_26910_26980 = state_26846__$1;
(statearr_26910_26980[(1)] = (7));

} else {
var statearr_26911_26981 = state_26846__$1;
(statearr_26911_26981[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (14))){
var inst_26719 = (state_26846[(22)]);
var inst_26728 = cljs.core.first.call(null,inst_26719);
var inst_26729 = figwheel.client.file_reloading.eval_body.call(null,inst_26728,opts);
var inst_26730 = cljs.core.next.call(null,inst_26719);
var inst_26706 = inst_26730;
var inst_26707 = null;
var inst_26708 = (0);
var inst_26709 = (0);
var state_26846__$1 = (function (){var statearr_26912 = state_26846;
(statearr_26912[(7)] = inst_26708);

(statearr_26912[(8)] = inst_26709);

(statearr_26912[(32)] = inst_26729);

(statearr_26912[(9)] = inst_26707);

(statearr_26912[(10)] = inst_26706);

return statearr_26912;
})();
var statearr_26913_26982 = state_26846__$1;
(statearr_26913_26982[(2)] = null);

(statearr_26913_26982[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (45))){
var state_26846__$1 = state_26846;
var statearr_26914_26983 = state_26846__$1;
(statearr_26914_26983[(2)] = null);

(statearr_26914_26983[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (26))){
var inst_26759 = (state_26846[(19)]);
var inst_26767 = (state_26846[(23)]);
var inst_26762 = (state_26846[(24)]);
var inst_26763 = (state_26846[(25)]);
var inst_26765 = (state_26846[(26)]);
var inst_26782 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_26784 = (function (){var all_files = inst_26759;
var res_SINGLEQUOTE_ = inst_26762;
var res = inst_26763;
var files_not_loaded = inst_26765;
var dependencies_that_loaded = inst_26767;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26759,inst_26767,inst_26762,inst_26763,inst_26765,inst_26782,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26783){
var map__26915 = p__26783;
var map__26915__$1 = ((((!((map__26915 == null)))?((((map__26915.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26915.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26915):map__26915);
var namespace = cljs.core.get.call(null,map__26915__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__26915__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26759,inst_26767,inst_26762,inst_26763,inst_26765,inst_26782,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26785 = cljs.core.map.call(null,inst_26784,inst_26763);
var inst_26786 = cljs.core.pr_str.call(null,inst_26785);
var inst_26787 = figwheel.client.utils.log.call(null,inst_26786);
var inst_26788 = (function (){var all_files = inst_26759;
var res_SINGLEQUOTE_ = inst_26762;
var res = inst_26763;
var files_not_loaded = inst_26765;
var dependencies_that_loaded = inst_26767;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26759,inst_26767,inst_26762,inst_26763,inst_26765,inst_26782,inst_26784,inst_26785,inst_26786,inst_26787,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26759,inst_26767,inst_26762,inst_26763,inst_26765,inst_26782,inst_26784,inst_26785,inst_26786,inst_26787,state_val_26847,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26789 = setTimeout(inst_26788,(10));
var state_26846__$1 = (function (){var statearr_26917 = state_26846;
(statearr_26917[(33)] = inst_26787);

(statearr_26917[(34)] = inst_26782);

return statearr_26917;
})();
var statearr_26918_26984 = state_26846__$1;
(statearr_26918_26984[(2)] = inst_26789);

(statearr_26918_26984[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (16))){
var state_26846__$1 = state_26846;
var statearr_26919_26985 = state_26846__$1;
(statearr_26919_26985[(2)] = reload_dependents);

(statearr_26919_26985[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (38))){
var inst_26799 = (state_26846[(16)]);
var inst_26817 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26799);
var state_26846__$1 = state_26846;
var statearr_26920_26986 = state_26846__$1;
(statearr_26920_26986[(2)] = inst_26817);

(statearr_26920_26986[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (30))){
var state_26846__$1 = state_26846;
var statearr_26921_26987 = state_26846__$1;
(statearr_26921_26987[(2)] = null);

(statearr_26921_26987[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (10))){
var inst_26719 = (state_26846[(22)]);
var inst_26721 = cljs.core.chunked_seq_QMARK_.call(null,inst_26719);
var state_26846__$1 = state_26846;
if(inst_26721){
var statearr_26922_26988 = state_26846__$1;
(statearr_26922_26988[(1)] = (13));

} else {
var statearr_26923_26989 = state_26846__$1;
(statearr_26923_26989[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (18))){
var inst_26753 = (state_26846[(2)]);
var state_26846__$1 = state_26846;
if(cljs.core.truth_(inst_26753)){
var statearr_26924_26990 = state_26846__$1;
(statearr_26924_26990[(1)] = (19));

} else {
var statearr_26925_26991 = state_26846__$1;
(statearr_26925_26991[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (42))){
var state_26846__$1 = state_26846;
var statearr_26926_26992 = state_26846__$1;
(statearr_26926_26992[(2)] = null);

(statearr_26926_26992[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (37))){
var inst_26812 = (state_26846[(2)]);
var state_26846__$1 = state_26846;
var statearr_26927_26993 = state_26846__$1;
(statearr_26927_26993[(2)] = inst_26812);

(statearr_26927_26993[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26847 === (8))){
var inst_26719 = (state_26846[(22)]);
var inst_26706 = (state_26846[(10)]);
var inst_26719__$1 = cljs.core.seq.call(null,inst_26706);
var state_26846__$1 = (function (){var statearr_26928 = state_26846;
(statearr_26928[(22)] = inst_26719__$1);

return statearr_26928;
})();
if(inst_26719__$1){
var statearr_26929_26994 = state_26846__$1;
(statearr_26929_26994[(1)] = (10));

} else {
var statearr_26930_26995 = state_26846__$1;
(statearr_26930_26995[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__23037__auto__,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto____0 = (function (){
var statearr_26934 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26934[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto__);

(statearr_26934[(1)] = (1));

return statearr_26934;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto____1 = (function (state_26846){
while(true){
var ret_value__23039__auto__ = (function (){try{while(true){
var result__23040__auto__ = switch__23037__auto__.call(null,state_26846);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23040__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23040__auto__;
}
break;
}
}catch (e26935){if((e26935 instanceof Object)){
var ex__23041__auto__ = e26935;
var statearr_26936_26996 = state_26846;
(statearr_26936_26996[(5)] = ex__23041__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26846);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26935;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23039__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26997 = state_26846;
state_26846 = G__26997;
continue;
} else {
return ret_value__23039__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto__ = function(state_26846){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto____1.call(this,state_26846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23038__auto__;
})()
;})(switch__23037__auto__,c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__23151__auto__ = (function (){var statearr_26937 = f__23150__auto__.call(null);
(statearr_26937[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23149__auto__);

return statearr_26937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23151__auto__);
});})(c__23149__auto__,map__26691,map__26691__$1,opts,before_jsload,on_jsload,reload_dependents,map__26692,map__26692__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__23149__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__27000,link){
var map__27003 = p__27000;
var map__27003__$1 = ((((!((map__27003 == null)))?((((map__27003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27003.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27003):map__27003);
var file = cljs.core.get.call(null,map__27003__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__27003,map__27003__$1,file){
return (function (p1__26998_SHARP_,p2__26999_SHARP_){
if(cljs.core._EQ_.call(null,p1__26998_SHARP_,p2__26999_SHARP_)){
return p1__26998_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__27003,map__27003__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__27009){
var map__27010 = p__27009;
var map__27010__$1 = ((((!((map__27010 == null)))?((((map__27010.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27010.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27010):map__27010);
var match_length = cljs.core.get.call(null,map__27010__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__27010__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__27005_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__27005_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args27012 = [];
var len__21363__auto___27015 = arguments.length;
var i__21364__auto___27016 = (0);
while(true){
if((i__21364__auto___27016 < len__21363__auto___27015)){
args27012.push((arguments[i__21364__auto___27016]));

var G__27017 = (i__21364__auto___27016 + (1));
i__21364__auto___27016 = G__27017;
continue;
} else {
}
break;
}

var G__27014 = args27012.length;
switch (G__27014) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27012.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__27019_SHARP_,p2__27020_SHARP_){
return cljs.core.assoc.call(null,p1__27019_SHARP_,cljs.core.get.call(null,p2__27020_SHARP_,key),p2__27020_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__27021){
var map__27024 = p__27021;
var map__27024__$1 = ((((!((map__27024 == null)))?((((map__27024.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27024.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27024):map__27024);
var f_data = map__27024__$1;
var file = cljs.core.get.call(null,map__27024__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__27026,files_msg){
var map__27033 = p__27026;
var map__27033__$1 = ((((!((map__27033 == null)))?((((map__27033.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27033.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27033):map__27033);
var opts = map__27033__$1;
var on_cssload = cljs.core.get.call(null,map__27033__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__27035_27039 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__27036_27040 = null;
var count__27037_27041 = (0);
var i__27038_27042 = (0);
while(true){
if((i__27038_27042 < count__27037_27041)){
var f_27043 = cljs.core._nth.call(null,chunk__27036_27040,i__27038_27042);
figwheel.client.file_reloading.reload_css_file.call(null,f_27043);

var G__27044 = seq__27035_27039;
var G__27045 = chunk__27036_27040;
var G__27046 = count__27037_27041;
var G__27047 = (i__27038_27042 + (1));
seq__27035_27039 = G__27044;
chunk__27036_27040 = G__27045;
count__27037_27041 = G__27046;
i__27038_27042 = G__27047;
continue;
} else {
var temp__4657__auto___27048 = cljs.core.seq.call(null,seq__27035_27039);
if(temp__4657__auto___27048){
var seq__27035_27049__$1 = temp__4657__auto___27048;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27035_27049__$1)){
var c__21069__auto___27050 = cljs.core.chunk_first.call(null,seq__27035_27049__$1);
var G__27051 = cljs.core.chunk_rest.call(null,seq__27035_27049__$1);
var G__27052 = c__21069__auto___27050;
var G__27053 = cljs.core.count.call(null,c__21069__auto___27050);
var G__27054 = (0);
seq__27035_27039 = G__27051;
chunk__27036_27040 = G__27052;
count__27037_27041 = G__27053;
i__27038_27042 = G__27054;
continue;
} else {
var f_27055 = cljs.core.first.call(null,seq__27035_27049__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_27055);

var G__27056 = cljs.core.next.call(null,seq__27035_27049__$1);
var G__27057 = null;
var G__27058 = (0);
var G__27059 = (0);
seq__27035_27039 = G__27056;
chunk__27036_27040 = G__27057;
count__27037_27041 = G__27058;
i__27038_27042 = G__27059;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__27033,map__27033__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__27033,map__27033__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1482335100412