// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__20285__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__20285__auto__){
return or__20285__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__20285__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__26072_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__26072_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__26077 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__26078 = null;
var count__26079 = (0);
var i__26080 = (0);
while(true){
if((i__26080 < count__26079)){
var n = cljs.core._nth.call(null,chunk__26078,i__26080);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__26081 = seq__26077;
var G__26082 = chunk__26078;
var G__26083 = count__26079;
var G__26084 = (i__26080 + (1));
seq__26077 = G__26081;
chunk__26078 = G__26082;
count__26079 = G__26083;
i__26080 = G__26084;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__26077);
if(temp__4657__auto__){
var seq__26077__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26077__$1)){
var c__21099__auto__ = cljs.core.chunk_first.call(null,seq__26077__$1);
var G__26085 = cljs.core.chunk_rest.call(null,seq__26077__$1);
var G__26086 = c__21099__auto__;
var G__26087 = cljs.core.count.call(null,c__21099__auto__);
var G__26088 = (0);
seq__26077 = G__26085;
chunk__26078 = G__26086;
count__26079 = G__26087;
i__26080 = G__26088;
continue;
} else {
var n = cljs.core.first.call(null,seq__26077__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__26089 = cljs.core.next.call(null,seq__26077__$1);
var G__26090 = null;
var G__26091 = (0);
var G__26092 = (0);
seq__26077 = G__26089;
chunk__26078 = G__26090;
count__26079 = G__26091;
i__26080 = G__26092;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__26143_26154 = cljs.core.seq.call(null,deps);
var chunk__26144_26155 = null;
var count__26145_26156 = (0);
var i__26146_26157 = (0);
while(true){
if((i__26146_26157 < count__26145_26156)){
var dep_26158 = cljs.core._nth.call(null,chunk__26144_26155,i__26146_26157);
topo_sort_helper_STAR_.call(null,dep_26158,(depth + (1)),state);

var G__26159 = seq__26143_26154;
var G__26160 = chunk__26144_26155;
var G__26161 = count__26145_26156;
var G__26162 = (i__26146_26157 + (1));
seq__26143_26154 = G__26159;
chunk__26144_26155 = G__26160;
count__26145_26156 = G__26161;
i__26146_26157 = G__26162;
continue;
} else {
var temp__4657__auto___26163 = cljs.core.seq.call(null,seq__26143_26154);
if(temp__4657__auto___26163){
var seq__26143_26164__$1 = temp__4657__auto___26163;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26143_26164__$1)){
var c__21099__auto___26165 = cljs.core.chunk_first.call(null,seq__26143_26164__$1);
var G__26166 = cljs.core.chunk_rest.call(null,seq__26143_26164__$1);
var G__26167 = c__21099__auto___26165;
var G__26168 = cljs.core.count.call(null,c__21099__auto___26165);
var G__26169 = (0);
seq__26143_26154 = G__26166;
chunk__26144_26155 = G__26167;
count__26145_26156 = G__26168;
i__26146_26157 = G__26169;
continue;
} else {
var dep_26170 = cljs.core.first.call(null,seq__26143_26164__$1);
topo_sort_helper_STAR_.call(null,dep_26170,(depth + (1)),state);

var G__26171 = cljs.core.next.call(null,seq__26143_26164__$1);
var G__26172 = null;
var G__26173 = (0);
var G__26174 = (0);
seq__26143_26154 = G__26171;
chunk__26144_26155 = G__26172;
count__26145_26156 = G__26173;
i__26146_26157 = G__26174;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__26147){
var vec__26151 = p__26147;
var seq__26152 = cljs.core.seq.call(null,vec__26151);
var first__26153 = cljs.core.first.call(null,seq__26152);
var seq__26152__$1 = cljs.core.next.call(null,seq__26152);
var x = first__26153;
var xs = seq__26152__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__26151,seq__26152,first__26153,seq__26152__$1,x,xs,get_deps__$1){
return (function (p1__26093_SHARP_){
return clojure.set.difference.call(null,p1__26093_SHARP_,x);
});})(vec__26151,seq__26152,first__26153,seq__26152__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__26187 = cljs.core.seq.call(null,provides);
var chunk__26188 = null;
var count__26189 = (0);
var i__26190 = (0);
while(true){
if((i__26190 < count__26189)){
var prov = cljs.core._nth.call(null,chunk__26188,i__26190);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__26191_26199 = cljs.core.seq.call(null,requires);
var chunk__26192_26200 = null;
var count__26193_26201 = (0);
var i__26194_26202 = (0);
while(true){
if((i__26194_26202 < count__26193_26201)){
var req_26203 = cljs.core._nth.call(null,chunk__26192_26200,i__26194_26202);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26203,prov);

var G__26204 = seq__26191_26199;
var G__26205 = chunk__26192_26200;
var G__26206 = count__26193_26201;
var G__26207 = (i__26194_26202 + (1));
seq__26191_26199 = G__26204;
chunk__26192_26200 = G__26205;
count__26193_26201 = G__26206;
i__26194_26202 = G__26207;
continue;
} else {
var temp__4657__auto___26208 = cljs.core.seq.call(null,seq__26191_26199);
if(temp__4657__auto___26208){
var seq__26191_26209__$1 = temp__4657__auto___26208;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26191_26209__$1)){
var c__21099__auto___26210 = cljs.core.chunk_first.call(null,seq__26191_26209__$1);
var G__26211 = cljs.core.chunk_rest.call(null,seq__26191_26209__$1);
var G__26212 = c__21099__auto___26210;
var G__26213 = cljs.core.count.call(null,c__21099__auto___26210);
var G__26214 = (0);
seq__26191_26199 = G__26211;
chunk__26192_26200 = G__26212;
count__26193_26201 = G__26213;
i__26194_26202 = G__26214;
continue;
} else {
var req_26215 = cljs.core.first.call(null,seq__26191_26209__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26215,prov);

var G__26216 = cljs.core.next.call(null,seq__26191_26209__$1);
var G__26217 = null;
var G__26218 = (0);
var G__26219 = (0);
seq__26191_26199 = G__26216;
chunk__26192_26200 = G__26217;
count__26193_26201 = G__26218;
i__26194_26202 = G__26219;
continue;
}
} else {
}
}
break;
}

var G__26220 = seq__26187;
var G__26221 = chunk__26188;
var G__26222 = count__26189;
var G__26223 = (i__26190 + (1));
seq__26187 = G__26220;
chunk__26188 = G__26221;
count__26189 = G__26222;
i__26190 = G__26223;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__26187);
if(temp__4657__auto__){
var seq__26187__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26187__$1)){
var c__21099__auto__ = cljs.core.chunk_first.call(null,seq__26187__$1);
var G__26224 = cljs.core.chunk_rest.call(null,seq__26187__$1);
var G__26225 = c__21099__auto__;
var G__26226 = cljs.core.count.call(null,c__21099__auto__);
var G__26227 = (0);
seq__26187 = G__26224;
chunk__26188 = G__26225;
count__26189 = G__26226;
i__26190 = G__26227;
continue;
} else {
var prov = cljs.core.first.call(null,seq__26187__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__26195_26228 = cljs.core.seq.call(null,requires);
var chunk__26196_26229 = null;
var count__26197_26230 = (0);
var i__26198_26231 = (0);
while(true){
if((i__26198_26231 < count__26197_26230)){
var req_26232 = cljs.core._nth.call(null,chunk__26196_26229,i__26198_26231);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26232,prov);

var G__26233 = seq__26195_26228;
var G__26234 = chunk__26196_26229;
var G__26235 = count__26197_26230;
var G__26236 = (i__26198_26231 + (1));
seq__26195_26228 = G__26233;
chunk__26196_26229 = G__26234;
count__26197_26230 = G__26235;
i__26198_26231 = G__26236;
continue;
} else {
var temp__4657__auto___26237__$1 = cljs.core.seq.call(null,seq__26195_26228);
if(temp__4657__auto___26237__$1){
var seq__26195_26238__$1 = temp__4657__auto___26237__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26195_26238__$1)){
var c__21099__auto___26239 = cljs.core.chunk_first.call(null,seq__26195_26238__$1);
var G__26240 = cljs.core.chunk_rest.call(null,seq__26195_26238__$1);
var G__26241 = c__21099__auto___26239;
var G__26242 = cljs.core.count.call(null,c__21099__auto___26239);
var G__26243 = (0);
seq__26195_26228 = G__26240;
chunk__26196_26229 = G__26241;
count__26197_26230 = G__26242;
i__26198_26231 = G__26243;
continue;
} else {
var req_26244 = cljs.core.first.call(null,seq__26195_26238__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26244,prov);

var G__26245 = cljs.core.next.call(null,seq__26195_26238__$1);
var G__26246 = null;
var G__26247 = (0);
var G__26248 = (0);
seq__26195_26228 = G__26245;
chunk__26196_26229 = G__26246;
count__26197_26230 = G__26247;
i__26198_26231 = G__26248;
continue;
}
} else {
}
}
break;
}

var G__26249 = cljs.core.next.call(null,seq__26187__$1);
var G__26250 = null;
var G__26251 = (0);
var G__26252 = (0);
seq__26187 = G__26249;
chunk__26188 = G__26250;
count__26189 = G__26251;
i__26190 = G__26252;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__26257_26261 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__26258_26262 = null;
var count__26259_26263 = (0);
var i__26260_26264 = (0);
while(true){
if((i__26260_26264 < count__26259_26263)){
var ns_26265 = cljs.core._nth.call(null,chunk__26258_26262,i__26260_26264);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_26265);

var G__26266 = seq__26257_26261;
var G__26267 = chunk__26258_26262;
var G__26268 = count__26259_26263;
var G__26269 = (i__26260_26264 + (1));
seq__26257_26261 = G__26266;
chunk__26258_26262 = G__26267;
count__26259_26263 = G__26268;
i__26260_26264 = G__26269;
continue;
} else {
var temp__4657__auto___26270 = cljs.core.seq.call(null,seq__26257_26261);
if(temp__4657__auto___26270){
var seq__26257_26271__$1 = temp__4657__auto___26270;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26257_26271__$1)){
var c__21099__auto___26272 = cljs.core.chunk_first.call(null,seq__26257_26271__$1);
var G__26273 = cljs.core.chunk_rest.call(null,seq__26257_26271__$1);
var G__26274 = c__21099__auto___26272;
var G__26275 = cljs.core.count.call(null,c__21099__auto___26272);
var G__26276 = (0);
seq__26257_26261 = G__26273;
chunk__26258_26262 = G__26274;
count__26259_26263 = G__26275;
i__26260_26264 = G__26276;
continue;
} else {
var ns_26277 = cljs.core.first.call(null,seq__26257_26271__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_26277);

var G__26278 = cljs.core.next.call(null,seq__26257_26271__$1);
var G__26279 = null;
var G__26280 = (0);
var G__26281 = (0);
seq__26257_26261 = G__26278;
chunk__26258_26262 = G__26279;
count__26259_26263 = G__26280;
i__26260_26264 = G__26281;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__20285__auto__ = goog.require__;
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__26282__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__26282 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__26283__i = 0, G__26283__a = new Array(arguments.length -  0);
while (G__26283__i < G__26283__a.length) {G__26283__a[G__26283__i] = arguments[G__26283__i + 0]; ++G__26283__i;}
  args = new cljs.core.IndexedSeq(G__26283__a,0);
} 
return G__26282__delegate.call(this,args);};
G__26282.cljs$lang$maxFixedArity = 0;
G__26282.cljs$lang$applyTo = (function (arglist__26284){
var args = cljs.core.seq(arglist__26284);
return G__26282__delegate(args);
});
G__26282.cljs$core$IFn$_invoke$arity$variadic = G__26282__delegate;
return G__26282;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__26286 = cljs.core._EQ_;
var expr__26287 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__26286.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__26287))){
var path_parts = ((function (pred__26286,expr__26287){
return (function (p1__26285_SHARP_){
return clojure.string.split.call(null,p1__26285_SHARP_,/[\/\\]/);
});})(pred__26286,expr__26287))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__26286,expr__26287){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e26289){if((e26289 instanceof Error)){
var e = e26289;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e26289;

}
}})());
});
;})(path_parts,sep,root,pred__26286,expr__26287))
} else {
if(cljs.core.truth_(pred__26286.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__26287))){
return ((function (pred__26286,expr__26287){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__26286,expr__26287){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__26286,expr__26287))
);

return deferred.addErrback(((function (deferred,pred__26286,expr__26287){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__26286,expr__26287))
);
});
;})(pred__26286,expr__26287))
} else {
return ((function (pred__26286,expr__26287){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__26286,expr__26287))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__26290,callback){
var map__26293 = p__26290;
var map__26293__$1 = ((((!((map__26293 == null)))?((((map__26293.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26293.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26293):map__26293);
var file_msg = map__26293__$1;
var request_url = cljs.core.get.call(null,map__26293__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__26293,map__26293__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__26293,map__26293__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__23180__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto__){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto__){
return (function (state_26317){
var state_val_26318 = (state_26317[(1)]);
if((state_val_26318 === (7))){
var inst_26313 = (state_26317[(2)]);
var state_26317__$1 = state_26317;
var statearr_26319_26339 = state_26317__$1;
(statearr_26319_26339[(2)] = inst_26313);

(statearr_26319_26339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26318 === (1))){
var state_26317__$1 = state_26317;
var statearr_26320_26340 = state_26317__$1;
(statearr_26320_26340[(2)] = null);

(statearr_26320_26340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26318 === (4))){
var inst_26297 = (state_26317[(7)]);
var inst_26297__$1 = (state_26317[(2)]);
var state_26317__$1 = (function (){var statearr_26321 = state_26317;
(statearr_26321[(7)] = inst_26297__$1);

return statearr_26321;
})();
if(cljs.core.truth_(inst_26297__$1)){
var statearr_26322_26341 = state_26317__$1;
(statearr_26322_26341[(1)] = (5));

} else {
var statearr_26323_26342 = state_26317__$1;
(statearr_26323_26342[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26318 === (6))){
var state_26317__$1 = state_26317;
var statearr_26324_26343 = state_26317__$1;
(statearr_26324_26343[(2)] = null);

(statearr_26324_26343[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26318 === (3))){
var inst_26315 = (state_26317[(2)]);
var state_26317__$1 = state_26317;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26317__$1,inst_26315);
} else {
if((state_val_26318 === (2))){
var state_26317__$1 = state_26317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26317__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_26318 === (11))){
var inst_26309 = (state_26317[(2)]);
var state_26317__$1 = (function (){var statearr_26325 = state_26317;
(statearr_26325[(8)] = inst_26309);

return statearr_26325;
})();
var statearr_26326_26344 = state_26317__$1;
(statearr_26326_26344[(2)] = null);

(statearr_26326_26344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26318 === (9))){
var inst_26301 = (state_26317[(9)]);
var inst_26303 = (state_26317[(10)]);
var inst_26305 = inst_26303.call(null,inst_26301);
var state_26317__$1 = state_26317;
var statearr_26327_26345 = state_26317__$1;
(statearr_26327_26345[(2)] = inst_26305);

(statearr_26327_26345[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26318 === (5))){
var inst_26297 = (state_26317[(7)]);
var inst_26299 = figwheel.client.file_reloading.blocking_load.call(null,inst_26297);
var state_26317__$1 = state_26317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26317__$1,(8),inst_26299);
} else {
if((state_val_26318 === (10))){
var inst_26301 = (state_26317[(9)]);
var inst_26307 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_26301);
var state_26317__$1 = state_26317;
var statearr_26328_26346 = state_26317__$1;
(statearr_26328_26346[(2)] = inst_26307);

(statearr_26328_26346[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26318 === (8))){
var inst_26303 = (state_26317[(10)]);
var inst_26297 = (state_26317[(7)]);
var inst_26301 = (state_26317[(2)]);
var inst_26302 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_26303__$1 = cljs.core.get.call(null,inst_26302,inst_26297);
var state_26317__$1 = (function (){var statearr_26329 = state_26317;
(statearr_26329[(9)] = inst_26301);

(statearr_26329[(10)] = inst_26303__$1);

return statearr_26329;
})();
if(cljs.core.truth_(inst_26303__$1)){
var statearr_26330_26347 = state_26317__$1;
(statearr_26330_26347[(1)] = (9));

} else {
var statearr_26331_26348 = state_26317__$1;
(statearr_26331_26348[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto__))
;
return ((function (switch__22336__auto__,c__23180__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__22337__auto__ = null;
var figwheel$client$file_reloading$state_machine__22337__auto____0 = (function (){
var statearr_26335 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26335[(0)] = figwheel$client$file_reloading$state_machine__22337__auto__);

(statearr_26335[(1)] = (1));

return statearr_26335;
});
var figwheel$client$file_reloading$state_machine__22337__auto____1 = (function (state_26317){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_26317);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e26336){if((e26336 instanceof Object)){
var ex__22340__auto__ = e26336;
var statearr_26337_26349 = state_26317;
(statearr_26337_26349[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26317);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26336;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26350 = state_26317;
state_26317 = G__26350;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__22337__auto__ = function(state_26317){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__22337__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__22337__auto____1.call(this,state_26317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__22337__auto____0;
figwheel$client$file_reloading$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__22337__auto____1;
return figwheel$client$file_reloading$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto__))
})();
var state__23182__auto__ = (function (){var statearr_26338 = f__23181__auto__.call(null);
(statearr_26338[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto__);

return statearr_26338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto__))
);

return c__23180__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__26351,callback){
var map__26354 = p__26351;
var map__26354__$1 = ((((!((map__26354 == null)))?((((map__26354.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26354.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26354):map__26354);
var file_msg = map__26354__$1;
var namespace = cljs.core.get.call(null,map__26354__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__26354,map__26354__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__26354,map__26354__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__26356){
var map__26359 = p__26356;
var map__26359__$1 = ((((!((map__26359 == null)))?((((map__26359.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26359.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26359):map__26359);
var file_msg = map__26359__$1;
var namespace = cljs.core.get.call(null,map__26359__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__20273__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__20273__auto__){
var or__20285__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
var or__20285__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__20285__auto____$1)){
return or__20285__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__20273__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__26361,callback){
var map__26364 = p__26361;
var map__26364__$1 = ((((!((map__26364 == null)))?((((map__26364.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26364.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26364):map__26364);
var file_msg = map__26364__$1;
var request_url = cljs.core.get.call(null,map__26364__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__26364__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__23180__auto___26468 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___26468,out){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___26468,out){
return (function (state_26450){
var state_val_26451 = (state_26450[(1)]);
if((state_val_26451 === (1))){
var inst_26424 = cljs.core.seq.call(null,files);
var inst_26425 = cljs.core.first.call(null,inst_26424);
var inst_26426 = cljs.core.next.call(null,inst_26424);
var inst_26427 = files;
var state_26450__$1 = (function (){var statearr_26452 = state_26450;
(statearr_26452[(7)] = inst_26426);

(statearr_26452[(8)] = inst_26427);

(statearr_26452[(9)] = inst_26425);

return statearr_26452;
})();
var statearr_26453_26469 = state_26450__$1;
(statearr_26453_26469[(2)] = null);

(statearr_26453_26469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26451 === (2))){
var inst_26433 = (state_26450[(10)]);
var inst_26427 = (state_26450[(8)]);
var inst_26432 = cljs.core.seq.call(null,inst_26427);
var inst_26433__$1 = cljs.core.first.call(null,inst_26432);
var inst_26434 = cljs.core.next.call(null,inst_26432);
var inst_26435 = (inst_26433__$1 == null);
var inst_26436 = cljs.core.not.call(null,inst_26435);
var state_26450__$1 = (function (){var statearr_26454 = state_26450;
(statearr_26454[(10)] = inst_26433__$1);

(statearr_26454[(11)] = inst_26434);

return statearr_26454;
})();
if(inst_26436){
var statearr_26455_26470 = state_26450__$1;
(statearr_26455_26470[(1)] = (4));

} else {
var statearr_26456_26471 = state_26450__$1;
(statearr_26456_26471[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26451 === (3))){
var inst_26448 = (state_26450[(2)]);
var state_26450__$1 = state_26450;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26450__$1,inst_26448);
} else {
if((state_val_26451 === (4))){
var inst_26433 = (state_26450[(10)]);
var inst_26438 = figwheel.client.file_reloading.reload_js_file.call(null,inst_26433);
var state_26450__$1 = state_26450;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26450__$1,(7),inst_26438);
} else {
if((state_val_26451 === (5))){
var inst_26444 = cljs.core.async.close_BANG_.call(null,out);
var state_26450__$1 = state_26450;
var statearr_26457_26472 = state_26450__$1;
(statearr_26457_26472[(2)] = inst_26444);

(statearr_26457_26472[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26451 === (6))){
var inst_26446 = (state_26450[(2)]);
var state_26450__$1 = state_26450;
var statearr_26458_26473 = state_26450__$1;
(statearr_26458_26473[(2)] = inst_26446);

(statearr_26458_26473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26451 === (7))){
var inst_26434 = (state_26450[(11)]);
var inst_26440 = (state_26450[(2)]);
var inst_26441 = cljs.core.async.put_BANG_.call(null,out,inst_26440);
var inst_26427 = inst_26434;
var state_26450__$1 = (function (){var statearr_26459 = state_26450;
(statearr_26459[(12)] = inst_26441);

(statearr_26459[(8)] = inst_26427);

return statearr_26459;
})();
var statearr_26460_26474 = state_26450__$1;
(statearr_26460_26474[(2)] = null);

(statearr_26460_26474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__23180__auto___26468,out))
;
return ((function (switch__22336__auto__,c__23180__auto___26468,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____0 = (function (){
var statearr_26464 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26464[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__);

(statearr_26464[(1)] = (1));

return statearr_26464;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____1 = (function (state_26450){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_26450);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e26465){if((e26465 instanceof Object)){
var ex__22340__auto__ = e26465;
var statearr_26466_26475 = state_26450;
(statearr_26466_26475[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26450);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26465;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26476 = state_26450;
state_26450 = G__26476;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__ = function(state_26450){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____1.call(this,state_26450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___26468,out))
})();
var state__23182__auto__ = (function (){var statearr_26467 = f__23181__auto__.call(null);
(statearr_26467[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___26468);

return statearr_26467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___26468,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__26477,opts){
var map__26481 = p__26477;
var map__26481__$1 = ((((!((map__26481 == null)))?((((map__26481.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26481.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26481):map__26481);
var eval_body = cljs.core.get.call(null,map__26481__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__26481__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__20273__auto__ = eval_body;
if(cljs.core.truth_(and__20273__auto__)){
return typeof eval_body === 'string';
} else {
return and__20273__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e26483){var e = e26483;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__26484_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__26484_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__26493){
var vec__26494 = p__26493;
var k = cljs.core.nth.call(null,vec__26494,(0),null);
var v = cljs.core.nth.call(null,vec__26494,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__26497){
var vec__26498 = p__26497;
var k = cljs.core.nth.call(null,vec__26498,(0),null);
var v = cljs.core.nth.call(null,vec__26498,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__26504,p__26505){
var map__26753 = p__26504;
var map__26753__$1 = ((((!((map__26753 == null)))?((((map__26753.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26753.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26753):map__26753);
var opts = map__26753__$1;
var before_jsload = cljs.core.get.call(null,map__26753__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__26753__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__26753__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__26754 = p__26505;
var map__26754__$1 = ((((!((map__26754 == null)))?((((map__26754.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26754.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26754):map__26754);
var msg = map__26754__$1;
var files = cljs.core.get.call(null,map__26754__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__26754__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__26754__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__23180__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_26908){
var state_val_26909 = (state_26908[(1)]);
if((state_val_26909 === (7))){
var inst_26769 = (state_26908[(7)]);
var inst_26770 = (state_26908[(8)]);
var inst_26768 = (state_26908[(9)]);
var inst_26771 = (state_26908[(10)]);
var inst_26776 = cljs.core._nth.call(null,inst_26769,inst_26771);
var inst_26777 = figwheel.client.file_reloading.eval_body.call(null,inst_26776,opts);
var inst_26778 = (inst_26771 + (1));
var tmp26910 = inst_26769;
var tmp26911 = inst_26770;
var tmp26912 = inst_26768;
var inst_26768__$1 = tmp26912;
var inst_26769__$1 = tmp26910;
var inst_26770__$1 = tmp26911;
var inst_26771__$1 = inst_26778;
var state_26908__$1 = (function (){var statearr_26913 = state_26908;
(statearr_26913[(7)] = inst_26769__$1);

(statearr_26913[(8)] = inst_26770__$1);

(statearr_26913[(9)] = inst_26768__$1);

(statearr_26913[(10)] = inst_26771__$1);

(statearr_26913[(11)] = inst_26777);

return statearr_26913;
})();
var statearr_26914_27000 = state_26908__$1;
(statearr_26914_27000[(2)] = null);

(statearr_26914_27000[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (20))){
var inst_26811 = (state_26908[(12)]);
var inst_26819 = figwheel.client.file_reloading.sort_files.call(null,inst_26811);
var state_26908__$1 = state_26908;
var statearr_26915_27001 = state_26908__$1;
(statearr_26915_27001[(2)] = inst_26819);

(statearr_26915_27001[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (27))){
var state_26908__$1 = state_26908;
var statearr_26916_27002 = state_26908__$1;
(statearr_26916_27002[(2)] = null);

(statearr_26916_27002[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (1))){
var inst_26760 = (state_26908[(13)]);
var inst_26757 = before_jsload.call(null,files);
var inst_26758 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_26759 = (function (){return ((function (inst_26760,inst_26757,inst_26758,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26501_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__26501_SHARP_);
});
;})(inst_26760,inst_26757,inst_26758,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26760__$1 = cljs.core.filter.call(null,inst_26759,files);
var inst_26761 = cljs.core.not_empty.call(null,inst_26760__$1);
var state_26908__$1 = (function (){var statearr_26917 = state_26908;
(statearr_26917[(13)] = inst_26760__$1);

(statearr_26917[(14)] = inst_26757);

(statearr_26917[(15)] = inst_26758);

return statearr_26917;
})();
if(cljs.core.truth_(inst_26761)){
var statearr_26918_27003 = state_26908__$1;
(statearr_26918_27003[(1)] = (2));

} else {
var statearr_26919_27004 = state_26908__$1;
(statearr_26919_27004[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (24))){
var state_26908__$1 = state_26908;
var statearr_26920_27005 = state_26908__$1;
(statearr_26920_27005[(2)] = null);

(statearr_26920_27005[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (39))){
var inst_26861 = (state_26908[(16)]);
var state_26908__$1 = state_26908;
var statearr_26921_27006 = state_26908__$1;
(statearr_26921_27006[(2)] = inst_26861);

(statearr_26921_27006[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (46))){
var inst_26903 = (state_26908[(2)]);
var state_26908__$1 = state_26908;
var statearr_26922_27007 = state_26908__$1;
(statearr_26922_27007[(2)] = inst_26903);

(statearr_26922_27007[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (4))){
var inst_26805 = (state_26908[(2)]);
var inst_26806 = cljs.core.List.EMPTY;
var inst_26807 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_26806);
var inst_26808 = (function (){return ((function (inst_26805,inst_26806,inst_26807,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26502_SHARP_){
var and__20273__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__26502_SHARP_);
if(cljs.core.truth_(and__20273__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__26502_SHARP_));
} else {
return and__20273__auto__;
}
});
;})(inst_26805,inst_26806,inst_26807,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26809 = cljs.core.filter.call(null,inst_26808,files);
var inst_26810 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_26811 = cljs.core.concat.call(null,inst_26809,inst_26810);
var state_26908__$1 = (function (){var statearr_26923 = state_26908;
(statearr_26923[(17)] = inst_26807);

(statearr_26923[(12)] = inst_26811);

(statearr_26923[(18)] = inst_26805);

return statearr_26923;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_26924_27008 = state_26908__$1;
(statearr_26924_27008[(1)] = (16));

} else {
var statearr_26925_27009 = state_26908__$1;
(statearr_26925_27009[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (15))){
var inst_26795 = (state_26908[(2)]);
var state_26908__$1 = state_26908;
var statearr_26926_27010 = state_26908__$1;
(statearr_26926_27010[(2)] = inst_26795);

(statearr_26926_27010[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (21))){
var inst_26821 = (state_26908[(19)]);
var inst_26821__$1 = (state_26908[(2)]);
var inst_26822 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_26821__$1);
var state_26908__$1 = (function (){var statearr_26927 = state_26908;
(statearr_26927[(19)] = inst_26821__$1);

return statearr_26927;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26908__$1,(22),inst_26822);
} else {
if((state_val_26909 === (31))){
var inst_26906 = (state_26908[(2)]);
var state_26908__$1 = state_26908;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26908__$1,inst_26906);
} else {
if((state_val_26909 === (32))){
var inst_26861 = (state_26908[(16)]);
var inst_26866 = inst_26861.cljs$lang$protocol_mask$partition0$;
var inst_26867 = (inst_26866 & (64));
var inst_26868 = inst_26861.cljs$core$ISeq$;
var inst_26869 = (cljs.core.PROTOCOL_SENTINEL === inst_26868);
var inst_26870 = (inst_26867) || (inst_26869);
var state_26908__$1 = state_26908;
if(cljs.core.truth_(inst_26870)){
var statearr_26928_27011 = state_26908__$1;
(statearr_26928_27011[(1)] = (35));

} else {
var statearr_26929_27012 = state_26908__$1;
(statearr_26929_27012[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (40))){
var inst_26883 = (state_26908[(20)]);
var inst_26882 = (state_26908[(2)]);
var inst_26883__$1 = cljs.core.get.call(null,inst_26882,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_26884 = cljs.core.get.call(null,inst_26882,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_26885 = cljs.core.not_empty.call(null,inst_26883__$1);
var state_26908__$1 = (function (){var statearr_26930 = state_26908;
(statearr_26930[(20)] = inst_26883__$1);

(statearr_26930[(21)] = inst_26884);

return statearr_26930;
})();
if(cljs.core.truth_(inst_26885)){
var statearr_26931_27013 = state_26908__$1;
(statearr_26931_27013[(1)] = (41));

} else {
var statearr_26932_27014 = state_26908__$1;
(statearr_26932_27014[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (33))){
var state_26908__$1 = state_26908;
var statearr_26933_27015 = state_26908__$1;
(statearr_26933_27015[(2)] = false);

(statearr_26933_27015[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (13))){
var inst_26781 = (state_26908[(22)]);
var inst_26785 = cljs.core.chunk_first.call(null,inst_26781);
var inst_26786 = cljs.core.chunk_rest.call(null,inst_26781);
var inst_26787 = cljs.core.count.call(null,inst_26785);
var inst_26768 = inst_26786;
var inst_26769 = inst_26785;
var inst_26770 = inst_26787;
var inst_26771 = (0);
var state_26908__$1 = (function (){var statearr_26934 = state_26908;
(statearr_26934[(7)] = inst_26769);

(statearr_26934[(8)] = inst_26770);

(statearr_26934[(9)] = inst_26768);

(statearr_26934[(10)] = inst_26771);

return statearr_26934;
})();
var statearr_26935_27016 = state_26908__$1;
(statearr_26935_27016[(2)] = null);

(statearr_26935_27016[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (22))){
var inst_26829 = (state_26908[(23)]);
var inst_26825 = (state_26908[(24)]);
var inst_26821 = (state_26908[(19)]);
var inst_26824 = (state_26908[(25)]);
var inst_26824__$1 = (state_26908[(2)]);
var inst_26825__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26824__$1);
var inst_26826 = (function (){var all_files = inst_26821;
var res_SINGLEQUOTE_ = inst_26824__$1;
var res = inst_26825__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_26829,inst_26825,inst_26821,inst_26824,inst_26824__$1,inst_26825__$1,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26503_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__26503_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_26829,inst_26825,inst_26821,inst_26824,inst_26824__$1,inst_26825__$1,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26827 = cljs.core.filter.call(null,inst_26826,inst_26824__$1);
var inst_26828 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_26829__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26828);
var inst_26830 = cljs.core.not_empty.call(null,inst_26829__$1);
var state_26908__$1 = (function (){var statearr_26936 = state_26908;
(statearr_26936[(23)] = inst_26829__$1);

(statearr_26936[(24)] = inst_26825__$1);

(statearr_26936[(26)] = inst_26827);

(statearr_26936[(25)] = inst_26824__$1);

return statearr_26936;
})();
if(cljs.core.truth_(inst_26830)){
var statearr_26937_27017 = state_26908__$1;
(statearr_26937_27017[(1)] = (23));

} else {
var statearr_26938_27018 = state_26908__$1;
(statearr_26938_27018[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (36))){
var state_26908__$1 = state_26908;
var statearr_26939_27019 = state_26908__$1;
(statearr_26939_27019[(2)] = false);

(statearr_26939_27019[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (41))){
var inst_26883 = (state_26908[(20)]);
var inst_26887 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_26888 = cljs.core.map.call(null,inst_26887,inst_26883);
var inst_26889 = cljs.core.pr_str.call(null,inst_26888);
var inst_26890 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_26889)].join('');
var inst_26891 = figwheel.client.utils.log.call(null,inst_26890);
var state_26908__$1 = state_26908;
var statearr_26940_27020 = state_26908__$1;
(statearr_26940_27020[(2)] = inst_26891);

(statearr_26940_27020[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (43))){
var inst_26884 = (state_26908[(21)]);
var inst_26894 = (state_26908[(2)]);
var inst_26895 = cljs.core.not_empty.call(null,inst_26884);
var state_26908__$1 = (function (){var statearr_26941 = state_26908;
(statearr_26941[(27)] = inst_26894);

return statearr_26941;
})();
if(cljs.core.truth_(inst_26895)){
var statearr_26942_27021 = state_26908__$1;
(statearr_26942_27021[(1)] = (44));

} else {
var statearr_26943_27022 = state_26908__$1;
(statearr_26943_27022[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (29))){
var inst_26861 = (state_26908[(16)]);
var inst_26829 = (state_26908[(23)]);
var inst_26825 = (state_26908[(24)]);
var inst_26827 = (state_26908[(26)]);
var inst_26821 = (state_26908[(19)]);
var inst_26824 = (state_26908[(25)]);
var inst_26857 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_26860 = (function (){var all_files = inst_26821;
var res_SINGLEQUOTE_ = inst_26824;
var res = inst_26825;
var files_not_loaded = inst_26827;
var dependencies_that_loaded = inst_26829;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26861,inst_26829,inst_26825,inst_26827,inst_26821,inst_26824,inst_26857,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26859){
var map__26944 = p__26859;
var map__26944__$1 = ((((!((map__26944 == null)))?((((map__26944.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26944.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26944):map__26944);
var namespace = cljs.core.get.call(null,map__26944__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26861,inst_26829,inst_26825,inst_26827,inst_26821,inst_26824,inst_26857,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26861__$1 = cljs.core.group_by.call(null,inst_26860,inst_26827);
var inst_26863 = (inst_26861__$1 == null);
var inst_26864 = cljs.core.not.call(null,inst_26863);
var state_26908__$1 = (function (){var statearr_26946 = state_26908;
(statearr_26946[(16)] = inst_26861__$1);

(statearr_26946[(28)] = inst_26857);

return statearr_26946;
})();
if(inst_26864){
var statearr_26947_27023 = state_26908__$1;
(statearr_26947_27023[(1)] = (32));

} else {
var statearr_26948_27024 = state_26908__$1;
(statearr_26948_27024[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (44))){
var inst_26884 = (state_26908[(21)]);
var inst_26897 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_26884);
var inst_26898 = cljs.core.pr_str.call(null,inst_26897);
var inst_26899 = [cljs.core.str("not required: "),cljs.core.str(inst_26898)].join('');
var inst_26900 = figwheel.client.utils.log.call(null,inst_26899);
var state_26908__$1 = state_26908;
var statearr_26949_27025 = state_26908__$1;
(statearr_26949_27025[(2)] = inst_26900);

(statearr_26949_27025[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (6))){
var inst_26802 = (state_26908[(2)]);
var state_26908__$1 = state_26908;
var statearr_26950_27026 = state_26908__$1;
(statearr_26950_27026[(2)] = inst_26802);

(statearr_26950_27026[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (28))){
var inst_26827 = (state_26908[(26)]);
var inst_26854 = (state_26908[(2)]);
var inst_26855 = cljs.core.not_empty.call(null,inst_26827);
var state_26908__$1 = (function (){var statearr_26951 = state_26908;
(statearr_26951[(29)] = inst_26854);

return statearr_26951;
})();
if(cljs.core.truth_(inst_26855)){
var statearr_26952_27027 = state_26908__$1;
(statearr_26952_27027[(1)] = (29));

} else {
var statearr_26953_27028 = state_26908__$1;
(statearr_26953_27028[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (25))){
var inst_26825 = (state_26908[(24)]);
var inst_26841 = (state_26908[(2)]);
var inst_26842 = cljs.core.not_empty.call(null,inst_26825);
var state_26908__$1 = (function (){var statearr_26954 = state_26908;
(statearr_26954[(30)] = inst_26841);

return statearr_26954;
})();
if(cljs.core.truth_(inst_26842)){
var statearr_26955_27029 = state_26908__$1;
(statearr_26955_27029[(1)] = (26));

} else {
var statearr_26956_27030 = state_26908__$1;
(statearr_26956_27030[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (34))){
var inst_26877 = (state_26908[(2)]);
var state_26908__$1 = state_26908;
if(cljs.core.truth_(inst_26877)){
var statearr_26957_27031 = state_26908__$1;
(statearr_26957_27031[(1)] = (38));

} else {
var statearr_26958_27032 = state_26908__$1;
(statearr_26958_27032[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (17))){
var state_26908__$1 = state_26908;
var statearr_26959_27033 = state_26908__$1;
(statearr_26959_27033[(2)] = recompile_dependents);

(statearr_26959_27033[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (3))){
var state_26908__$1 = state_26908;
var statearr_26960_27034 = state_26908__$1;
(statearr_26960_27034[(2)] = null);

(statearr_26960_27034[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (12))){
var inst_26798 = (state_26908[(2)]);
var state_26908__$1 = state_26908;
var statearr_26961_27035 = state_26908__$1;
(statearr_26961_27035[(2)] = inst_26798);

(statearr_26961_27035[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (2))){
var inst_26760 = (state_26908[(13)]);
var inst_26767 = cljs.core.seq.call(null,inst_26760);
var inst_26768 = inst_26767;
var inst_26769 = null;
var inst_26770 = (0);
var inst_26771 = (0);
var state_26908__$1 = (function (){var statearr_26962 = state_26908;
(statearr_26962[(7)] = inst_26769);

(statearr_26962[(8)] = inst_26770);

(statearr_26962[(9)] = inst_26768);

(statearr_26962[(10)] = inst_26771);

return statearr_26962;
})();
var statearr_26963_27036 = state_26908__$1;
(statearr_26963_27036[(2)] = null);

(statearr_26963_27036[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (23))){
var inst_26829 = (state_26908[(23)]);
var inst_26825 = (state_26908[(24)]);
var inst_26827 = (state_26908[(26)]);
var inst_26821 = (state_26908[(19)]);
var inst_26824 = (state_26908[(25)]);
var inst_26832 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_26834 = (function (){var all_files = inst_26821;
var res_SINGLEQUOTE_ = inst_26824;
var res = inst_26825;
var files_not_loaded = inst_26827;
var dependencies_that_loaded = inst_26829;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26829,inst_26825,inst_26827,inst_26821,inst_26824,inst_26832,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26833){
var map__26964 = p__26833;
var map__26964__$1 = ((((!((map__26964 == null)))?((((map__26964.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26964.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26964):map__26964);
var request_url = cljs.core.get.call(null,map__26964__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26829,inst_26825,inst_26827,inst_26821,inst_26824,inst_26832,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26835 = cljs.core.reverse.call(null,inst_26829);
var inst_26836 = cljs.core.map.call(null,inst_26834,inst_26835);
var inst_26837 = cljs.core.pr_str.call(null,inst_26836);
var inst_26838 = figwheel.client.utils.log.call(null,inst_26837);
var state_26908__$1 = (function (){var statearr_26966 = state_26908;
(statearr_26966[(31)] = inst_26832);

return statearr_26966;
})();
var statearr_26967_27037 = state_26908__$1;
(statearr_26967_27037[(2)] = inst_26838);

(statearr_26967_27037[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (35))){
var state_26908__$1 = state_26908;
var statearr_26968_27038 = state_26908__$1;
(statearr_26968_27038[(2)] = true);

(statearr_26968_27038[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (19))){
var inst_26811 = (state_26908[(12)]);
var inst_26817 = figwheel.client.file_reloading.expand_files.call(null,inst_26811);
var state_26908__$1 = state_26908;
var statearr_26969_27039 = state_26908__$1;
(statearr_26969_27039[(2)] = inst_26817);

(statearr_26969_27039[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (11))){
var state_26908__$1 = state_26908;
var statearr_26970_27040 = state_26908__$1;
(statearr_26970_27040[(2)] = null);

(statearr_26970_27040[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (9))){
var inst_26800 = (state_26908[(2)]);
var state_26908__$1 = state_26908;
var statearr_26971_27041 = state_26908__$1;
(statearr_26971_27041[(2)] = inst_26800);

(statearr_26971_27041[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (5))){
var inst_26770 = (state_26908[(8)]);
var inst_26771 = (state_26908[(10)]);
var inst_26773 = (inst_26771 < inst_26770);
var inst_26774 = inst_26773;
var state_26908__$1 = state_26908;
if(cljs.core.truth_(inst_26774)){
var statearr_26972_27042 = state_26908__$1;
(statearr_26972_27042[(1)] = (7));

} else {
var statearr_26973_27043 = state_26908__$1;
(statearr_26973_27043[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (14))){
var inst_26781 = (state_26908[(22)]);
var inst_26790 = cljs.core.first.call(null,inst_26781);
var inst_26791 = figwheel.client.file_reloading.eval_body.call(null,inst_26790,opts);
var inst_26792 = cljs.core.next.call(null,inst_26781);
var inst_26768 = inst_26792;
var inst_26769 = null;
var inst_26770 = (0);
var inst_26771 = (0);
var state_26908__$1 = (function (){var statearr_26974 = state_26908;
(statearr_26974[(7)] = inst_26769);

(statearr_26974[(8)] = inst_26770);

(statearr_26974[(9)] = inst_26768);

(statearr_26974[(10)] = inst_26771);

(statearr_26974[(32)] = inst_26791);

return statearr_26974;
})();
var statearr_26975_27044 = state_26908__$1;
(statearr_26975_27044[(2)] = null);

(statearr_26975_27044[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (45))){
var state_26908__$1 = state_26908;
var statearr_26976_27045 = state_26908__$1;
(statearr_26976_27045[(2)] = null);

(statearr_26976_27045[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (26))){
var inst_26829 = (state_26908[(23)]);
var inst_26825 = (state_26908[(24)]);
var inst_26827 = (state_26908[(26)]);
var inst_26821 = (state_26908[(19)]);
var inst_26824 = (state_26908[(25)]);
var inst_26844 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_26846 = (function (){var all_files = inst_26821;
var res_SINGLEQUOTE_ = inst_26824;
var res = inst_26825;
var files_not_loaded = inst_26827;
var dependencies_that_loaded = inst_26829;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26829,inst_26825,inst_26827,inst_26821,inst_26824,inst_26844,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26845){
var map__26977 = p__26845;
var map__26977__$1 = ((((!((map__26977 == null)))?((((map__26977.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26977.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26977):map__26977);
var namespace = cljs.core.get.call(null,map__26977__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__26977__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26829,inst_26825,inst_26827,inst_26821,inst_26824,inst_26844,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26847 = cljs.core.map.call(null,inst_26846,inst_26825);
var inst_26848 = cljs.core.pr_str.call(null,inst_26847);
var inst_26849 = figwheel.client.utils.log.call(null,inst_26848);
var inst_26850 = (function (){var all_files = inst_26821;
var res_SINGLEQUOTE_ = inst_26824;
var res = inst_26825;
var files_not_loaded = inst_26827;
var dependencies_that_loaded = inst_26829;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26829,inst_26825,inst_26827,inst_26821,inst_26824,inst_26844,inst_26846,inst_26847,inst_26848,inst_26849,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26829,inst_26825,inst_26827,inst_26821,inst_26824,inst_26844,inst_26846,inst_26847,inst_26848,inst_26849,state_val_26909,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26851 = setTimeout(inst_26850,(10));
var state_26908__$1 = (function (){var statearr_26979 = state_26908;
(statearr_26979[(33)] = inst_26849);

(statearr_26979[(34)] = inst_26844);

return statearr_26979;
})();
var statearr_26980_27046 = state_26908__$1;
(statearr_26980_27046[(2)] = inst_26851);

(statearr_26980_27046[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (16))){
var state_26908__$1 = state_26908;
var statearr_26981_27047 = state_26908__$1;
(statearr_26981_27047[(2)] = reload_dependents);

(statearr_26981_27047[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (38))){
var inst_26861 = (state_26908[(16)]);
var inst_26879 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26861);
var state_26908__$1 = state_26908;
var statearr_26982_27048 = state_26908__$1;
(statearr_26982_27048[(2)] = inst_26879);

(statearr_26982_27048[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (30))){
var state_26908__$1 = state_26908;
var statearr_26983_27049 = state_26908__$1;
(statearr_26983_27049[(2)] = null);

(statearr_26983_27049[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (10))){
var inst_26781 = (state_26908[(22)]);
var inst_26783 = cljs.core.chunked_seq_QMARK_.call(null,inst_26781);
var state_26908__$1 = state_26908;
if(inst_26783){
var statearr_26984_27050 = state_26908__$1;
(statearr_26984_27050[(1)] = (13));

} else {
var statearr_26985_27051 = state_26908__$1;
(statearr_26985_27051[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (18))){
var inst_26815 = (state_26908[(2)]);
var state_26908__$1 = state_26908;
if(cljs.core.truth_(inst_26815)){
var statearr_26986_27052 = state_26908__$1;
(statearr_26986_27052[(1)] = (19));

} else {
var statearr_26987_27053 = state_26908__$1;
(statearr_26987_27053[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (42))){
var state_26908__$1 = state_26908;
var statearr_26988_27054 = state_26908__$1;
(statearr_26988_27054[(2)] = null);

(statearr_26988_27054[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (37))){
var inst_26874 = (state_26908[(2)]);
var state_26908__$1 = state_26908;
var statearr_26989_27055 = state_26908__$1;
(statearr_26989_27055[(2)] = inst_26874);

(statearr_26989_27055[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26909 === (8))){
var inst_26768 = (state_26908[(9)]);
var inst_26781 = (state_26908[(22)]);
var inst_26781__$1 = cljs.core.seq.call(null,inst_26768);
var state_26908__$1 = (function (){var statearr_26990 = state_26908;
(statearr_26990[(22)] = inst_26781__$1);

return statearr_26990;
})();
if(inst_26781__$1){
var statearr_26991_27056 = state_26908__$1;
(statearr_26991_27056[(1)] = (10));

} else {
var statearr_26992_27057 = state_26908__$1;
(statearr_26992_27057[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__22336__auto__,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____0 = (function (){
var statearr_26996 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26996[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__);

(statearr_26996[(1)] = (1));

return statearr_26996;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____1 = (function (state_26908){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_26908);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e26997){if((e26997 instanceof Object)){
var ex__22340__auto__ = e26997;
var statearr_26998_27058 = state_26908;
(statearr_26998_27058[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26908);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26997;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27059 = state_26908;
state_26908 = G__27059;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__ = function(state_26908){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____1.call(this,state_26908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__23182__auto__ = (function (){var statearr_26999 = f__23181__auto__.call(null);
(statearr_26999[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto__);

return statearr_26999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto__,map__26753,map__26753__$1,opts,before_jsload,on_jsload,reload_dependents,map__26754,map__26754__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__23180__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__27062,link){
var map__27065 = p__27062;
var map__27065__$1 = ((((!((map__27065 == null)))?((((map__27065.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27065.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27065):map__27065);
var file = cljs.core.get.call(null,map__27065__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__27065,map__27065__$1,file){
return (function (p1__27060_SHARP_,p2__27061_SHARP_){
if(cljs.core._EQ_.call(null,p1__27060_SHARP_,p2__27061_SHARP_)){
return p1__27060_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__27065,map__27065__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__27071){
var map__27072 = p__27071;
var map__27072__$1 = ((((!((map__27072 == null)))?((((map__27072.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27072.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27072):map__27072);
var match_length = cljs.core.get.call(null,map__27072__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__27072__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__27067_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__27067_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args27074 = [];
var len__21393__auto___27077 = arguments.length;
var i__21394__auto___27078 = (0);
while(true){
if((i__21394__auto___27078 < len__21393__auto___27077)){
args27074.push((arguments[i__21394__auto___27078]));

var G__27079 = (i__21394__auto___27078 + (1));
i__21394__auto___27078 = G__27079;
continue;
} else {
}
break;
}

var G__27076 = args27074.length;
switch (G__27076) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27074.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__27081_SHARP_,p2__27082_SHARP_){
return cljs.core.assoc.call(null,p1__27081_SHARP_,cljs.core.get.call(null,p2__27082_SHARP_,key),p2__27082_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__27083){
var map__27086 = p__27083;
var map__27086__$1 = ((((!((map__27086 == null)))?((((map__27086.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27086.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27086):map__27086);
var f_data = map__27086__$1;
var file = cljs.core.get.call(null,map__27086__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__27088,files_msg){
var map__27095 = p__27088;
var map__27095__$1 = ((((!((map__27095 == null)))?((((map__27095.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27095.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27095):map__27095);
var opts = map__27095__$1;
var on_cssload = cljs.core.get.call(null,map__27095__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__27097_27101 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__27098_27102 = null;
var count__27099_27103 = (0);
var i__27100_27104 = (0);
while(true){
if((i__27100_27104 < count__27099_27103)){
var f_27105 = cljs.core._nth.call(null,chunk__27098_27102,i__27100_27104);
figwheel.client.file_reloading.reload_css_file.call(null,f_27105);

var G__27106 = seq__27097_27101;
var G__27107 = chunk__27098_27102;
var G__27108 = count__27099_27103;
var G__27109 = (i__27100_27104 + (1));
seq__27097_27101 = G__27106;
chunk__27098_27102 = G__27107;
count__27099_27103 = G__27108;
i__27100_27104 = G__27109;
continue;
} else {
var temp__4657__auto___27110 = cljs.core.seq.call(null,seq__27097_27101);
if(temp__4657__auto___27110){
var seq__27097_27111__$1 = temp__4657__auto___27110;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27097_27111__$1)){
var c__21099__auto___27112 = cljs.core.chunk_first.call(null,seq__27097_27111__$1);
var G__27113 = cljs.core.chunk_rest.call(null,seq__27097_27111__$1);
var G__27114 = c__21099__auto___27112;
var G__27115 = cljs.core.count.call(null,c__21099__auto___27112);
var G__27116 = (0);
seq__27097_27101 = G__27113;
chunk__27098_27102 = G__27114;
count__27099_27103 = G__27115;
i__27100_27104 = G__27116;
continue;
} else {
var f_27117 = cljs.core.first.call(null,seq__27097_27111__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_27117);

var G__27118 = cljs.core.next.call(null,seq__27097_27111__$1);
var G__27119 = null;
var G__27120 = (0);
var G__27121 = (0);
seq__27097_27101 = G__27118;
chunk__27098_27102 = G__27119;
count__27099_27103 = G__27120;
i__27100_27104 = G__27121;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__27095,map__27095__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__27095,map__27095__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1481827030725