// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args23225 = [];
var len__21393__auto___23231 = arguments.length;
var i__21394__auto___23232 = (0);
while(true){
if((i__21394__auto___23232 < len__21393__auto___23231)){
args23225.push((arguments[i__21394__auto___23232]));

var G__23233 = (i__21394__auto___23232 + (1));
i__21394__auto___23232 = G__23233;
continue;
} else {
}
break;
}

var G__23227 = args23225.length;
switch (G__23227) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23225.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async23228 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23228 = (function (f,blockable,meta23229){
this.f = f;
this.blockable = blockable;
this.meta23229 = meta23229;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23228.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23230,meta23229__$1){
var self__ = this;
var _23230__$1 = this;
return (new cljs.core.async.t_cljs$core$async23228(self__.f,self__.blockable,meta23229__$1));
});

cljs.core.async.t_cljs$core$async23228.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23230){
var self__ = this;
var _23230__$1 = this;
return self__.meta23229;
});

cljs.core.async.t_cljs$core$async23228.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23228.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async23228.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async23228.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async23228.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta23229","meta23229",1348747339,null)], null);
});

cljs.core.async.t_cljs$core$async23228.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23228.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23228";

cljs.core.async.t_cljs$core$async23228.cljs$lang$ctorPrWriter = (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async23228");
});

cljs.core.async.__GT_t_cljs$core$async23228 = (function cljs$core$async$__GT_t_cljs$core$async23228(f__$1,blockable__$1,meta23229){
return (new cljs.core.async.t_cljs$core$async23228(f__$1,blockable__$1,meta23229));
});

}

return (new cljs.core.async.t_cljs$core$async23228(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args23237 = [];
var len__21393__auto___23240 = arguments.length;
var i__21394__auto___23241 = (0);
while(true){
if((i__21394__auto___23241 < len__21393__auto___23240)){
args23237.push((arguments[i__21394__auto___23241]));

var G__23242 = (i__21394__auto___23241 + (1));
i__21394__auto___23241 = G__23242;
continue;
} else {
}
break;
}

var G__23239 = args23237.length;
switch (G__23239) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23237.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args23244 = [];
var len__21393__auto___23247 = arguments.length;
var i__21394__auto___23248 = (0);
while(true){
if((i__21394__auto___23248 < len__21393__auto___23247)){
args23244.push((arguments[i__21394__auto___23248]));

var G__23249 = (i__21394__auto___23248 + (1));
i__21394__auto___23248 = G__23249;
continue;
} else {
}
break;
}

var G__23246 = args23244.length;
switch (G__23246) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23244.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args23251 = [];
var len__21393__auto___23254 = arguments.length;
var i__21394__auto___23255 = (0);
while(true){
if((i__21394__auto___23255 < len__21393__auto___23254)){
args23251.push((arguments[i__21394__auto___23255]));

var G__23256 = (i__21394__auto___23255 + (1));
i__21394__auto___23255 = G__23256;
continue;
} else {
}
break;
}

var G__23253 = args23251.length;
switch (G__23253) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23251.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_23258 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_23258);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_23258,ret){
return (function (){
return fn1.call(null,val_23258);
});})(val_23258,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args23259 = [];
var len__21393__auto___23262 = arguments.length;
var i__21394__auto___23263 = (0);
while(true){
if((i__21394__auto___23263 < len__21393__auto___23262)){
args23259.push((arguments[i__21394__auto___23263]));

var G__23264 = (i__21394__auto___23263 + (1));
i__21394__auto___23263 = G__23264;
continue;
} else {
}
break;
}

var G__23261 = args23259.length;
switch (G__23261) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23259.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__21203__auto___23266 = n;
var x_23267 = (0);
while(true){
if((x_23267 < n__21203__auto___23266)){
(a[x_23267] = (0));

var G__23268 = (x_23267 + (1));
x_23267 = G__23268;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__23269 = (i + (1));
i = G__23269;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async23273 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23273 = (function (flag,meta23274){
this.flag = flag;
this.meta23274 = meta23274;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23273.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_23275,meta23274__$1){
var self__ = this;
var _23275__$1 = this;
return (new cljs.core.async.t_cljs$core$async23273(self__.flag,meta23274__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async23273.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_23275){
var self__ = this;
var _23275__$1 = this;
return self__.meta23274;
});})(flag))
;

cljs.core.async.t_cljs$core$async23273.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23273.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async23273.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async23273.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async23273.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta23274","meta23274",-760724792,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async23273.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23273.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23273";

cljs.core.async.t_cljs$core$async23273.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async23273");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async23273 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async23273(flag__$1,meta23274){
return (new cljs.core.async.t_cljs$core$async23273(flag__$1,meta23274));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async23273(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async23279 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23279 = (function (flag,cb,meta23280){
this.flag = flag;
this.cb = cb;
this.meta23280 = meta23280;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23279.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23281,meta23280__$1){
var self__ = this;
var _23281__$1 = this;
return (new cljs.core.async.t_cljs$core$async23279(self__.flag,self__.cb,meta23280__$1));
});

cljs.core.async.t_cljs$core$async23279.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23281){
var self__ = this;
var _23281__$1 = this;
return self__.meta23280;
});

cljs.core.async.t_cljs$core$async23279.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23279.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async23279.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async23279.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async23279.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta23280","meta23280",443944158,null)], null);
});

cljs.core.async.t_cljs$core$async23279.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23279.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23279";

cljs.core.async.t_cljs$core$async23279.cljs$lang$ctorPrWriter = (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async23279");
});

cljs.core.async.__GT_t_cljs$core$async23279 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async23279(flag__$1,cb__$1,meta23280){
return (new cljs.core.async.t_cljs$core$async23279(flag__$1,cb__$1,meta23280));
});

}

return (new cljs.core.async.t_cljs$core$async23279(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__23282_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23282_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__23283_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23283_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__20285__auto__ = wport;
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
return port;
}
})()], null));
} else {
var G__23284 = (i + (1));
i = G__23284;
continue;
}
} else {
return null;
}
break;
}
})();
var or__20285__auto__ = ret;
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__20273__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__20273__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__20273__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__21400__auto__ = [];
var len__21393__auto___23290 = arguments.length;
var i__21394__auto___23291 = (0);
while(true){
if((i__21394__auto___23291 < len__21393__auto___23290)){
args__21400__auto__.push((arguments[i__21394__auto___23291]));

var G__23292 = (i__21394__auto___23291 + (1));
i__21394__auto___23291 = G__23292;
continue;
} else {
}
break;
}

var argseq__21401__auto__ = ((((1) < args__21400__auto__.length))?(new cljs.core.IndexedSeq(args__21400__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21401__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__23287){
var map__23288 = p__23287;
var map__23288__$1 = ((((!((map__23288 == null)))?((((map__23288.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23288.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23288):map__23288);
var opts = map__23288__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq23285){
var G__23286 = cljs.core.first.call(null,seq23285);
var seq23285__$1 = cljs.core.next.call(null,seq23285);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23286,seq23285__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args23293 = [];
var len__21393__auto___23343 = arguments.length;
var i__21394__auto___23344 = (0);
while(true){
if((i__21394__auto___23344 < len__21393__auto___23343)){
args23293.push((arguments[i__21394__auto___23344]));

var G__23345 = (i__21394__auto___23344 + (1));
i__21394__auto___23344 = G__23345;
continue;
} else {
}
break;
}

var G__23295 = args23293.length;
switch (G__23295) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23293.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__23180__auto___23347 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___23347){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___23347){
return (function (state_23319){
var state_val_23320 = (state_23319[(1)]);
if((state_val_23320 === (7))){
var inst_23315 = (state_23319[(2)]);
var state_23319__$1 = state_23319;
var statearr_23321_23348 = state_23319__$1;
(statearr_23321_23348[(2)] = inst_23315);

(statearr_23321_23348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23320 === (1))){
var state_23319__$1 = state_23319;
var statearr_23322_23349 = state_23319__$1;
(statearr_23322_23349[(2)] = null);

(statearr_23322_23349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23320 === (4))){
var inst_23298 = (state_23319[(7)]);
var inst_23298__$1 = (state_23319[(2)]);
var inst_23299 = (inst_23298__$1 == null);
var state_23319__$1 = (function (){var statearr_23323 = state_23319;
(statearr_23323[(7)] = inst_23298__$1);

return statearr_23323;
})();
if(cljs.core.truth_(inst_23299)){
var statearr_23324_23350 = state_23319__$1;
(statearr_23324_23350[(1)] = (5));

} else {
var statearr_23325_23351 = state_23319__$1;
(statearr_23325_23351[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23320 === (13))){
var state_23319__$1 = state_23319;
var statearr_23326_23352 = state_23319__$1;
(statearr_23326_23352[(2)] = null);

(statearr_23326_23352[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23320 === (6))){
var inst_23298 = (state_23319[(7)]);
var state_23319__$1 = state_23319;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23319__$1,(11),to,inst_23298);
} else {
if((state_val_23320 === (3))){
var inst_23317 = (state_23319[(2)]);
var state_23319__$1 = state_23319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23319__$1,inst_23317);
} else {
if((state_val_23320 === (12))){
var state_23319__$1 = state_23319;
var statearr_23327_23353 = state_23319__$1;
(statearr_23327_23353[(2)] = null);

(statearr_23327_23353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23320 === (2))){
var state_23319__$1 = state_23319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23319__$1,(4),from);
} else {
if((state_val_23320 === (11))){
var inst_23308 = (state_23319[(2)]);
var state_23319__$1 = state_23319;
if(cljs.core.truth_(inst_23308)){
var statearr_23328_23354 = state_23319__$1;
(statearr_23328_23354[(1)] = (12));

} else {
var statearr_23329_23355 = state_23319__$1;
(statearr_23329_23355[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23320 === (9))){
var state_23319__$1 = state_23319;
var statearr_23330_23356 = state_23319__$1;
(statearr_23330_23356[(2)] = null);

(statearr_23330_23356[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23320 === (5))){
var state_23319__$1 = state_23319;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23331_23357 = state_23319__$1;
(statearr_23331_23357[(1)] = (8));

} else {
var statearr_23332_23358 = state_23319__$1;
(statearr_23332_23358[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23320 === (14))){
var inst_23313 = (state_23319[(2)]);
var state_23319__$1 = state_23319;
var statearr_23333_23359 = state_23319__$1;
(statearr_23333_23359[(2)] = inst_23313);

(statearr_23333_23359[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23320 === (10))){
var inst_23305 = (state_23319[(2)]);
var state_23319__$1 = state_23319;
var statearr_23334_23360 = state_23319__$1;
(statearr_23334_23360[(2)] = inst_23305);

(statearr_23334_23360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23320 === (8))){
var inst_23302 = cljs.core.async.close_BANG_.call(null,to);
var state_23319__$1 = state_23319;
var statearr_23335_23361 = state_23319__$1;
(statearr_23335_23361[(2)] = inst_23302);

(statearr_23335_23361[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___23347))
;
return ((function (switch__22336__auto__,c__23180__auto___23347){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_23339 = [null,null,null,null,null,null,null,null];
(statearr_23339[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_23339[(1)] = (1));

return statearr_23339;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_23319){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23340){if((e23340 instanceof Object)){
var ex__22340__auto__ = e23340;
var statearr_23341_23362 = state_23319;
(statearr_23341_23362[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23340;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23363 = state_23319;
state_23319 = G__23363;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_23319){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_23319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___23347))
})();
var state__23182__auto__ = (function (){var statearr_23342 = f__23181__auto__.call(null);
(statearr_23342[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___23347);

return statearr_23342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___23347))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__23551){
var vec__23552 = p__23551;
var v = cljs.core.nth.call(null,vec__23552,(0),null);
var p = cljs.core.nth.call(null,vec__23552,(1),null);
var job = vec__23552;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__23180__auto___23738 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___23738,res,vec__23552,v,p,job,jobs,results){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___23738,res,vec__23552,v,p,job,jobs,results){
return (function (state_23559){
var state_val_23560 = (state_23559[(1)]);
if((state_val_23560 === (1))){
var state_23559__$1 = state_23559;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23559__$1,(2),res,v);
} else {
if((state_val_23560 === (2))){
var inst_23556 = (state_23559[(2)]);
var inst_23557 = cljs.core.async.close_BANG_.call(null,res);
var state_23559__$1 = (function (){var statearr_23561 = state_23559;
(statearr_23561[(7)] = inst_23556);

return statearr_23561;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23559__$1,inst_23557);
} else {
return null;
}
}
});})(c__23180__auto___23738,res,vec__23552,v,p,job,jobs,results))
;
return ((function (switch__22336__auto__,c__23180__auto___23738,res,vec__23552,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_23565 = [null,null,null,null,null,null,null,null];
(statearr_23565[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__);

(statearr_23565[(1)] = (1));

return statearr_23565;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1 = (function (state_23559){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23559);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23566){if((e23566 instanceof Object)){
var ex__22340__auto__ = e23566;
var statearr_23567_23739 = state_23559;
(statearr_23567_23739[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23559);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23566;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23740 = state_23559;
state_23559 = G__23740;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = function(state_23559){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1.call(this,state_23559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___23738,res,vec__23552,v,p,job,jobs,results))
})();
var state__23182__auto__ = (function (){var statearr_23568 = f__23181__auto__.call(null);
(statearr_23568[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___23738);

return statearr_23568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___23738,res,vec__23552,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__23569){
var vec__23570 = p__23569;
var v = cljs.core.nth.call(null,vec__23570,(0),null);
var p = cljs.core.nth.call(null,vec__23570,(1),null);
var job = vec__23570;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__21203__auto___23741 = n;
var __23742 = (0);
while(true){
if((__23742 < n__21203__auto___23741)){
var G__23573_23743 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__23573_23743) {
case "compute":
var c__23180__auto___23745 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23742,c__23180__auto___23745,G__23573_23743,n__21203__auto___23741,jobs,results,process,async){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (__23742,c__23180__auto___23745,G__23573_23743,n__21203__auto___23741,jobs,results,process,async){
return (function (state_23586){
var state_val_23587 = (state_23586[(1)]);
if((state_val_23587 === (1))){
var state_23586__$1 = state_23586;
var statearr_23588_23746 = state_23586__$1;
(statearr_23588_23746[(2)] = null);

(statearr_23588_23746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23587 === (2))){
var state_23586__$1 = state_23586;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23586__$1,(4),jobs);
} else {
if((state_val_23587 === (3))){
var inst_23584 = (state_23586[(2)]);
var state_23586__$1 = state_23586;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23586__$1,inst_23584);
} else {
if((state_val_23587 === (4))){
var inst_23576 = (state_23586[(2)]);
var inst_23577 = process.call(null,inst_23576);
var state_23586__$1 = state_23586;
if(cljs.core.truth_(inst_23577)){
var statearr_23589_23747 = state_23586__$1;
(statearr_23589_23747[(1)] = (5));

} else {
var statearr_23590_23748 = state_23586__$1;
(statearr_23590_23748[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23587 === (5))){
var state_23586__$1 = state_23586;
var statearr_23591_23749 = state_23586__$1;
(statearr_23591_23749[(2)] = null);

(statearr_23591_23749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23587 === (6))){
var state_23586__$1 = state_23586;
var statearr_23592_23750 = state_23586__$1;
(statearr_23592_23750[(2)] = null);

(statearr_23592_23750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23587 === (7))){
var inst_23582 = (state_23586[(2)]);
var state_23586__$1 = state_23586;
var statearr_23593_23751 = state_23586__$1;
(statearr_23593_23751[(2)] = inst_23582);

(statearr_23593_23751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23742,c__23180__auto___23745,G__23573_23743,n__21203__auto___23741,jobs,results,process,async))
;
return ((function (__23742,switch__22336__auto__,c__23180__auto___23745,G__23573_23743,n__21203__auto___23741,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_23597 = [null,null,null,null,null,null,null];
(statearr_23597[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__);

(statearr_23597[(1)] = (1));

return statearr_23597;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1 = (function (state_23586){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23586);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23598){if((e23598 instanceof Object)){
var ex__22340__auto__ = e23598;
var statearr_23599_23752 = state_23586;
(statearr_23599_23752[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23586);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23598;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23753 = state_23586;
state_23586 = G__23753;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = function(state_23586){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1.call(this,state_23586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__;
})()
;})(__23742,switch__22336__auto__,c__23180__auto___23745,G__23573_23743,n__21203__auto___23741,jobs,results,process,async))
})();
var state__23182__auto__ = (function (){var statearr_23600 = f__23181__auto__.call(null);
(statearr_23600[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___23745);

return statearr_23600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(__23742,c__23180__auto___23745,G__23573_23743,n__21203__auto___23741,jobs,results,process,async))
);


break;
case "async":
var c__23180__auto___23754 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23742,c__23180__auto___23754,G__23573_23743,n__21203__auto___23741,jobs,results,process,async){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (__23742,c__23180__auto___23754,G__23573_23743,n__21203__auto___23741,jobs,results,process,async){
return (function (state_23613){
var state_val_23614 = (state_23613[(1)]);
if((state_val_23614 === (1))){
var state_23613__$1 = state_23613;
var statearr_23615_23755 = state_23613__$1;
(statearr_23615_23755[(2)] = null);

(statearr_23615_23755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23614 === (2))){
var state_23613__$1 = state_23613;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23613__$1,(4),jobs);
} else {
if((state_val_23614 === (3))){
var inst_23611 = (state_23613[(2)]);
var state_23613__$1 = state_23613;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23613__$1,inst_23611);
} else {
if((state_val_23614 === (4))){
var inst_23603 = (state_23613[(2)]);
var inst_23604 = async.call(null,inst_23603);
var state_23613__$1 = state_23613;
if(cljs.core.truth_(inst_23604)){
var statearr_23616_23756 = state_23613__$1;
(statearr_23616_23756[(1)] = (5));

} else {
var statearr_23617_23757 = state_23613__$1;
(statearr_23617_23757[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23614 === (5))){
var state_23613__$1 = state_23613;
var statearr_23618_23758 = state_23613__$1;
(statearr_23618_23758[(2)] = null);

(statearr_23618_23758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23614 === (6))){
var state_23613__$1 = state_23613;
var statearr_23619_23759 = state_23613__$1;
(statearr_23619_23759[(2)] = null);

(statearr_23619_23759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23614 === (7))){
var inst_23609 = (state_23613[(2)]);
var state_23613__$1 = state_23613;
var statearr_23620_23760 = state_23613__$1;
(statearr_23620_23760[(2)] = inst_23609);

(statearr_23620_23760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23742,c__23180__auto___23754,G__23573_23743,n__21203__auto___23741,jobs,results,process,async))
;
return ((function (__23742,switch__22336__auto__,c__23180__auto___23754,G__23573_23743,n__21203__auto___23741,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_23624 = [null,null,null,null,null,null,null];
(statearr_23624[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__);

(statearr_23624[(1)] = (1));

return statearr_23624;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1 = (function (state_23613){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23613);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23625){if((e23625 instanceof Object)){
var ex__22340__auto__ = e23625;
var statearr_23626_23761 = state_23613;
(statearr_23626_23761[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23613);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23625;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23762 = state_23613;
state_23613 = G__23762;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = function(state_23613){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1.call(this,state_23613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__;
})()
;})(__23742,switch__22336__auto__,c__23180__auto___23754,G__23573_23743,n__21203__auto___23741,jobs,results,process,async))
})();
var state__23182__auto__ = (function (){var statearr_23627 = f__23181__auto__.call(null);
(statearr_23627[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___23754);

return statearr_23627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(__23742,c__23180__auto___23754,G__23573_23743,n__21203__auto___23741,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__23763 = (__23742 + (1));
__23742 = G__23763;
continue;
} else {
}
break;
}

var c__23180__auto___23764 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___23764,jobs,results,process,async){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___23764,jobs,results,process,async){
return (function (state_23649){
var state_val_23650 = (state_23649[(1)]);
if((state_val_23650 === (1))){
var state_23649__$1 = state_23649;
var statearr_23651_23765 = state_23649__$1;
(statearr_23651_23765[(2)] = null);

(statearr_23651_23765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23650 === (2))){
var state_23649__$1 = state_23649;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23649__$1,(4),from);
} else {
if((state_val_23650 === (3))){
var inst_23647 = (state_23649[(2)]);
var state_23649__$1 = state_23649;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23649__$1,inst_23647);
} else {
if((state_val_23650 === (4))){
var inst_23630 = (state_23649[(7)]);
var inst_23630__$1 = (state_23649[(2)]);
var inst_23631 = (inst_23630__$1 == null);
var state_23649__$1 = (function (){var statearr_23652 = state_23649;
(statearr_23652[(7)] = inst_23630__$1);

return statearr_23652;
})();
if(cljs.core.truth_(inst_23631)){
var statearr_23653_23766 = state_23649__$1;
(statearr_23653_23766[(1)] = (5));

} else {
var statearr_23654_23767 = state_23649__$1;
(statearr_23654_23767[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23650 === (5))){
var inst_23633 = cljs.core.async.close_BANG_.call(null,jobs);
var state_23649__$1 = state_23649;
var statearr_23655_23768 = state_23649__$1;
(statearr_23655_23768[(2)] = inst_23633);

(statearr_23655_23768[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23650 === (6))){
var inst_23630 = (state_23649[(7)]);
var inst_23635 = (state_23649[(8)]);
var inst_23635__$1 = cljs.core.async.chan.call(null,(1));
var inst_23636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23637 = [inst_23630,inst_23635__$1];
var inst_23638 = (new cljs.core.PersistentVector(null,2,(5),inst_23636,inst_23637,null));
var state_23649__$1 = (function (){var statearr_23656 = state_23649;
(statearr_23656[(8)] = inst_23635__$1);

return statearr_23656;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23649__$1,(8),jobs,inst_23638);
} else {
if((state_val_23650 === (7))){
var inst_23645 = (state_23649[(2)]);
var state_23649__$1 = state_23649;
var statearr_23657_23769 = state_23649__$1;
(statearr_23657_23769[(2)] = inst_23645);

(statearr_23657_23769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23650 === (8))){
var inst_23635 = (state_23649[(8)]);
var inst_23640 = (state_23649[(2)]);
var state_23649__$1 = (function (){var statearr_23658 = state_23649;
(statearr_23658[(9)] = inst_23640);

return statearr_23658;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23649__$1,(9),results,inst_23635);
} else {
if((state_val_23650 === (9))){
var inst_23642 = (state_23649[(2)]);
var state_23649__$1 = (function (){var statearr_23659 = state_23649;
(statearr_23659[(10)] = inst_23642);

return statearr_23659;
})();
var statearr_23660_23770 = state_23649__$1;
(statearr_23660_23770[(2)] = null);

(statearr_23660_23770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___23764,jobs,results,process,async))
;
return ((function (switch__22336__auto__,c__23180__auto___23764,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_23664 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23664[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__);

(statearr_23664[(1)] = (1));

return statearr_23664;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1 = (function (state_23649){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23649);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23665){if((e23665 instanceof Object)){
var ex__22340__auto__ = e23665;
var statearr_23666_23771 = state_23649;
(statearr_23666_23771[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23649);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23665;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23772 = state_23649;
state_23649 = G__23772;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = function(state_23649){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1.call(this,state_23649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___23764,jobs,results,process,async))
})();
var state__23182__auto__ = (function (){var statearr_23667 = f__23181__auto__.call(null);
(statearr_23667[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___23764);

return statearr_23667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___23764,jobs,results,process,async))
);


var c__23180__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto__,jobs,results,process,async){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto__,jobs,results,process,async){
return (function (state_23705){
var state_val_23706 = (state_23705[(1)]);
if((state_val_23706 === (7))){
var inst_23701 = (state_23705[(2)]);
var state_23705__$1 = state_23705;
var statearr_23707_23773 = state_23705__$1;
(statearr_23707_23773[(2)] = inst_23701);

(statearr_23707_23773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (20))){
var state_23705__$1 = state_23705;
var statearr_23708_23774 = state_23705__$1;
(statearr_23708_23774[(2)] = null);

(statearr_23708_23774[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (1))){
var state_23705__$1 = state_23705;
var statearr_23709_23775 = state_23705__$1;
(statearr_23709_23775[(2)] = null);

(statearr_23709_23775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (4))){
var inst_23670 = (state_23705[(7)]);
var inst_23670__$1 = (state_23705[(2)]);
var inst_23671 = (inst_23670__$1 == null);
var state_23705__$1 = (function (){var statearr_23710 = state_23705;
(statearr_23710[(7)] = inst_23670__$1);

return statearr_23710;
})();
if(cljs.core.truth_(inst_23671)){
var statearr_23711_23776 = state_23705__$1;
(statearr_23711_23776[(1)] = (5));

} else {
var statearr_23712_23777 = state_23705__$1;
(statearr_23712_23777[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (15))){
var inst_23683 = (state_23705[(8)]);
var state_23705__$1 = state_23705;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23705__$1,(18),to,inst_23683);
} else {
if((state_val_23706 === (21))){
var inst_23696 = (state_23705[(2)]);
var state_23705__$1 = state_23705;
var statearr_23713_23778 = state_23705__$1;
(statearr_23713_23778[(2)] = inst_23696);

(statearr_23713_23778[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (13))){
var inst_23698 = (state_23705[(2)]);
var state_23705__$1 = (function (){var statearr_23714 = state_23705;
(statearr_23714[(9)] = inst_23698);

return statearr_23714;
})();
var statearr_23715_23779 = state_23705__$1;
(statearr_23715_23779[(2)] = null);

(statearr_23715_23779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (6))){
var inst_23670 = (state_23705[(7)]);
var state_23705__$1 = state_23705;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23705__$1,(11),inst_23670);
} else {
if((state_val_23706 === (17))){
var inst_23691 = (state_23705[(2)]);
var state_23705__$1 = state_23705;
if(cljs.core.truth_(inst_23691)){
var statearr_23716_23780 = state_23705__$1;
(statearr_23716_23780[(1)] = (19));

} else {
var statearr_23717_23781 = state_23705__$1;
(statearr_23717_23781[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (3))){
var inst_23703 = (state_23705[(2)]);
var state_23705__$1 = state_23705;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23705__$1,inst_23703);
} else {
if((state_val_23706 === (12))){
var inst_23680 = (state_23705[(10)]);
var state_23705__$1 = state_23705;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23705__$1,(14),inst_23680);
} else {
if((state_val_23706 === (2))){
var state_23705__$1 = state_23705;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23705__$1,(4),results);
} else {
if((state_val_23706 === (19))){
var state_23705__$1 = state_23705;
var statearr_23718_23782 = state_23705__$1;
(statearr_23718_23782[(2)] = null);

(statearr_23718_23782[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (11))){
var inst_23680 = (state_23705[(2)]);
var state_23705__$1 = (function (){var statearr_23719 = state_23705;
(statearr_23719[(10)] = inst_23680);

return statearr_23719;
})();
var statearr_23720_23783 = state_23705__$1;
(statearr_23720_23783[(2)] = null);

(statearr_23720_23783[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (9))){
var state_23705__$1 = state_23705;
var statearr_23721_23784 = state_23705__$1;
(statearr_23721_23784[(2)] = null);

(statearr_23721_23784[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (5))){
var state_23705__$1 = state_23705;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23722_23785 = state_23705__$1;
(statearr_23722_23785[(1)] = (8));

} else {
var statearr_23723_23786 = state_23705__$1;
(statearr_23723_23786[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (14))){
var inst_23685 = (state_23705[(11)]);
var inst_23683 = (state_23705[(8)]);
var inst_23683__$1 = (state_23705[(2)]);
var inst_23684 = (inst_23683__$1 == null);
var inst_23685__$1 = cljs.core.not.call(null,inst_23684);
var state_23705__$1 = (function (){var statearr_23724 = state_23705;
(statearr_23724[(11)] = inst_23685__$1);

(statearr_23724[(8)] = inst_23683__$1);

return statearr_23724;
})();
if(inst_23685__$1){
var statearr_23725_23787 = state_23705__$1;
(statearr_23725_23787[(1)] = (15));

} else {
var statearr_23726_23788 = state_23705__$1;
(statearr_23726_23788[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (16))){
var inst_23685 = (state_23705[(11)]);
var state_23705__$1 = state_23705;
var statearr_23727_23789 = state_23705__$1;
(statearr_23727_23789[(2)] = inst_23685);

(statearr_23727_23789[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (10))){
var inst_23677 = (state_23705[(2)]);
var state_23705__$1 = state_23705;
var statearr_23728_23790 = state_23705__$1;
(statearr_23728_23790[(2)] = inst_23677);

(statearr_23728_23790[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (18))){
var inst_23688 = (state_23705[(2)]);
var state_23705__$1 = state_23705;
var statearr_23729_23791 = state_23705__$1;
(statearr_23729_23791[(2)] = inst_23688);

(statearr_23729_23791[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23706 === (8))){
var inst_23674 = cljs.core.async.close_BANG_.call(null,to);
var state_23705__$1 = state_23705;
var statearr_23730_23792 = state_23705__$1;
(statearr_23730_23792[(2)] = inst_23674);

(statearr_23730_23792[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto__,jobs,results,process,async))
;
return ((function (switch__22336__auto__,c__23180__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_23734 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23734[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__);

(statearr_23734[(1)] = (1));

return statearr_23734;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1 = (function (state_23705){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23705);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23735){if((e23735 instanceof Object)){
var ex__22340__auto__ = e23735;
var statearr_23736_23793 = state_23705;
(statearr_23736_23793[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23705);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23735;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23794 = state_23705;
state_23705 = G__23794;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = function(state_23705){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1.call(this,state_23705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto__,jobs,results,process,async))
})();
var state__23182__auto__ = (function (){var statearr_23737 = f__23181__auto__.call(null);
(statearr_23737[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto__);

return statearr_23737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto__,jobs,results,process,async))
);

return c__23180__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args23795 = [];
var len__21393__auto___23798 = arguments.length;
var i__21394__auto___23799 = (0);
while(true){
if((i__21394__auto___23799 < len__21393__auto___23798)){
args23795.push((arguments[i__21394__auto___23799]));

var G__23800 = (i__21394__auto___23799 + (1));
i__21394__auto___23799 = G__23800;
continue;
} else {
}
break;
}

var G__23797 = args23795.length;
switch (G__23797) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23795.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args23802 = [];
var len__21393__auto___23805 = arguments.length;
var i__21394__auto___23806 = (0);
while(true){
if((i__21394__auto___23806 < len__21393__auto___23805)){
args23802.push((arguments[i__21394__auto___23806]));

var G__23807 = (i__21394__auto___23806 + (1));
i__21394__auto___23806 = G__23807;
continue;
} else {
}
break;
}

var G__23804 = args23802.length;
switch (G__23804) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23802.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args23809 = [];
var len__21393__auto___23862 = arguments.length;
var i__21394__auto___23863 = (0);
while(true){
if((i__21394__auto___23863 < len__21393__auto___23862)){
args23809.push((arguments[i__21394__auto___23863]));

var G__23864 = (i__21394__auto___23863 + (1));
i__21394__auto___23863 = G__23864;
continue;
} else {
}
break;
}

var G__23811 = args23809.length;
switch (G__23811) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23809.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__23180__auto___23866 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___23866,tc,fc){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___23866,tc,fc){
return (function (state_23837){
var state_val_23838 = (state_23837[(1)]);
if((state_val_23838 === (7))){
var inst_23833 = (state_23837[(2)]);
var state_23837__$1 = state_23837;
var statearr_23839_23867 = state_23837__$1;
(statearr_23839_23867[(2)] = inst_23833);

(statearr_23839_23867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23838 === (1))){
var state_23837__$1 = state_23837;
var statearr_23840_23868 = state_23837__$1;
(statearr_23840_23868[(2)] = null);

(statearr_23840_23868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23838 === (4))){
var inst_23814 = (state_23837[(7)]);
var inst_23814__$1 = (state_23837[(2)]);
var inst_23815 = (inst_23814__$1 == null);
var state_23837__$1 = (function (){var statearr_23841 = state_23837;
(statearr_23841[(7)] = inst_23814__$1);

return statearr_23841;
})();
if(cljs.core.truth_(inst_23815)){
var statearr_23842_23869 = state_23837__$1;
(statearr_23842_23869[(1)] = (5));

} else {
var statearr_23843_23870 = state_23837__$1;
(statearr_23843_23870[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23838 === (13))){
var state_23837__$1 = state_23837;
var statearr_23844_23871 = state_23837__$1;
(statearr_23844_23871[(2)] = null);

(statearr_23844_23871[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23838 === (6))){
var inst_23814 = (state_23837[(7)]);
var inst_23820 = p.call(null,inst_23814);
var state_23837__$1 = state_23837;
if(cljs.core.truth_(inst_23820)){
var statearr_23845_23872 = state_23837__$1;
(statearr_23845_23872[(1)] = (9));

} else {
var statearr_23846_23873 = state_23837__$1;
(statearr_23846_23873[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23838 === (3))){
var inst_23835 = (state_23837[(2)]);
var state_23837__$1 = state_23837;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23837__$1,inst_23835);
} else {
if((state_val_23838 === (12))){
var state_23837__$1 = state_23837;
var statearr_23847_23874 = state_23837__$1;
(statearr_23847_23874[(2)] = null);

(statearr_23847_23874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23838 === (2))){
var state_23837__$1 = state_23837;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23837__$1,(4),ch);
} else {
if((state_val_23838 === (11))){
var inst_23814 = (state_23837[(7)]);
var inst_23824 = (state_23837[(2)]);
var state_23837__$1 = state_23837;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23837__$1,(8),inst_23824,inst_23814);
} else {
if((state_val_23838 === (9))){
var state_23837__$1 = state_23837;
var statearr_23848_23875 = state_23837__$1;
(statearr_23848_23875[(2)] = tc);

(statearr_23848_23875[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23838 === (5))){
var inst_23817 = cljs.core.async.close_BANG_.call(null,tc);
var inst_23818 = cljs.core.async.close_BANG_.call(null,fc);
var state_23837__$1 = (function (){var statearr_23849 = state_23837;
(statearr_23849[(8)] = inst_23817);

return statearr_23849;
})();
var statearr_23850_23876 = state_23837__$1;
(statearr_23850_23876[(2)] = inst_23818);

(statearr_23850_23876[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23838 === (14))){
var inst_23831 = (state_23837[(2)]);
var state_23837__$1 = state_23837;
var statearr_23851_23877 = state_23837__$1;
(statearr_23851_23877[(2)] = inst_23831);

(statearr_23851_23877[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23838 === (10))){
var state_23837__$1 = state_23837;
var statearr_23852_23878 = state_23837__$1;
(statearr_23852_23878[(2)] = fc);

(statearr_23852_23878[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23838 === (8))){
var inst_23826 = (state_23837[(2)]);
var state_23837__$1 = state_23837;
if(cljs.core.truth_(inst_23826)){
var statearr_23853_23879 = state_23837__$1;
(statearr_23853_23879[(1)] = (12));

} else {
var statearr_23854_23880 = state_23837__$1;
(statearr_23854_23880[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___23866,tc,fc))
;
return ((function (switch__22336__auto__,c__23180__auto___23866,tc,fc){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_23858 = [null,null,null,null,null,null,null,null,null];
(statearr_23858[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_23858[(1)] = (1));

return statearr_23858;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_23837){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23837);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23859){if((e23859 instanceof Object)){
var ex__22340__auto__ = e23859;
var statearr_23860_23881 = state_23837;
(statearr_23860_23881[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23837);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23859;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23882 = state_23837;
state_23837 = G__23882;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_23837){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_23837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___23866,tc,fc))
})();
var state__23182__auto__ = (function (){var statearr_23861 = f__23181__auto__.call(null);
(statearr_23861[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___23866);

return statearr_23861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___23866,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__23180__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto__){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto__){
return (function (state_23946){
var state_val_23947 = (state_23946[(1)]);
if((state_val_23947 === (7))){
var inst_23942 = (state_23946[(2)]);
var state_23946__$1 = state_23946;
var statearr_23948_23969 = state_23946__$1;
(statearr_23948_23969[(2)] = inst_23942);

(statearr_23948_23969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (1))){
var inst_23926 = init;
var state_23946__$1 = (function (){var statearr_23949 = state_23946;
(statearr_23949[(7)] = inst_23926);

return statearr_23949;
})();
var statearr_23950_23970 = state_23946__$1;
(statearr_23950_23970[(2)] = null);

(statearr_23950_23970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (4))){
var inst_23929 = (state_23946[(8)]);
var inst_23929__$1 = (state_23946[(2)]);
var inst_23930 = (inst_23929__$1 == null);
var state_23946__$1 = (function (){var statearr_23951 = state_23946;
(statearr_23951[(8)] = inst_23929__$1);

return statearr_23951;
})();
if(cljs.core.truth_(inst_23930)){
var statearr_23952_23971 = state_23946__$1;
(statearr_23952_23971[(1)] = (5));

} else {
var statearr_23953_23972 = state_23946__$1;
(statearr_23953_23972[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (6))){
var inst_23933 = (state_23946[(9)]);
var inst_23926 = (state_23946[(7)]);
var inst_23929 = (state_23946[(8)]);
var inst_23933__$1 = f.call(null,inst_23926,inst_23929);
var inst_23934 = cljs.core.reduced_QMARK_.call(null,inst_23933__$1);
var state_23946__$1 = (function (){var statearr_23954 = state_23946;
(statearr_23954[(9)] = inst_23933__$1);

return statearr_23954;
})();
if(inst_23934){
var statearr_23955_23973 = state_23946__$1;
(statearr_23955_23973[(1)] = (8));

} else {
var statearr_23956_23974 = state_23946__$1;
(statearr_23956_23974[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (3))){
var inst_23944 = (state_23946[(2)]);
var state_23946__$1 = state_23946;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23946__$1,inst_23944);
} else {
if((state_val_23947 === (2))){
var state_23946__$1 = state_23946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23946__$1,(4),ch);
} else {
if((state_val_23947 === (9))){
var inst_23933 = (state_23946[(9)]);
var inst_23926 = inst_23933;
var state_23946__$1 = (function (){var statearr_23957 = state_23946;
(statearr_23957[(7)] = inst_23926);

return statearr_23957;
})();
var statearr_23958_23975 = state_23946__$1;
(statearr_23958_23975[(2)] = null);

(statearr_23958_23975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (5))){
var inst_23926 = (state_23946[(7)]);
var state_23946__$1 = state_23946;
var statearr_23959_23976 = state_23946__$1;
(statearr_23959_23976[(2)] = inst_23926);

(statearr_23959_23976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (10))){
var inst_23940 = (state_23946[(2)]);
var state_23946__$1 = state_23946;
var statearr_23960_23977 = state_23946__$1;
(statearr_23960_23977[(2)] = inst_23940);

(statearr_23960_23977[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23947 === (8))){
var inst_23933 = (state_23946[(9)]);
var inst_23936 = cljs.core.deref.call(null,inst_23933);
var state_23946__$1 = state_23946;
var statearr_23961_23978 = state_23946__$1;
(statearr_23961_23978[(2)] = inst_23936);

(statearr_23961_23978[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto__))
;
return ((function (switch__22336__auto__,c__23180__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__22337__auto__ = null;
var cljs$core$async$reduce_$_state_machine__22337__auto____0 = (function (){
var statearr_23965 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23965[(0)] = cljs$core$async$reduce_$_state_machine__22337__auto__);

(statearr_23965[(1)] = (1));

return statearr_23965;
});
var cljs$core$async$reduce_$_state_machine__22337__auto____1 = (function (state_23946){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23946);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23966){if((e23966 instanceof Object)){
var ex__22340__auto__ = e23966;
var statearr_23967_23979 = state_23946;
(statearr_23967_23979[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23946);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23966;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23980 = state_23946;
state_23946 = G__23980;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__22337__auto__ = function(state_23946){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__22337__auto____1.call(this,state_23946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__22337__auto____0;
cljs$core$async$reduce_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__22337__auto____1;
return cljs$core$async$reduce_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto__))
})();
var state__23182__auto__ = (function (){var statearr_23968 = f__23181__auto__.call(null);
(statearr_23968[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto__);

return statearr_23968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto__))
);

return c__23180__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__23180__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto__,f__$1){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto__,f__$1){
return (function (state_24000){
var state_val_24001 = (state_24000[(1)]);
if((state_val_24001 === (1))){
var inst_23995 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_24000__$1 = state_24000;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24000__$1,(2),inst_23995);
} else {
if((state_val_24001 === (2))){
var inst_23997 = (state_24000[(2)]);
var inst_23998 = f__$1.call(null,inst_23997);
var state_24000__$1 = state_24000;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24000__$1,inst_23998);
} else {
return null;
}
}
});})(c__23180__auto__,f__$1))
;
return ((function (switch__22336__auto__,c__23180__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__22337__auto__ = null;
var cljs$core$async$transduce_$_state_machine__22337__auto____0 = (function (){
var statearr_24005 = [null,null,null,null,null,null,null];
(statearr_24005[(0)] = cljs$core$async$transduce_$_state_machine__22337__auto__);

(statearr_24005[(1)] = (1));

return statearr_24005;
});
var cljs$core$async$transduce_$_state_machine__22337__auto____1 = (function (state_24000){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_24000);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e24006){if((e24006 instanceof Object)){
var ex__22340__auto__ = e24006;
var statearr_24007_24009 = state_24000;
(statearr_24007_24009[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24000);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24006;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24010 = state_24000;
state_24000 = G__24010;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__22337__auto__ = function(state_24000){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__22337__auto____1.call(this,state_24000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__22337__auto____0;
cljs$core$async$transduce_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__22337__auto____1;
return cljs$core$async$transduce_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto__,f__$1))
})();
var state__23182__auto__ = (function (){var statearr_24008 = f__23181__auto__.call(null);
(statearr_24008[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto__);

return statearr_24008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto__,f__$1))
);

return c__23180__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args24011 = [];
var len__21393__auto___24063 = arguments.length;
var i__21394__auto___24064 = (0);
while(true){
if((i__21394__auto___24064 < len__21393__auto___24063)){
args24011.push((arguments[i__21394__auto___24064]));

var G__24065 = (i__21394__auto___24064 + (1));
i__21394__auto___24064 = G__24065;
continue;
} else {
}
break;
}

var G__24013 = args24011.length;
switch (G__24013) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24011.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__23180__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto__){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto__){
return (function (state_24038){
var state_val_24039 = (state_24038[(1)]);
if((state_val_24039 === (7))){
var inst_24020 = (state_24038[(2)]);
var state_24038__$1 = state_24038;
var statearr_24040_24067 = state_24038__$1;
(statearr_24040_24067[(2)] = inst_24020);

(statearr_24040_24067[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24039 === (1))){
var inst_24014 = cljs.core.seq.call(null,coll);
var inst_24015 = inst_24014;
var state_24038__$1 = (function (){var statearr_24041 = state_24038;
(statearr_24041[(7)] = inst_24015);

return statearr_24041;
})();
var statearr_24042_24068 = state_24038__$1;
(statearr_24042_24068[(2)] = null);

(statearr_24042_24068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24039 === (4))){
var inst_24015 = (state_24038[(7)]);
var inst_24018 = cljs.core.first.call(null,inst_24015);
var state_24038__$1 = state_24038;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24038__$1,(7),ch,inst_24018);
} else {
if((state_val_24039 === (13))){
var inst_24032 = (state_24038[(2)]);
var state_24038__$1 = state_24038;
var statearr_24043_24069 = state_24038__$1;
(statearr_24043_24069[(2)] = inst_24032);

(statearr_24043_24069[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24039 === (6))){
var inst_24023 = (state_24038[(2)]);
var state_24038__$1 = state_24038;
if(cljs.core.truth_(inst_24023)){
var statearr_24044_24070 = state_24038__$1;
(statearr_24044_24070[(1)] = (8));

} else {
var statearr_24045_24071 = state_24038__$1;
(statearr_24045_24071[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24039 === (3))){
var inst_24036 = (state_24038[(2)]);
var state_24038__$1 = state_24038;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24038__$1,inst_24036);
} else {
if((state_val_24039 === (12))){
var state_24038__$1 = state_24038;
var statearr_24046_24072 = state_24038__$1;
(statearr_24046_24072[(2)] = null);

(statearr_24046_24072[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24039 === (2))){
var inst_24015 = (state_24038[(7)]);
var state_24038__$1 = state_24038;
if(cljs.core.truth_(inst_24015)){
var statearr_24047_24073 = state_24038__$1;
(statearr_24047_24073[(1)] = (4));

} else {
var statearr_24048_24074 = state_24038__$1;
(statearr_24048_24074[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24039 === (11))){
var inst_24029 = cljs.core.async.close_BANG_.call(null,ch);
var state_24038__$1 = state_24038;
var statearr_24049_24075 = state_24038__$1;
(statearr_24049_24075[(2)] = inst_24029);

(statearr_24049_24075[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24039 === (9))){
var state_24038__$1 = state_24038;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24050_24076 = state_24038__$1;
(statearr_24050_24076[(1)] = (11));

} else {
var statearr_24051_24077 = state_24038__$1;
(statearr_24051_24077[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24039 === (5))){
var inst_24015 = (state_24038[(7)]);
var state_24038__$1 = state_24038;
var statearr_24052_24078 = state_24038__$1;
(statearr_24052_24078[(2)] = inst_24015);

(statearr_24052_24078[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24039 === (10))){
var inst_24034 = (state_24038[(2)]);
var state_24038__$1 = state_24038;
var statearr_24053_24079 = state_24038__$1;
(statearr_24053_24079[(2)] = inst_24034);

(statearr_24053_24079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24039 === (8))){
var inst_24015 = (state_24038[(7)]);
var inst_24025 = cljs.core.next.call(null,inst_24015);
var inst_24015__$1 = inst_24025;
var state_24038__$1 = (function (){var statearr_24054 = state_24038;
(statearr_24054[(7)] = inst_24015__$1);

return statearr_24054;
})();
var statearr_24055_24080 = state_24038__$1;
(statearr_24055_24080[(2)] = null);

(statearr_24055_24080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto__))
;
return ((function (switch__22336__auto__,c__23180__auto__){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_24059 = [null,null,null,null,null,null,null,null];
(statearr_24059[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_24059[(1)] = (1));

return statearr_24059;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_24038){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_24038);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e24060){if((e24060 instanceof Object)){
var ex__22340__auto__ = e24060;
var statearr_24061_24081 = state_24038;
(statearr_24061_24081[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24038);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24060;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24082 = state_24038;
state_24038 = G__24082;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_24038){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_24038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto__))
})();
var state__23182__auto__ = (function (){var statearr_24062 = f__23181__auto__.call(null);
(statearr_24062[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto__);

return statearr_24062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto__))
);

return c__23180__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__20948__auto__ = (((_ == null))?null:_);
var m__20949__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,_);
} else {
var m__20949__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__20949__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,ch);
} else {
var m__20949__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m);
} else {
var m__20949__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async24308 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24308 = (function (ch,cs,meta24309){
this.ch = ch;
this.cs = cs;
this.meta24309 = meta24309;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24308.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_24310,meta24309__$1){
var self__ = this;
var _24310__$1 = this;
return (new cljs.core.async.t_cljs$core$async24308(self__.ch,self__.cs,meta24309__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async24308.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_24310){
var self__ = this;
var _24310__$1 = this;
return self__.meta24309;
});})(cs))
;

cljs.core.async.t_cljs$core$async24308.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24308.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async24308.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24308.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24308.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24308.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24308.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta24309","meta24309",469365387,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async24308.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24308.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24308";

cljs.core.async.t_cljs$core$async24308.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async24308");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async24308 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async24308(ch__$1,cs__$1,meta24309){
return (new cljs.core.async.t_cljs$core$async24308(ch__$1,cs__$1,meta24309));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async24308(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__23180__auto___24533 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___24533,cs,m,dchan,dctr,done){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___24533,cs,m,dchan,dctr,done){
return (function (state_24445){
var state_val_24446 = (state_24445[(1)]);
if((state_val_24446 === (7))){
var inst_24441 = (state_24445[(2)]);
var state_24445__$1 = state_24445;
var statearr_24447_24534 = state_24445__$1;
(statearr_24447_24534[(2)] = inst_24441);

(statearr_24447_24534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (20))){
var inst_24344 = (state_24445[(7)]);
var inst_24356 = cljs.core.first.call(null,inst_24344);
var inst_24357 = cljs.core.nth.call(null,inst_24356,(0),null);
var inst_24358 = cljs.core.nth.call(null,inst_24356,(1),null);
var state_24445__$1 = (function (){var statearr_24448 = state_24445;
(statearr_24448[(8)] = inst_24357);

return statearr_24448;
})();
if(cljs.core.truth_(inst_24358)){
var statearr_24449_24535 = state_24445__$1;
(statearr_24449_24535[(1)] = (22));

} else {
var statearr_24450_24536 = state_24445__$1;
(statearr_24450_24536[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (27))){
var inst_24313 = (state_24445[(9)]);
var inst_24388 = (state_24445[(10)]);
var inst_24386 = (state_24445[(11)]);
var inst_24393 = (state_24445[(12)]);
var inst_24393__$1 = cljs.core._nth.call(null,inst_24386,inst_24388);
var inst_24394 = cljs.core.async.put_BANG_.call(null,inst_24393__$1,inst_24313,done);
var state_24445__$1 = (function (){var statearr_24451 = state_24445;
(statearr_24451[(12)] = inst_24393__$1);

return statearr_24451;
})();
if(cljs.core.truth_(inst_24394)){
var statearr_24452_24537 = state_24445__$1;
(statearr_24452_24537[(1)] = (30));

} else {
var statearr_24453_24538 = state_24445__$1;
(statearr_24453_24538[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (1))){
var state_24445__$1 = state_24445;
var statearr_24454_24539 = state_24445__$1;
(statearr_24454_24539[(2)] = null);

(statearr_24454_24539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (24))){
var inst_24344 = (state_24445[(7)]);
var inst_24363 = (state_24445[(2)]);
var inst_24364 = cljs.core.next.call(null,inst_24344);
var inst_24322 = inst_24364;
var inst_24323 = null;
var inst_24324 = (0);
var inst_24325 = (0);
var state_24445__$1 = (function (){var statearr_24455 = state_24445;
(statearr_24455[(13)] = inst_24324);

(statearr_24455[(14)] = inst_24325);

(statearr_24455[(15)] = inst_24363);

(statearr_24455[(16)] = inst_24322);

(statearr_24455[(17)] = inst_24323);

return statearr_24455;
})();
var statearr_24456_24540 = state_24445__$1;
(statearr_24456_24540[(2)] = null);

(statearr_24456_24540[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (39))){
var state_24445__$1 = state_24445;
var statearr_24460_24541 = state_24445__$1;
(statearr_24460_24541[(2)] = null);

(statearr_24460_24541[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (4))){
var inst_24313 = (state_24445[(9)]);
var inst_24313__$1 = (state_24445[(2)]);
var inst_24314 = (inst_24313__$1 == null);
var state_24445__$1 = (function (){var statearr_24461 = state_24445;
(statearr_24461[(9)] = inst_24313__$1);

return statearr_24461;
})();
if(cljs.core.truth_(inst_24314)){
var statearr_24462_24542 = state_24445__$1;
(statearr_24462_24542[(1)] = (5));

} else {
var statearr_24463_24543 = state_24445__$1;
(statearr_24463_24543[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (15))){
var inst_24324 = (state_24445[(13)]);
var inst_24325 = (state_24445[(14)]);
var inst_24322 = (state_24445[(16)]);
var inst_24323 = (state_24445[(17)]);
var inst_24340 = (state_24445[(2)]);
var inst_24341 = (inst_24325 + (1));
var tmp24457 = inst_24324;
var tmp24458 = inst_24322;
var tmp24459 = inst_24323;
var inst_24322__$1 = tmp24458;
var inst_24323__$1 = tmp24459;
var inst_24324__$1 = tmp24457;
var inst_24325__$1 = inst_24341;
var state_24445__$1 = (function (){var statearr_24464 = state_24445;
(statearr_24464[(13)] = inst_24324__$1);

(statearr_24464[(14)] = inst_24325__$1);

(statearr_24464[(16)] = inst_24322__$1);

(statearr_24464[(17)] = inst_24323__$1);

(statearr_24464[(18)] = inst_24340);

return statearr_24464;
})();
var statearr_24465_24544 = state_24445__$1;
(statearr_24465_24544[(2)] = null);

(statearr_24465_24544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (21))){
var inst_24367 = (state_24445[(2)]);
var state_24445__$1 = state_24445;
var statearr_24469_24545 = state_24445__$1;
(statearr_24469_24545[(2)] = inst_24367);

(statearr_24469_24545[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (31))){
var inst_24393 = (state_24445[(12)]);
var inst_24397 = done.call(null,null);
var inst_24398 = cljs.core.async.untap_STAR_.call(null,m,inst_24393);
var state_24445__$1 = (function (){var statearr_24470 = state_24445;
(statearr_24470[(19)] = inst_24397);

return statearr_24470;
})();
var statearr_24471_24546 = state_24445__$1;
(statearr_24471_24546[(2)] = inst_24398);

(statearr_24471_24546[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (32))){
var inst_24388 = (state_24445[(10)]);
var inst_24385 = (state_24445[(20)]);
var inst_24386 = (state_24445[(11)]);
var inst_24387 = (state_24445[(21)]);
var inst_24400 = (state_24445[(2)]);
var inst_24401 = (inst_24388 + (1));
var tmp24466 = inst_24385;
var tmp24467 = inst_24386;
var tmp24468 = inst_24387;
var inst_24385__$1 = tmp24466;
var inst_24386__$1 = tmp24467;
var inst_24387__$1 = tmp24468;
var inst_24388__$1 = inst_24401;
var state_24445__$1 = (function (){var statearr_24472 = state_24445;
(statearr_24472[(10)] = inst_24388__$1);

(statearr_24472[(20)] = inst_24385__$1);

(statearr_24472[(11)] = inst_24386__$1);

(statearr_24472[(21)] = inst_24387__$1);

(statearr_24472[(22)] = inst_24400);

return statearr_24472;
})();
var statearr_24473_24547 = state_24445__$1;
(statearr_24473_24547[(2)] = null);

(statearr_24473_24547[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (40))){
var inst_24413 = (state_24445[(23)]);
var inst_24417 = done.call(null,null);
var inst_24418 = cljs.core.async.untap_STAR_.call(null,m,inst_24413);
var state_24445__$1 = (function (){var statearr_24474 = state_24445;
(statearr_24474[(24)] = inst_24417);

return statearr_24474;
})();
var statearr_24475_24548 = state_24445__$1;
(statearr_24475_24548[(2)] = inst_24418);

(statearr_24475_24548[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (33))){
var inst_24404 = (state_24445[(25)]);
var inst_24406 = cljs.core.chunked_seq_QMARK_.call(null,inst_24404);
var state_24445__$1 = state_24445;
if(inst_24406){
var statearr_24476_24549 = state_24445__$1;
(statearr_24476_24549[(1)] = (36));

} else {
var statearr_24477_24550 = state_24445__$1;
(statearr_24477_24550[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (13))){
var inst_24334 = (state_24445[(26)]);
var inst_24337 = cljs.core.async.close_BANG_.call(null,inst_24334);
var state_24445__$1 = state_24445;
var statearr_24478_24551 = state_24445__$1;
(statearr_24478_24551[(2)] = inst_24337);

(statearr_24478_24551[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (22))){
var inst_24357 = (state_24445[(8)]);
var inst_24360 = cljs.core.async.close_BANG_.call(null,inst_24357);
var state_24445__$1 = state_24445;
var statearr_24479_24552 = state_24445__$1;
(statearr_24479_24552[(2)] = inst_24360);

(statearr_24479_24552[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (36))){
var inst_24404 = (state_24445[(25)]);
var inst_24408 = cljs.core.chunk_first.call(null,inst_24404);
var inst_24409 = cljs.core.chunk_rest.call(null,inst_24404);
var inst_24410 = cljs.core.count.call(null,inst_24408);
var inst_24385 = inst_24409;
var inst_24386 = inst_24408;
var inst_24387 = inst_24410;
var inst_24388 = (0);
var state_24445__$1 = (function (){var statearr_24480 = state_24445;
(statearr_24480[(10)] = inst_24388);

(statearr_24480[(20)] = inst_24385);

(statearr_24480[(11)] = inst_24386);

(statearr_24480[(21)] = inst_24387);

return statearr_24480;
})();
var statearr_24481_24553 = state_24445__$1;
(statearr_24481_24553[(2)] = null);

(statearr_24481_24553[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (41))){
var inst_24404 = (state_24445[(25)]);
var inst_24420 = (state_24445[(2)]);
var inst_24421 = cljs.core.next.call(null,inst_24404);
var inst_24385 = inst_24421;
var inst_24386 = null;
var inst_24387 = (0);
var inst_24388 = (0);
var state_24445__$1 = (function (){var statearr_24482 = state_24445;
(statearr_24482[(10)] = inst_24388);

(statearr_24482[(27)] = inst_24420);

(statearr_24482[(20)] = inst_24385);

(statearr_24482[(11)] = inst_24386);

(statearr_24482[(21)] = inst_24387);

return statearr_24482;
})();
var statearr_24483_24554 = state_24445__$1;
(statearr_24483_24554[(2)] = null);

(statearr_24483_24554[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (43))){
var state_24445__$1 = state_24445;
var statearr_24484_24555 = state_24445__$1;
(statearr_24484_24555[(2)] = null);

(statearr_24484_24555[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (29))){
var inst_24429 = (state_24445[(2)]);
var state_24445__$1 = state_24445;
var statearr_24485_24556 = state_24445__$1;
(statearr_24485_24556[(2)] = inst_24429);

(statearr_24485_24556[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (44))){
var inst_24438 = (state_24445[(2)]);
var state_24445__$1 = (function (){var statearr_24486 = state_24445;
(statearr_24486[(28)] = inst_24438);

return statearr_24486;
})();
var statearr_24487_24557 = state_24445__$1;
(statearr_24487_24557[(2)] = null);

(statearr_24487_24557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (6))){
var inst_24377 = (state_24445[(29)]);
var inst_24376 = cljs.core.deref.call(null,cs);
var inst_24377__$1 = cljs.core.keys.call(null,inst_24376);
var inst_24378 = cljs.core.count.call(null,inst_24377__$1);
var inst_24379 = cljs.core.reset_BANG_.call(null,dctr,inst_24378);
var inst_24384 = cljs.core.seq.call(null,inst_24377__$1);
var inst_24385 = inst_24384;
var inst_24386 = null;
var inst_24387 = (0);
var inst_24388 = (0);
var state_24445__$1 = (function (){var statearr_24488 = state_24445;
(statearr_24488[(10)] = inst_24388);

(statearr_24488[(20)] = inst_24385);

(statearr_24488[(11)] = inst_24386);

(statearr_24488[(21)] = inst_24387);

(statearr_24488[(29)] = inst_24377__$1);

(statearr_24488[(30)] = inst_24379);

return statearr_24488;
})();
var statearr_24489_24558 = state_24445__$1;
(statearr_24489_24558[(2)] = null);

(statearr_24489_24558[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (28))){
var inst_24385 = (state_24445[(20)]);
var inst_24404 = (state_24445[(25)]);
var inst_24404__$1 = cljs.core.seq.call(null,inst_24385);
var state_24445__$1 = (function (){var statearr_24490 = state_24445;
(statearr_24490[(25)] = inst_24404__$1);

return statearr_24490;
})();
if(inst_24404__$1){
var statearr_24491_24559 = state_24445__$1;
(statearr_24491_24559[(1)] = (33));

} else {
var statearr_24492_24560 = state_24445__$1;
(statearr_24492_24560[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (25))){
var inst_24388 = (state_24445[(10)]);
var inst_24387 = (state_24445[(21)]);
var inst_24390 = (inst_24388 < inst_24387);
var inst_24391 = inst_24390;
var state_24445__$1 = state_24445;
if(cljs.core.truth_(inst_24391)){
var statearr_24493_24561 = state_24445__$1;
(statearr_24493_24561[(1)] = (27));

} else {
var statearr_24494_24562 = state_24445__$1;
(statearr_24494_24562[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (34))){
var state_24445__$1 = state_24445;
var statearr_24495_24563 = state_24445__$1;
(statearr_24495_24563[(2)] = null);

(statearr_24495_24563[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (17))){
var state_24445__$1 = state_24445;
var statearr_24496_24564 = state_24445__$1;
(statearr_24496_24564[(2)] = null);

(statearr_24496_24564[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (3))){
var inst_24443 = (state_24445[(2)]);
var state_24445__$1 = state_24445;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24445__$1,inst_24443);
} else {
if((state_val_24446 === (12))){
var inst_24372 = (state_24445[(2)]);
var state_24445__$1 = state_24445;
var statearr_24497_24565 = state_24445__$1;
(statearr_24497_24565[(2)] = inst_24372);

(statearr_24497_24565[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (2))){
var state_24445__$1 = state_24445;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24445__$1,(4),ch);
} else {
if((state_val_24446 === (23))){
var state_24445__$1 = state_24445;
var statearr_24498_24566 = state_24445__$1;
(statearr_24498_24566[(2)] = null);

(statearr_24498_24566[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (35))){
var inst_24427 = (state_24445[(2)]);
var state_24445__$1 = state_24445;
var statearr_24499_24567 = state_24445__$1;
(statearr_24499_24567[(2)] = inst_24427);

(statearr_24499_24567[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (19))){
var inst_24344 = (state_24445[(7)]);
var inst_24348 = cljs.core.chunk_first.call(null,inst_24344);
var inst_24349 = cljs.core.chunk_rest.call(null,inst_24344);
var inst_24350 = cljs.core.count.call(null,inst_24348);
var inst_24322 = inst_24349;
var inst_24323 = inst_24348;
var inst_24324 = inst_24350;
var inst_24325 = (0);
var state_24445__$1 = (function (){var statearr_24500 = state_24445;
(statearr_24500[(13)] = inst_24324);

(statearr_24500[(14)] = inst_24325);

(statearr_24500[(16)] = inst_24322);

(statearr_24500[(17)] = inst_24323);

return statearr_24500;
})();
var statearr_24501_24568 = state_24445__$1;
(statearr_24501_24568[(2)] = null);

(statearr_24501_24568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (11))){
var inst_24344 = (state_24445[(7)]);
var inst_24322 = (state_24445[(16)]);
var inst_24344__$1 = cljs.core.seq.call(null,inst_24322);
var state_24445__$1 = (function (){var statearr_24502 = state_24445;
(statearr_24502[(7)] = inst_24344__$1);

return statearr_24502;
})();
if(inst_24344__$1){
var statearr_24503_24569 = state_24445__$1;
(statearr_24503_24569[(1)] = (16));

} else {
var statearr_24504_24570 = state_24445__$1;
(statearr_24504_24570[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (9))){
var inst_24374 = (state_24445[(2)]);
var state_24445__$1 = state_24445;
var statearr_24505_24571 = state_24445__$1;
(statearr_24505_24571[(2)] = inst_24374);

(statearr_24505_24571[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (5))){
var inst_24320 = cljs.core.deref.call(null,cs);
var inst_24321 = cljs.core.seq.call(null,inst_24320);
var inst_24322 = inst_24321;
var inst_24323 = null;
var inst_24324 = (0);
var inst_24325 = (0);
var state_24445__$1 = (function (){var statearr_24506 = state_24445;
(statearr_24506[(13)] = inst_24324);

(statearr_24506[(14)] = inst_24325);

(statearr_24506[(16)] = inst_24322);

(statearr_24506[(17)] = inst_24323);

return statearr_24506;
})();
var statearr_24507_24572 = state_24445__$1;
(statearr_24507_24572[(2)] = null);

(statearr_24507_24572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (14))){
var state_24445__$1 = state_24445;
var statearr_24508_24573 = state_24445__$1;
(statearr_24508_24573[(2)] = null);

(statearr_24508_24573[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (45))){
var inst_24435 = (state_24445[(2)]);
var state_24445__$1 = state_24445;
var statearr_24509_24574 = state_24445__$1;
(statearr_24509_24574[(2)] = inst_24435);

(statearr_24509_24574[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (26))){
var inst_24377 = (state_24445[(29)]);
var inst_24431 = (state_24445[(2)]);
var inst_24432 = cljs.core.seq.call(null,inst_24377);
var state_24445__$1 = (function (){var statearr_24510 = state_24445;
(statearr_24510[(31)] = inst_24431);

return statearr_24510;
})();
if(inst_24432){
var statearr_24511_24575 = state_24445__$1;
(statearr_24511_24575[(1)] = (42));

} else {
var statearr_24512_24576 = state_24445__$1;
(statearr_24512_24576[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (16))){
var inst_24344 = (state_24445[(7)]);
var inst_24346 = cljs.core.chunked_seq_QMARK_.call(null,inst_24344);
var state_24445__$1 = state_24445;
if(inst_24346){
var statearr_24513_24577 = state_24445__$1;
(statearr_24513_24577[(1)] = (19));

} else {
var statearr_24514_24578 = state_24445__$1;
(statearr_24514_24578[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (38))){
var inst_24424 = (state_24445[(2)]);
var state_24445__$1 = state_24445;
var statearr_24515_24579 = state_24445__$1;
(statearr_24515_24579[(2)] = inst_24424);

(statearr_24515_24579[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (30))){
var state_24445__$1 = state_24445;
var statearr_24516_24580 = state_24445__$1;
(statearr_24516_24580[(2)] = null);

(statearr_24516_24580[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (10))){
var inst_24325 = (state_24445[(14)]);
var inst_24323 = (state_24445[(17)]);
var inst_24333 = cljs.core._nth.call(null,inst_24323,inst_24325);
var inst_24334 = cljs.core.nth.call(null,inst_24333,(0),null);
var inst_24335 = cljs.core.nth.call(null,inst_24333,(1),null);
var state_24445__$1 = (function (){var statearr_24517 = state_24445;
(statearr_24517[(26)] = inst_24334);

return statearr_24517;
})();
if(cljs.core.truth_(inst_24335)){
var statearr_24518_24581 = state_24445__$1;
(statearr_24518_24581[(1)] = (13));

} else {
var statearr_24519_24582 = state_24445__$1;
(statearr_24519_24582[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (18))){
var inst_24370 = (state_24445[(2)]);
var state_24445__$1 = state_24445;
var statearr_24520_24583 = state_24445__$1;
(statearr_24520_24583[(2)] = inst_24370);

(statearr_24520_24583[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (42))){
var state_24445__$1 = state_24445;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24445__$1,(45),dchan);
} else {
if((state_val_24446 === (37))){
var inst_24313 = (state_24445[(9)]);
var inst_24413 = (state_24445[(23)]);
var inst_24404 = (state_24445[(25)]);
var inst_24413__$1 = cljs.core.first.call(null,inst_24404);
var inst_24414 = cljs.core.async.put_BANG_.call(null,inst_24413__$1,inst_24313,done);
var state_24445__$1 = (function (){var statearr_24521 = state_24445;
(statearr_24521[(23)] = inst_24413__$1);

return statearr_24521;
})();
if(cljs.core.truth_(inst_24414)){
var statearr_24522_24584 = state_24445__$1;
(statearr_24522_24584[(1)] = (39));

} else {
var statearr_24523_24585 = state_24445__$1;
(statearr_24523_24585[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24446 === (8))){
var inst_24324 = (state_24445[(13)]);
var inst_24325 = (state_24445[(14)]);
var inst_24327 = (inst_24325 < inst_24324);
var inst_24328 = inst_24327;
var state_24445__$1 = state_24445;
if(cljs.core.truth_(inst_24328)){
var statearr_24524_24586 = state_24445__$1;
(statearr_24524_24586[(1)] = (10));

} else {
var statearr_24525_24587 = state_24445__$1;
(statearr_24525_24587[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___24533,cs,m,dchan,dctr,done))
;
return ((function (switch__22336__auto__,c__23180__auto___24533,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__22337__auto__ = null;
var cljs$core$async$mult_$_state_machine__22337__auto____0 = (function (){
var statearr_24529 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24529[(0)] = cljs$core$async$mult_$_state_machine__22337__auto__);

(statearr_24529[(1)] = (1));

return statearr_24529;
});
var cljs$core$async$mult_$_state_machine__22337__auto____1 = (function (state_24445){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_24445);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e24530){if((e24530 instanceof Object)){
var ex__22340__auto__ = e24530;
var statearr_24531_24588 = state_24445;
(statearr_24531_24588[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24445);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24530;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24589 = state_24445;
state_24445 = G__24589;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__22337__auto__ = function(state_24445){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__22337__auto____1.call(this,state_24445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__22337__auto____0;
cljs$core$async$mult_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__22337__auto____1;
return cljs$core$async$mult_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___24533,cs,m,dchan,dctr,done))
})();
var state__23182__auto__ = (function (){var statearr_24532 = f__23181__auto__.call(null);
(statearr_24532[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___24533);

return statearr_24532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___24533,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args24590 = [];
var len__21393__auto___24593 = arguments.length;
var i__21394__auto___24594 = (0);
while(true){
if((i__21394__auto___24594 < len__21393__auto___24593)){
args24590.push((arguments[i__21394__auto___24594]));

var G__24595 = (i__21394__auto___24594 + (1));
i__21394__auto___24594 = G__24595;
continue;
} else {
}
break;
}

var G__24592 = args24590.length;
switch (G__24592) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24590.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,ch);
} else {
var m__20949__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,ch);
} else {
var m__20949__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m);
} else {
var m__20949__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,state_map);
} else {
var m__20949__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,mode);
} else {
var m__20949__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__21400__auto__ = [];
var len__21393__auto___24607 = arguments.length;
var i__21394__auto___24608 = (0);
while(true){
if((i__21394__auto___24608 < len__21393__auto___24607)){
args__21400__auto__.push((arguments[i__21394__auto___24608]));

var G__24609 = (i__21394__auto___24608 + (1));
i__21394__auto___24608 = G__24609;
continue;
} else {
}
break;
}

var argseq__21401__auto__ = ((((3) < args__21400__auto__.length))?(new cljs.core.IndexedSeq(args__21400__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__21401__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__24601){
var map__24602 = p__24601;
var map__24602__$1 = ((((!((map__24602 == null)))?((((map__24602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24602.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24602):map__24602);
var opts = map__24602__$1;
var statearr_24604_24610 = state;
(statearr_24604_24610[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__24602,map__24602__$1,opts){
return (function (val){
var statearr_24605_24611 = state;
(statearr_24605_24611[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__24602,map__24602__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_24606_24612 = state;
(statearr_24606_24612[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq24597){
var G__24598 = cljs.core.first.call(null,seq24597);
var seq24597__$1 = cljs.core.next.call(null,seq24597);
var G__24599 = cljs.core.first.call(null,seq24597__$1);
var seq24597__$2 = cljs.core.next.call(null,seq24597__$1);
var G__24600 = cljs.core.first.call(null,seq24597__$2);
var seq24597__$3 = cljs.core.next.call(null,seq24597__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__24598,G__24599,G__24600,seq24597__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async24780 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24780 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta24781){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta24781 = meta24781;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24780.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24782,meta24781__$1){
var self__ = this;
var _24782__$1 = this;
return (new cljs.core.async.t_cljs$core$async24780(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta24781__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24780.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24782){
var self__ = this;
var _24782__$1 = this;
return self__.meta24781;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24780.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24780.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24780.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24780.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24780.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24780.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24780.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24780.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24780.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta24781","meta24781",1061752224,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24780.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24780.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24780";

cljs.core.async.t_cljs$core$async24780.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async24780");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async24780 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async24780(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24781){
return (new cljs.core.async.t_cljs$core$async24780(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24781));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async24780(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23180__auto___24947 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___24947,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___24947,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_24884){
var state_val_24885 = (state_24884[(1)]);
if((state_val_24885 === (7))){
var inst_24799 = (state_24884[(2)]);
var state_24884__$1 = state_24884;
var statearr_24886_24948 = state_24884__$1;
(statearr_24886_24948[(2)] = inst_24799);

(statearr_24886_24948[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (20))){
var inst_24811 = (state_24884[(7)]);
var state_24884__$1 = state_24884;
var statearr_24887_24949 = state_24884__$1;
(statearr_24887_24949[(2)] = inst_24811);

(statearr_24887_24949[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (27))){
var state_24884__$1 = state_24884;
var statearr_24888_24950 = state_24884__$1;
(statearr_24888_24950[(2)] = null);

(statearr_24888_24950[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (1))){
var inst_24786 = (state_24884[(8)]);
var inst_24786__$1 = calc_state.call(null);
var inst_24788 = (inst_24786__$1 == null);
var inst_24789 = cljs.core.not.call(null,inst_24788);
var state_24884__$1 = (function (){var statearr_24889 = state_24884;
(statearr_24889[(8)] = inst_24786__$1);

return statearr_24889;
})();
if(inst_24789){
var statearr_24890_24951 = state_24884__$1;
(statearr_24890_24951[(1)] = (2));

} else {
var statearr_24891_24952 = state_24884__$1;
(statearr_24891_24952[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (24))){
var inst_24858 = (state_24884[(9)]);
var inst_24835 = (state_24884[(10)]);
var inst_24844 = (state_24884[(11)]);
var inst_24858__$1 = inst_24835.call(null,inst_24844);
var state_24884__$1 = (function (){var statearr_24892 = state_24884;
(statearr_24892[(9)] = inst_24858__$1);

return statearr_24892;
})();
if(cljs.core.truth_(inst_24858__$1)){
var statearr_24893_24953 = state_24884__$1;
(statearr_24893_24953[(1)] = (29));

} else {
var statearr_24894_24954 = state_24884__$1;
(statearr_24894_24954[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (4))){
var inst_24802 = (state_24884[(2)]);
var state_24884__$1 = state_24884;
if(cljs.core.truth_(inst_24802)){
var statearr_24895_24955 = state_24884__$1;
(statearr_24895_24955[(1)] = (8));

} else {
var statearr_24896_24956 = state_24884__$1;
(statearr_24896_24956[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (15))){
var inst_24829 = (state_24884[(2)]);
var state_24884__$1 = state_24884;
if(cljs.core.truth_(inst_24829)){
var statearr_24897_24957 = state_24884__$1;
(statearr_24897_24957[(1)] = (19));

} else {
var statearr_24898_24958 = state_24884__$1;
(statearr_24898_24958[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (21))){
var inst_24834 = (state_24884[(12)]);
var inst_24834__$1 = (state_24884[(2)]);
var inst_24835 = cljs.core.get.call(null,inst_24834__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24836 = cljs.core.get.call(null,inst_24834__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24837 = cljs.core.get.call(null,inst_24834__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_24884__$1 = (function (){var statearr_24899 = state_24884;
(statearr_24899[(10)] = inst_24835);

(statearr_24899[(13)] = inst_24836);

(statearr_24899[(12)] = inst_24834__$1);

return statearr_24899;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_24884__$1,(22),inst_24837);
} else {
if((state_val_24885 === (31))){
var inst_24866 = (state_24884[(2)]);
var state_24884__$1 = state_24884;
if(cljs.core.truth_(inst_24866)){
var statearr_24900_24959 = state_24884__$1;
(statearr_24900_24959[(1)] = (32));

} else {
var statearr_24901_24960 = state_24884__$1;
(statearr_24901_24960[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (32))){
var inst_24843 = (state_24884[(14)]);
var state_24884__$1 = state_24884;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24884__$1,(35),out,inst_24843);
} else {
if((state_val_24885 === (33))){
var inst_24834 = (state_24884[(12)]);
var inst_24811 = inst_24834;
var state_24884__$1 = (function (){var statearr_24902 = state_24884;
(statearr_24902[(7)] = inst_24811);

return statearr_24902;
})();
var statearr_24903_24961 = state_24884__$1;
(statearr_24903_24961[(2)] = null);

(statearr_24903_24961[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (13))){
var inst_24811 = (state_24884[(7)]);
var inst_24818 = inst_24811.cljs$lang$protocol_mask$partition0$;
var inst_24819 = (inst_24818 & (64));
var inst_24820 = inst_24811.cljs$core$ISeq$;
var inst_24821 = (cljs.core.PROTOCOL_SENTINEL === inst_24820);
var inst_24822 = (inst_24819) || (inst_24821);
var state_24884__$1 = state_24884;
if(cljs.core.truth_(inst_24822)){
var statearr_24904_24962 = state_24884__$1;
(statearr_24904_24962[(1)] = (16));

} else {
var statearr_24905_24963 = state_24884__$1;
(statearr_24905_24963[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (22))){
var inst_24844 = (state_24884[(11)]);
var inst_24843 = (state_24884[(14)]);
var inst_24842 = (state_24884[(2)]);
var inst_24843__$1 = cljs.core.nth.call(null,inst_24842,(0),null);
var inst_24844__$1 = cljs.core.nth.call(null,inst_24842,(1),null);
var inst_24845 = (inst_24843__$1 == null);
var inst_24846 = cljs.core._EQ_.call(null,inst_24844__$1,change);
var inst_24847 = (inst_24845) || (inst_24846);
var state_24884__$1 = (function (){var statearr_24906 = state_24884;
(statearr_24906[(11)] = inst_24844__$1);

(statearr_24906[(14)] = inst_24843__$1);

return statearr_24906;
})();
if(cljs.core.truth_(inst_24847)){
var statearr_24907_24964 = state_24884__$1;
(statearr_24907_24964[(1)] = (23));

} else {
var statearr_24908_24965 = state_24884__$1;
(statearr_24908_24965[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (36))){
var inst_24834 = (state_24884[(12)]);
var inst_24811 = inst_24834;
var state_24884__$1 = (function (){var statearr_24909 = state_24884;
(statearr_24909[(7)] = inst_24811);

return statearr_24909;
})();
var statearr_24910_24966 = state_24884__$1;
(statearr_24910_24966[(2)] = null);

(statearr_24910_24966[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (29))){
var inst_24858 = (state_24884[(9)]);
var state_24884__$1 = state_24884;
var statearr_24911_24967 = state_24884__$1;
(statearr_24911_24967[(2)] = inst_24858);

(statearr_24911_24967[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (6))){
var state_24884__$1 = state_24884;
var statearr_24912_24968 = state_24884__$1;
(statearr_24912_24968[(2)] = false);

(statearr_24912_24968[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (28))){
var inst_24854 = (state_24884[(2)]);
var inst_24855 = calc_state.call(null);
var inst_24811 = inst_24855;
var state_24884__$1 = (function (){var statearr_24913 = state_24884;
(statearr_24913[(15)] = inst_24854);

(statearr_24913[(7)] = inst_24811);

return statearr_24913;
})();
var statearr_24914_24969 = state_24884__$1;
(statearr_24914_24969[(2)] = null);

(statearr_24914_24969[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (25))){
var inst_24880 = (state_24884[(2)]);
var state_24884__$1 = state_24884;
var statearr_24915_24970 = state_24884__$1;
(statearr_24915_24970[(2)] = inst_24880);

(statearr_24915_24970[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (34))){
var inst_24878 = (state_24884[(2)]);
var state_24884__$1 = state_24884;
var statearr_24916_24971 = state_24884__$1;
(statearr_24916_24971[(2)] = inst_24878);

(statearr_24916_24971[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (17))){
var state_24884__$1 = state_24884;
var statearr_24917_24972 = state_24884__$1;
(statearr_24917_24972[(2)] = false);

(statearr_24917_24972[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (3))){
var state_24884__$1 = state_24884;
var statearr_24918_24973 = state_24884__$1;
(statearr_24918_24973[(2)] = false);

(statearr_24918_24973[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (12))){
var inst_24882 = (state_24884[(2)]);
var state_24884__$1 = state_24884;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24884__$1,inst_24882);
} else {
if((state_val_24885 === (2))){
var inst_24786 = (state_24884[(8)]);
var inst_24791 = inst_24786.cljs$lang$protocol_mask$partition0$;
var inst_24792 = (inst_24791 & (64));
var inst_24793 = inst_24786.cljs$core$ISeq$;
var inst_24794 = (cljs.core.PROTOCOL_SENTINEL === inst_24793);
var inst_24795 = (inst_24792) || (inst_24794);
var state_24884__$1 = state_24884;
if(cljs.core.truth_(inst_24795)){
var statearr_24919_24974 = state_24884__$1;
(statearr_24919_24974[(1)] = (5));

} else {
var statearr_24920_24975 = state_24884__$1;
(statearr_24920_24975[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (23))){
var inst_24843 = (state_24884[(14)]);
var inst_24849 = (inst_24843 == null);
var state_24884__$1 = state_24884;
if(cljs.core.truth_(inst_24849)){
var statearr_24921_24976 = state_24884__$1;
(statearr_24921_24976[(1)] = (26));

} else {
var statearr_24922_24977 = state_24884__$1;
(statearr_24922_24977[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (35))){
var inst_24869 = (state_24884[(2)]);
var state_24884__$1 = state_24884;
if(cljs.core.truth_(inst_24869)){
var statearr_24923_24978 = state_24884__$1;
(statearr_24923_24978[(1)] = (36));

} else {
var statearr_24924_24979 = state_24884__$1;
(statearr_24924_24979[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (19))){
var inst_24811 = (state_24884[(7)]);
var inst_24831 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24811);
var state_24884__$1 = state_24884;
var statearr_24925_24980 = state_24884__$1;
(statearr_24925_24980[(2)] = inst_24831);

(statearr_24925_24980[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (11))){
var inst_24811 = (state_24884[(7)]);
var inst_24815 = (inst_24811 == null);
var inst_24816 = cljs.core.not.call(null,inst_24815);
var state_24884__$1 = state_24884;
if(inst_24816){
var statearr_24926_24981 = state_24884__$1;
(statearr_24926_24981[(1)] = (13));

} else {
var statearr_24927_24982 = state_24884__$1;
(statearr_24927_24982[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (9))){
var inst_24786 = (state_24884[(8)]);
var state_24884__$1 = state_24884;
var statearr_24928_24983 = state_24884__$1;
(statearr_24928_24983[(2)] = inst_24786);

(statearr_24928_24983[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (5))){
var state_24884__$1 = state_24884;
var statearr_24929_24984 = state_24884__$1;
(statearr_24929_24984[(2)] = true);

(statearr_24929_24984[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (14))){
var state_24884__$1 = state_24884;
var statearr_24930_24985 = state_24884__$1;
(statearr_24930_24985[(2)] = false);

(statearr_24930_24985[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (26))){
var inst_24844 = (state_24884[(11)]);
var inst_24851 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_24844);
var state_24884__$1 = state_24884;
var statearr_24931_24986 = state_24884__$1;
(statearr_24931_24986[(2)] = inst_24851);

(statearr_24931_24986[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (16))){
var state_24884__$1 = state_24884;
var statearr_24932_24987 = state_24884__$1;
(statearr_24932_24987[(2)] = true);

(statearr_24932_24987[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (38))){
var inst_24874 = (state_24884[(2)]);
var state_24884__$1 = state_24884;
var statearr_24933_24988 = state_24884__$1;
(statearr_24933_24988[(2)] = inst_24874);

(statearr_24933_24988[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (30))){
var inst_24835 = (state_24884[(10)]);
var inst_24844 = (state_24884[(11)]);
var inst_24836 = (state_24884[(13)]);
var inst_24861 = cljs.core.empty_QMARK_.call(null,inst_24835);
var inst_24862 = inst_24836.call(null,inst_24844);
var inst_24863 = cljs.core.not.call(null,inst_24862);
var inst_24864 = (inst_24861) && (inst_24863);
var state_24884__$1 = state_24884;
var statearr_24934_24989 = state_24884__$1;
(statearr_24934_24989[(2)] = inst_24864);

(statearr_24934_24989[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (10))){
var inst_24786 = (state_24884[(8)]);
var inst_24807 = (state_24884[(2)]);
var inst_24808 = cljs.core.get.call(null,inst_24807,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24809 = cljs.core.get.call(null,inst_24807,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24810 = cljs.core.get.call(null,inst_24807,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_24811 = inst_24786;
var state_24884__$1 = (function (){var statearr_24935 = state_24884;
(statearr_24935[(16)] = inst_24810);

(statearr_24935[(17)] = inst_24808);

(statearr_24935[(18)] = inst_24809);

(statearr_24935[(7)] = inst_24811);

return statearr_24935;
})();
var statearr_24936_24990 = state_24884__$1;
(statearr_24936_24990[(2)] = null);

(statearr_24936_24990[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (18))){
var inst_24826 = (state_24884[(2)]);
var state_24884__$1 = state_24884;
var statearr_24937_24991 = state_24884__$1;
(statearr_24937_24991[(2)] = inst_24826);

(statearr_24937_24991[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (37))){
var state_24884__$1 = state_24884;
var statearr_24938_24992 = state_24884__$1;
(statearr_24938_24992[(2)] = null);

(statearr_24938_24992[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24885 === (8))){
var inst_24786 = (state_24884[(8)]);
var inst_24804 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24786);
var state_24884__$1 = state_24884;
var statearr_24939_24993 = state_24884__$1;
(statearr_24939_24993[(2)] = inst_24804);

(statearr_24939_24993[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___24947,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__22336__auto__,c__23180__auto___24947,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__22337__auto__ = null;
var cljs$core$async$mix_$_state_machine__22337__auto____0 = (function (){
var statearr_24943 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24943[(0)] = cljs$core$async$mix_$_state_machine__22337__auto__);

(statearr_24943[(1)] = (1));

return statearr_24943;
});
var cljs$core$async$mix_$_state_machine__22337__auto____1 = (function (state_24884){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_24884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e24944){if((e24944 instanceof Object)){
var ex__22340__auto__ = e24944;
var statearr_24945_24994 = state_24884;
(statearr_24945_24994[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24884);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24944;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24995 = state_24884;
state_24884 = G__24995;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__22337__auto__ = function(state_24884){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__22337__auto____1.call(this,state_24884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__22337__auto____0;
cljs$core$async$mix_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__22337__auto____1;
return cljs$core$async$mix_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___24947,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__23182__auto__ = (function (){var statearr_24946 = f__23181__auto__.call(null);
(statearr_24946[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___24947);

return statearr_24946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___24947,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__20948__auto__ = (((p == null))?null:p);
var m__20949__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__20949__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__20948__auto__ = (((p == null))?null:p);
var m__20949__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,p,v,ch);
} else {
var m__20949__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args24996 = [];
var len__21393__auto___24999 = arguments.length;
var i__21394__auto___25000 = (0);
while(true){
if((i__21394__auto___25000 < len__21393__auto___24999)){
args24996.push((arguments[i__21394__auto___25000]));

var G__25001 = (i__21394__auto___25000 + (1));
i__21394__auto___25000 = G__25001;
continue;
} else {
}
break;
}

var G__24998 = args24996.length;
switch (G__24998) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24996.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__20948__auto__ = (((p == null))?null:p);
var m__20949__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,p);
} else {
var m__20949__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__20948__auto__ = (((p == null))?null:p);
var m__20949__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,p,v);
} else {
var m__20949__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args25004 = [];
var len__21393__auto___25129 = arguments.length;
var i__21394__auto___25130 = (0);
while(true){
if((i__21394__auto___25130 < len__21393__auto___25129)){
args25004.push((arguments[i__21394__auto___25130]));

var G__25131 = (i__21394__auto___25130 + (1));
i__21394__auto___25130 = G__25131;
continue;
} else {
}
break;
}

var G__25006 = args25004.length;
switch (G__25006) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25004.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__20285__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__20285__auto__,mults){
return (function (p1__25003_SHARP_){
if(cljs.core.truth_(p1__25003_SHARP_.call(null,topic))){
return p1__25003_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__25003_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__20285__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async25007 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25007 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta25008){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta25008 = meta25008;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25007.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_25009,meta25008__$1){
var self__ = this;
var _25009__$1 = this;
return (new cljs.core.async.t_cljs$core$async25007(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta25008__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25007.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_25009){
var self__ = this;
var _25009__$1 = this;
return self__.meta25008;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25007.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25007.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25007.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25007.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25007.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25007.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25007.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25007.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta25008","meta25008",808194449,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25007.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25007.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25007";

cljs.core.async.t_cljs$core$async25007.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async25007");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async25007 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async25007(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25008){
return (new cljs.core.async.t_cljs$core$async25007(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25008));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async25007(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23180__auto___25134 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___25134,mults,ensure_mult,p){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___25134,mults,ensure_mult,p){
return (function (state_25081){
var state_val_25082 = (state_25081[(1)]);
if((state_val_25082 === (7))){
var inst_25077 = (state_25081[(2)]);
var state_25081__$1 = state_25081;
var statearr_25083_25135 = state_25081__$1;
(statearr_25083_25135[(2)] = inst_25077);

(statearr_25083_25135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (20))){
var state_25081__$1 = state_25081;
var statearr_25084_25136 = state_25081__$1;
(statearr_25084_25136[(2)] = null);

(statearr_25084_25136[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (1))){
var state_25081__$1 = state_25081;
var statearr_25085_25137 = state_25081__$1;
(statearr_25085_25137[(2)] = null);

(statearr_25085_25137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (24))){
var inst_25060 = (state_25081[(7)]);
var inst_25069 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_25060);
var state_25081__$1 = state_25081;
var statearr_25086_25138 = state_25081__$1;
(statearr_25086_25138[(2)] = inst_25069);

(statearr_25086_25138[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (4))){
var inst_25012 = (state_25081[(8)]);
var inst_25012__$1 = (state_25081[(2)]);
var inst_25013 = (inst_25012__$1 == null);
var state_25081__$1 = (function (){var statearr_25087 = state_25081;
(statearr_25087[(8)] = inst_25012__$1);

return statearr_25087;
})();
if(cljs.core.truth_(inst_25013)){
var statearr_25088_25139 = state_25081__$1;
(statearr_25088_25139[(1)] = (5));

} else {
var statearr_25089_25140 = state_25081__$1;
(statearr_25089_25140[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (15))){
var inst_25054 = (state_25081[(2)]);
var state_25081__$1 = state_25081;
var statearr_25090_25141 = state_25081__$1;
(statearr_25090_25141[(2)] = inst_25054);

(statearr_25090_25141[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (21))){
var inst_25074 = (state_25081[(2)]);
var state_25081__$1 = (function (){var statearr_25091 = state_25081;
(statearr_25091[(9)] = inst_25074);

return statearr_25091;
})();
var statearr_25092_25142 = state_25081__$1;
(statearr_25092_25142[(2)] = null);

(statearr_25092_25142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (13))){
var inst_25036 = (state_25081[(10)]);
var inst_25038 = cljs.core.chunked_seq_QMARK_.call(null,inst_25036);
var state_25081__$1 = state_25081;
if(inst_25038){
var statearr_25093_25143 = state_25081__$1;
(statearr_25093_25143[(1)] = (16));

} else {
var statearr_25094_25144 = state_25081__$1;
(statearr_25094_25144[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (22))){
var inst_25066 = (state_25081[(2)]);
var state_25081__$1 = state_25081;
if(cljs.core.truth_(inst_25066)){
var statearr_25095_25145 = state_25081__$1;
(statearr_25095_25145[(1)] = (23));

} else {
var statearr_25096_25146 = state_25081__$1;
(statearr_25096_25146[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (6))){
var inst_25060 = (state_25081[(7)]);
var inst_25062 = (state_25081[(11)]);
var inst_25012 = (state_25081[(8)]);
var inst_25060__$1 = topic_fn.call(null,inst_25012);
var inst_25061 = cljs.core.deref.call(null,mults);
var inst_25062__$1 = cljs.core.get.call(null,inst_25061,inst_25060__$1);
var state_25081__$1 = (function (){var statearr_25097 = state_25081;
(statearr_25097[(7)] = inst_25060__$1);

(statearr_25097[(11)] = inst_25062__$1);

return statearr_25097;
})();
if(cljs.core.truth_(inst_25062__$1)){
var statearr_25098_25147 = state_25081__$1;
(statearr_25098_25147[(1)] = (19));

} else {
var statearr_25099_25148 = state_25081__$1;
(statearr_25099_25148[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (25))){
var inst_25071 = (state_25081[(2)]);
var state_25081__$1 = state_25081;
var statearr_25100_25149 = state_25081__$1;
(statearr_25100_25149[(2)] = inst_25071);

(statearr_25100_25149[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (17))){
var inst_25036 = (state_25081[(10)]);
var inst_25045 = cljs.core.first.call(null,inst_25036);
var inst_25046 = cljs.core.async.muxch_STAR_.call(null,inst_25045);
var inst_25047 = cljs.core.async.close_BANG_.call(null,inst_25046);
var inst_25048 = cljs.core.next.call(null,inst_25036);
var inst_25022 = inst_25048;
var inst_25023 = null;
var inst_25024 = (0);
var inst_25025 = (0);
var state_25081__$1 = (function (){var statearr_25101 = state_25081;
(statearr_25101[(12)] = inst_25022);

(statearr_25101[(13)] = inst_25024);

(statearr_25101[(14)] = inst_25023);

(statearr_25101[(15)] = inst_25047);

(statearr_25101[(16)] = inst_25025);

return statearr_25101;
})();
var statearr_25102_25150 = state_25081__$1;
(statearr_25102_25150[(2)] = null);

(statearr_25102_25150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (3))){
var inst_25079 = (state_25081[(2)]);
var state_25081__$1 = state_25081;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25081__$1,inst_25079);
} else {
if((state_val_25082 === (12))){
var inst_25056 = (state_25081[(2)]);
var state_25081__$1 = state_25081;
var statearr_25103_25151 = state_25081__$1;
(statearr_25103_25151[(2)] = inst_25056);

(statearr_25103_25151[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (2))){
var state_25081__$1 = state_25081;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25081__$1,(4),ch);
} else {
if((state_val_25082 === (23))){
var state_25081__$1 = state_25081;
var statearr_25104_25152 = state_25081__$1;
(statearr_25104_25152[(2)] = null);

(statearr_25104_25152[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (19))){
var inst_25062 = (state_25081[(11)]);
var inst_25012 = (state_25081[(8)]);
var inst_25064 = cljs.core.async.muxch_STAR_.call(null,inst_25062);
var state_25081__$1 = state_25081;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25081__$1,(22),inst_25064,inst_25012);
} else {
if((state_val_25082 === (11))){
var inst_25022 = (state_25081[(12)]);
var inst_25036 = (state_25081[(10)]);
var inst_25036__$1 = cljs.core.seq.call(null,inst_25022);
var state_25081__$1 = (function (){var statearr_25105 = state_25081;
(statearr_25105[(10)] = inst_25036__$1);

return statearr_25105;
})();
if(inst_25036__$1){
var statearr_25106_25153 = state_25081__$1;
(statearr_25106_25153[(1)] = (13));

} else {
var statearr_25107_25154 = state_25081__$1;
(statearr_25107_25154[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (9))){
var inst_25058 = (state_25081[(2)]);
var state_25081__$1 = state_25081;
var statearr_25108_25155 = state_25081__$1;
(statearr_25108_25155[(2)] = inst_25058);

(statearr_25108_25155[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (5))){
var inst_25019 = cljs.core.deref.call(null,mults);
var inst_25020 = cljs.core.vals.call(null,inst_25019);
var inst_25021 = cljs.core.seq.call(null,inst_25020);
var inst_25022 = inst_25021;
var inst_25023 = null;
var inst_25024 = (0);
var inst_25025 = (0);
var state_25081__$1 = (function (){var statearr_25109 = state_25081;
(statearr_25109[(12)] = inst_25022);

(statearr_25109[(13)] = inst_25024);

(statearr_25109[(14)] = inst_25023);

(statearr_25109[(16)] = inst_25025);

return statearr_25109;
})();
var statearr_25110_25156 = state_25081__$1;
(statearr_25110_25156[(2)] = null);

(statearr_25110_25156[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (14))){
var state_25081__$1 = state_25081;
var statearr_25114_25157 = state_25081__$1;
(statearr_25114_25157[(2)] = null);

(statearr_25114_25157[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (16))){
var inst_25036 = (state_25081[(10)]);
var inst_25040 = cljs.core.chunk_first.call(null,inst_25036);
var inst_25041 = cljs.core.chunk_rest.call(null,inst_25036);
var inst_25042 = cljs.core.count.call(null,inst_25040);
var inst_25022 = inst_25041;
var inst_25023 = inst_25040;
var inst_25024 = inst_25042;
var inst_25025 = (0);
var state_25081__$1 = (function (){var statearr_25115 = state_25081;
(statearr_25115[(12)] = inst_25022);

(statearr_25115[(13)] = inst_25024);

(statearr_25115[(14)] = inst_25023);

(statearr_25115[(16)] = inst_25025);

return statearr_25115;
})();
var statearr_25116_25158 = state_25081__$1;
(statearr_25116_25158[(2)] = null);

(statearr_25116_25158[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (10))){
var inst_25022 = (state_25081[(12)]);
var inst_25024 = (state_25081[(13)]);
var inst_25023 = (state_25081[(14)]);
var inst_25025 = (state_25081[(16)]);
var inst_25030 = cljs.core._nth.call(null,inst_25023,inst_25025);
var inst_25031 = cljs.core.async.muxch_STAR_.call(null,inst_25030);
var inst_25032 = cljs.core.async.close_BANG_.call(null,inst_25031);
var inst_25033 = (inst_25025 + (1));
var tmp25111 = inst_25022;
var tmp25112 = inst_25024;
var tmp25113 = inst_25023;
var inst_25022__$1 = tmp25111;
var inst_25023__$1 = tmp25113;
var inst_25024__$1 = tmp25112;
var inst_25025__$1 = inst_25033;
var state_25081__$1 = (function (){var statearr_25117 = state_25081;
(statearr_25117[(12)] = inst_25022__$1);

(statearr_25117[(13)] = inst_25024__$1);

(statearr_25117[(14)] = inst_25023__$1);

(statearr_25117[(16)] = inst_25025__$1);

(statearr_25117[(17)] = inst_25032);

return statearr_25117;
})();
var statearr_25118_25159 = state_25081__$1;
(statearr_25118_25159[(2)] = null);

(statearr_25118_25159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (18))){
var inst_25051 = (state_25081[(2)]);
var state_25081__$1 = state_25081;
var statearr_25119_25160 = state_25081__$1;
(statearr_25119_25160[(2)] = inst_25051);

(statearr_25119_25160[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25082 === (8))){
var inst_25024 = (state_25081[(13)]);
var inst_25025 = (state_25081[(16)]);
var inst_25027 = (inst_25025 < inst_25024);
var inst_25028 = inst_25027;
var state_25081__$1 = state_25081;
if(cljs.core.truth_(inst_25028)){
var statearr_25120_25161 = state_25081__$1;
(statearr_25120_25161[(1)] = (10));

} else {
var statearr_25121_25162 = state_25081__$1;
(statearr_25121_25162[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___25134,mults,ensure_mult,p))
;
return ((function (switch__22336__auto__,c__23180__auto___25134,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25125 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25125[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25125[(1)] = (1));

return statearr_25125;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25081){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25081);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25126){if((e25126 instanceof Object)){
var ex__22340__auto__ = e25126;
var statearr_25127_25163 = state_25081;
(statearr_25127_25163[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25081);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25126;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25164 = state_25081;
state_25081 = G__25164;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25081){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___25134,mults,ensure_mult,p))
})();
var state__23182__auto__ = (function (){var statearr_25128 = f__23181__auto__.call(null);
(statearr_25128[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___25134);

return statearr_25128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___25134,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args25165 = [];
var len__21393__auto___25168 = arguments.length;
var i__21394__auto___25169 = (0);
while(true){
if((i__21394__auto___25169 < len__21393__auto___25168)){
args25165.push((arguments[i__21394__auto___25169]));

var G__25170 = (i__21394__auto___25169 + (1));
i__21394__auto___25169 = G__25170;
continue;
} else {
}
break;
}

var G__25167 = args25165.length;
switch (G__25167) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25165.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args25172 = [];
var len__21393__auto___25175 = arguments.length;
var i__21394__auto___25176 = (0);
while(true){
if((i__21394__auto___25176 < len__21393__auto___25175)){
args25172.push((arguments[i__21394__auto___25176]));

var G__25177 = (i__21394__auto___25176 + (1));
i__21394__auto___25176 = G__25177;
continue;
} else {
}
break;
}

var G__25174 = args25172.length;
switch (G__25174) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25172.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args25179 = [];
var len__21393__auto___25250 = arguments.length;
var i__21394__auto___25251 = (0);
while(true){
if((i__21394__auto___25251 < len__21393__auto___25250)){
args25179.push((arguments[i__21394__auto___25251]));

var G__25252 = (i__21394__auto___25251 + (1));
i__21394__auto___25251 = G__25252;
continue;
} else {
}
break;
}

var G__25181 = args25179.length;
switch (G__25181) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25179.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__23180__auto___25254 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___25254,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___25254,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_25220){
var state_val_25221 = (state_25220[(1)]);
if((state_val_25221 === (7))){
var state_25220__$1 = state_25220;
var statearr_25222_25255 = state_25220__$1;
(statearr_25222_25255[(2)] = null);

(statearr_25222_25255[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (1))){
var state_25220__$1 = state_25220;
var statearr_25223_25256 = state_25220__$1;
(statearr_25223_25256[(2)] = null);

(statearr_25223_25256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (4))){
var inst_25184 = (state_25220[(7)]);
var inst_25186 = (inst_25184 < cnt);
var state_25220__$1 = state_25220;
if(cljs.core.truth_(inst_25186)){
var statearr_25224_25257 = state_25220__$1;
(statearr_25224_25257[(1)] = (6));

} else {
var statearr_25225_25258 = state_25220__$1;
(statearr_25225_25258[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (15))){
var inst_25216 = (state_25220[(2)]);
var state_25220__$1 = state_25220;
var statearr_25226_25259 = state_25220__$1;
(statearr_25226_25259[(2)] = inst_25216);

(statearr_25226_25259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (13))){
var inst_25209 = cljs.core.async.close_BANG_.call(null,out);
var state_25220__$1 = state_25220;
var statearr_25227_25260 = state_25220__$1;
(statearr_25227_25260[(2)] = inst_25209);

(statearr_25227_25260[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (6))){
var state_25220__$1 = state_25220;
var statearr_25228_25261 = state_25220__$1;
(statearr_25228_25261[(2)] = null);

(statearr_25228_25261[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (3))){
var inst_25218 = (state_25220[(2)]);
var state_25220__$1 = state_25220;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25220__$1,inst_25218);
} else {
if((state_val_25221 === (12))){
var inst_25206 = (state_25220[(8)]);
var inst_25206__$1 = (state_25220[(2)]);
var inst_25207 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_25206__$1);
var state_25220__$1 = (function (){var statearr_25229 = state_25220;
(statearr_25229[(8)] = inst_25206__$1);

return statearr_25229;
})();
if(cljs.core.truth_(inst_25207)){
var statearr_25230_25262 = state_25220__$1;
(statearr_25230_25262[(1)] = (13));

} else {
var statearr_25231_25263 = state_25220__$1;
(statearr_25231_25263[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (2))){
var inst_25183 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_25184 = (0);
var state_25220__$1 = (function (){var statearr_25232 = state_25220;
(statearr_25232[(7)] = inst_25184);

(statearr_25232[(9)] = inst_25183);

return statearr_25232;
})();
var statearr_25233_25264 = state_25220__$1;
(statearr_25233_25264[(2)] = null);

(statearr_25233_25264[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (11))){
var inst_25184 = (state_25220[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_25220,(10),Object,null,(9));
var inst_25193 = chs__$1.call(null,inst_25184);
var inst_25194 = done.call(null,inst_25184);
var inst_25195 = cljs.core.async.take_BANG_.call(null,inst_25193,inst_25194);
var state_25220__$1 = state_25220;
var statearr_25234_25265 = state_25220__$1;
(statearr_25234_25265[(2)] = inst_25195);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25220__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (9))){
var inst_25184 = (state_25220[(7)]);
var inst_25197 = (state_25220[(2)]);
var inst_25198 = (inst_25184 + (1));
var inst_25184__$1 = inst_25198;
var state_25220__$1 = (function (){var statearr_25235 = state_25220;
(statearr_25235[(7)] = inst_25184__$1);

(statearr_25235[(10)] = inst_25197);

return statearr_25235;
})();
var statearr_25236_25266 = state_25220__$1;
(statearr_25236_25266[(2)] = null);

(statearr_25236_25266[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (5))){
var inst_25204 = (state_25220[(2)]);
var state_25220__$1 = (function (){var statearr_25237 = state_25220;
(statearr_25237[(11)] = inst_25204);

return statearr_25237;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25220__$1,(12),dchan);
} else {
if((state_val_25221 === (14))){
var inst_25206 = (state_25220[(8)]);
var inst_25211 = cljs.core.apply.call(null,f,inst_25206);
var state_25220__$1 = state_25220;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25220__$1,(16),out,inst_25211);
} else {
if((state_val_25221 === (16))){
var inst_25213 = (state_25220[(2)]);
var state_25220__$1 = (function (){var statearr_25238 = state_25220;
(statearr_25238[(12)] = inst_25213);

return statearr_25238;
})();
var statearr_25239_25267 = state_25220__$1;
(statearr_25239_25267[(2)] = null);

(statearr_25239_25267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (10))){
var inst_25188 = (state_25220[(2)]);
var inst_25189 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_25220__$1 = (function (){var statearr_25240 = state_25220;
(statearr_25240[(13)] = inst_25188);

return statearr_25240;
})();
var statearr_25241_25268 = state_25220__$1;
(statearr_25241_25268[(2)] = inst_25189);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25220__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25221 === (8))){
var inst_25202 = (state_25220[(2)]);
var state_25220__$1 = state_25220;
var statearr_25242_25269 = state_25220__$1;
(statearr_25242_25269[(2)] = inst_25202);

(statearr_25242_25269[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___25254,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__22336__auto__,c__23180__auto___25254,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25246 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25246[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25246[(1)] = (1));

return statearr_25246;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25220){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25220);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25247){if((e25247 instanceof Object)){
var ex__22340__auto__ = e25247;
var statearr_25248_25270 = state_25220;
(statearr_25248_25270[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25220);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25247;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25271 = state_25220;
state_25220 = G__25271;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25220){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___25254,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__23182__auto__ = (function (){var statearr_25249 = f__23181__auto__.call(null);
(statearr_25249[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___25254);

return statearr_25249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___25254,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args25273 = [];
var len__21393__auto___25331 = arguments.length;
var i__21394__auto___25332 = (0);
while(true){
if((i__21394__auto___25332 < len__21393__auto___25331)){
args25273.push((arguments[i__21394__auto___25332]));

var G__25333 = (i__21394__auto___25332 + (1));
i__21394__auto___25332 = G__25333;
continue;
} else {
}
break;
}

var G__25275 = args25273.length;
switch (G__25275) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25273.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23180__auto___25335 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___25335,out){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___25335,out){
return (function (state_25307){
var state_val_25308 = (state_25307[(1)]);
if((state_val_25308 === (7))){
var inst_25286 = (state_25307[(7)]);
var inst_25287 = (state_25307[(8)]);
var inst_25286__$1 = (state_25307[(2)]);
var inst_25287__$1 = cljs.core.nth.call(null,inst_25286__$1,(0),null);
var inst_25288 = cljs.core.nth.call(null,inst_25286__$1,(1),null);
var inst_25289 = (inst_25287__$1 == null);
var state_25307__$1 = (function (){var statearr_25309 = state_25307;
(statearr_25309[(7)] = inst_25286__$1);

(statearr_25309[(9)] = inst_25288);

(statearr_25309[(8)] = inst_25287__$1);

return statearr_25309;
})();
if(cljs.core.truth_(inst_25289)){
var statearr_25310_25336 = state_25307__$1;
(statearr_25310_25336[(1)] = (8));

} else {
var statearr_25311_25337 = state_25307__$1;
(statearr_25311_25337[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25308 === (1))){
var inst_25276 = cljs.core.vec.call(null,chs);
var inst_25277 = inst_25276;
var state_25307__$1 = (function (){var statearr_25312 = state_25307;
(statearr_25312[(10)] = inst_25277);

return statearr_25312;
})();
var statearr_25313_25338 = state_25307__$1;
(statearr_25313_25338[(2)] = null);

(statearr_25313_25338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25308 === (4))){
var inst_25277 = (state_25307[(10)]);
var state_25307__$1 = state_25307;
return cljs.core.async.ioc_alts_BANG_.call(null,state_25307__$1,(7),inst_25277);
} else {
if((state_val_25308 === (6))){
var inst_25303 = (state_25307[(2)]);
var state_25307__$1 = state_25307;
var statearr_25314_25339 = state_25307__$1;
(statearr_25314_25339[(2)] = inst_25303);

(statearr_25314_25339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25308 === (3))){
var inst_25305 = (state_25307[(2)]);
var state_25307__$1 = state_25307;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25307__$1,inst_25305);
} else {
if((state_val_25308 === (2))){
var inst_25277 = (state_25307[(10)]);
var inst_25279 = cljs.core.count.call(null,inst_25277);
var inst_25280 = (inst_25279 > (0));
var state_25307__$1 = state_25307;
if(cljs.core.truth_(inst_25280)){
var statearr_25316_25340 = state_25307__$1;
(statearr_25316_25340[(1)] = (4));

} else {
var statearr_25317_25341 = state_25307__$1;
(statearr_25317_25341[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25308 === (11))){
var inst_25277 = (state_25307[(10)]);
var inst_25296 = (state_25307[(2)]);
var tmp25315 = inst_25277;
var inst_25277__$1 = tmp25315;
var state_25307__$1 = (function (){var statearr_25318 = state_25307;
(statearr_25318[(11)] = inst_25296);

(statearr_25318[(10)] = inst_25277__$1);

return statearr_25318;
})();
var statearr_25319_25342 = state_25307__$1;
(statearr_25319_25342[(2)] = null);

(statearr_25319_25342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25308 === (9))){
var inst_25287 = (state_25307[(8)]);
var state_25307__$1 = state_25307;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25307__$1,(11),out,inst_25287);
} else {
if((state_val_25308 === (5))){
var inst_25301 = cljs.core.async.close_BANG_.call(null,out);
var state_25307__$1 = state_25307;
var statearr_25320_25343 = state_25307__$1;
(statearr_25320_25343[(2)] = inst_25301);

(statearr_25320_25343[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25308 === (10))){
var inst_25299 = (state_25307[(2)]);
var state_25307__$1 = state_25307;
var statearr_25321_25344 = state_25307__$1;
(statearr_25321_25344[(2)] = inst_25299);

(statearr_25321_25344[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25308 === (8))){
var inst_25286 = (state_25307[(7)]);
var inst_25288 = (state_25307[(9)]);
var inst_25277 = (state_25307[(10)]);
var inst_25287 = (state_25307[(8)]);
var inst_25291 = (function (){var cs = inst_25277;
var vec__25282 = inst_25286;
var v = inst_25287;
var c = inst_25288;
return ((function (cs,vec__25282,v,c,inst_25286,inst_25288,inst_25277,inst_25287,state_val_25308,c__23180__auto___25335,out){
return (function (p1__25272_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__25272_SHARP_);
});
;})(cs,vec__25282,v,c,inst_25286,inst_25288,inst_25277,inst_25287,state_val_25308,c__23180__auto___25335,out))
})();
var inst_25292 = cljs.core.filterv.call(null,inst_25291,inst_25277);
var inst_25277__$1 = inst_25292;
var state_25307__$1 = (function (){var statearr_25322 = state_25307;
(statearr_25322[(10)] = inst_25277__$1);

return statearr_25322;
})();
var statearr_25323_25345 = state_25307__$1;
(statearr_25323_25345[(2)] = null);

(statearr_25323_25345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___25335,out))
;
return ((function (switch__22336__auto__,c__23180__auto___25335,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25327 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25327[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25327[(1)] = (1));

return statearr_25327;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25307){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25307);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25328){if((e25328 instanceof Object)){
var ex__22340__auto__ = e25328;
var statearr_25329_25346 = state_25307;
(statearr_25329_25346[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25307);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25328;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25347 = state_25307;
state_25307 = G__25347;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25307){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___25335,out))
})();
var state__23182__auto__ = (function (){var statearr_25330 = f__23181__auto__.call(null);
(statearr_25330[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___25335);

return statearr_25330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___25335,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args25348 = [];
var len__21393__auto___25397 = arguments.length;
var i__21394__auto___25398 = (0);
while(true){
if((i__21394__auto___25398 < len__21393__auto___25397)){
args25348.push((arguments[i__21394__auto___25398]));

var G__25399 = (i__21394__auto___25398 + (1));
i__21394__auto___25398 = G__25399;
continue;
} else {
}
break;
}

var G__25350 = args25348.length;
switch (G__25350) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25348.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23180__auto___25401 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___25401,out){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___25401,out){
return (function (state_25374){
var state_val_25375 = (state_25374[(1)]);
if((state_val_25375 === (7))){
var inst_25356 = (state_25374[(7)]);
var inst_25356__$1 = (state_25374[(2)]);
var inst_25357 = (inst_25356__$1 == null);
var inst_25358 = cljs.core.not.call(null,inst_25357);
var state_25374__$1 = (function (){var statearr_25376 = state_25374;
(statearr_25376[(7)] = inst_25356__$1);

return statearr_25376;
})();
if(inst_25358){
var statearr_25377_25402 = state_25374__$1;
(statearr_25377_25402[(1)] = (8));

} else {
var statearr_25378_25403 = state_25374__$1;
(statearr_25378_25403[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25375 === (1))){
var inst_25351 = (0);
var state_25374__$1 = (function (){var statearr_25379 = state_25374;
(statearr_25379[(8)] = inst_25351);

return statearr_25379;
})();
var statearr_25380_25404 = state_25374__$1;
(statearr_25380_25404[(2)] = null);

(statearr_25380_25404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25375 === (4))){
var state_25374__$1 = state_25374;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25374__$1,(7),ch);
} else {
if((state_val_25375 === (6))){
var inst_25369 = (state_25374[(2)]);
var state_25374__$1 = state_25374;
var statearr_25381_25405 = state_25374__$1;
(statearr_25381_25405[(2)] = inst_25369);

(statearr_25381_25405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25375 === (3))){
var inst_25371 = (state_25374[(2)]);
var inst_25372 = cljs.core.async.close_BANG_.call(null,out);
var state_25374__$1 = (function (){var statearr_25382 = state_25374;
(statearr_25382[(9)] = inst_25371);

return statearr_25382;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25374__$1,inst_25372);
} else {
if((state_val_25375 === (2))){
var inst_25351 = (state_25374[(8)]);
var inst_25353 = (inst_25351 < n);
var state_25374__$1 = state_25374;
if(cljs.core.truth_(inst_25353)){
var statearr_25383_25406 = state_25374__$1;
(statearr_25383_25406[(1)] = (4));

} else {
var statearr_25384_25407 = state_25374__$1;
(statearr_25384_25407[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25375 === (11))){
var inst_25351 = (state_25374[(8)]);
var inst_25361 = (state_25374[(2)]);
var inst_25362 = (inst_25351 + (1));
var inst_25351__$1 = inst_25362;
var state_25374__$1 = (function (){var statearr_25385 = state_25374;
(statearr_25385[(10)] = inst_25361);

(statearr_25385[(8)] = inst_25351__$1);

return statearr_25385;
})();
var statearr_25386_25408 = state_25374__$1;
(statearr_25386_25408[(2)] = null);

(statearr_25386_25408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25375 === (9))){
var state_25374__$1 = state_25374;
var statearr_25387_25409 = state_25374__$1;
(statearr_25387_25409[(2)] = null);

(statearr_25387_25409[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25375 === (5))){
var state_25374__$1 = state_25374;
var statearr_25388_25410 = state_25374__$1;
(statearr_25388_25410[(2)] = null);

(statearr_25388_25410[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25375 === (10))){
var inst_25366 = (state_25374[(2)]);
var state_25374__$1 = state_25374;
var statearr_25389_25411 = state_25374__$1;
(statearr_25389_25411[(2)] = inst_25366);

(statearr_25389_25411[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25375 === (8))){
var inst_25356 = (state_25374[(7)]);
var state_25374__$1 = state_25374;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25374__$1,(11),out,inst_25356);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___25401,out))
;
return ((function (switch__22336__auto__,c__23180__auto___25401,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25393 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25393[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25393[(1)] = (1));

return statearr_25393;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25374){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25374);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25394){if((e25394 instanceof Object)){
var ex__22340__auto__ = e25394;
var statearr_25395_25412 = state_25374;
(statearr_25395_25412[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25374);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25394;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25413 = state_25374;
state_25374 = G__25413;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25374){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___25401,out))
})();
var state__23182__auto__ = (function (){var statearr_25396 = f__23181__auto__.call(null);
(statearr_25396[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___25401);

return statearr_25396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___25401,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async25421 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25421 = (function (f,ch,meta25422){
this.f = f;
this.ch = ch;
this.meta25422 = meta25422;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25421.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25423,meta25422__$1){
var self__ = this;
var _25423__$1 = this;
return (new cljs.core.async.t_cljs$core$async25421(self__.f,self__.ch,meta25422__$1));
});

cljs.core.async.t_cljs$core$async25421.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25423){
var self__ = this;
var _25423__$1 = this;
return self__.meta25422;
});

cljs.core.async.t_cljs$core$async25421.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25421.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25421.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25421.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25421.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async25424 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25424 = (function (f,ch,meta25422,_,fn1,meta25425){
this.f = f;
this.ch = ch;
this.meta25422 = meta25422;
this._ = _;
this.fn1 = fn1;
this.meta25425 = meta25425;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25424.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_25426,meta25425__$1){
var self__ = this;
var _25426__$1 = this;
return (new cljs.core.async.t_cljs$core$async25424(self__.f,self__.ch,self__.meta25422,self__._,self__.fn1,meta25425__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async25424.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_25426){
var self__ = this;
var _25426__$1 = this;
return self__.meta25425;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25424.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25424.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25424.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25424.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__25414_SHARP_){
return f1.call(null,(((p1__25414_SHARP_ == null))?null:self__.f.call(null,p1__25414_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async25424.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25422","meta25422",-1074457615,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async25421","cljs.core.async/t_cljs$core$async25421",1682308518,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta25425","meta25425",-1682292900,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25424.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25424.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25424";

cljs.core.async.t_cljs$core$async25424.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async25424");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async25424 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25424(f__$1,ch__$1,meta25422__$1,___$2,fn1__$1,meta25425){
return (new cljs.core.async.t_cljs$core$async25424(f__$1,ch__$1,meta25422__$1,___$2,fn1__$1,meta25425));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async25424(self__.f,self__.ch,self__.meta25422,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__20273__auto__ = ret;
if(cljs.core.truth_(and__20273__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__20273__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async25421.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25421.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async25421.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25422","meta25422",-1074457615,null)], null);
});

cljs.core.async.t_cljs$core$async25421.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25421.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25421";

cljs.core.async.t_cljs$core$async25421.cljs$lang$ctorPrWriter = (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async25421");
});

cljs.core.async.__GT_t_cljs$core$async25421 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25421(f__$1,ch__$1,meta25422){
return (new cljs.core.async.t_cljs$core$async25421(f__$1,ch__$1,meta25422));
});

}

return (new cljs.core.async.t_cljs$core$async25421(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async25430 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25430 = (function (f,ch,meta25431){
this.f = f;
this.ch = ch;
this.meta25431 = meta25431;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25430.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25432,meta25431__$1){
var self__ = this;
var _25432__$1 = this;
return (new cljs.core.async.t_cljs$core$async25430(self__.f,self__.ch,meta25431__$1));
});

cljs.core.async.t_cljs$core$async25430.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25432){
var self__ = this;
var _25432__$1 = this;
return self__.meta25431;
});

cljs.core.async.t_cljs$core$async25430.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25430.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25430.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25430.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25430.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25430.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async25430.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25431","meta25431",-1286929831,null)], null);
});

cljs.core.async.t_cljs$core$async25430.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25430.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25430";

cljs.core.async.t_cljs$core$async25430.cljs$lang$ctorPrWriter = (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async25430");
});

cljs.core.async.__GT_t_cljs$core$async25430 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async25430(f__$1,ch__$1,meta25431){
return (new cljs.core.async.t_cljs$core$async25430(f__$1,ch__$1,meta25431));
});

}

return (new cljs.core.async.t_cljs$core$async25430(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async25436 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25436 = (function (p,ch,meta25437){
this.p = p;
this.ch = ch;
this.meta25437 = meta25437;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25436.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25438,meta25437__$1){
var self__ = this;
var _25438__$1 = this;
return (new cljs.core.async.t_cljs$core$async25436(self__.p,self__.ch,meta25437__$1));
});

cljs.core.async.t_cljs$core$async25436.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25438){
var self__ = this;
var _25438__$1 = this;
return self__.meta25437;
});

cljs.core.async.t_cljs$core$async25436.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25436.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25436.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25436.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25436.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25436.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25436.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async25436.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25437","meta25437",-918709693,null)], null);
});

cljs.core.async.t_cljs$core$async25436.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25436.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25436";

cljs.core.async.t_cljs$core$async25436.cljs$lang$ctorPrWriter = (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async25436");
});

cljs.core.async.__GT_t_cljs$core$async25436 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async25436(p__$1,ch__$1,meta25437){
return (new cljs.core.async.t_cljs$core$async25436(p__$1,ch__$1,meta25437));
});

}

return (new cljs.core.async.t_cljs$core$async25436(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args25439 = [];
var len__21393__auto___25483 = arguments.length;
var i__21394__auto___25484 = (0);
while(true){
if((i__21394__auto___25484 < len__21393__auto___25483)){
args25439.push((arguments[i__21394__auto___25484]));

var G__25485 = (i__21394__auto___25484 + (1));
i__21394__auto___25484 = G__25485;
continue;
} else {
}
break;
}

var G__25441 = args25439.length;
switch (G__25441) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25439.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23180__auto___25487 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___25487,out){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___25487,out){
return (function (state_25462){
var state_val_25463 = (state_25462[(1)]);
if((state_val_25463 === (7))){
var inst_25458 = (state_25462[(2)]);
var state_25462__$1 = state_25462;
var statearr_25464_25488 = state_25462__$1;
(statearr_25464_25488[(2)] = inst_25458);

(statearr_25464_25488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25463 === (1))){
var state_25462__$1 = state_25462;
var statearr_25465_25489 = state_25462__$1;
(statearr_25465_25489[(2)] = null);

(statearr_25465_25489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25463 === (4))){
var inst_25444 = (state_25462[(7)]);
var inst_25444__$1 = (state_25462[(2)]);
var inst_25445 = (inst_25444__$1 == null);
var state_25462__$1 = (function (){var statearr_25466 = state_25462;
(statearr_25466[(7)] = inst_25444__$1);

return statearr_25466;
})();
if(cljs.core.truth_(inst_25445)){
var statearr_25467_25490 = state_25462__$1;
(statearr_25467_25490[(1)] = (5));

} else {
var statearr_25468_25491 = state_25462__$1;
(statearr_25468_25491[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25463 === (6))){
var inst_25444 = (state_25462[(7)]);
var inst_25449 = p.call(null,inst_25444);
var state_25462__$1 = state_25462;
if(cljs.core.truth_(inst_25449)){
var statearr_25469_25492 = state_25462__$1;
(statearr_25469_25492[(1)] = (8));

} else {
var statearr_25470_25493 = state_25462__$1;
(statearr_25470_25493[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25463 === (3))){
var inst_25460 = (state_25462[(2)]);
var state_25462__$1 = state_25462;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25462__$1,inst_25460);
} else {
if((state_val_25463 === (2))){
var state_25462__$1 = state_25462;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25462__$1,(4),ch);
} else {
if((state_val_25463 === (11))){
var inst_25452 = (state_25462[(2)]);
var state_25462__$1 = state_25462;
var statearr_25471_25494 = state_25462__$1;
(statearr_25471_25494[(2)] = inst_25452);

(statearr_25471_25494[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25463 === (9))){
var state_25462__$1 = state_25462;
var statearr_25472_25495 = state_25462__$1;
(statearr_25472_25495[(2)] = null);

(statearr_25472_25495[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25463 === (5))){
var inst_25447 = cljs.core.async.close_BANG_.call(null,out);
var state_25462__$1 = state_25462;
var statearr_25473_25496 = state_25462__$1;
(statearr_25473_25496[(2)] = inst_25447);

(statearr_25473_25496[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25463 === (10))){
var inst_25455 = (state_25462[(2)]);
var state_25462__$1 = (function (){var statearr_25474 = state_25462;
(statearr_25474[(8)] = inst_25455);

return statearr_25474;
})();
var statearr_25475_25497 = state_25462__$1;
(statearr_25475_25497[(2)] = null);

(statearr_25475_25497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25463 === (8))){
var inst_25444 = (state_25462[(7)]);
var state_25462__$1 = state_25462;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25462__$1,(11),out,inst_25444);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___25487,out))
;
return ((function (switch__22336__auto__,c__23180__auto___25487,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25479 = [null,null,null,null,null,null,null,null,null];
(statearr_25479[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25479[(1)] = (1));

return statearr_25479;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25462){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25462);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25480){if((e25480 instanceof Object)){
var ex__22340__auto__ = e25480;
var statearr_25481_25498 = state_25462;
(statearr_25481_25498[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25462);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25480;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25499 = state_25462;
state_25462 = G__25499;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25462){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___25487,out))
})();
var state__23182__auto__ = (function (){var statearr_25482 = f__23181__auto__.call(null);
(statearr_25482[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___25487);

return statearr_25482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___25487,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args25500 = [];
var len__21393__auto___25503 = arguments.length;
var i__21394__auto___25504 = (0);
while(true){
if((i__21394__auto___25504 < len__21393__auto___25503)){
args25500.push((arguments[i__21394__auto___25504]));

var G__25505 = (i__21394__auto___25504 + (1));
i__21394__auto___25504 = G__25505;
continue;
} else {
}
break;
}

var G__25502 = args25500.length;
switch (G__25502) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25500.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__23180__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto__){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto__){
return (function (state_25672){
var state_val_25673 = (state_25672[(1)]);
if((state_val_25673 === (7))){
var inst_25668 = (state_25672[(2)]);
var state_25672__$1 = state_25672;
var statearr_25674_25715 = state_25672__$1;
(statearr_25674_25715[(2)] = inst_25668);

(statearr_25674_25715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (20))){
var inst_25638 = (state_25672[(7)]);
var inst_25649 = (state_25672[(2)]);
var inst_25650 = cljs.core.next.call(null,inst_25638);
var inst_25624 = inst_25650;
var inst_25625 = null;
var inst_25626 = (0);
var inst_25627 = (0);
var state_25672__$1 = (function (){var statearr_25675 = state_25672;
(statearr_25675[(8)] = inst_25649);

(statearr_25675[(9)] = inst_25624);

(statearr_25675[(10)] = inst_25626);

(statearr_25675[(11)] = inst_25627);

(statearr_25675[(12)] = inst_25625);

return statearr_25675;
})();
var statearr_25676_25716 = state_25672__$1;
(statearr_25676_25716[(2)] = null);

(statearr_25676_25716[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (1))){
var state_25672__$1 = state_25672;
var statearr_25677_25717 = state_25672__$1;
(statearr_25677_25717[(2)] = null);

(statearr_25677_25717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (4))){
var inst_25613 = (state_25672[(13)]);
var inst_25613__$1 = (state_25672[(2)]);
var inst_25614 = (inst_25613__$1 == null);
var state_25672__$1 = (function (){var statearr_25678 = state_25672;
(statearr_25678[(13)] = inst_25613__$1);

return statearr_25678;
})();
if(cljs.core.truth_(inst_25614)){
var statearr_25679_25718 = state_25672__$1;
(statearr_25679_25718[(1)] = (5));

} else {
var statearr_25680_25719 = state_25672__$1;
(statearr_25680_25719[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (15))){
var state_25672__$1 = state_25672;
var statearr_25684_25720 = state_25672__$1;
(statearr_25684_25720[(2)] = null);

(statearr_25684_25720[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (21))){
var state_25672__$1 = state_25672;
var statearr_25685_25721 = state_25672__$1;
(statearr_25685_25721[(2)] = null);

(statearr_25685_25721[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (13))){
var inst_25624 = (state_25672[(9)]);
var inst_25626 = (state_25672[(10)]);
var inst_25627 = (state_25672[(11)]);
var inst_25625 = (state_25672[(12)]);
var inst_25634 = (state_25672[(2)]);
var inst_25635 = (inst_25627 + (1));
var tmp25681 = inst_25624;
var tmp25682 = inst_25626;
var tmp25683 = inst_25625;
var inst_25624__$1 = tmp25681;
var inst_25625__$1 = tmp25683;
var inst_25626__$1 = tmp25682;
var inst_25627__$1 = inst_25635;
var state_25672__$1 = (function (){var statearr_25686 = state_25672;
(statearr_25686[(14)] = inst_25634);

(statearr_25686[(9)] = inst_25624__$1);

(statearr_25686[(10)] = inst_25626__$1);

(statearr_25686[(11)] = inst_25627__$1);

(statearr_25686[(12)] = inst_25625__$1);

return statearr_25686;
})();
var statearr_25687_25722 = state_25672__$1;
(statearr_25687_25722[(2)] = null);

(statearr_25687_25722[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (22))){
var state_25672__$1 = state_25672;
var statearr_25688_25723 = state_25672__$1;
(statearr_25688_25723[(2)] = null);

(statearr_25688_25723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (6))){
var inst_25613 = (state_25672[(13)]);
var inst_25622 = f.call(null,inst_25613);
var inst_25623 = cljs.core.seq.call(null,inst_25622);
var inst_25624 = inst_25623;
var inst_25625 = null;
var inst_25626 = (0);
var inst_25627 = (0);
var state_25672__$1 = (function (){var statearr_25689 = state_25672;
(statearr_25689[(9)] = inst_25624);

(statearr_25689[(10)] = inst_25626);

(statearr_25689[(11)] = inst_25627);

(statearr_25689[(12)] = inst_25625);

return statearr_25689;
})();
var statearr_25690_25724 = state_25672__$1;
(statearr_25690_25724[(2)] = null);

(statearr_25690_25724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (17))){
var inst_25638 = (state_25672[(7)]);
var inst_25642 = cljs.core.chunk_first.call(null,inst_25638);
var inst_25643 = cljs.core.chunk_rest.call(null,inst_25638);
var inst_25644 = cljs.core.count.call(null,inst_25642);
var inst_25624 = inst_25643;
var inst_25625 = inst_25642;
var inst_25626 = inst_25644;
var inst_25627 = (0);
var state_25672__$1 = (function (){var statearr_25691 = state_25672;
(statearr_25691[(9)] = inst_25624);

(statearr_25691[(10)] = inst_25626);

(statearr_25691[(11)] = inst_25627);

(statearr_25691[(12)] = inst_25625);

return statearr_25691;
})();
var statearr_25692_25725 = state_25672__$1;
(statearr_25692_25725[(2)] = null);

(statearr_25692_25725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (3))){
var inst_25670 = (state_25672[(2)]);
var state_25672__$1 = state_25672;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25672__$1,inst_25670);
} else {
if((state_val_25673 === (12))){
var inst_25658 = (state_25672[(2)]);
var state_25672__$1 = state_25672;
var statearr_25693_25726 = state_25672__$1;
(statearr_25693_25726[(2)] = inst_25658);

(statearr_25693_25726[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (2))){
var state_25672__$1 = state_25672;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25672__$1,(4),in$);
} else {
if((state_val_25673 === (23))){
var inst_25666 = (state_25672[(2)]);
var state_25672__$1 = state_25672;
var statearr_25694_25727 = state_25672__$1;
(statearr_25694_25727[(2)] = inst_25666);

(statearr_25694_25727[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (19))){
var inst_25653 = (state_25672[(2)]);
var state_25672__$1 = state_25672;
var statearr_25695_25728 = state_25672__$1;
(statearr_25695_25728[(2)] = inst_25653);

(statearr_25695_25728[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (11))){
var inst_25624 = (state_25672[(9)]);
var inst_25638 = (state_25672[(7)]);
var inst_25638__$1 = cljs.core.seq.call(null,inst_25624);
var state_25672__$1 = (function (){var statearr_25696 = state_25672;
(statearr_25696[(7)] = inst_25638__$1);

return statearr_25696;
})();
if(inst_25638__$1){
var statearr_25697_25729 = state_25672__$1;
(statearr_25697_25729[(1)] = (14));

} else {
var statearr_25698_25730 = state_25672__$1;
(statearr_25698_25730[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (9))){
var inst_25660 = (state_25672[(2)]);
var inst_25661 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_25672__$1 = (function (){var statearr_25699 = state_25672;
(statearr_25699[(15)] = inst_25660);

return statearr_25699;
})();
if(cljs.core.truth_(inst_25661)){
var statearr_25700_25731 = state_25672__$1;
(statearr_25700_25731[(1)] = (21));

} else {
var statearr_25701_25732 = state_25672__$1;
(statearr_25701_25732[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (5))){
var inst_25616 = cljs.core.async.close_BANG_.call(null,out);
var state_25672__$1 = state_25672;
var statearr_25702_25733 = state_25672__$1;
(statearr_25702_25733[(2)] = inst_25616);

(statearr_25702_25733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (14))){
var inst_25638 = (state_25672[(7)]);
var inst_25640 = cljs.core.chunked_seq_QMARK_.call(null,inst_25638);
var state_25672__$1 = state_25672;
if(inst_25640){
var statearr_25703_25734 = state_25672__$1;
(statearr_25703_25734[(1)] = (17));

} else {
var statearr_25704_25735 = state_25672__$1;
(statearr_25704_25735[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (16))){
var inst_25656 = (state_25672[(2)]);
var state_25672__$1 = state_25672;
var statearr_25705_25736 = state_25672__$1;
(statearr_25705_25736[(2)] = inst_25656);

(statearr_25705_25736[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25673 === (10))){
var inst_25627 = (state_25672[(11)]);
var inst_25625 = (state_25672[(12)]);
var inst_25632 = cljs.core._nth.call(null,inst_25625,inst_25627);
var state_25672__$1 = state_25672;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25672__$1,(13),out,inst_25632);
} else {
if((state_val_25673 === (18))){
var inst_25638 = (state_25672[(7)]);
var inst_25647 = cljs.core.first.call(null,inst_25638);
var state_25672__$1 = state_25672;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25672__$1,(20),out,inst_25647);
} else {
if((state_val_25673 === (8))){
var inst_25626 = (state_25672[(10)]);
var inst_25627 = (state_25672[(11)]);
var inst_25629 = (inst_25627 < inst_25626);
var inst_25630 = inst_25629;
var state_25672__$1 = state_25672;
if(cljs.core.truth_(inst_25630)){
var statearr_25706_25737 = state_25672__$1;
(statearr_25706_25737[(1)] = (10));

} else {
var statearr_25707_25738 = state_25672__$1;
(statearr_25707_25738[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto__))
;
return ((function (switch__22336__auto__,c__23180__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_25711 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25711[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__);

(statearr_25711[(1)] = (1));

return statearr_25711;
});
var cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____1 = (function (state_25672){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25672);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25712){if((e25712 instanceof Object)){
var ex__22340__auto__ = e25712;
var statearr_25713_25739 = state_25672;
(statearr_25713_25739[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25672);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25712;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25740 = state_25672;
state_25672 = G__25740;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__ = function(state_25672){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____1.call(this,state_25672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto__))
})();
var state__23182__auto__ = (function (){var statearr_25714 = f__23181__auto__.call(null);
(statearr_25714[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto__);

return statearr_25714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto__))
);

return c__23180__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args25741 = [];
var len__21393__auto___25744 = arguments.length;
var i__21394__auto___25745 = (0);
while(true){
if((i__21394__auto___25745 < len__21393__auto___25744)){
args25741.push((arguments[i__21394__auto___25745]));

var G__25746 = (i__21394__auto___25745 + (1));
i__21394__auto___25745 = G__25746;
continue;
} else {
}
break;
}

var G__25743 = args25741.length;
switch (G__25743) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25741.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args25748 = [];
var len__21393__auto___25751 = arguments.length;
var i__21394__auto___25752 = (0);
while(true){
if((i__21394__auto___25752 < len__21393__auto___25751)){
args25748.push((arguments[i__21394__auto___25752]));

var G__25753 = (i__21394__auto___25752 + (1));
i__21394__auto___25752 = G__25753;
continue;
} else {
}
break;
}

var G__25750 = args25748.length;
switch (G__25750) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25748.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args25755 = [];
var len__21393__auto___25806 = arguments.length;
var i__21394__auto___25807 = (0);
while(true){
if((i__21394__auto___25807 < len__21393__auto___25806)){
args25755.push((arguments[i__21394__auto___25807]));

var G__25808 = (i__21394__auto___25807 + (1));
i__21394__auto___25807 = G__25808;
continue;
} else {
}
break;
}

var G__25757 = args25755.length;
switch (G__25757) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25755.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23180__auto___25810 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___25810,out){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___25810,out){
return (function (state_25781){
var state_val_25782 = (state_25781[(1)]);
if((state_val_25782 === (7))){
var inst_25776 = (state_25781[(2)]);
var state_25781__$1 = state_25781;
var statearr_25783_25811 = state_25781__$1;
(statearr_25783_25811[(2)] = inst_25776);

(statearr_25783_25811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25782 === (1))){
var inst_25758 = null;
var state_25781__$1 = (function (){var statearr_25784 = state_25781;
(statearr_25784[(7)] = inst_25758);

return statearr_25784;
})();
var statearr_25785_25812 = state_25781__$1;
(statearr_25785_25812[(2)] = null);

(statearr_25785_25812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25782 === (4))){
var inst_25761 = (state_25781[(8)]);
var inst_25761__$1 = (state_25781[(2)]);
var inst_25762 = (inst_25761__$1 == null);
var inst_25763 = cljs.core.not.call(null,inst_25762);
var state_25781__$1 = (function (){var statearr_25786 = state_25781;
(statearr_25786[(8)] = inst_25761__$1);

return statearr_25786;
})();
if(inst_25763){
var statearr_25787_25813 = state_25781__$1;
(statearr_25787_25813[(1)] = (5));

} else {
var statearr_25788_25814 = state_25781__$1;
(statearr_25788_25814[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25782 === (6))){
var state_25781__$1 = state_25781;
var statearr_25789_25815 = state_25781__$1;
(statearr_25789_25815[(2)] = null);

(statearr_25789_25815[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25782 === (3))){
var inst_25778 = (state_25781[(2)]);
var inst_25779 = cljs.core.async.close_BANG_.call(null,out);
var state_25781__$1 = (function (){var statearr_25790 = state_25781;
(statearr_25790[(9)] = inst_25778);

return statearr_25790;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25781__$1,inst_25779);
} else {
if((state_val_25782 === (2))){
var state_25781__$1 = state_25781;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25781__$1,(4),ch);
} else {
if((state_val_25782 === (11))){
var inst_25761 = (state_25781[(8)]);
var inst_25770 = (state_25781[(2)]);
var inst_25758 = inst_25761;
var state_25781__$1 = (function (){var statearr_25791 = state_25781;
(statearr_25791[(10)] = inst_25770);

(statearr_25791[(7)] = inst_25758);

return statearr_25791;
})();
var statearr_25792_25816 = state_25781__$1;
(statearr_25792_25816[(2)] = null);

(statearr_25792_25816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25782 === (9))){
var inst_25761 = (state_25781[(8)]);
var state_25781__$1 = state_25781;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25781__$1,(11),out,inst_25761);
} else {
if((state_val_25782 === (5))){
var inst_25761 = (state_25781[(8)]);
var inst_25758 = (state_25781[(7)]);
var inst_25765 = cljs.core._EQ_.call(null,inst_25761,inst_25758);
var state_25781__$1 = state_25781;
if(inst_25765){
var statearr_25794_25817 = state_25781__$1;
(statearr_25794_25817[(1)] = (8));

} else {
var statearr_25795_25818 = state_25781__$1;
(statearr_25795_25818[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25782 === (10))){
var inst_25773 = (state_25781[(2)]);
var state_25781__$1 = state_25781;
var statearr_25796_25819 = state_25781__$1;
(statearr_25796_25819[(2)] = inst_25773);

(statearr_25796_25819[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25782 === (8))){
var inst_25758 = (state_25781[(7)]);
var tmp25793 = inst_25758;
var inst_25758__$1 = tmp25793;
var state_25781__$1 = (function (){var statearr_25797 = state_25781;
(statearr_25797[(7)] = inst_25758__$1);

return statearr_25797;
})();
var statearr_25798_25820 = state_25781__$1;
(statearr_25798_25820[(2)] = null);

(statearr_25798_25820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___25810,out))
;
return ((function (switch__22336__auto__,c__23180__auto___25810,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25802 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25802[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25802[(1)] = (1));

return statearr_25802;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25781){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25781);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25803){if((e25803 instanceof Object)){
var ex__22340__auto__ = e25803;
var statearr_25804_25821 = state_25781;
(statearr_25804_25821[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25781);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25803;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25822 = state_25781;
state_25781 = G__25822;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25781){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___25810,out))
})();
var state__23182__auto__ = (function (){var statearr_25805 = f__23181__auto__.call(null);
(statearr_25805[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___25810);

return statearr_25805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___25810,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args25823 = [];
var len__21393__auto___25893 = arguments.length;
var i__21394__auto___25894 = (0);
while(true){
if((i__21394__auto___25894 < len__21393__auto___25893)){
args25823.push((arguments[i__21394__auto___25894]));

var G__25895 = (i__21394__auto___25894 + (1));
i__21394__auto___25894 = G__25895;
continue;
} else {
}
break;
}

var G__25825 = args25823.length;
switch (G__25825) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25823.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23180__auto___25897 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___25897,out){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___25897,out){
return (function (state_25863){
var state_val_25864 = (state_25863[(1)]);
if((state_val_25864 === (7))){
var inst_25859 = (state_25863[(2)]);
var state_25863__$1 = state_25863;
var statearr_25865_25898 = state_25863__$1;
(statearr_25865_25898[(2)] = inst_25859);

(statearr_25865_25898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25864 === (1))){
var inst_25826 = (new Array(n));
var inst_25827 = inst_25826;
var inst_25828 = (0);
var state_25863__$1 = (function (){var statearr_25866 = state_25863;
(statearr_25866[(7)] = inst_25827);

(statearr_25866[(8)] = inst_25828);

return statearr_25866;
})();
var statearr_25867_25899 = state_25863__$1;
(statearr_25867_25899[(2)] = null);

(statearr_25867_25899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25864 === (4))){
var inst_25831 = (state_25863[(9)]);
var inst_25831__$1 = (state_25863[(2)]);
var inst_25832 = (inst_25831__$1 == null);
var inst_25833 = cljs.core.not.call(null,inst_25832);
var state_25863__$1 = (function (){var statearr_25868 = state_25863;
(statearr_25868[(9)] = inst_25831__$1);

return statearr_25868;
})();
if(inst_25833){
var statearr_25869_25900 = state_25863__$1;
(statearr_25869_25900[(1)] = (5));

} else {
var statearr_25870_25901 = state_25863__$1;
(statearr_25870_25901[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25864 === (15))){
var inst_25853 = (state_25863[(2)]);
var state_25863__$1 = state_25863;
var statearr_25871_25902 = state_25863__$1;
(statearr_25871_25902[(2)] = inst_25853);

(statearr_25871_25902[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25864 === (13))){
var state_25863__$1 = state_25863;
var statearr_25872_25903 = state_25863__$1;
(statearr_25872_25903[(2)] = null);

(statearr_25872_25903[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25864 === (6))){
var inst_25828 = (state_25863[(8)]);
var inst_25849 = (inst_25828 > (0));
var state_25863__$1 = state_25863;
if(cljs.core.truth_(inst_25849)){
var statearr_25873_25904 = state_25863__$1;
(statearr_25873_25904[(1)] = (12));

} else {
var statearr_25874_25905 = state_25863__$1;
(statearr_25874_25905[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25864 === (3))){
var inst_25861 = (state_25863[(2)]);
var state_25863__$1 = state_25863;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25863__$1,inst_25861);
} else {
if((state_val_25864 === (12))){
var inst_25827 = (state_25863[(7)]);
var inst_25851 = cljs.core.vec.call(null,inst_25827);
var state_25863__$1 = state_25863;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25863__$1,(15),out,inst_25851);
} else {
if((state_val_25864 === (2))){
var state_25863__$1 = state_25863;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25863__$1,(4),ch);
} else {
if((state_val_25864 === (11))){
var inst_25843 = (state_25863[(2)]);
var inst_25844 = (new Array(n));
var inst_25827 = inst_25844;
var inst_25828 = (0);
var state_25863__$1 = (function (){var statearr_25875 = state_25863;
(statearr_25875[(10)] = inst_25843);

(statearr_25875[(7)] = inst_25827);

(statearr_25875[(8)] = inst_25828);

return statearr_25875;
})();
var statearr_25876_25906 = state_25863__$1;
(statearr_25876_25906[(2)] = null);

(statearr_25876_25906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25864 === (9))){
var inst_25827 = (state_25863[(7)]);
var inst_25841 = cljs.core.vec.call(null,inst_25827);
var state_25863__$1 = state_25863;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25863__$1,(11),out,inst_25841);
} else {
if((state_val_25864 === (5))){
var inst_25827 = (state_25863[(7)]);
var inst_25836 = (state_25863[(11)]);
var inst_25831 = (state_25863[(9)]);
var inst_25828 = (state_25863[(8)]);
var inst_25835 = (inst_25827[inst_25828] = inst_25831);
var inst_25836__$1 = (inst_25828 + (1));
var inst_25837 = (inst_25836__$1 < n);
var state_25863__$1 = (function (){var statearr_25877 = state_25863;
(statearr_25877[(11)] = inst_25836__$1);

(statearr_25877[(12)] = inst_25835);

return statearr_25877;
})();
if(cljs.core.truth_(inst_25837)){
var statearr_25878_25907 = state_25863__$1;
(statearr_25878_25907[(1)] = (8));

} else {
var statearr_25879_25908 = state_25863__$1;
(statearr_25879_25908[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25864 === (14))){
var inst_25856 = (state_25863[(2)]);
var inst_25857 = cljs.core.async.close_BANG_.call(null,out);
var state_25863__$1 = (function (){var statearr_25881 = state_25863;
(statearr_25881[(13)] = inst_25856);

return statearr_25881;
})();
var statearr_25882_25909 = state_25863__$1;
(statearr_25882_25909[(2)] = inst_25857);

(statearr_25882_25909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25864 === (10))){
var inst_25847 = (state_25863[(2)]);
var state_25863__$1 = state_25863;
var statearr_25883_25910 = state_25863__$1;
(statearr_25883_25910[(2)] = inst_25847);

(statearr_25883_25910[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25864 === (8))){
var inst_25827 = (state_25863[(7)]);
var inst_25836 = (state_25863[(11)]);
var tmp25880 = inst_25827;
var inst_25827__$1 = tmp25880;
var inst_25828 = inst_25836;
var state_25863__$1 = (function (){var statearr_25884 = state_25863;
(statearr_25884[(7)] = inst_25827__$1);

(statearr_25884[(8)] = inst_25828);

return statearr_25884;
})();
var statearr_25885_25911 = state_25863__$1;
(statearr_25885_25911[(2)] = null);

(statearr_25885_25911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___25897,out))
;
return ((function (switch__22336__auto__,c__23180__auto___25897,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25889 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25889[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25889[(1)] = (1));

return statearr_25889;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25863){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25890){if((e25890 instanceof Object)){
var ex__22340__auto__ = e25890;
var statearr_25891_25912 = state_25863;
(statearr_25891_25912[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25863);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25890;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25913 = state_25863;
state_25863 = G__25913;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25863){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___25897,out))
})();
var state__23182__auto__ = (function (){var statearr_25892 = f__23181__auto__.call(null);
(statearr_25892[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___25897);

return statearr_25892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___25897,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args25914 = [];
var len__21393__auto___25988 = arguments.length;
var i__21394__auto___25989 = (0);
while(true){
if((i__21394__auto___25989 < len__21393__auto___25988)){
args25914.push((arguments[i__21394__auto___25989]));

var G__25990 = (i__21394__auto___25989 + (1));
i__21394__auto___25989 = G__25990;
continue;
} else {
}
break;
}

var G__25916 = args25914.length;
switch (G__25916) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25914.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23180__auto___25992 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23180__auto___25992,out){
return (function (){
var f__23181__auto__ = (function (){var switch__22336__auto__ = ((function (c__23180__auto___25992,out){
return (function (state_25958){
var state_val_25959 = (state_25958[(1)]);
if((state_val_25959 === (7))){
var inst_25954 = (state_25958[(2)]);
var state_25958__$1 = state_25958;
var statearr_25960_25993 = state_25958__$1;
(statearr_25960_25993[(2)] = inst_25954);

(statearr_25960_25993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25959 === (1))){
var inst_25917 = [];
var inst_25918 = inst_25917;
var inst_25919 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_25958__$1 = (function (){var statearr_25961 = state_25958;
(statearr_25961[(7)] = inst_25919);

(statearr_25961[(8)] = inst_25918);

return statearr_25961;
})();
var statearr_25962_25994 = state_25958__$1;
(statearr_25962_25994[(2)] = null);

(statearr_25962_25994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25959 === (4))){
var inst_25922 = (state_25958[(9)]);
var inst_25922__$1 = (state_25958[(2)]);
var inst_25923 = (inst_25922__$1 == null);
var inst_25924 = cljs.core.not.call(null,inst_25923);
var state_25958__$1 = (function (){var statearr_25963 = state_25958;
(statearr_25963[(9)] = inst_25922__$1);

return statearr_25963;
})();
if(inst_25924){
var statearr_25964_25995 = state_25958__$1;
(statearr_25964_25995[(1)] = (5));

} else {
var statearr_25965_25996 = state_25958__$1;
(statearr_25965_25996[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25959 === (15))){
var inst_25948 = (state_25958[(2)]);
var state_25958__$1 = state_25958;
var statearr_25966_25997 = state_25958__$1;
(statearr_25966_25997[(2)] = inst_25948);

(statearr_25966_25997[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25959 === (13))){
var state_25958__$1 = state_25958;
var statearr_25967_25998 = state_25958__$1;
(statearr_25967_25998[(2)] = null);

(statearr_25967_25998[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25959 === (6))){
var inst_25918 = (state_25958[(8)]);
var inst_25943 = inst_25918.length;
var inst_25944 = (inst_25943 > (0));
var state_25958__$1 = state_25958;
if(cljs.core.truth_(inst_25944)){
var statearr_25968_25999 = state_25958__$1;
(statearr_25968_25999[(1)] = (12));

} else {
var statearr_25969_26000 = state_25958__$1;
(statearr_25969_26000[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25959 === (3))){
var inst_25956 = (state_25958[(2)]);
var state_25958__$1 = state_25958;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25958__$1,inst_25956);
} else {
if((state_val_25959 === (12))){
var inst_25918 = (state_25958[(8)]);
var inst_25946 = cljs.core.vec.call(null,inst_25918);
var state_25958__$1 = state_25958;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25958__$1,(15),out,inst_25946);
} else {
if((state_val_25959 === (2))){
var state_25958__$1 = state_25958;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25958__$1,(4),ch);
} else {
if((state_val_25959 === (11))){
var inst_25926 = (state_25958[(10)]);
var inst_25922 = (state_25958[(9)]);
var inst_25936 = (state_25958[(2)]);
var inst_25937 = [];
var inst_25938 = inst_25937.push(inst_25922);
var inst_25918 = inst_25937;
var inst_25919 = inst_25926;
var state_25958__$1 = (function (){var statearr_25970 = state_25958;
(statearr_25970[(11)] = inst_25938);

(statearr_25970[(12)] = inst_25936);

(statearr_25970[(7)] = inst_25919);

(statearr_25970[(8)] = inst_25918);

return statearr_25970;
})();
var statearr_25971_26001 = state_25958__$1;
(statearr_25971_26001[(2)] = null);

(statearr_25971_26001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25959 === (9))){
var inst_25918 = (state_25958[(8)]);
var inst_25934 = cljs.core.vec.call(null,inst_25918);
var state_25958__$1 = state_25958;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25958__$1,(11),out,inst_25934);
} else {
if((state_val_25959 === (5))){
var inst_25926 = (state_25958[(10)]);
var inst_25922 = (state_25958[(9)]);
var inst_25919 = (state_25958[(7)]);
var inst_25926__$1 = f.call(null,inst_25922);
var inst_25927 = cljs.core._EQ_.call(null,inst_25926__$1,inst_25919);
var inst_25928 = cljs.core.keyword_identical_QMARK_.call(null,inst_25919,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_25929 = (inst_25927) || (inst_25928);
var state_25958__$1 = (function (){var statearr_25972 = state_25958;
(statearr_25972[(10)] = inst_25926__$1);

return statearr_25972;
})();
if(cljs.core.truth_(inst_25929)){
var statearr_25973_26002 = state_25958__$1;
(statearr_25973_26002[(1)] = (8));

} else {
var statearr_25974_26003 = state_25958__$1;
(statearr_25974_26003[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25959 === (14))){
var inst_25951 = (state_25958[(2)]);
var inst_25952 = cljs.core.async.close_BANG_.call(null,out);
var state_25958__$1 = (function (){var statearr_25976 = state_25958;
(statearr_25976[(13)] = inst_25951);

return statearr_25976;
})();
var statearr_25977_26004 = state_25958__$1;
(statearr_25977_26004[(2)] = inst_25952);

(statearr_25977_26004[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25959 === (10))){
var inst_25941 = (state_25958[(2)]);
var state_25958__$1 = state_25958;
var statearr_25978_26005 = state_25958__$1;
(statearr_25978_26005[(2)] = inst_25941);

(statearr_25978_26005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25959 === (8))){
var inst_25926 = (state_25958[(10)]);
var inst_25922 = (state_25958[(9)]);
var inst_25918 = (state_25958[(8)]);
var inst_25931 = inst_25918.push(inst_25922);
var tmp25975 = inst_25918;
var inst_25918__$1 = tmp25975;
var inst_25919 = inst_25926;
var state_25958__$1 = (function (){var statearr_25979 = state_25958;
(statearr_25979[(7)] = inst_25919);

(statearr_25979[(8)] = inst_25918__$1);

(statearr_25979[(14)] = inst_25931);

return statearr_25979;
})();
var statearr_25980_26006 = state_25958__$1;
(statearr_25980_26006[(2)] = null);

(statearr_25980_26006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23180__auto___25992,out))
;
return ((function (switch__22336__auto__,c__23180__auto___25992,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25984 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25984[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25984[(1)] = (1));

return statearr_25984;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25958){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25958);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25985){if((e25985 instanceof Object)){
var ex__22340__auto__ = e25985;
var statearr_25986_26007 = state_25958;
(statearr_25986_26007[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25958);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25985;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26008 = state_25958;
state_25958 = G__26008;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25958){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23180__auto___25992,out))
})();
var state__23182__auto__ = (function (){var statearr_25987 = f__23181__auto__.call(null);
(statearr_25987[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23180__auto___25992);

return statearr_25987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23182__auto__);
});})(c__23180__auto___25992,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1481827030152