// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__20285__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__20285__auto__){
return or__20285__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__20285__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__26070_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__26070_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__26075 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__26076 = null;
var count__26077 = (0);
var i__26078 = (0);
while(true){
if((i__26078 < count__26077)){
var n = cljs.core._nth.call(null,chunk__26076,i__26078);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__26079 = seq__26075;
var G__26080 = chunk__26076;
var G__26081 = count__26077;
var G__26082 = (i__26078 + (1));
seq__26075 = G__26079;
chunk__26076 = G__26080;
count__26077 = G__26081;
i__26078 = G__26082;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__26075);
if(temp__4657__auto__){
var seq__26075__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26075__$1)){
var c__21099__auto__ = cljs.core.chunk_first.call(null,seq__26075__$1);
var G__26083 = cljs.core.chunk_rest.call(null,seq__26075__$1);
var G__26084 = c__21099__auto__;
var G__26085 = cljs.core.count.call(null,c__21099__auto__);
var G__26086 = (0);
seq__26075 = G__26083;
chunk__26076 = G__26084;
count__26077 = G__26085;
i__26078 = G__26086;
continue;
} else {
var n = cljs.core.first.call(null,seq__26075__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__26087 = cljs.core.next.call(null,seq__26075__$1);
var G__26088 = null;
var G__26089 = (0);
var G__26090 = (0);
seq__26075 = G__26087;
chunk__26076 = G__26088;
count__26077 = G__26089;
i__26078 = G__26090;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__26141_26152 = cljs.core.seq.call(null,deps);
var chunk__26142_26153 = null;
var count__26143_26154 = (0);
var i__26144_26155 = (0);
while(true){
if((i__26144_26155 < count__26143_26154)){
var dep_26156 = cljs.core._nth.call(null,chunk__26142_26153,i__26144_26155);
topo_sort_helper_STAR_.call(null,dep_26156,(depth + (1)),state);

var G__26157 = seq__26141_26152;
var G__26158 = chunk__26142_26153;
var G__26159 = count__26143_26154;
var G__26160 = (i__26144_26155 + (1));
seq__26141_26152 = G__26157;
chunk__26142_26153 = G__26158;
count__26143_26154 = G__26159;
i__26144_26155 = G__26160;
continue;
} else {
var temp__4657__auto___26161 = cljs.core.seq.call(null,seq__26141_26152);
if(temp__4657__auto___26161){
var seq__26141_26162__$1 = temp__4657__auto___26161;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26141_26162__$1)){
var c__21099__auto___26163 = cljs.core.chunk_first.call(null,seq__26141_26162__$1);
var G__26164 = cljs.core.chunk_rest.call(null,seq__26141_26162__$1);
var G__26165 = c__21099__auto___26163;
var G__26166 = cljs.core.count.call(null,c__21099__auto___26163);
var G__26167 = (0);
seq__26141_26152 = G__26164;
chunk__26142_26153 = G__26165;
count__26143_26154 = G__26166;
i__26144_26155 = G__26167;
continue;
} else {
var dep_26168 = cljs.core.first.call(null,seq__26141_26162__$1);
topo_sort_helper_STAR_.call(null,dep_26168,(depth + (1)),state);

var G__26169 = cljs.core.next.call(null,seq__26141_26162__$1);
var G__26170 = null;
var G__26171 = (0);
var G__26172 = (0);
seq__26141_26152 = G__26169;
chunk__26142_26153 = G__26170;
count__26143_26154 = G__26171;
i__26144_26155 = G__26172;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__26145){
var vec__26149 = p__26145;
var seq__26150 = cljs.core.seq.call(null,vec__26149);
var first__26151 = cljs.core.first.call(null,seq__26150);
var seq__26150__$1 = cljs.core.next.call(null,seq__26150);
var x = first__26151;
var xs = seq__26150__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__26149,seq__26150,first__26151,seq__26150__$1,x,xs,get_deps__$1){
return (function (p1__26091_SHARP_){
return clojure.set.difference.call(null,p1__26091_SHARP_,x);
});})(vec__26149,seq__26150,first__26151,seq__26150__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__26185 = cljs.core.seq.call(null,provides);
var chunk__26186 = null;
var count__26187 = (0);
var i__26188 = (0);
while(true){
if((i__26188 < count__26187)){
var prov = cljs.core._nth.call(null,chunk__26186,i__26188);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__26189_26197 = cljs.core.seq.call(null,requires);
var chunk__26190_26198 = null;
var count__26191_26199 = (0);
var i__26192_26200 = (0);
while(true){
if((i__26192_26200 < count__26191_26199)){
var req_26201 = cljs.core._nth.call(null,chunk__26190_26198,i__26192_26200);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26201,prov);

var G__26202 = seq__26189_26197;
var G__26203 = chunk__26190_26198;
var G__26204 = count__26191_26199;
var G__26205 = (i__26192_26200 + (1));
seq__26189_26197 = G__26202;
chunk__26190_26198 = G__26203;
count__26191_26199 = G__26204;
i__26192_26200 = G__26205;
continue;
} else {
var temp__4657__auto___26206 = cljs.core.seq.call(null,seq__26189_26197);
if(temp__4657__auto___26206){
var seq__26189_26207__$1 = temp__4657__auto___26206;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26189_26207__$1)){
var c__21099__auto___26208 = cljs.core.chunk_first.call(null,seq__26189_26207__$1);
var G__26209 = cljs.core.chunk_rest.call(null,seq__26189_26207__$1);
var G__26210 = c__21099__auto___26208;
var G__26211 = cljs.core.count.call(null,c__21099__auto___26208);
var G__26212 = (0);
seq__26189_26197 = G__26209;
chunk__26190_26198 = G__26210;
count__26191_26199 = G__26211;
i__26192_26200 = G__26212;
continue;
} else {
var req_26213 = cljs.core.first.call(null,seq__26189_26207__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26213,prov);

var G__26214 = cljs.core.next.call(null,seq__26189_26207__$1);
var G__26215 = null;
var G__26216 = (0);
var G__26217 = (0);
seq__26189_26197 = G__26214;
chunk__26190_26198 = G__26215;
count__26191_26199 = G__26216;
i__26192_26200 = G__26217;
continue;
}
} else {
}
}
break;
}

var G__26218 = seq__26185;
var G__26219 = chunk__26186;
var G__26220 = count__26187;
var G__26221 = (i__26188 + (1));
seq__26185 = G__26218;
chunk__26186 = G__26219;
count__26187 = G__26220;
i__26188 = G__26221;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__26185);
if(temp__4657__auto__){
var seq__26185__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26185__$1)){
var c__21099__auto__ = cljs.core.chunk_first.call(null,seq__26185__$1);
var G__26222 = cljs.core.chunk_rest.call(null,seq__26185__$1);
var G__26223 = c__21099__auto__;
var G__26224 = cljs.core.count.call(null,c__21099__auto__);
var G__26225 = (0);
seq__26185 = G__26222;
chunk__26186 = G__26223;
count__26187 = G__26224;
i__26188 = G__26225;
continue;
} else {
var prov = cljs.core.first.call(null,seq__26185__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__26193_26226 = cljs.core.seq.call(null,requires);
var chunk__26194_26227 = null;
var count__26195_26228 = (0);
var i__26196_26229 = (0);
while(true){
if((i__26196_26229 < count__26195_26228)){
var req_26230 = cljs.core._nth.call(null,chunk__26194_26227,i__26196_26229);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26230,prov);

var G__26231 = seq__26193_26226;
var G__26232 = chunk__26194_26227;
var G__26233 = count__26195_26228;
var G__26234 = (i__26196_26229 + (1));
seq__26193_26226 = G__26231;
chunk__26194_26227 = G__26232;
count__26195_26228 = G__26233;
i__26196_26229 = G__26234;
continue;
} else {
var temp__4657__auto___26235__$1 = cljs.core.seq.call(null,seq__26193_26226);
if(temp__4657__auto___26235__$1){
var seq__26193_26236__$1 = temp__4657__auto___26235__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26193_26236__$1)){
var c__21099__auto___26237 = cljs.core.chunk_first.call(null,seq__26193_26236__$1);
var G__26238 = cljs.core.chunk_rest.call(null,seq__26193_26236__$1);
var G__26239 = c__21099__auto___26237;
var G__26240 = cljs.core.count.call(null,c__21099__auto___26237);
var G__26241 = (0);
seq__26193_26226 = G__26238;
chunk__26194_26227 = G__26239;
count__26195_26228 = G__26240;
i__26196_26229 = G__26241;
continue;
} else {
var req_26242 = cljs.core.first.call(null,seq__26193_26236__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_26242,prov);

var G__26243 = cljs.core.next.call(null,seq__26193_26236__$1);
var G__26244 = null;
var G__26245 = (0);
var G__26246 = (0);
seq__26193_26226 = G__26243;
chunk__26194_26227 = G__26244;
count__26195_26228 = G__26245;
i__26196_26229 = G__26246;
continue;
}
} else {
}
}
break;
}

var G__26247 = cljs.core.next.call(null,seq__26185__$1);
var G__26248 = null;
var G__26249 = (0);
var G__26250 = (0);
seq__26185 = G__26247;
chunk__26186 = G__26248;
count__26187 = G__26249;
i__26188 = G__26250;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__26255_26259 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__26256_26260 = null;
var count__26257_26261 = (0);
var i__26258_26262 = (0);
while(true){
if((i__26258_26262 < count__26257_26261)){
var ns_26263 = cljs.core._nth.call(null,chunk__26256_26260,i__26258_26262);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_26263);

var G__26264 = seq__26255_26259;
var G__26265 = chunk__26256_26260;
var G__26266 = count__26257_26261;
var G__26267 = (i__26258_26262 + (1));
seq__26255_26259 = G__26264;
chunk__26256_26260 = G__26265;
count__26257_26261 = G__26266;
i__26258_26262 = G__26267;
continue;
} else {
var temp__4657__auto___26268 = cljs.core.seq.call(null,seq__26255_26259);
if(temp__4657__auto___26268){
var seq__26255_26269__$1 = temp__4657__auto___26268;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26255_26269__$1)){
var c__21099__auto___26270 = cljs.core.chunk_first.call(null,seq__26255_26269__$1);
var G__26271 = cljs.core.chunk_rest.call(null,seq__26255_26269__$1);
var G__26272 = c__21099__auto___26270;
var G__26273 = cljs.core.count.call(null,c__21099__auto___26270);
var G__26274 = (0);
seq__26255_26259 = G__26271;
chunk__26256_26260 = G__26272;
count__26257_26261 = G__26273;
i__26258_26262 = G__26274;
continue;
} else {
var ns_26275 = cljs.core.first.call(null,seq__26255_26269__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_26275);

var G__26276 = cljs.core.next.call(null,seq__26255_26269__$1);
var G__26277 = null;
var G__26278 = (0);
var G__26279 = (0);
seq__26255_26259 = G__26276;
chunk__26256_26260 = G__26277;
count__26257_26261 = G__26278;
i__26258_26262 = G__26279;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__20285__auto__ = goog.require__;
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__26280__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__26280 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__26281__i = 0, G__26281__a = new Array(arguments.length -  0);
while (G__26281__i < G__26281__a.length) {G__26281__a[G__26281__i] = arguments[G__26281__i + 0]; ++G__26281__i;}
  args = new cljs.core.IndexedSeq(G__26281__a,0);
} 
return G__26280__delegate.call(this,args);};
G__26280.cljs$lang$maxFixedArity = 0;
G__26280.cljs$lang$applyTo = (function (arglist__26282){
var args = cljs.core.seq(arglist__26282);
return G__26280__delegate(args);
});
G__26280.cljs$core$IFn$_invoke$arity$variadic = G__26280__delegate;
return G__26280;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__26284 = cljs.core._EQ_;
var expr__26285 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__26284.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__26285))){
var path_parts = ((function (pred__26284,expr__26285){
return (function (p1__26283_SHARP_){
return clojure.string.split.call(null,p1__26283_SHARP_,/[\/\\]/);
});})(pred__26284,expr__26285))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__26284,expr__26285){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e26287){if((e26287 instanceof Error)){
var e = e26287;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e26287;

}
}})());
});
;})(path_parts,sep,root,pred__26284,expr__26285))
} else {
if(cljs.core.truth_(pred__26284.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__26285))){
return ((function (pred__26284,expr__26285){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__26284,expr__26285){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__26284,expr__26285))
);

return deferred.addErrback(((function (deferred,pred__26284,expr__26285){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__26284,expr__26285))
);
});
;})(pred__26284,expr__26285))
} else {
return ((function (pred__26284,expr__26285){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__26284,expr__26285))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__26288,callback){
var map__26291 = p__26288;
var map__26291__$1 = ((((!((map__26291 == null)))?((((map__26291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26291.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26291):map__26291);
var file_msg = map__26291__$1;
var request_url = cljs.core.get.call(null,map__26291__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__26291,map__26291__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__26291,map__26291__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__23179__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto__){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto__){
return (function (state_26315){
var state_val_26316 = (state_26315[(1)]);
if((state_val_26316 === (7))){
var inst_26311 = (state_26315[(2)]);
var state_26315__$1 = state_26315;
var statearr_26317_26337 = state_26315__$1;
(statearr_26317_26337[(2)] = inst_26311);

(statearr_26317_26337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26316 === (1))){
var state_26315__$1 = state_26315;
var statearr_26318_26338 = state_26315__$1;
(statearr_26318_26338[(2)] = null);

(statearr_26318_26338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26316 === (4))){
var inst_26295 = (state_26315[(7)]);
var inst_26295__$1 = (state_26315[(2)]);
var state_26315__$1 = (function (){var statearr_26319 = state_26315;
(statearr_26319[(7)] = inst_26295__$1);

return statearr_26319;
})();
if(cljs.core.truth_(inst_26295__$1)){
var statearr_26320_26339 = state_26315__$1;
(statearr_26320_26339[(1)] = (5));

} else {
var statearr_26321_26340 = state_26315__$1;
(statearr_26321_26340[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26316 === (6))){
var state_26315__$1 = state_26315;
var statearr_26322_26341 = state_26315__$1;
(statearr_26322_26341[(2)] = null);

(statearr_26322_26341[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26316 === (3))){
var inst_26313 = (state_26315[(2)]);
var state_26315__$1 = state_26315;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26315__$1,inst_26313);
} else {
if((state_val_26316 === (2))){
var state_26315__$1 = state_26315;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26315__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_26316 === (11))){
var inst_26307 = (state_26315[(2)]);
var state_26315__$1 = (function (){var statearr_26323 = state_26315;
(statearr_26323[(8)] = inst_26307);

return statearr_26323;
})();
var statearr_26324_26342 = state_26315__$1;
(statearr_26324_26342[(2)] = null);

(statearr_26324_26342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26316 === (9))){
var inst_26301 = (state_26315[(9)]);
var inst_26299 = (state_26315[(10)]);
var inst_26303 = inst_26301.call(null,inst_26299);
var state_26315__$1 = state_26315;
var statearr_26325_26343 = state_26315__$1;
(statearr_26325_26343[(2)] = inst_26303);

(statearr_26325_26343[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26316 === (5))){
var inst_26295 = (state_26315[(7)]);
var inst_26297 = figwheel.client.file_reloading.blocking_load.call(null,inst_26295);
var state_26315__$1 = state_26315;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26315__$1,(8),inst_26297);
} else {
if((state_val_26316 === (10))){
var inst_26299 = (state_26315[(10)]);
var inst_26305 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_26299);
var state_26315__$1 = state_26315;
var statearr_26326_26344 = state_26315__$1;
(statearr_26326_26344[(2)] = inst_26305);

(statearr_26326_26344[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26316 === (8))){
var inst_26301 = (state_26315[(9)]);
var inst_26295 = (state_26315[(7)]);
var inst_26299 = (state_26315[(2)]);
var inst_26300 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_26301__$1 = cljs.core.get.call(null,inst_26300,inst_26295);
var state_26315__$1 = (function (){var statearr_26327 = state_26315;
(statearr_26327[(9)] = inst_26301__$1);

(statearr_26327[(10)] = inst_26299);

return statearr_26327;
})();
if(cljs.core.truth_(inst_26301__$1)){
var statearr_26328_26345 = state_26315__$1;
(statearr_26328_26345[(1)] = (9));

} else {
var statearr_26329_26346 = state_26315__$1;
(statearr_26329_26346[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto__))
;
return ((function (switch__22336__auto__,c__23179__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__22337__auto__ = null;
var figwheel$client$file_reloading$state_machine__22337__auto____0 = (function (){
var statearr_26333 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26333[(0)] = figwheel$client$file_reloading$state_machine__22337__auto__);

(statearr_26333[(1)] = (1));

return statearr_26333;
});
var figwheel$client$file_reloading$state_machine__22337__auto____1 = (function (state_26315){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_26315);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e26334){if((e26334 instanceof Object)){
var ex__22340__auto__ = e26334;
var statearr_26335_26347 = state_26315;
(statearr_26335_26347[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26315);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26334;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26348 = state_26315;
state_26315 = G__26348;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__22337__auto__ = function(state_26315){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__22337__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__22337__auto____1.call(this,state_26315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__22337__auto____0;
figwheel$client$file_reloading$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__22337__auto____1;
return figwheel$client$file_reloading$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto__))
})();
var state__23181__auto__ = (function (){var statearr_26336 = f__23180__auto__.call(null);
(statearr_26336[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto__);

return statearr_26336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto__))
);

return c__23179__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__26349,callback){
var map__26352 = p__26349;
var map__26352__$1 = ((((!((map__26352 == null)))?((((map__26352.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26352.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26352):map__26352);
var file_msg = map__26352__$1;
var namespace = cljs.core.get.call(null,map__26352__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__26352,map__26352__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__26352,map__26352__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__26354){
var map__26357 = p__26354;
var map__26357__$1 = ((((!((map__26357 == null)))?((((map__26357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26357.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26357):map__26357);
var file_msg = map__26357__$1;
var namespace = cljs.core.get.call(null,map__26357__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__20273__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__20273__auto__){
var or__20285__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
var or__20285__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__20285__auto____$1)){
return or__20285__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__20273__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__26359,callback){
var map__26362 = p__26359;
var map__26362__$1 = ((((!((map__26362 == null)))?((((map__26362.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26362.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26362):map__26362);
var file_msg = map__26362__$1;
var request_url = cljs.core.get.call(null,map__26362__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__26362__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__23179__auto___26466 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___26466,out){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___26466,out){
return (function (state_26448){
var state_val_26449 = (state_26448[(1)]);
if((state_val_26449 === (1))){
var inst_26422 = cljs.core.seq.call(null,files);
var inst_26423 = cljs.core.first.call(null,inst_26422);
var inst_26424 = cljs.core.next.call(null,inst_26422);
var inst_26425 = files;
var state_26448__$1 = (function (){var statearr_26450 = state_26448;
(statearr_26450[(7)] = inst_26423);

(statearr_26450[(8)] = inst_26424);

(statearr_26450[(9)] = inst_26425);

return statearr_26450;
})();
var statearr_26451_26467 = state_26448__$1;
(statearr_26451_26467[(2)] = null);

(statearr_26451_26467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26449 === (2))){
var inst_26425 = (state_26448[(9)]);
var inst_26431 = (state_26448[(10)]);
var inst_26430 = cljs.core.seq.call(null,inst_26425);
var inst_26431__$1 = cljs.core.first.call(null,inst_26430);
var inst_26432 = cljs.core.next.call(null,inst_26430);
var inst_26433 = (inst_26431__$1 == null);
var inst_26434 = cljs.core.not.call(null,inst_26433);
var state_26448__$1 = (function (){var statearr_26452 = state_26448;
(statearr_26452[(11)] = inst_26432);

(statearr_26452[(10)] = inst_26431__$1);

return statearr_26452;
})();
if(inst_26434){
var statearr_26453_26468 = state_26448__$1;
(statearr_26453_26468[(1)] = (4));

} else {
var statearr_26454_26469 = state_26448__$1;
(statearr_26454_26469[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26449 === (3))){
var inst_26446 = (state_26448[(2)]);
var state_26448__$1 = state_26448;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26448__$1,inst_26446);
} else {
if((state_val_26449 === (4))){
var inst_26431 = (state_26448[(10)]);
var inst_26436 = figwheel.client.file_reloading.reload_js_file.call(null,inst_26431);
var state_26448__$1 = state_26448;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26448__$1,(7),inst_26436);
} else {
if((state_val_26449 === (5))){
var inst_26442 = cljs.core.async.close_BANG_.call(null,out);
var state_26448__$1 = state_26448;
var statearr_26455_26470 = state_26448__$1;
(statearr_26455_26470[(2)] = inst_26442);

(statearr_26455_26470[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26449 === (6))){
var inst_26444 = (state_26448[(2)]);
var state_26448__$1 = state_26448;
var statearr_26456_26471 = state_26448__$1;
(statearr_26456_26471[(2)] = inst_26444);

(statearr_26456_26471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26449 === (7))){
var inst_26432 = (state_26448[(11)]);
var inst_26438 = (state_26448[(2)]);
var inst_26439 = cljs.core.async.put_BANG_.call(null,out,inst_26438);
var inst_26425 = inst_26432;
var state_26448__$1 = (function (){var statearr_26457 = state_26448;
(statearr_26457[(9)] = inst_26425);

(statearr_26457[(12)] = inst_26439);

return statearr_26457;
})();
var statearr_26458_26472 = state_26448__$1;
(statearr_26458_26472[(2)] = null);

(statearr_26458_26472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__23179__auto___26466,out))
;
return ((function (switch__22336__auto__,c__23179__auto___26466,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____0 = (function (){
var statearr_26462 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26462[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__);

(statearr_26462[(1)] = (1));

return statearr_26462;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____1 = (function (state_26448){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_26448);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e26463){if((e26463 instanceof Object)){
var ex__22340__auto__ = e26463;
var statearr_26464_26473 = state_26448;
(statearr_26464_26473[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26448);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26463;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26474 = state_26448;
state_26448 = G__26474;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__ = function(state_26448){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____1.call(this,state_26448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___26466,out))
})();
var state__23181__auto__ = (function (){var statearr_26465 = f__23180__auto__.call(null);
(statearr_26465[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___26466);

return statearr_26465;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___26466,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__26475,opts){
var map__26479 = p__26475;
var map__26479__$1 = ((((!((map__26479 == null)))?((((map__26479.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26479.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26479):map__26479);
var eval_body = cljs.core.get.call(null,map__26479__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__26479__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__20273__auto__ = eval_body;
if(cljs.core.truth_(and__20273__auto__)){
return typeof eval_body === 'string';
} else {
return and__20273__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e26481){var e = e26481;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__26482_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__26482_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__26491){
var vec__26492 = p__26491;
var k = cljs.core.nth.call(null,vec__26492,(0),null);
var v = cljs.core.nth.call(null,vec__26492,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__26495){
var vec__26496 = p__26495;
var k = cljs.core.nth.call(null,vec__26496,(0),null);
var v = cljs.core.nth.call(null,vec__26496,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__26502,p__26503){
var map__26751 = p__26502;
var map__26751__$1 = ((((!((map__26751 == null)))?((((map__26751.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26751.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26751):map__26751);
var opts = map__26751__$1;
var before_jsload = cljs.core.get.call(null,map__26751__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__26751__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__26751__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__26752 = p__26503;
var map__26752__$1 = ((((!((map__26752 == null)))?((((map__26752.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26752.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26752):map__26752);
var msg = map__26752__$1;
var files = cljs.core.get.call(null,map__26752__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__26752__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__26752__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__23179__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_26906){
var state_val_26907 = (state_26906[(1)]);
if((state_val_26907 === (7))){
var inst_26766 = (state_26906[(7)]);
var inst_26769 = (state_26906[(8)]);
var inst_26768 = (state_26906[(9)]);
var inst_26767 = (state_26906[(10)]);
var inst_26774 = cljs.core._nth.call(null,inst_26767,inst_26769);
var inst_26775 = figwheel.client.file_reloading.eval_body.call(null,inst_26774,opts);
var inst_26776 = (inst_26769 + (1));
var tmp26908 = inst_26766;
var tmp26909 = inst_26768;
var tmp26910 = inst_26767;
var inst_26766__$1 = tmp26908;
var inst_26767__$1 = tmp26910;
var inst_26768__$1 = tmp26909;
var inst_26769__$1 = inst_26776;
var state_26906__$1 = (function (){var statearr_26911 = state_26906;
(statearr_26911[(7)] = inst_26766__$1);

(statearr_26911[(8)] = inst_26769__$1);

(statearr_26911[(9)] = inst_26768__$1);

(statearr_26911[(10)] = inst_26767__$1);

(statearr_26911[(11)] = inst_26775);

return statearr_26911;
})();
var statearr_26912_26998 = state_26906__$1;
(statearr_26912_26998[(2)] = null);

(statearr_26912_26998[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (20))){
var inst_26809 = (state_26906[(12)]);
var inst_26817 = figwheel.client.file_reloading.sort_files.call(null,inst_26809);
var state_26906__$1 = state_26906;
var statearr_26913_26999 = state_26906__$1;
(statearr_26913_26999[(2)] = inst_26817);

(statearr_26913_26999[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (27))){
var state_26906__$1 = state_26906;
var statearr_26914_27000 = state_26906__$1;
(statearr_26914_27000[(2)] = null);

(statearr_26914_27000[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (1))){
var inst_26758 = (state_26906[(13)]);
var inst_26755 = before_jsload.call(null,files);
var inst_26756 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_26757 = (function (){return ((function (inst_26758,inst_26755,inst_26756,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26499_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__26499_SHARP_);
});
;})(inst_26758,inst_26755,inst_26756,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26758__$1 = cljs.core.filter.call(null,inst_26757,files);
var inst_26759 = cljs.core.not_empty.call(null,inst_26758__$1);
var state_26906__$1 = (function (){var statearr_26915 = state_26906;
(statearr_26915[(14)] = inst_26755);

(statearr_26915[(15)] = inst_26756);

(statearr_26915[(13)] = inst_26758__$1);

return statearr_26915;
})();
if(cljs.core.truth_(inst_26759)){
var statearr_26916_27001 = state_26906__$1;
(statearr_26916_27001[(1)] = (2));

} else {
var statearr_26917_27002 = state_26906__$1;
(statearr_26917_27002[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (24))){
var state_26906__$1 = state_26906;
var statearr_26918_27003 = state_26906__$1;
(statearr_26918_27003[(2)] = null);

(statearr_26918_27003[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (39))){
var inst_26859 = (state_26906[(16)]);
var state_26906__$1 = state_26906;
var statearr_26919_27004 = state_26906__$1;
(statearr_26919_27004[(2)] = inst_26859);

(statearr_26919_27004[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (46))){
var inst_26901 = (state_26906[(2)]);
var state_26906__$1 = state_26906;
var statearr_26920_27005 = state_26906__$1;
(statearr_26920_27005[(2)] = inst_26901);

(statearr_26920_27005[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (4))){
var inst_26803 = (state_26906[(2)]);
var inst_26804 = cljs.core.List.EMPTY;
var inst_26805 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_26804);
var inst_26806 = (function (){return ((function (inst_26803,inst_26804,inst_26805,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26500_SHARP_){
var and__20273__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__26500_SHARP_);
if(cljs.core.truth_(and__20273__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__26500_SHARP_));
} else {
return and__20273__auto__;
}
});
;})(inst_26803,inst_26804,inst_26805,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26807 = cljs.core.filter.call(null,inst_26806,files);
var inst_26808 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_26809 = cljs.core.concat.call(null,inst_26807,inst_26808);
var state_26906__$1 = (function (){var statearr_26921 = state_26906;
(statearr_26921[(17)] = inst_26805);

(statearr_26921[(18)] = inst_26803);

(statearr_26921[(12)] = inst_26809);

return statearr_26921;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_26922_27006 = state_26906__$1;
(statearr_26922_27006[(1)] = (16));

} else {
var statearr_26923_27007 = state_26906__$1;
(statearr_26923_27007[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (15))){
var inst_26793 = (state_26906[(2)]);
var state_26906__$1 = state_26906;
var statearr_26924_27008 = state_26906__$1;
(statearr_26924_27008[(2)] = inst_26793);

(statearr_26924_27008[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (21))){
var inst_26819 = (state_26906[(19)]);
var inst_26819__$1 = (state_26906[(2)]);
var inst_26820 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_26819__$1);
var state_26906__$1 = (function (){var statearr_26925 = state_26906;
(statearr_26925[(19)] = inst_26819__$1);

return statearr_26925;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26906__$1,(22),inst_26820);
} else {
if((state_val_26907 === (31))){
var inst_26904 = (state_26906[(2)]);
var state_26906__$1 = state_26906;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26906__$1,inst_26904);
} else {
if((state_val_26907 === (32))){
var inst_26859 = (state_26906[(16)]);
var inst_26864 = inst_26859.cljs$lang$protocol_mask$partition0$;
var inst_26865 = (inst_26864 & (64));
var inst_26866 = inst_26859.cljs$core$ISeq$;
var inst_26867 = (cljs.core.PROTOCOL_SENTINEL === inst_26866);
var inst_26868 = (inst_26865) || (inst_26867);
var state_26906__$1 = state_26906;
if(cljs.core.truth_(inst_26868)){
var statearr_26926_27009 = state_26906__$1;
(statearr_26926_27009[(1)] = (35));

} else {
var statearr_26927_27010 = state_26906__$1;
(statearr_26927_27010[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (40))){
var inst_26881 = (state_26906[(20)]);
var inst_26880 = (state_26906[(2)]);
var inst_26881__$1 = cljs.core.get.call(null,inst_26880,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_26882 = cljs.core.get.call(null,inst_26880,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_26883 = cljs.core.not_empty.call(null,inst_26881__$1);
var state_26906__$1 = (function (){var statearr_26928 = state_26906;
(statearr_26928[(21)] = inst_26882);

(statearr_26928[(20)] = inst_26881__$1);

return statearr_26928;
})();
if(cljs.core.truth_(inst_26883)){
var statearr_26929_27011 = state_26906__$1;
(statearr_26929_27011[(1)] = (41));

} else {
var statearr_26930_27012 = state_26906__$1;
(statearr_26930_27012[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (33))){
var state_26906__$1 = state_26906;
var statearr_26931_27013 = state_26906__$1;
(statearr_26931_27013[(2)] = false);

(statearr_26931_27013[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (13))){
var inst_26779 = (state_26906[(22)]);
var inst_26783 = cljs.core.chunk_first.call(null,inst_26779);
var inst_26784 = cljs.core.chunk_rest.call(null,inst_26779);
var inst_26785 = cljs.core.count.call(null,inst_26783);
var inst_26766 = inst_26784;
var inst_26767 = inst_26783;
var inst_26768 = inst_26785;
var inst_26769 = (0);
var state_26906__$1 = (function (){var statearr_26932 = state_26906;
(statearr_26932[(7)] = inst_26766);

(statearr_26932[(8)] = inst_26769);

(statearr_26932[(9)] = inst_26768);

(statearr_26932[(10)] = inst_26767);

return statearr_26932;
})();
var statearr_26933_27014 = state_26906__$1;
(statearr_26933_27014[(2)] = null);

(statearr_26933_27014[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (22))){
var inst_26823 = (state_26906[(23)]);
var inst_26827 = (state_26906[(24)]);
var inst_26822 = (state_26906[(25)]);
var inst_26819 = (state_26906[(19)]);
var inst_26822__$1 = (state_26906[(2)]);
var inst_26823__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26822__$1);
var inst_26824 = (function (){var all_files = inst_26819;
var res_SINGLEQUOTE_ = inst_26822__$1;
var res = inst_26823__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_26823,inst_26827,inst_26822,inst_26819,inst_26822__$1,inst_26823__$1,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__26501_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__26501_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_26823,inst_26827,inst_26822,inst_26819,inst_26822__$1,inst_26823__$1,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26825 = cljs.core.filter.call(null,inst_26824,inst_26822__$1);
var inst_26826 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_26827__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_26826);
var inst_26828 = cljs.core.not_empty.call(null,inst_26827__$1);
var state_26906__$1 = (function (){var statearr_26934 = state_26906;
(statearr_26934[(23)] = inst_26823__$1);

(statearr_26934[(26)] = inst_26825);

(statearr_26934[(24)] = inst_26827__$1);

(statearr_26934[(25)] = inst_26822__$1);

return statearr_26934;
})();
if(cljs.core.truth_(inst_26828)){
var statearr_26935_27015 = state_26906__$1;
(statearr_26935_27015[(1)] = (23));

} else {
var statearr_26936_27016 = state_26906__$1;
(statearr_26936_27016[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (36))){
var state_26906__$1 = state_26906;
var statearr_26937_27017 = state_26906__$1;
(statearr_26937_27017[(2)] = false);

(statearr_26937_27017[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (41))){
var inst_26881 = (state_26906[(20)]);
var inst_26885 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_26886 = cljs.core.map.call(null,inst_26885,inst_26881);
var inst_26887 = cljs.core.pr_str.call(null,inst_26886);
var inst_26888 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_26887)].join('');
var inst_26889 = figwheel.client.utils.log.call(null,inst_26888);
var state_26906__$1 = state_26906;
var statearr_26938_27018 = state_26906__$1;
(statearr_26938_27018[(2)] = inst_26889);

(statearr_26938_27018[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (43))){
var inst_26882 = (state_26906[(21)]);
var inst_26892 = (state_26906[(2)]);
var inst_26893 = cljs.core.not_empty.call(null,inst_26882);
var state_26906__$1 = (function (){var statearr_26939 = state_26906;
(statearr_26939[(27)] = inst_26892);

return statearr_26939;
})();
if(cljs.core.truth_(inst_26893)){
var statearr_26940_27019 = state_26906__$1;
(statearr_26940_27019[(1)] = (44));

} else {
var statearr_26941_27020 = state_26906__$1;
(statearr_26941_27020[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (29))){
var inst_26823 = (state_26906[(23)]);
var inst_26825 = (state_26906[(26)]);
var inst_26859 = (state_26906[(16)]);
var inst_26827 = (state_26906[(24)]);
var inst_26822 = (state_26906[(25)]);
var inst_26819 = (state_26906[(19)]);
var inst_26855 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_26858 = (function (){var all_files = inst_26819;
var res_SINGLEQUOTE_ = inst_26822;
var res = inst_26823;
var files_not_loaded = inst_26825;
var dependencies_that_loaded = inst_26827;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26823,inst_26825,inst_26859,inst_26827,inst_26822,inst_26819,inst_26855,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26857){
var map__26942 = p__26857;
var map__26942__$1 = ((((!((map__26942 == null)))?((((map__26942.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26942.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26942):map__26942);
var namespace = cljs.core.get.call(null,map__26942__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26823,inst_26825,inst_26859,inst_26827,inst_26822,inst_26819,inst_26855,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26859__$1 = cljs.core.group_by.call(null,inst_26858,inst_26825);
var inst_26861 = (inst_26859__$1 == null);
var inst_26862 = cljs.core.not.call(null,inst_26861);
var state_26906__$1 = (function (){var statearr_26944 = state_26906;
(statearr_26944[(28)] = inst_26855);

(statearr_26944[(16)] = inst_26859__$1);

return statearr_26944;
})();
if(inst_26862){
var statearr_26945_27021 = state_26906__$1;
(statearr_26945_27021[(1)] = (32));

} else {
var statearr_26946_27022 = state_26906__$1;
(statearr_26946_27022[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (44))){
var inst_26882 = (state_26906[(21)]);
var inst_26895 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_26882);
var inst_26896 = cljs.core.pr_str.call(null,inst_26895);
var inst_26897 = [cljs.core.str("not required: "),cljs.core.str(inst_26896)].join('');
var inst_26898 = figwheel.client.utils.log.call(null,inst_26897);
var state_26906__$1 = state_26906;
var statearr_26947_27023 = state_26906__$1;
(statearr_26947_27023[(2)] = inst_26898);

(statearr_26947_27023[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (6))){
var inst_26800 = (state_26906[(2)]);
var state_26906__$1 = state_26906;
var statearr_26948_27024 = state_26906__$1;
(statearr_26948_27024[(2)] = inst_26800);

(statearr_26948_27024[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (28))){
var inst_26825 = (state_26906[(26)]);
var inst_26852 = (state_26906[(2)]);
var inst_26853 = cljs.core.not_empty.call(null,inst_26825);
var state_26906__$1 = (function (){var statearr_26949 = state_26906;
(statearr_26949[(29)] = inst_26852);

return statearr_26949;
})();
if(cljs.core.truth_(inst_26853)){
var statearr_26950_27025 = state_26906__$1;
(statearr_26950_27025[(1)] = (29));

} else {
var statearr_26951_27026 = state_26906__$1;
(statearr_26951_27026[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (25))){
var inst_26823 = (state_26906[(23)]);
var inst_26839 = (state_26906[(2)]);
var inst_26840 = cljs.core.not_empty.call(null,inst_26823);
var state_26906__$1 = (function (){var statearr_26952 = state_26906;
(statearr_26952[(30)] = inst_26839);

return statearr_26952;
})();
if(cljs.core.truth_(inst_26840)){
var statearr_26953_27027 = state_26906__$1;
(statearr_26953_27027[(1)] = (26));

} else {
var statearr_26954_27028 = state_26906__$1;
(statearr_26954_27028[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (34))){
var inst_26875 = (state_26906[(2)]);
var state_26906__$1 = state_26906;
if(cljs.core.truth_(inst_26875)){
var statearr_26955_27029 = state_26906__$1;
(statearr_26955_27029[(1)] = (38));

} else {
var statearr_26956_27030 = state_26906__$1;
(statearr_26956_27030[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (17))){
var state_26906__$1 = state_26906;
var statearr_26957_27031 = state_26906__$1;
(statearr_26957_27031[(2)] = recompile_dependents);

(statearr_26957_27031[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (3))){
var state_26906__$1 = state_26906;
var statearr_26958_27032 = state_26906__$1;
(statearr_26958_27032[(2)] = null);

(statearr_26958_27032[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (12))){
var inst_26796 = (state_26906[(2)]);
var state_26906__$1 = state_26906;
var statearr_26959_27033 = state_26906__$1;
(statearr_26959_27033[(2)] = inst_26796);

(statearr_26959_27033[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (2))){
var inst_26758 = (state_26906[(13)]);
var inst_26765 = cljs.core.seq.call(null,inst_26758);
var inst_26766 = inst_26765;
var inst_26767 = null;
var inst_26768 = (0);
var inst_26769 = (0);
var state_26906__$1 = (function (){var statearr_26960 = state_26906;
(statearr_26960[(7)] = inst_26766);

(statearr_26960[(8)] = inst_26769);

(statearr_26960[(9)] = inst_26768);

(statearr_26960[(10)] = inst_26767);

return statearr_26960;
})();
var statearr_26961_27034 = state_26906__$1;
(statearr_26961_27034[(2)] = null);

(statearr_26961_27034[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (23))){
var inst_26823 = (state_26906[(23)]);
var inst_26825 = (state_26906[(26)]);
var inst_26827 = (state_26906[(24)]);
var inst_26822 = (state_26906[(25)]);
var inst_26819 = (state_26906[(19)]);
var inst_26830 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_26832 = (function (){var all_files = inst_26819;
var res_SINGLEQUOTE_ = inst_26822;
var res = inst_26823;
var files_not_loaded = inst_26825;
var dependencies_that_loaded = inst_26827;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26823,inst_26825,inst_26827,inst_26822,inst_26819,inst_26830,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26831){
var map__26962 = p__26831;
var map__26962__$1 = ((((!((map__26962 == null)))?((((map__26962.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26962.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26962):map__26962);
var request_url = cljs.core.get.call(null,map__26962__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26823,inst_26825,inst_26827,inst_26822,inst_26819,inst_26830,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26833 = cljs.core.reverse.call(null,inst_26827);
var inst_26834 = cljs.core.map.call(null,inst_26832,inst_26833);
var inst_26835 = cljs.core.pr_str.call(null,inst_26834);
var inst_26836 = figwheel.client.utils.log.call(null,inst_26835);
var state_26906__$1 = (function (){var statearr_26964 = state_26906;
(statearr_26964[(31)] = inst_26830);

return statearr_26964;
})();
var statearr_26965_27035 = state_26906__$1;
(statearr_26965_27035[(2)] = inst_26836);

(statearr_26965_27035[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (35))){
var state_26906__$1 = state_26906;
var statearr_26966_27036 = state_26906__$1;
(statearr_26966_27036[(2)] = true);

(statearr_26966_27036[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (19))){
var inst_26809 = (state_26906[(12)]);
var inst_26815 = figwheel.client.file_reloading.expand_files.call(null,inst_26809);
var state_26906__$1 = state_26906;
var statearr_26967_27037 = state_26906__$1;
(statearr_26967_27037[(2)] = inst_26815);

(statearr_26967_27037[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (11))){
var state_26906__$1 = state_26906;
var statearr_26968_27038 = state_26906__$1;
(statearr_26968_27038[(2)] = null);

(statearr_26968_27038[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (9))){
var inst_26798 = (state_26906[(2)]);
var state_26906__$1 = state_26906;
var statearr_26969_27039 = state_26906__$1;
(statearr_26969_27039[(2)] = inst_26798);

(statearr_26969_27039[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (5))){
var inst_26769 = (state_26906[(8)]);
var inst_26768 = (state_26906[(9)]);
var inst_26771 = (inst_26769 < inst_26768);
var inst_26772 = inst_26771;
var state_26906__$1 = state_26906;
if(cljs.core.truth_(inst_26772)){
var statearr_26970_27040 = state_26906__$1;
(statearr_26970_27040[(1)] = (7));

} else {
var statearr_26971_27041 = state_26906__$1;
(statearr_26971_27041[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (14))){
var inst_26779 = (state_26906[(22)]);
var inst_26788 = cljs.core.first.call(null,inst_26779);
var inst_26789 = figwheel.client.file_reloading.eval_body.call(null,inst_26788,opts);
var inst_26790 = cljs.core.next.call(null,inst_26779);
var inst_26766 = inst_26790;
var inst_26767 = null;
var inst_26768 = (0);
var inst_26769 = (0);
var state_26906__$1 = (function (){var statearr_26972 = state_26906;
(statearr_26972[(32)] = inst_26789);

(statearr_26972[(7)] = inst_26766);

(statearr_26972[(8)] = inst_26769);

(statearr_26972[(9)] = inst_26768);

(statearr_26972[(10)] = inst_26767);

return statearr_26972;
})();
var statearr_26973_27042 = state_26906__$1;
(statearr_26973_27042[(2)] = null);

(statearr_26973_27042[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (45))){
var state_26906__$1 = state_26906;
var statearr_26974_27043 = state_26906__$1;
(statearr_26974_27043[(2)] = null);

(statearr_26974_27043[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (26))){
var inst_26823 = (state_26906[(23)]);
var inst_26825 = (state_26906[(26)]);
var inst_26827 = (state_26906[(24)]);
var inst_26822 = (state_26906[(25)]);
var inst_26819 = (state_26906[(19)]);
var inst_26842 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_26844 = (function (){var all_files = inst_26819;
var res_SINGLEQUOTE_ = inst_26822;
var res = inst_26823;
var files_not_loaded = inst_26825;
var dependencies_that_loaded = inst_26827;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26823,inst_26825,inst_26827,inst_26822,inst_26819,inst_26842,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__26843){
var map__26975 = p__26843;
var map__26975__$1 = ((((!((map__26975 == null)))?((((map__26975.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26975.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26975):map__26975);
var namespace = cljs.core.get.call(null,map__26975__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__26975__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26823,inst_26825,inst_26827,inst_26822,inst_26819,inst_26842,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26845 = cljs.core.map.call(null,inst_26844,inst_26823);
var inst_26846 = cljs.core.pr_str.call(null,inst_26845);
var inst_26847 = figwheel.client.utils.log.call(null,inst_26846);
var inst_26848 = (function (){var all_files = inst_26819;
var res_SINGLEQUOTE_ = inst_26822;
var res = inst_26823;
var files_not_loaded = inst_26825;
var dependencies_that_loaded = inst_26827;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26823,inst_26825,inst_26827,inst_26822,inst_26819,inst_26842,inst_26844,inst_26845,inst_26846,inst_26847,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_26823,inst_26825,inst_26827,inst_26822,inst_26819,inst_26842,inst_26844,inst_26845,inst_26846,inst_26847,state_val_26907,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_26849 = setTimeout(inst_26848,(10));
var state_26906__$1 = (function (){var statearr_26977 = state_26906;
(statearr_26977[(33)] = inst_26842);

(statearr_26977[(34)] = inst_26847);

return statearr_26977;
})();
var statearr_26978_27044 = state_26906__$1;
(statearr_26978_27044[(2)] = inst_26849);

(statearr_26978_27044[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (16))){
var state_26906__$1 = state_26906;
var statearr_26979_27045 = state_26906__$1;
(statearr_26979_27045[(2)] = reload_dependents);

(statearr_26979_27045[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (38))){
var inst_26859 = (state_26906[(16)]);
var inst_26877 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26859);
var state_26906__$1 = state_26906;
var statearr_26980_27046 = state_26906__$1;
(statearr_26980_27046[(2)] = inst_26877);

(statearr_26980_27046[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (30))){
var state_26906__$1 = state_26906;
var statearr_26981_27047 = state_26906__$1;
(statearr_26981_27047[(2)] = null);

(statearr_26981_27047[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (10))){
var inst_26779 = (state_26906[(22)]);
var inst_26781 = cljs.core.chunked_seq_QMARK_.call(null,inst_26779);
var state_26906__$1 = state_26906;
if(inst_26781){
var statearr_26982_27048 = state_26906__$1;
(statearr_26982_27048[(1)] = (13));

} else {
var statearr_26983_27049 = state_26906__$1;
(statearr_26983_27049[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (18))){
var inst_26813 = (state_26906[(2)]);
var state_26906__$1 = state_26906;
if(cljs.core.truth_(inst_26813)){
var statearr_26984_27050 = state_26906__$1;
(statearr_26984_27050[(1)] = (19));

} else {
var statearr_26985_27051 = state_26906__$1;
(statearr_26985_27051[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (42))){
var state_26906__$1 = state_26906;
var statearr_26986_27052 = state_26906__$1;
(statearr_26986_27052[(2)] = null);

(statearr_26986_27052[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (37))){
var inst_26872 = (state_26906[(2)]);
var state_26906__$1 = state_26906;
var statearr_26987_27053 = state_26906__$1;
(statearr_26987_27053[(2)] = inst_26872);

(statearr_26987_27053[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26907 === (8))){
var inst_26766 = (state_26906[(7)]);
var inst_26779 = (state_26906[(22)]);
var inst_26779__$1 = cljs.core.seq.call(null,inst_26766);
var state_26906__$1 = (function (){var statearr_26988 = state_26906;
(statearr_26988[(22)] = inst_26779__$1);

return statearr_26988;
})();
if(inst_26779__$1){
var statearr_26989_27054 = state_26906__$1;
(statearr_26989_27054[(1)] = (10));

} else {
var statearr_26990_27055 = state_26906__$1;
(statearr_26990_27055[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__22336__auto__,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____0 = (function (){
var statearr_26994 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26994[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__);

(statearr_26994[(1)] = (1));

return statearr_26994;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____1 = (function (state_26906){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_26906);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e26995){if((e26995 instanceof Object)){
var ex__22340__auto__ = e26995;
var statearr_26996_27056 = state_26906;
(statearr_26996_27056[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26906);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26995;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27057 = state_26906;
state_26906 = G__27057;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__ = function(state_26906){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____1.call(this,state_26906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__23181__auto__ = (function (){var statearr_26997 = f__23180__auto__.call(null);
(statearr_26997[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto__);

return statearr_26997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto__,map__26751,map__26751__$1,opts,before_jsload,on_jsload,reload_dependents,map__26752,map__26752__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__23179__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__27060,link){
var map__27063 = p__27060;
var map__27063__$1 = ((((!((map__27063 == null)))?((((map__27063.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27063.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27063):map__27063);
var file = cljs.core.get.call(null,map__27063__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__27063,map__27063__$1,file){
return (function (p1__27058_SHARP_,p2__27059_SHARP_){
if(cljs.core._EQ_.call(null,p1__27058_SHARP_,p2__27059_SHARP_)){
return p1__27058_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__27063,map__27063__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__27069){
var map__27070 = p__27069;
var map__27070__$1 = ((((!((map__27070 == null)))?((((map__27070.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27070.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27070):map__27070);
var match_length = cljs.core.get.call(null,map__27070__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__27070__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__27065_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__27065_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args27072 = [];
var len__21393__auto___27075 = arguments.length;
var i__21394__auto___27076 = (0);
while(true){
if((i__21394__auto___27076 < len__21393__auto___27075)){
args27072.push((arguments[i__21394__auto___27076]));

var G__27077 = (i__21394__auto___27076 + (1));
i__21394__auto___27076 = G__27077;
continue;
} else {
}
break;
}

var G__27074 = args27072.length;
switch (G__27074) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27072.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__27079_SHARP_,p2__27080_SHARP_){
return cljs.core.assoc.call(null,p1__27079_SHARP_,cljs.core.get.call(null,p2__27080_SHARP_,key),p2__27080_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__27081){
var map__27084 = p__27081;
var map__27084__$1 = ((((!((map__27084 == null)))?((((map__27084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27084.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27084):map__27084);
var f_data = map__27084__$1;
var file = cljs.core.get.call(null,map__27084__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__27086,files_msg){
var map__27093 = p__27086;
var map__27093__$1 = ((((!((map__27093 == null)))?((((map__27093.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27093.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27093):map__27093);
var opts = map__27093__$1;
var on_cssload = cljs.core.get.call(null,map__27093__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__27095_27099 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__27096_27100 = null;
var count__27097_27101 = (0);
var i__27098_27102 = (0);
while(true){
if((i__27098_27102 < count__27097_27101)){
var f_27103 = cljs.core._nth.call(null,chunk__27096_27100,i__27098_27102);
figwheel.client.file_reloading.reload_css_file.call(null,f_27103);

var G__27104 = seq__27095_27099;
var G__27105 = chunk__27096_27100;
var G__27106 = count__27097_27101;
var G__27107 = (i__27098_27102 + (1));
seq__27095_27099 = G__27104;
chunk__27096_27100 = G__27105;
count__27097_27101 = G__27106;
i__27098_27102 = G__27107;
continue;
} else {
var temp__4657__auto___27108 = cljs.core.seq.call(null,seq__27095_27099);
if(temp__4657__auto___27108){
var seq__27095_27109__$1 = temp__4657__auto___27108;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27095_27109__$1)){
var c__21099__auto___27110 = cljs.core.chunk_first.call(null,seq__27095_27109__$1);
var G__27111 = cljs.core.chunk_rest.call(null,seq__27095_27109__$1);
var G__27112 = c__21099__auto___27110;
var G__27113 = cljs.core.count.call(null,c__21099__auto___27110);
var G__27114 = (0);
seq__27095_27099 = G__27111;
chunk__27096_27100 = G__27112;
count__27097_27101 = G__27113;
i__27098_27102 = G__27114;
continue;
} else {
var f_27115 = cljs.core.first.call(null,seq__27095_27109__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_27115);

var G__27116 = cljs.core.next.call(null,seq__27095_27109__$1);
var G__27117 = null;
var G__27118 = (0);
var G__27119 = (0);
seq__27095_27099 = G__27116;
chunk__27096_27100 = G__27117;
count__27097_27101 = G__27118;
i__27098_27102 = G__27119;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__27093,map__27093__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__27093,map__27093__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1481743379909