// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args23224 = [];
var len__21393__auto___23230 = arguments.length;
var i__21394__auto___23231 = (0);
while(true){
if((i__21394__auto___23231 < len__21393__auto___23230)){
args23224.push((arguments[i__21394__auto___23231]));

var G__23232 = (i__21394__auto___23231 + (1));
i__21394__auto___23231 = G__23232;
continue;
} else {
}
break;
}

var G__23226 = args23224.length;
switch (G__23226) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23224.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async23227 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23227 = (function (f,blockable,meta23228){
this.f = f;
this.blockable = blockable;
this.meta23228 = meta23228;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23227.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23229,meta23228__$1){
var self__ = this;
var _23229__$1 = this;
return (new cljs.core.async.t_cljs$core$async23227(self__.f,self__.blockable,meta23228__$1));
});

cljs.core.async.t_cljs$core$async23227.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23229){
var self__ = this;
var _23229__$1 = this;
return self__.meta23228;
});

cljs.core.async.t_cljs$core$async23227.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23227.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async23227.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async23227.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async23227.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta23228","meta23228",-2020733421,null)], null);
});

cljs.core.async.t_cljs$core$async23227.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23227.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23227";

cljs.core.async.t_cljs$core$async23227.cljs$lang$ctorPrWriter = (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async23227");
});

cljs.core.async.__GT_t_cljs$core$async23227 = (function cljs$core$async$__GT_t_cljs$core$async23227(f__$1,blockable__$1,meta23228){
return (new cljs.core.async.t_cljs$core$async23227(f__$1,blockable__$1,meta23228));
});

}

return (new cljs.core.async.t_cljs$core$async23227(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args23236 = [];
var len__21393__auto___23239 = arguments.length;
var i__21394__auto___23240 = (0);
while(true){
if((i__21394__auto___23240 < len__21393__auto___23239)){
args23236.push((arguments[i__21394__auto___23240]));

var G__23241 = (i__21394__auto___23240 + (1));
i__21394__auto___23240 = G__23241;
continue;
} else {
}
break;
}

var G__23238 = args23236.length;
switch (G__23238) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23236.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args23243 = [];
var len__21393__auto___23246 = arguments.length;
var i__21394__auto___23247 = (0);
while(true){
if((i__21394__auto___23247 < len__21393__auto___23246)){
args23243.push((arguments[i__21394__auto___23247]));

var G__23248 = (i__21394__auto___23247 + (1));
i__21394__auto___23247 = G__23248;
continue;
} else {
}
break;
}

var G__23245 = args23243.length;
switch (G__23245) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23243.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args23250 = [];
var len__21393__auto___23253 = arguments.length;
var i__21394__auto___23254 = (0);
while(true){
if((i__21394__auto___23254 < len__21393__auto___23253)){
args23250.push((arguments[i__21394__auto___23254]));

var G__23255 = (i__21394__auto___23254 + (1));
i__21394__auto___23254 = G__23255;
continue;
} else {
}
break;
}

var G__23252 = args23250.length;
switch (G__23252) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23250.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_23257 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_23257);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_23257,ret){
return (function (){
return fn1.call(null,val_23257);
});})(val_23257,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args23258 = [];
var len__21393__auto___23261 = arguments.length;
var i__21394__auto___23262 = (0);
while(true){
if((i__21394__auto___23262 < len__21393__auto___23261)){
args23258.push((arguments[i__21394__auto___23262]));

var G__23263 = (i__21394__auto___23262 + (1));
i__21394__auto___23262 = G__23263;
continue;
} else {
}
break;
}

var G__23260 = args23258.length;
switch (G__23260) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23258.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__21203__auto___23265 = n;
var x_23266 = (0);
while(true){
if((x_23266 < n__21203__auto___23265)){
(a[x_23266] = (0));

var G__23267 = (x_23266 + (1));
x_23266 = G__23267;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__23268 = (i + (1));
i = G__23268;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async23272 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23272 = (function (flag,meta23273){
this.flag = flag;
this.meta23273 = meta23273;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23272.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_23274,meta23273__$1){
var self__ = this;
var _23274__$1 = this;
return (new cljs.core.async.t_cljs$core$async23272(self__.flag,meta23273__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async23272.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_23274){
var self__ = this;
var _23274__$1 = this;
return self__.meta23273;
});})(flag))
;

cljs.core.async.t_cljs$core$async23272.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23272.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async23272.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async23272.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async23272.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta23273","meta23273",-97158658,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async23272.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23272.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23272";

cljs.core.async.t_cljs$core$async23272.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async23272");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async23272 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async23272(flag__$1,meta23273){
return (new cljs.core.async.t_cljs$core$async23272(flag__$1,meta23273));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async23272(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async23278 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23278 = (function (flag,cb,meta23279){
this.flag = flag;
this.cb = cb;
this.meta23279 = meta23279;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async23278.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23280,meta23279__$1){
var self__ = this;
var _23280__$1 = this;
return (new cljs.core.async.t_cljs$core$async23278(self__.flag,self__.cb,meta23279__$1));
});

cljs.core.async.t_cljs$core$async23278.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23280){
var self__ = this;
var _23280__$1 = this;
return self__.meta23279;
});

cljs.core.async.t_cljs$core$async23278.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async23278.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async23278.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async23278.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async23278.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta23279","meta23279",-1844360728,null)], null);
});

cljs.core.async.t_cljs$core$async23278.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async23278.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23278";

cljs.core.async.t_cljs$core$async23278.cljs$lang$ctorPrWriter = (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async23278");
});

cljs.core.async.__GT_t_cljs$core$async23278 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async23278(flag__$1,cb__$1,meta23279){
return (new cljs.core.async.t_cljs$core$async23278(flag__$1,cb__$1,meta23279));
});

}

return (new cljs.core.async.t_cljs$core$async23278(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__23281_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23281_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__23282_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__23282_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__20285__auto__ = wport;
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
return port;
}
})()], null));
} else {
var G__23283 = (i + (1));
i = G__23283;
continue;
}
} else {
return null;
}
break;
}
})();
var or__20285__auto__ = ret;
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__20273__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__20273__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__20273__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__21400__auto__ = [];
var len__21393__auto___23289 = arguments.length;
var i__21394__auto___23290 = (0);
while(true){
if((i__21394__auto___23290 < len__21393__auto___23289)){
args__21400__auto__.push((arguments[i__21394__auto___23290]));

var G__23291 = (i__21394__auto___23290 + (1));
i__21394__auto___23290 = G__23291;
continue;
} else {
}
break;
}

var argseq__21401__auto__ = ((((1) < args__21400__auto__.length))?(new cljs.core.IndexedSeq(args__21400__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__21401__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__23286){
var map__23287 = p__23286;
var map__23287__$1 = ((((!((map__23287 == null)))?((((map__23287.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23287.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23287):map__23287);
var opts = map__23287__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq23284){
var G__23285 = cljs.core.first.call(null,seq23284);
var seq23284__$1 = cljs.core.next.call(null,seq23284);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23285,seq23284__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args23292 = [];
var len__21393__auto___23342 = arguments.length;
var i__21394__auto___23343 = (0);
while(true){
if((i__21394__auto___23343 < len__21393__auto___23342)){
args23292.push((arguments[i__21394__auto___23343]));

var G__23344 = (i__21394__auto___23343 + (1));
i__21394__auto___23343 = G__23344;
continue;
} else {
}
break;
}

var G__23294 = args23292.length;
switch (G__23294) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23292.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__23179__auto___23346 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___23346){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___23346){
return (function (state_23318){
var state_val_23319 = (state_23318[(1)]);
if((state_val_23319 === (7))){
var inst_23314 = (state_23318[(2)]);
var state_23318__$1 = state_23318;
var statearr_23320_23347 = state_23318__$1;
(statearr_23320_23347[(2)] = inst_23314);

(statearr_23320_23347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23319 === (1))){
var state_23318__$1 = state_23318;
var statearr_23321_23348 = state_23318__$1;
(statearr_23321_23348[(2)] = null);

(statearr_23321_23348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23319 === (4))){
var inst_23297 = (state_23318[(7)]);
var inst_23297__$1 = (state_23318[(2)]);
var inst_23298 = (inst_23297__$1 == null);
var state_23318__$1 = (function (){var statearr_23322 = state_23318;
(statearr_23322[(7)] = inst_23297__$1);

return statearr_23322;
})();
if(cljs.core.truth_(inst_23298)){
var statearr_23323_23349 = state_23318__$1;
(statearr_23323_23349[(1)] = (5));

} else {
var statearr_23324_23350 = state_23318__$1;
(statearr_23324_23350[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23319 === (13))){
var state_23318__$1 = state_23318;
var statearr_23325_23351 = state_23318__$1;
(statearr_23325_23351[(2)] = null);

(statearr_23325_23351[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23319 === (6))){
var inst_23297 = (state_23318[(7)]);
var state_23318__$1 = state_23318;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23318__$1,(11),to,inst_23297);
} else {
if((state_val_23319 === (3))){
var inst_23316 = (state_23318[(2)]);
var state_23318__$1 = state_23318;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23318__$1,inst_23316);
} else {
if((state_val_23319 === (12))){
var state_23318__$1 = state_23318;
var statearr_23326_23352 = state_23318__$1;
(statearr_23326_23352[(2)] = null);

(statearr_23326_23352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23319 === (2))){
var state_23318__$1 = state_23318;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23318__$1,(4),from);
} else {
if((state_val_23319 === (11))){
var inst_23307 = (state_23318[(2)]);
var state_23318__$1 = state_23318;
if(cljs.core.truth_(inst_23307)){
var statearr_23327_23353 = state_23318__$1;
(statearr_23327_23353[(1)] = (12));

} else {
var statearr_23328_23354 = state_23318__$1;
(statearr_23328_23354[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23319 === (9))){
var state_23318__$1 = state_23318;
var statearr_23329_23355 = state_23318__$1;
(statearr_23329_23355[(2)] = null);

(statearr_23329_23355[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23319 === (5))){
var state_23318__$1 = state_23318;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23330_23356 = state_23318__$1;
(statearr_23330_23356[(1)] = (8));

} else {
var statearr_23331_23357 = state_23318__$1;
(statearr_23331_23357[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23319 === (14))){
var inst_23312 = (state_23318[(2)]);
var state_23318__$1 = state_23318;
var statearr_23332_23358 = state_23318__$1;
(statearr_23332_23358[(2)] = inst_23312);

(statearr_23332_23358[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23319 === (10))){
var inst_23304 = (state_23318[(2)]);
var state_23318__$1 = state_23318;
var statearr_23333_23359 = state_23318__$1;
(statearr_23333_23359[(2)] = inst_23304);

(statearr_23333_23359[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23319 === (8))){
var inst_23301 = cljs.core.async.close_BANG_.call(null,to);
var state_23318__$1 = state_23318;
var statearr_23334_23360 = state_23318__$1;
(statearr_23334_23360[(2)] = inst_23301);

(statearr_23334_23360[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___23346))
;
return ((function (switch__22336__auto__,c__23179__auto___23346){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_23338 = [null,null,null,null,null,null,null,null];
(statearr_23338[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_23338[(1)] = (1));

return statearr_23338;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_23318){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23318);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23339){if((e23339 instanceof Object)){
var ex__22340__auto__ = e23339;
var statearr_23340_23361 = state_23318;
(statearr_23340_23361[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23318);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23339;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23362 = state_23318;
state_23318 = G__23362;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_23318){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_23318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___23346))
})();
var state__23181__auto__ = (function (){var statearr_23341 = f__23180__auto__.call(null);
(statearr_23341[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___23346);

return statearr_23341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___23346))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__23550){
var vec__23551 = p__23550;
var v = cljs.core.nth.call(null,vec__23551,(0),null);
var p = cljs.core.nth.call(null,vec__23551,(1),null);
var job = vec__23551;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__23179__auto___23737 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___23737,res,vec__23551,v,p,job,jobs,results){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___23737,res,vec__23551,v,p,job,jobs,results){
return (function (state_23558){
var state_val_23559 = (state_23558[(1)]);
if((state_val_23559 === (1))){
var state_23558__$1 = state_23558;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23558__$1,(2),res,v);
} else {
if((state_val_23559 === (2))){
var inst_23555 = (state_23558[(2)]);
var inst_23556 = cljs.core.async.close_BANG_.call(null,res);
var state_23558__$1 = (function (){var statearr_23560 = state_23558;
(statearr_23560[(7)] = inst_23555);

return statearr_23560;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23558__$1,inst_23556);
} else {
return null;
}
}
});})(c__23179__auto___23737,res,vec__23551,v,p,job,jobs,results))
;
return ((function (switch__22336__auto__,c__23179__auto___23737,res,vec__23551,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_23564 = [null,null,null,null,null,null,null,null];
(statearr_23564[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__);

(statearr_23564[(1)] = (1));

return statearr_23564;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1 = (function (state_23558){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23558);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23565){if((e23565 instanceof Object)){
var ex__22340__auto__ = e23565;
var statearr_23566_23738 = state_23558;
(statearr_23566_23738[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23558);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23565;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23739 = state_23558;
state_23558 = G__23739;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = function(state_23558){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1.call(this,state_23558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___23737,res,vec__23551,v,p,job,jobs,results))
})();
var state__23181__auto__ = (function (){var statearr_23567 = f__23180__auto__.call(null);
(statearr_23567[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___23737);

return statearr_23567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___23737,res,vec__23551,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__23568){
var vec__23569 = p__23568;
var v = cljs.core.nth.call(null,vec__23569,(0),null);
var p = cljs.core.nth.call(null,vec__23569,(1),null);
var job = vec__23569;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__21203__auto___23740 = n;
var __23741 = (0);
while(true){
if((__23741 < n__21203__auto___23740)){
var G__23572_23742 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__23572_23742) {
case "compute":
var c__23179__auto___23744 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23741,c__23179__auto___23744,G__23572_23742,n__21203__auto___23740,jobs,results,process,async){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (__23741,c__23179__auto___23744,G__23572_23742,n__21203__auto___23740,jobs,results,process,async){
return (function (state_23585){
var state_val_23586 = (state_23585[(1)]);
if((state_val_23586 === (1))){
var state_23585__$1 = state_23585;
var statearr_23587_23745 = state_23585__$1;
(statearr_23587_23745[(2)] = null);

(statearr_23587_23745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (2))){
var state_23585__$1 = state_23585;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23585__$1,(4),jobs);
} else {
if((state_val_23586 === (3))){
var inst_23583 = (state_23585[(2)]);
var state_23585__$1 = state_23585;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23585__$1,inst_23583);
} else {
if((state_val_23586 === (4))){
var inst_23575 = (state_23585[(2)]);
var inst_23576 = process.call(null,inst_23575);
var state_23585__$1 = state_23585;
if(cljs.core.truth_(inst_23576)){
var statearr_23588_23746 = state_23585__$1;
(statearr_23588_23746[(1)] = (5));

} else {
var statearr_23589_23747 = state_23585__$1;
(statearr_23589_23747[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (5))){
var state_23585__$1 = state_23585;
var statearr_23590_23748 = state_23585__$1;
(statearr_23590_23748[(2)] = null);

(statearr_23590_23748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (6))){
var state_23585__$1 = state_23585;
var statearr_23591_23749 = state_23585__$1;
(statearr_23591_23749[(2)] = null);

(statearr_23591_23749[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23586 === (7))){
var inst_23581 = (state_23585[(2)]);
var state_23585__$1 = state_23585;
var statearr_23592_23750 = state_23585__$1;
(statearr_23592_23750[(2)] = inst_23581);

(statearr_23592_23750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23741,c__23179__auto___23744,G__23572_23742,n__21203__auto___23740,jobs,results,process,async))
;
return ((function (__23741,switch__22336__auto__,c__23179__auto___23744,G__23572_23742,n__21203__auto___23740,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_23596 = [null,null,null,null,null,null,null];
(statearr_23596[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__);

(statearr_23596[(1)] = (1));

return statearr_23596;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1 = (function (state_23585){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23585);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23597){if((e23597 instanceof Object)){
var ex__22340__auto__ = e23597;
var statearr_23598_23751 = state_23585;
(statearr_23598_23751[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23585);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23597;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23752 = state_23585;
state_23585 = G__23752;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = function(state_23585){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1.call(this,state_23585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__;
})()
;})(__23741,switch__22336__auto__,c__23179__auto___23744,G__23572_23742,n__21203__auto___23740,jobs,results,process,async))
})();
var state__23181__auto__ = (function (){var statearr_23599 = f__23180__auto__.call(null);
(statearr_23599[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___23744);

return statearr_23599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(__23741,c__23179__auto___23744,G__23572_23742,n__21203__auto___23740,jobs,results,process,async))
);


break;
case "async":
var c__23179__auto___23753 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__23741,c__23179__auto___23753,G__23572_23742,n__21203__auto___23740,jobs,results,process,async){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (__23741,c__23179__auto___23753,G__23572_23742,n__21203__auto___23740,jobs,results,process,async){
return (function (state_23612){
var state_val_23613 = (state_23612[(1)]);
if((state_val_23613 === (1))){
var state_23612__$1 = state_23612;
var statearr_23614_23754 = state_23612__$1;
(statearr_23614_23754[(2)] = null);

(statearr_23614_23754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (2))){
var state_23612__$1 = state_23612;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23612__$1,(4),jobs);
} else {
if((state_val_23613 === (3))){
var inst_23610 = (state_23612[(2)]);
var state_23612__$1 = state_23612;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23612__$1,inst_23610);
} else {
if((state_val_23613 === (4))){
var inst_23602 = (state_23612[(2)]);
var inst_23603 = async.call(null,inst_23602);
var state_23612__$1 = state_23612;
if(cljs.core.truth_(inst_23603)){
var statearr_23615_23755 = state_23612__$1;
(statearr_23615_23755[(1)] = (5));

} else {
var statearr_23616_23756 = state_23612__$1;
(statearr_23616_23756[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (5))){
var state_23612__$1 = state_23612;
var statearr_23617_23757 = state_23612__$1;
(statearr_23617_23757[(2)] = null);

(statearr_23617_23757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (6))){
var state_23612__$1 = state_23612;
var statearr_23618_23758 = state_23612__$1;
(statearr_23618_23758[(2)] = null);

(statearr_23618_23758[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (7))){
var inst_23608 = (state_23612[(2)]);
var state_23612__$1 = state_23612;
var statearr_23619_23759 = state_23612__$1;
(statearr_23619_23759[(2)] = inst_23608);

(statearr_23619_23759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__23741,c__23179__auto___23753,G__23572_23742,n__21203__auto___23740,jobs,results,process,async))
;
return ((function (__23741,switch__22336__auto__,c__23179__auto___23753,G__23572_23742,n__21203__auto___23740,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_23623 = [null,null,null,null,null,null,null];
(statearr_23623[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__);

(statearr_23623[(1)] = (1));

return statearr_23623;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1 = (function (state_23612){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23612);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23624){if((e23624 instanceof Object)){
var ex__22340__auto__ = e23624;
var statearr_23625_23760 = state_23612;
(statearr_23625_23760[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23612);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23624;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23761 = state_23612;
state_23612 = G__23761;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = function(state_23612){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1.call(this,state_23612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__;
})()
;})(__23741,switch__22336__auto__,c__23179__auto___23753,G__23572_23742,n__21203__auto___23740,jobs,results,process,async))
})();
var state__23181__auto__ = (function (){var statearr_23626 = f__23180__auto__.call(null);
(statearr_23626[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___23753);

return statearr_23626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(__23741,c__23179__auto___23753,G__23572_23742,n__21203__auto___23740,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__23762 = (__23741 + (1));
__23741 = G__23762;
continue;
} else {
}
break;
}

var c__23179__auto___23763 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___23763,jobs,results,process,async){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___23763,jobs,results,process,async){
return (function (state_23648){
var state_val_23649 = (state_23648[(1)]);
if((state_val_23649 === (1))){
var state_23648__$1 = state_23648;
var statearr_23650_23764 = state_23648__$1;
(statearr_23650_23764[(2)] = null);

(statearr_23650_23764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23649 === (2))){
var state_23648__$1 = state_23648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23648__$1,(4),from);
} else {
if((state_val_23649 === (3))){
var inst_23646 = (state_23648[(2)]);
var state_23648__$1 = state_23648;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23648__$1,inst_23646);
} else {
if((state_val_23649 === (4))){
var inst_23629 = (state_23648[(7)]);
var inst_23629__$1 = (state_23648[(2)]);
var inst_23630 = (inst_23629__$1 == null);
var state_23648__$1 = (function (){var statearr_23651 = state_23648;
(statearr_23651[(7)] = inst_23629__$1);

return statearr_23651;
})();
if(cljs.core.truth_(inst_23630)){
var statearr_23652_23765 = state_23648__$1;
(statearr_23652_23765[(1)] = (5));

} else {
var statearr_23653_23766 = state_23648__$1;
(statearr_23653_23766[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23649 === (5))){
var inst_23632 = cljs.core.async.close_BANG_.call(null,jobs);
var state_23648__$1 = state_23648;
var statearr_23654_23767 = state_23648__$1;
(statearr_23654_23767[(2)] = inst_23632);

(statearr_23654_23767[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23649 === (6))){
var inst_23634 = (state_23648[(8)]);
var inst_23629 = (state_23648[(7)]);
var inst_23634__$1 = cljs.core.async.chan.call(null,(1));
var inst_23635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23636 = [inst_23629,inst_23634__$1];
var inst_23637 = (new cljs.core.PersistentVector(null,2,(5),inst_23635,inst_23636,null));
var state_23648__$1 = (function (){var statearr_23655 = state_23648;
(statearr_23655[(8)] = inst_23634__$1);

return statearr_23655;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23648__$1,(8),jobs,inst_23637);
} else {
if((state_val_23649 === (7))){
var inst_23644 = (state_23648[(2)]);
var state_23648__$1 = state_23648;
var statearr_23656_23768 = state_23648__$1;
(statearr_23656_23768[(2)] = inst_23644);

(statearr_23656_23768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23649 === (8))){
var inst_23634 = (state_23648[(8)]);
var inst_23639 = (state_23648[(2)]);
var state_23648__$1 = (function (){var statearr_23657 = state_23648;
(statearr_23657[(9)] = inst_23639);

return statearr_23657;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23648__$1,(9),results,inst_23634);
} else {
if((state_val_23649 === (9))){
var inst_23641 = (state_23648[(2)]);
var state_23648__$1 = (function (){var statearr_23658 = state_23648;
(statearr_23658[(10)] = inst_23641);

return statearr_23658;
})();
var statearr_23659_23769 = state_23648__$1;
(statearr_23659_23769[(2)] = null);

(statearr_23659_23769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___23763,jobs,results,process,async))
;
return ((function (switch__22336__auto__,c__23179__auto___23763,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_23663 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23663[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__);

(statearr_23663[(1)] = (1));

return statearr_23663;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1 = (function (state_23648){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23664){if((e23664 instanceof Object)){
var ex__22340__auto__ = e23664;
var statearr_23665_23770 = state_23648;
(statearr_23665_23770[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23648);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23664;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23771 = state_23648;
state_23648 = G__23771;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = function(state_23648){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1.call(this,state_23648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___23763,jobs,results,process,async))
})();
var state__23181__auto__ = (function (){var statearr_23666 = f__23180__auto__.call(null);
(statearr_23666[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___23763);

return statearr_23666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___23763,jobs,results,process,async))
);


var c__23179__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto__,jobs,results,process,async){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto__,jobs,results,process,async){
return (function (state_23704){
var state_val_23705 = (state_23704[(1)]);
if((state_val_23705 === (7))){
var inst_23700 = (state_23704[(2)]);
var state_23704__$1 = state_23704;
var statearr_23706_23772 = state_23704__$1;
(statearr_23706_23772[(2)] = inst_23700);

(statearr_23706_23772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (20))){
var state_23704__$1 = state_23704;
var statearr_23707_23773 = state_23704__$1;
(statearr_23707_23773[(2)] = null);

(statearr_23707_23773[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (1))){
var state_23704__$1 = state_23704;
var statearr_23708_23774 = state_23704__$1;
(statearr_23708_23774[(2)] = null);

(statearr_23708_23774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (4))){
var inst_23669 = (state_23704[(7)]);
var inst_23669__$1 = (state_23704[(2)]);
var inst_23670 = (inst_23669__$1 == null);
var state_23704__$1 = (function (){var statearr_23709 = state_23704;
(statearr_23709[(7)] = inst_23669__$1);

return statearr_23709;
})();
if(cljs.core.truth_(inst_23670)){
var statearr_23710_23775 = state_23704__$1;
(statearr_23710_23775[(1)] = (5));

} else {
var statearr_23711_23776 = state_23704__$1;
(statearr_23711_23776[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (15))){
var inst_23682 = (state_23704[(8)]);
var state_23704__$1 = state_23704;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23704__$1,(18),to,inst_23682);
} else {
if((state_val_23705 === (21))){
var inst_23695 = (state_23704[(2)]);
var state_23704__$1 = state_23704;
var statearr_23712_23777 = state_23704__$1;
(statearr_23712_23777[(2)] = inst_23695);

(statearr_23712_23777[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (13))){
var inst_23697 = (state_23704[(2)]);
var state_23704__$1 = (function (){var statearr_23713 = state_23704;
(statearr_23713[(9)] = inst_23697);

return statearr_23713;
})();
var statearr_23714_23778 = state_23704__$1;
(statearr_23714_23778[(2)] = null);

(statearr_23714_23778[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (6))){
var inst_23669 = (state_23704[(7)]);
var state_23704__$1 = state_23704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23704__$1,(11),inst_23669);
} else {
if((state_val_23705 === (17))){
var inst_23690 = (state_23704[(2)]);
var state_23704__$1 = state_23704;
if(cljs.core.truth_(inst_23690)){
var statearr_23715_23779 = state_23704__$1;
(statearr_23715_23779[(1)] = (19));

} else {
var statearr_23716_23780 = state_23704__$1;
(statearr_23716_23780[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (3))){
var inst_23702 = (state_23704[(2)]);
var state_23704__$1 = state_23704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23704__$1,inst_23702);
} else {
if((state_val_23705 === (12))){
var inst_23679 = (state_23704[(10)]);
var state_23704__$1 = state_23704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23704__$1,(14),inst_23679);
} else {
if((state_val_23705 === (2))){
var state_23704__$1 = state_23704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23704__$1,(4),results);
} else {
if((state_val_23705 === (19))){
var state_23704__$1 = state_23704;
var statearr_23717_23781 = state_23704__$1;
(statearr_23717_23781[(2)] = null);

(statearr_23717_23781[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (11))){
var inst_23679 = (state_23704[(2)]);
var state_23704__$1 = (function (){var statearr_23718 = state_23704;
(statearr_23718[(10)] = inst_23679);

return statearr_23718;
})();
var statearr_23719_23782 = state_23704__$1;
(statearr_23719_23782[(2)] = null);

(statearr_23719_23782[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (9))){
var state_23704__$1 = state_23704;
var statearr_23720_23783 = state_23704__$1;
(statearr_23720_23783[(2)] = null);

(statearr_23720_23783[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (5))){
var state_23704__$1 = state_23704;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23721_23784 = state_23704__$1;
(statearr_23721_23784[(1)] = (8));

} else {
var statearr_23722_23785 = state_23704__$1;
(statearr_23722_23785[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (14))){
var inst_23682 = (state_23704[(8)]);
var inst_23684 = (state_23704[(11)]);
var inst_23682__$1 = (state_23704[(2)]);
var inst_23683 = (inst_23682__$1 == null);
var inst_23684__$1 = cljs.core.not.call(null,inst_23683);
var state_23704__$1 = (function (){var statearr_23723 = state_23704;
(statearr_23723[(8)] = inst_23682__$1);

(statearr_23723[(11)] = inst_23684__$1);

return statearr_23723;
})();
if(inst_23684__$1){
var statearr_23724_23786 = state_23704__$1;
(statearr_23724_23786[(1)] = (15));

} else {
var statearr_23725_23787 = state_23704__$1;
(statearr_23725_23787[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (16))){
var inst_23684 = (state_23704[(11)]);
var state_23704__$1 = state_23704;
var statearr_23726_23788 = state_23704__$1;
(statearr_23726_23788[(2)] = inst_23684);

(statearr_23726_23788[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (10))){
var inst_23676 = (state_23704[(2)]);
var state_23704__$1 = state_23704;
var statearr_23727_23789 = state_23704__$1;
(statearr_23727_23789[(2)] = inst_23676);

(statearr_23727_23789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (18))){
var inst_23687 = (state_23704[(2)]);
var state_23704__$1 = state_23704;
var statearr_23728_23790 = state_23704__$1;
(statearr_23728_23790[(2)] = inst_23687);

(statearr_23728_23790[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23705 === (8))){
var inst_23673 = cljs.core.async.close_BANG_.call(null,to);
var state_23704__$1 = state_23704;
var statearr_23729_23791 = state_23704__$1;
(statearr_23729_23791[(2)] = inst_23673);

(statearr_23729_23791[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto__,jobs,results,process,async))
;
return ((function (switch__22336__auto__,c__23179__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_23733 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23733[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__);

(statearr_23733[(1)] = (1));

return statearr_23733;
});
var cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1 = (function (state_23704){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23734){if((e23734 instanceof Object)){
var ex__22340__auto__ = e23734;
var statearr_23735_23792 = state_23704;
(statearr_23735_23792[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23704);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23734;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23793 = state_23704;
state_23704 = G__23793;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__ = function(state_23704){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1.call(this,state_23704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto__,jobs,results,process,async))
})();
var state__23181__auto__ = (function (){var statearr_23736 = f__23180__auto__.call(null);
(statearr_23736[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto__);

return statearr_23736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto__,jobs,results,process,async))
);

return c__23179__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args23794 = [];
var len__21393__auto___23797 = arguments.length;
var i__21394__auto___23798 = (0);
while(true){
if((i__21394__auto___23798 < len__21393__auto___23797)){
args23794.push((arguments[i__21394__auto___23798]));

var G__23799 = (i__21394__auto___23798 + (1));
i__21394__auto___23798 = G__23799;
continue;
} else {
}
break;
}

var G__23796 = args23794.length;
switch (G__23796) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23794.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args23801 = [];
var len__21393__auto___23804 = arguments.length;
var i__21394__auto___23805 = (0);
while(true){
if((i__21394__auto___23805 < len__21393__auto___23804)){
args23801.push((arguments[i__21394__auto___23805]));

var G__23806 = (i__21394__auto___23805 + (1));
i__21394__auto___23805 = G__23806;
continue;
} else {
}
break;
}

var G__23803 = args23801.length;
switch (G__23803) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23801.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args23808 = [];
var len__21393__auto___23861 = arguments.length;
var i__21394__auto___23862 = (0);
while(true){
if((i__21394__auto___23862 < len__21393__auto___23861)){
args23808.push((arguments[i__21394__auto___23862]));

var G__23863 = (i__21394__auto___23862 + (1));
i__21394__auto___23862 = G__23863;
continue;
} else {
}
break;
}

var G__23810 = args23808.length;
switch (G__23810) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23808.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__23179__auto___23865 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___23865,tc,fc){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___23865,tc,fc){
return (function (state_23836){
var state_val_23837 = (state_23836[(1)]);
if((state_val_23837 === (7))){
var inst_23832 = (state_23836[(2)]);
var state_23836__$1 = state_23836;
var statearr_23838_23866 = state_23836__$1;
(statearr_23838_23866[(2)] = inst_23832);

(statearr_23838_23866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23837 === (1))){
var state_23836__$1 = state_23836;
var statearr_23839_23867 = state_23836__$1;
(statearr_23839_23867[(2)] = null);

(statearr_23839_23867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23837 === (4))){
var inst_23813 = (state_23836[(7)]);
var inst_23813__$1 = (state_23836[(2)]);
var inst_23814 = (inst_23813__$1 == null);
var state_23836__$1 = (function (){var statearr_23840 = state_23836;
(statearr_23840[(7)] = inst_23813__$1);

return statearr_23840;
})();
if(cljs.core.truth_(inst_23814)){
var statearr_23841_23868 = state_23836__$1;
(statearr_23841_23868[(1)] = (5));

} else {
var statearr_23842_23869 = state_23836__$1;
(statearr_23842_23869[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23837 === (13))){
var state_23836__$1 = state_23836;
var statearr_23843_23870 = state_23836__$1;
(statearr_23843_23870[(2)] = null);

(statearr_23843_23870[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23837 === (6))){
var inst_23813 = (state_23836[(7)]);
var inst_23819 = p.call(null,inst_23813);
var state_23836__$1 = state_23836;
if(cljs.core.truth_(inst_23819)){
var statearr_23844_23871 = state_23836__$1;
(statearr_23844_23871[(1)] = (9));

} else {
var statearr_23845_23872 = state_23836__$1;
(statearr_23845_23872[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23837 === (3))){
var inst_23834 = (state_23836[(2)]);
var state_23836__$1 = state_23836;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23836__$1,inst_23834);
} else {
if((state_val_23837 === (12))){
var state_23836__$1 = state_23836;
var statearr_23846_23873 = state_23836__$1;
(statearr_23846_23873[(2)] = null);

(statearr_23846_23873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23837 === (2))){
var state_23836__$1 = state_23836;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23836__$1,(4),ch);
} else {
if((state_val_23837 === (11))){
var inst_23813 = (state_23836[(7)]);
var inst_23823 = (state_23836[(2)]);
var state_23836__$1 = state_23836;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23836__$1,(8),inst_23823,inst_23813);
} else {
if((state_val_23837 === (9))){
var state_23836__$1 = state_23836;
var statearr_23847_23874 = state_23836__$1;
(statearr_23847_23874[(2)] = tc);

(statearr_23847_23874[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23837 === (5))){
var inst_23816 = cljs.core.async.close_BANG_.call(null,tc);
var inst_23817 = cljs.core.async.close_BANG_.call(null,fc);
var state_23836__$1 = (function (){var statearr_23848 = state_23836;
(statearr_23848[(8)] = inst_23816);

return statearr_23848;
})();
var statearr_23849_23875 = state_23836__$1;
(statearr_23849_23875[(2)] = inst_23817);

(statearr_23849_23875[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23837 === (14))){
var inst_23830 = (state_23836[(2)]);
var state_23836__$1 = state_23836;
var statearr_23850_23876 = state_23836__$1;
(statearr_23850_23876[(2)] = inst_23830);

(statearr_23850_23876[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23837 === (10))){
var state_23836__$1 = state_23836;
var statearr_23851_23877 = state_23836__$1;
(statearr_23851_23877[(2)] = fc);

(statearr_23851_23877[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23837 === (8))){
var inst_23825 = (state_23836[(2)]);
var state_23836__$1 = state_23836;
if(cljs.core.truth_(inst_23825)){
var statearr_23852_23878 = state_23836__$1;
(statearr_23852_23878[(1)] = (12));

} else {
var statearr_23853_23879 = state_23836__$1;
(statearr_23853_23879[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___23865,tc,fc))
;
return ((function (switch__22336__auto__,c__23179__auto___23865,tc,fc){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_23857 = [null,null,null,null,null,null,null,null,null];
(statearr_23857[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_23857[(1)] = (1));

return statearr_23857;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_23836){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23836);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23858){if((e23858 instanceof Object)){
var ex__22340__auto__ = e23858;
var statearr_23859_23880 = state_23836;
(statearr_23859_23880[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23836);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23858;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23881 = state_23836;
state_23836 = G__23881;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_23836){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_23836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___23865,tc,fc))
})();
var state__23181__auto__ = (function (){var statearr_23860 = f__23180__auto__.call(null);
(statearr_23860[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___23865);

return statearr_23860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___23865,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__23179__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto__){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto__){
return (function (state_23945){
var state_val_23946 = (state_23945[(1)]);
if((state_val_23946 === (7))){
var inst_23941 = (state_23945[(2)]);
var state_23945__$1 = state_23945;
var statearr_23947_23968 = state_23945__$1;
(statearr_23947_23968[(2)] = inst_23941);

(statearr_23947_23968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23946 === (1))){
var inst_23925 = init;
var state_23945__$1 = (function (){var statearr_23948 = state_23945;
(statearr_23948[(7)] = inst_23925);

return statearr_23948;
})();
var statearr_23949_23969 = state_23945__$1;
(statearr_23949_23969[(2)] = null);

(statearr_23949_23969[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23946 === (4))){
var inst_23928 = (state_23945[(8)]);
var inst_23928__$1 = (state_23945[(2)]);
var inst_23929 = (inst_23928__$1 == null);
var state_23945__$1 = (function (){var statearr_23950 = state_23945;
(statearr_23950[(8)] = inst_23928__$1);

return statearr_23950;
})();
if(cljs.core.truth_(inst_23929)){
var statearr_23951_23970 = state_23945__$1;
(statearr_23951_23970[(1)] = (5));

} else {
var statearr_23952_23971 = state_23945__$1;
(statearr_23952_23971[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23946 === (6))){
var inst_23925 = (state_23945[(7)]);
var inst_23932 = (state_23945[(9)]);
var inst_23928 = (state_23945[(8)]);
var inst_23932__$1 = f.call(null,inst_23925,inst_23928);
var inst_23933 = cljs.core.reduced_QMARK_.call(null,inst_23932__$1);
var state_23945__$1 = (function (){var statearr_23953 = state_23945;
(statearr_23953[(9)] = inst_23932__$1);

return statearr_23953;
})();
if(inst_23933){
var statearr_23954_23972 = state_23945__$1;
(statearr_23954_23972[(1)] = (8));

} else {
var statearr_23955_23973 = state_23945__$1;
(statearr_23955_23973[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23946 === (3))){
var inst_23943 = (state_23945[(2)]);
var state_23945__$1 = state_23945;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23945__$1,inst_23943);
} else {
if((state_val_23946 === (2))){
var state_23945__$1 = state_23945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23945__$1,(4),ch);
} else {
if((state_val_23946 === (9))){
var inst_23932 = (state_23945[(9)]);
var inst_23925 = inst_23932;
var state_23945__$1 = (function (){var statearr_23956 = state_23945;
(statearr_23956[(7)] = inst_23925);

return statearr_23956;
})();
var statearr_23957_23974 = state_23945__$1;
(statearr_23957_23974[(2)] = null);

(statearr_23957_23974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23946 === (5))){
var inst_23925 = (state_23945[(7)]);
var state_23945__$1 = state_23945;
var statearr_23958_23975 = state_23945__$1;
(statearr_23958_23975[(2)] = inst_23925);

(statearr_23958_23975[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23946 === (10))){
var inst_23939 = (state_23945[(2)]);
var state_23945__$1 = state_23945;
var statearr_23959_23976 = state_23945__$1;
(statearr_23959_23976[(2)] = inst_23939);

(statearr_23959_23976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23946 === (8))){
var inst_23932 = (state_23945[(9)]);
var inst_23935 = cljs.core.deref.call(null,inst_23932);
var state_23945__$1 = state_23945;
var statearr_23960_23977 = state_23945__$1;
(statearr_23960_23977[(2)] = inst_23935);

(statearr_23960_23977[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto__))
;
return ((function (switch__22336__auto__,c__23179__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__22337__auto__ = null;
var cljs$core$async$reduce_$_state_machine__22337__auto____0 = (function (){
var statearr_23964 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23964[(0)] = cljs$core$async$reduce_$_state_machine__22337__auto__);

(statearr_23964[(1)] = (1));

return statearr_23964;
});
var cljs$core$async$reduce_$_state_machine__22337__auto____1 = (function (state_23945){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23945);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e23965){if((e23965 instanceof Object)){
var ex__22340__auto__ = e23965;
var statearr_23966_23978 = state_23945;
(statearr_23966_23978[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23945);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23965;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23979 = state_23945;
state_23945 = G__23979;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__22337__auto__ = function(state_23945){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__22337__auto____1.call(this,state_23945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__22337__auto____0;
cljs$core$async$reduce_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__22337__auto____1;
return cljs$core$async$reduce_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto__))
})();
var state__23181__auto__ = (function (){var statearr_23967 = f__23180__auto__.call(null);
(statearr_23967[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto__);

return statearr_23967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto__))
);

return c__23179__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__23179__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto__,f__$1){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto__,f__$1){
return (function (state_23999){
var state_val_24000 = (state_23999[(1)]);
if((state_val_24000 === (1))){
var inst_23994 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_23999__$1 = state_23999;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23999__$1,(2),inst_23994);
} else {
if((state_val_24000 === (2))){
var inst_23996 = (state_23999[(2)]);
var inst_23997 = f__$1.call(null,inst_23996);
var state_23999__$1 = state_23999;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23999__$1,inst_23997);
} else {
return null;
}
}
});})(c__23179__auto__,f__$1))
;
return ((function (switch__22336__auto__,c__23179__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__22337__auto__ = null;
var cljs$core$async$transduce_$_state_machine__22337__auto____0 = (function (){
var statearr_24004 = [null,null,null,null,null,null,null];
(statearr_24004[(0)] = cljs$core$async$transduce_$_state_machine__22337__auto__);

(statearr_24004[(1)] = (1));

return statearr_24004;
});
var cljs$core$async$transduce_$_state_machine__22337__auto____1 = (function (state_23999){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_23999);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e24005){if((e24005 instanceof Object)){
var ex__22340__auto__ = e24005;
var statearr_24006_24008 = state_23999;
(statearr_24006_24008[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_23999);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24005;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24009 = state_23999;
state_23999 = G__24009;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__22337__auto__ = function(state_23999){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__22337__auto____1.call(this,state_23999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__22337__auto____0;
cljs$core$async$transduce_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__22337__auto____1;
return cljs$core$async$transduce_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto__,f__$1))
})();
var state__23181__auto__ = (function (){var statearr_24007 = f__23180__auto__.call(null);
(statearr_24007[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto__);

return statearr_24007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto__,f__$1))
);

return c__23179__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args24010 = [];
var len__21393__auto___24062 = arguments.length;
var i__21394__auto___24063 = (0);
while(true){
if((i__21394__auto___24063 < len__21393__auto___24062)){
args24010.push((arguments[i__21394__auto___24063]));

var G__24064 = (i__21394__auto___24063 + (1));
i__21394__auto___24063 = G__24064;
continue;
} else {
}
break;
}

var G__24012 = args24010.length;
switch (G__24012) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24010.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__23179__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto__){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto__){
return (function (state_24037){
var state_val_24038 = (state_24037[(1)]);
if((state_val_24038 === (7))){
var inst_24019 = (state_24037[(2)]);
var state_24037__$1 = state_24037;
var statearr_24039_24066 = state_24037__$1;
(statearr_24039_24066[(2)] = inst_24019);

(statearr_24039_24066[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24038 === (1))){
var inst_24013 = cljs.core.seq.call(null,coll);
var inst_24014 = inst_24013;
var state_24037__$1 = (function (){var statearr_24040 = state_24037;
(statearr_24040[(7)] = inst_24014);

return statearr_24040;
})();
var statearr_24041_24067 = state_24037__$1;
(statearr_24041_24067[(2)] = null);

(statearr_24041_24067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24038 === (4))){
var inst_24014 = (state_24037[(7)]);
var inst_24017 = cljs.core.first.call(null,inst_24014);
var state_24037__$1 = state_24037;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24037__$1,(7),ch,inst_24017);
} else {
if((state_val_24038 === (13))){
var inst_24031 = (state_24037[(2)]);
var state_24037__$1 = state_24037;
var statearr_24042_24068 = state_24037__$1;
(statearr_24042_24068[(2)] = inst_24031);

(statearr_24042_24068[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24038 === (6))){
var inst_24022 = (state_24037[(2)]);
var state_24037__$1 = state_24037;
if(cljs.core.truth_(inst_24022)){
var statearr_24043_24069 = state_24037__$1;
(statearr_24043_24069[(1)] = (8));

} else {
var statearr_24044_24070 = state_24037__$1;
(statearr_24044_24070[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24038 === (3))){
var inst_24035 = (state_24037[(2)]);
var state_24037__$1 = state_24037;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24037__$1,inst_24035);
} else {
if((state_val_24038 === (12))){
var state_24037__$1 = state_24037;
var statearr_24045_24071 = state_24037__$1;
(statearr_24045_24071[(2)] = null);

(statearr_24045_24071[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24038 === (2))){
var inst_24014 = (state_24037[(7)]);
var state_24037__$1 = state_24037;
if(cljs.core.truth_(inst_24014)){
var statearr_24046_24072 = state_24037__$1;
(statearr_24046_24072[(1)] = (4));

} else {
var statearr_24047_24073 = state_24037__$1;
(statearr_24047_24073[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24038 === (11))){
var inst_24028 = cljs.core.async.close_BANG_.call(null,ch);
var state_24037__$1 = state_24037;
var statearr_24048_24074 = state_24037__$1;
(statearr_24048_24074[(2)] = inst_24028);

(statearr_24048_24074[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24038 === (9))){
var state_24037__$1 = state_24037;
if(cljs.core.truth_(close_QMARK_)){
var statearr_24049_24075 = state_24037__$1;
(statearr_24049_24075[(1)] = (11));

} else {
var statearr_24050_24076 = state_24037__$1;
(statearr_24050_24076[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24038 === (5))){
var inst_24014 = (state_24037[(7)]);
var state_24037__$1 = state_24037;
var statearr_24051_24077 = state_24037__$1;
(statearr_24051_24077[(2)] = inst_24014);

(statearr_24051_24077[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24038 === (10))){
var inst_24033 = (state_24037[(2)]);
var state_24037__$1 = state_24037;
var statearr_24052_24078 = state_24037__$1;
(statearr_24052_24078[(2)] = inst_24033);

(statearr_24052_24078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24038 === (8))){
var inst_24014 = (state_24037[(7)]);
var inst_24024 = cljs.core.next.call(null,inst_24014);
var inst_24014__$1 = inst_24024;
var state_24037__$1 = (function (){var statearr_24053 = state_24037;
(statearr_24053[(7)] = inst_24014__$1);

return statearr_24053;
})();
var statearr_24054_24079 = state_24037__$1;
(statearr_24054_24079[(2)] = null);

(statearr_24054_24079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto__))
;
return ((function (switch__22336__auto__,c__23179__auto__){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_24058 = [null,null,null,null,null,null,null,null];
(statearr_24058[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_24058[(1)] = (1));

return statearr_24058;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_24037){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_24037);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e24059){if((e24059 instanceof Object)){
var ex__22340__auto__ = e24059;
var statearr_24060_24080 = state_24037;
(statearr_24060_24080[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24037);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24059;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24081 = state_24037;
state_24037 = G__24081;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_24037){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_24037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto__))
})();
var state__23181__auto__ = (function (){var statearr_24061 = f__23180__auto__.call(null);
(statearr_24061[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto__);

return statearr_24061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto__))
);

return c__23179__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__20948__auto__ = (((_ == null))?null:_);
var m__20949__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,_);
} else {
var m__20949__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__20949__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,ch);
} else {
var m__20949__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m);
} else {
var m__20949__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async24307 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24307 = (function (ch,cs,meta24308){
this.ch = ch;
this.cs = cs;
this.meta24308 = meta24308;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24307.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_24309,meta24308__$1){
var self__ = this;
var _24309__$1 = this;
return (new cljs.core.async.t_cljs$core$async24307(self__.ch,self__.cs,meta24308__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async24307.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_24309){
var self__ = this;
var _24309__$1 = this;
return self__.meta24308;
});})(cs))
;

cljs.core.async.t_cljs$core$async24307.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24307.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async24307.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24307.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24307.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24307.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async24307.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta24308","meta24308",1713287287,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async24307.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24307.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24307";

cljs.core.async.t_cljs$core$async24307.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async24307");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async24307 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async24307(ch__$1,cs__$1,meta24308){
return (new cljs.core.async.t_cljs$core$async24307(ch__$1,cs__$1,meta24308));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async24307(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__23179__auto___24532 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___24532,cs,m,dchan,dctr,done){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___24532,cs,m,dchan,dctr,done){
return (function (state_24444){
var state_val_24445 = (state_24444[(1)]);
if((state_val_24445 === (7))){
var inst_24440 = (state_24444[(2)]);
var state_24444__$1 = state_24444;
var statearr_24446_24533 = state_24444__$1;
(statearr_24446_24533[(2)] = inst_24440);

(statearr_24446_24533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (20))){
var inst_24343 = (state_24444[(7)]);
var inst_24355 = cljs.core.first.call(null,inst_24343);
var inst_24356 = cljs.core.nth.call(null,inst_24355,(0),null);
var inst_24357 = cljs.core.nth.call(null,inst_24355,(1),null);
var state_24444__$1 = (function (){var statearr_24447 = state_24444;
(statearr_24447[(8)] = inst_24356);

return statearr_24447;
})();
if(cljs.core.truth_(inst_24357)){
var statearr_24448_24534 = state_24444__$1;
(statearr_24448_24534[(1)] = (22));

} else {
var statearr_24449_24535 = state_24444__$1;
(statearr_24449_24535[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (27))){
var inst_24392 = (state_24444[(9)]);
var inst_24385 = (state_24444[(10)]);
var inst_24387 = (state_24444[(11)]);
var inst_24312 = (state_24444[(12)]);
var inst_24392__$1 = cljs.core._nth.call(null,inst_24385,inst_24387);
var inst_24393 = cljs.core.async.put_BANG_.call(null,inst_24392__$1,inst_24312,done);
var state_24444__$1 = (function (){var statearr_24450 = state_24444;
(statearr_24450[(9)] = inst_24392__$1);

return statearr_24450;
})();
if(cljs.core.truth_(inst_24393)){
var statearr_24451_24536 = state_24444__$1;
(statearr_24451_24536[(1)] = (30));

} else {
var statearr_24452_24537 = state_24444__$1;
(statearr_24452_24537[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (1))){
var state_24444__$1 = state_24444;
var statearr_24453_24538 = state_24444__$1;
(statearr_24453_24538[(2)] = null);

(statearr_24453_24538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (24))){
var inst_24343 = (state_24444[(7)]);
var inst_24362 = (state_24444[(2)]);
var inst_24363 = cljs.core.next.call(null,inst_24343);
var inst_24321 = inst_24363;
var inst_24322 = null;
var inst_24323 = (0);
var inst_24324 = (0);
var state_24444__$1 = (function (){var statearr_24454 = state_24444;
(statearr_24454[(13)] = inst_24324);

(statearr_24454[(14)] = inst_24322);

(statearr_24454[(15)] = inst_24321);

(statearr_24454[(16)] = inst_24323);

(statearr_24454[(17)] = inst_24362);

return statearr_24454;
})();
var statearr_24455_24539 = state_24444__$1;
(statearr_24455_24539[(2)] = null);

(statearr_24455_24539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (39))){
var state_24444__$1 = state_24444;
var statearr_24459_24540 = state_24444__$1;
(statearr_24459_24540[(2)] = null);

(statearr_24459_24540[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (4))){
var inst_24312 = (state_24444[(12)]);
var inst_24312__$1 = (state_24444[(2)]);
var inst_24313 = (inst_24312__$1 == null);
var state_24444__$1 = (function (){var statearr_24460 = state_24444;
(statearr_24460[(12)] = inst_24312__$1);

return statearr_24460;
})();
if(cljs.core.truth_(inst_24313)){
var statearr_24461_24541 = state_24444__$1;
(statearr_24461_24541[(1)] = (5));

} else {
var statearr_24462_24542 = state_24444__$1;
(statearr_24462_24542[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (15))){
var inst_24324 = (state_24444[(13)]);
var inst_24322 = (state_24444[(14)]);
var inst_24321 = (state_24444[(15)]);
var inst_24323 = (state_24444[(16)]);
var inst_24339 = (state_24444[(2)]);
var inst_24340 = (inst_24324 + (1));
var tmp24456 = inst_24322;
var tmp24457 = inst_24321;
var tmp24458 = inst_24323;
var inst_24321__$1 = tmp24457;
var inst_24322__$1 = tmp24456;
var inst_24323__$1 = tmp24458;
var inst_24324__$1 = inst_24340;
var state_24444__$1 = (function (){var statearr_24463 = state_24444;
(statearr_24463[(13)] = inst_24324__$1);

(statearr_24463[(18)] = inst_24339);

(statearr_24463[(14)] = inst_24322__$1);

(statearr_24463[(15)] = inst_24321__$1);

(statearr_24463[(16)] = inst_24323__$1);

return statearr_24463;
})();
var statearr_24464_24543 = state_24444__$1;
(statearr_24464_24543[(2)] = null);

(statearr_24464_24543[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (21))){
var inst_24366 = (state_24444[(2)]);
var state_24444__$1 = state_24444;
var statearr_24468_24544 = state_24444__$1;
(statearr_24468_24544[(2)] = inst_24366);

(statearr_24468_24544[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (31))){
var inst_24392 = (state_24444[(9)]);
var inst_24396 = done.call(null,null);
var inst_24397 = cljs.core.async.untap_STAR_.call(null,m,inst_24392);
var state_24444__$1 = (function (){var statearr_24469 = state_24444;
(statearr_24469[(19)] = inst_24396);

return statearr_24469;
})();
var statearr_24470_24545 = state_24444__$1;
(statearr_24470_24545[(2)] = inst_24397);

(statearr_24470_24545[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (32))){
var inst_24384 = (state_24444[(20)]);
var inst_24385 = (state_24444[(10)]);
var inst_24386 = (state_24444[(21)]);
var inst_24387 = (state_24444[(11)]);
var inst_24399 = (state_24444[(2)]);
var inst_24400 = (inst_24387 + (1));
var tmp24465 = inst_24384;
var tmp24466 = inst_24385;
var tmp24467 = inst_24386;
var inst_24384__$1 = tmp24465;
var inst_24385__$1 = tmp24466;
var inst_24386__$1 = tmp24467;
var inst_24387__$1 = inst_24400;
var state_24444__$1 = (function (){var statearr_24471 = state_24444;
(statearr_24471[(20)] = inst_24384__$1);

(statearr_24471[(10)] = inst_24385__$1);

(statearr_24471[(21)] = inst_24386__$1);

(statearr_24471[(11)] = inst_24387__$1);

(statearr_24471[(22)] = inst_24399);

return statearr_24471;
})();
var statearr_24472_24546 = state_24444__$1;
(statearr_24472_24546[(2)] = null);

(statearr_24472_24546[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (40))){
var inst_24412 = (state_24444[(23)]);
var inst_24416 = done.call(null,null);
var inst_24417 = cljs.core.async.untap_STAR_.call(null,m,inst_24412);
var state_24444__$1 = (function (){var statearr_24473 = state_24444;
(statearr_24473[(24)] = inst_24416);

return statearr_24473;
})();
var statearr_24474_24547 = state_24444__$1;
(statearr_24474_24547[(2)] = inst_24417);

(statearr_24474_24547[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (33))){
var inst_24403 = (state_24444[(25)]);
var inst_24405 = cljs.core.chunked_seq_QMARK_.call(null,inst_24403);
var state_24444__$1 = state_24444;
if(inst_24405){
var statearr_24475_24548 = state_24444__$1;
(statearr_24475_24548[(1)] = (36));

} else {
var statearr_24476_24549 = state_24444__$1;
(statearr_24476_24549[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (13))){
var inst_24333 = (state_24444[(26)]);
var inst_24336 = cljs.core.async.close_BANG_.call(null,inst_24333);
var state_24444__$1 = state_24444;
var statearr_24477_24550 = state_24444__$1;
(statearr_24477_24550[(2)] = inst_24336);

(statearr_24477_24550[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (22))){
var inst_24356 = (state_24444[(8)]);
var inst_24359 = cljs.core.async.close_BANG_.call(null,inst_24356);
var state_24444__$1 = state_24444;
var statearr_24478_24551 = state_24444__$1;
(statearr_24478_24551[(2)] = inst_24359);

(statearr_24478_24551[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (36))){
var inst_24403 = (state_24444[(25)]);
var inst_24407 = cljs.core.chunk_first.call(null,inst_24403);
var inst_24408 = cljs.core.chunk_rest.call(null,inst_24403);
var inst_24409 = cljs.core.count.call(null,inst_24407);
var inst_24384 = inst_24408;
var inst_24385 = inst_24407;
var inst_24386 = inst_24409;
var inst_24387 = (0);
var state_24444__$1 = (function (){var statearr_24479 = state_24444;
(statearr_24479[(20)] = inst_24384);

(statearr_24479[(10)] = inst_24385);

(statearr_24479[(21)] = inst_24386);

(statearr_24479[(11)] = inst_24387);

return statearr_24479;
})();
var statearr_24480_24552 = state_24444__$1;
(statearr_24480_24552[(2)] = null);

(statearr_24480_24552[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (41))){
var inst_24403 = (state_24444[(25)]);
var inst_24419 = (state_24444[(2)]);
var inst_24420 = cljs.core.next.call(null,inst_24403);
var inst_24384 = inst_24420;
var inst_24385 = null;
var inst_24386 = (0);
var inst_24387 = (0);
var state_24444__$1 = (function (){var statearr_24481 = state_24444;
(statearr_24481[(20)] = inst_24384);

(statearr_24481[(10)] = inst_24385);

(statearr_24481[(21)] = inst_24386);

(statearr_24481[(11)] = inst_24387);

(statearr_24481[(27)] = inst_24419);

return statearr_24481;
})();
var statearr_24482_24553 = state_24444__$1;
(statearr_24482_24553[(2)] = null);

(statearr_24482_24553[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (43))){
var state_24444__$1 = state_24444;
var statearr_24483_24554 = state_24444__$1;
(statearr_24483_24554[(2)] = null);

(statearr_24483_24554[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (29))){
var inst_24428 = (state_24444[(2)]);
var state_24444__$1 = state_24444;
var statearr_24484_24555 = state_24444__$1;
(statearr_24484_24555[(2)] = inst_24428);

(statearr_24484_24555[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (44))){
var inst_24437 = (state_24444[(2)]);
var state_24444__$1 = (function (){var statearr_24485 = state_24444;
(statearr_24485[(28)] = inst_24437);

return statearr_24485;
})();
var statearr_24486_24556 = state_24444__$1;
(statearr_24486_24556[(2)] = null);

(statearr_24486_24556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (6))){
var inst_24376 = (state_24444[(29)]);
var inst_24375 = cljs.core.deref.call(null,cs);
var inst_24376__$1 = cljs.core.keys.call(null,inst_24375);
var inst_24377 = cljs.core.count.call(null,inst_24376__$1);
var inst_24378 = cljs.core.reset_BANG_.call(null,dctr,inst_24377);
var inst_24383 = cljs.core.seq.call(null,inst_24376__$1);
var inst_24384 = inst_24383;
var inst_24385 = null;
var inst_24386 = (0);
var inst_24387 = (0);
var state_24444__$1 = (function (){var statearr_24487 = state_24444;
(statearr_24487[(20)] = inst_24384);

(statearr_24487[(10)] = inst_24385);

(statearr_24487[(29)] = inst_24376__$1);

(statearr_24487[(21)] = inst_24386);

(statearr_24487[(11)] = inst_24387);

(statearr_24487[(30)] = inst_24378);

return statearr_24487;
})();
var statearr_24488_24557 = state_24444__$1;
(statearr_24488_24557[(2)] = null);

(statearr_24488_24557[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (28))){
var inst_24384 = (state_24444[(20)]);
var inst_24403 = (state_24444[(25)]);
var inst_24403__$1 = cljs.core.seq.call(null,inst_24384);
var state_24444__$1 = (function (){var statearr_24489 = state_24444;
(statearr_24489[(25)] = inst_24403__$1);

return statearr_24489;
})();
if(inst_24403__$1){
var statearr_24490_24558 = state_24444__$1;
(statearr_24490_24558[(1)] = (33));

} else {
var statearr_24491_24559 = state_24444__$1;
(statearr_24491_24559[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (25))){
var inst_24386 = (state_24444[(21)]);
var inst_24387 = (state_24444[(11)]);
var inst_24389 = (inst_24387 < inst_24386);
var inst_24390 = inst_24389;
var state_24444__$1 = state_24444;
if(cljs.core.truth_(inst_24390)){
var statearr_24492_24560 = state_24444__$1;
(statearr_24492_24560[(1)] = (27));

} else {
var statearr_24493_24561 = state_24444__$1;
(statearr_24493_24561[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (34))){
var state_24444__$1 = state_24444;
var statearr_24494_24562 = state_24444__$1;
(statearr_24494_24562[(2)] = null);

(statearr_24494_24562[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (17))){
var state_24444__$1 = state_24444;
var statearr_24495_24563 = state_24444__$1;
(statearr_24495_24563[(2)] = null);

(statearr_24495_24563[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (3))){
var inst_24442 = (state_24444[(2)]);
var state_24444__$1 = state_24444;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24444__$1,inst_24442);
} else {
if((state_val_24445 === (12))){
var inst_24371 = (state_24444[(2)]);
var state_24444__$1 = state_24444;
var statearr_24496_24564 = state_24444__$1;
(statearr_24496_24564[(2)] = inst_24371);

(statearr_24496_24564[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (2))){
var state_24444__$1 = state_24444;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24444__$1,(4),ch);
} else {
if((state_val_24445 === (23))){
var state_24444__$1 = state_24444;
var statearr_24497_24565 = state_24444__$1;
(statearr_24497_24565[(2)] = null);

(statearr_24497_24565[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (35))){
var inst_24426 = (state_24444[(2)]);
var state_24444__$1 = state_24444;
var statearr_24498_24566 = state_24444__$1;
(statearr_24498_24566[(2)] = inst_24426);

(statearr_24498_24566[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (19))){
var inst_24343 = (state_24444[(7)]);
var inst_24347 = cljs.core.chunk_first.call(null,inst_24343);
var inst_24348 = cljs.core.chunk_rest.call(null,inst_24343);
var inst_24349 = cljs.core.count.call(null,inst_24347);
var inst_24321 = inst_24348;
var inst_24322 = inst_24347;
var inst_24323 = inst_24349;
var inst_24324 = (0);
var state_24444__$1 = (function (){var statearr_24499 = state_24444;
(statearr_24499[(13)] = inst_24324);

(statearr_24499[(14)] = inst_24322);

(statearr_24499[(15)] = inst_24321);

(statearr_24499[(16)] = inst_24323);

return statearr_24499;
})();
var statearr_24500_24567 = state_24444__$1;
(statearr_24500_24567[(2)] = null);

(statearr_24500_24567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (11))){
var inst_24343 = (state_24444[(7)]);
var inst_24321 = (state_24444[(15)]);
var inst_24343__$1 = cljs.core.seq.call(null,inst_24321);
var state_24444__$1 = (function (){var statearr_24501 = state_24444;
(statearr_24501[(7)] = inst_24343__$1);

return statearr_24501;
})();
if(inst_24343__$1){
var statearr_24502_24568 = state_24444__$1;
(statearr_24502_24568[(1)] = (16));

} else {
var statearr_24503_24569 = state_24444__$1;
(statearr_24503_24569[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (9))){
var inst_24373 = (state_24444[(2)]);
var state_24444__$1 = state_24444;
var statearr_24504_24570 = state_24444__$1;
(statearr_24504_24570[(2)] = inst_24373);

(statearr_24504_24570[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (5))){
var inst_24319 = cljs.core.deref.call(null,cs);
var inst_24320 = cljs.core.seq.call(null,inst_24319);
var inst_24321 = inst_24320;
var inst_24322 = null;
var inst_24323 = (0);
var inst_24324 = (0);
var state_24444__$1 = (function (){var statearr_24505 = state_24444;
(statearr_24505[(13)] = inst_24324);

(statearr_24505[(14)] = inst_24322);

(statearr_24505[(15)] = inst_24321);

(statearr_24505[(16)] = inst_24323);

return statearr_24505;
})();
var statearr_24506_24571 = state_24444__$1;
(statearr_24506_24571[(2)] = null);

(statearr_24506_24571[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (14))){
var state_24444__$1 = state_24444;
var statearr_24507_24572 = state_24444__$1;
(statearr_24507_24572[(2)] = null);

(statearr_24507_24572[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (45))){
var inst_24434 = (state_24444[(2)]);
var state_24444__$1 = state_24444;
var statearr_24508_24573 = state_24444__$1;
(statearr_24508_24573[(2)] = inst_24434);

(statearr_24508_24573[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (26))){
var inst_24376 = (state_24444[(29)]);
var inst_24430 = (state_24444[(2)]);
var inst_24431 = cljs.core.seq.call(null,inst_24376);
var state_24444__$1 = (function (){var statearr_24509 = state_24444;
(statearr_24509[(31)] = inst_24430);

return statearr_24509;
})();
if(inst_24431){
var statearr_24510_24574 = state_24444__$1;
(statearr_24510_24574[(1)] = (42));

} else {
var statearr_24511_24575 = state_24444__$1;
(statearr_24511_24575[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (16))){
var inst_24343 = (state_24444[(7)]);
var inst_24345 = cljs.core.chunked_seq_QMARK_.call(null,inst_24343);
var state_24444__$1 = state_24444;
if(inst_24345){
var statearr_24512_24576 = state_24444__$1;
(statearr_24512_24576[(1)] = (19));

} else {
var statearr_24513_24577 = state_24444__$1;
(statearr_24513_24577[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (38))){
var inst_24423 = (state_24444[(2)]);
var state_24444__$1 = state_24444;
var statearr_24514_24578 = state_24444__$1;
(statearr_24514_24578[(2)] = inst_24423);

(statearr_24514_24578[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (30))){
var state_24444__$1 = state_24444;
var statearr_24515_24579 = state_24444__$1;
(statearr_24515_24579[(2)] = null);

(statearr_24515_24579[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (10))){
var inst_24324 = (state_24444[(13)]);
var inst_24322 = (state_24444[(14)]);
var inst_24332 = cljs.core._nth.call(null,inst_24322,inst_24324);
var inst_24333 = cljs.core.nth.call(null,inst_24332,(0),null);
var inst_24334 = cljs.core.nth.call(null,inst_24332,(1),null);
var state_24444__$1 = (function (){var statearr_24516 = state_24444;
(statearr_24516[(26)] = inst_24333);

return statearr_24516;
})();
if(cljs.core.truth_(inst_24334)){
var statearr_24517_24580 = state_24444__$1;
(statearr_24517_24580[(1)] = (13));

} else {
var statearr_24518_24581 = state_24444__$1;
(statearr_24518_24581[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (18))){
var inst_24369 = (state_24444[(2)]);
var state_24444__$1 = state_24444;
var statearr_24519_24582 = state_24444__$1;
(statearr_24519_24582[(2)] = inst_24369);

(statearr_24519_24582[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (42))){
var state_24444__$1 = state_24444;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24444__$1,(45),dchan);
} else {
if((state_val_24445 === (37))){
var inst_24312 = (state_24444[(12)]);
var inst_24412 = (state_24444[(23)]);
var inst_24403 = (state_24444[(25)]);
var inst_24412__$1 = cljs.core.first.call(null,inst_24403);
var inst_24413 = cljs.core.async.put_BANG_.call(null,inst_24412__$1,inst_24312,done);
var state_24444__$1 = (function (){var statearr_24520 = state_24444;
(statearr_24520[(23)] = inst_24412__$1);

return statearr_24520;
})();
if(cljs.core.truth_(inst_24413)){
var statearr_24521_24583 = state_24444__$1;
(statearr_24521_24583[(1)] = (39));

} else {
var statearr_24522_24584 = state_24444__$1;
(statearr_24522_24584[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24445 === (8))){
var inst_24324 = (state_24444[(13)]);
var inst_24323 = (state_24444[(16)]);
var inst_24326 = (inst_24324 < inst_24323);
var inst_24327 = inst_24326;
var state_24444__$1 = state_24444;
if(cljs.core.truth_(inst_24327)){
var statearr_24523_24585 = state_24444__$1;
(statearr_24523_24585[(1)] = (10));

} else {
var statearr_24524_24586 = state_24444__$1;
(statearr_24524_24586[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___24532,cs,m,dchan,dctr,done))
;
return ((function (switch__22336__auto__,c__23179__auto___24532,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__22337__auto__ = null;
var cljs$core$async$mult_$_state_machine__22337__auto____0 = (function (){
var statearr_24528 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24528[(0)] = cljs$core$async$mult_$_state_machine__22337__auto__);

(statearr_24528[(1)] = (1));

return statearr_24528;
});
var cljs$core$async$mult_$_state_machine__22337__auto____1 = (function (state_24444){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_24444);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e24529){if((e24529 instanceof Object)){
var ex__22340__auto__ = e24529;
var statearr_24530_24587 = state_24444;
(statearr_24530_24587[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24444);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24529;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24588 = state_24444;
state_24444 = G__24588;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__22337__auto__ = function(state_24444){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__22337__auto____1.call(this,state_24444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__22337__auto____0;
cljs$core$async$mult_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__22337__auto____1;
return cljs$core$async$mult_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___24532,cs,m,dchan,dctr,done))
})();
var state__23181__auto__ = (function (){var statearr_24531 = f__23180__auto__.call(null);
(statearr_24531[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___24532);

return statearr_24531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___24532,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args24589 = [];
var len__21393__auto___24592 = arguments.length;
var i__21394__auto___24593 = (0);
while(true){
if((i__21394__auto___24593 < len__21393__auto___24592)){
args24589.push((arguments[i__21394__auto___24593]));

var G__24594 = (i__21394__auto___24593 + (1));
i__21394__auto___24593 = G__24594;
continue;
} else {
}
break;
}

var G__24591 = args24589.length;
switch (G__24591) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24589.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,ch);
} else {
var m__20949__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,ch);
} else {
var m__20949__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m);
} else {
var m__20949__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,state_map);
} else {
var m__20949__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__20948__auto__ = (((m == null))?null:m);
var m__20949__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,m,mode);
} else {
var m__20949__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__21400__auto__ = [];
var len__21393__auto___24606 = arguments.length;
var i__21394__auto___24607 = (0);
while(true){
if((i__21394__auto___24607 < len__21393__auto___24606)){
args__21400__auto__.push((arguments[i__21394__auto___24607]));

var G__24608 = (i__21394__auto___24607 + (1));
i__21394__auto___24607 = G__24608;
continue;
} else {
}
break;
}

var argseq__21401__auto__ = ((((3) < args__21400__auto__.length))?(new cljs.core.IndexedSeq(args__21400__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__21401__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__24600){
var map__24601 = p__24600;
var map__24601__$1 = ((((!((map__24601 == null)))?((((map__24601.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24601.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24601):map__24601);
var opts = map__24601__$1;
var statearr_24603_24609 = state;
(statearr_24603_24609[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__24601,map__24601__$1,opts){
return (function (val){
var statearr_24604_24610 = state;
(statearr_24604_24610[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__24601,map__24601__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_24605_24611 = state;
(statearr_24605_24611[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq24596){
var G__24597 = cljs.core.first.call(null,seq24596);
var seq24596__$1 = cljs.core.next.call(null,seq24596);
var G__24598 = cljs.core.first.call(null,seq24596__$1);
var seq24596__$2 = cljs.core.next.call(null,seq24596__$1);
var G__24599 = cljs.core.first.call(null,seq24596__$2);
var seq24596__$3 = cljs.core.next.call(null,seq24596__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__24597,G__24598,G__24599,seq24596__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async24779 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async24779 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta24780){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta24780 = meta24780;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async24779.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24781,meta24780__$1){
var self__ = this;
var _24781__$1 = this;
return (new cljs.core.async.t_cljs$core$async24779(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta24780__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24779.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_24781){
var self__ = this;
var _24781__$1 = this;
return self__.meta24780;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24779.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24779.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24779.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async24779.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24779.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24779.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24779.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24779.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24779.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta24780","meta24780",1477182331,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async24779.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async24779.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async24779";

cljs.core.async.t_cljs$core$async24779.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async24779");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async24779 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async24779(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24780){
return (new cljs.core.async.t_cljs$core$async24779(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta24780));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async24779(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23179__auto___24946 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___24946,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___24946,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_24883){
var state_val_24884 = (state_24883[(1)]);
if((state_val_24884 === (7))){
var inst_24798 = (state_24883[(2)]);
var state_24883__$1 = state_24883;
var statearr_24885_24947 = state_24883__$1;
(statearr_24885_24947[(2)] = inst_24798);

(statearr_24885_24947[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (20))){
var inst_24810 = (state_24883[(7)]);
var state_24883__$1 = state_24883;
var statearr_24886_24948 = state_24883__$1;
(statearr_24886_24948[(2)] = inst_24810);

(statearr_24886_24948[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (27))){
var state_24883__$1 = state_24883;
var statearr_24887_24949 = state_24883__$1;
(statearr_24887_24949[(2)] = null);

(statearr_24887_24949[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (1))){
var inst_24785 = (state_24883[(8)]);
var inst_24785__$1 = calc_state.call(null);
var inst_24787 = (inst_24785__$1 == null);
var inst_24788 = cljs.core.not.call(null,inst_24787);
var state_24883__$1 = (function (){var statearr_24888 = state_24883;
(statearr_24888[(8)] = inst_24785__$1);

return statearr_24888;
})();
if(inst_24788){
var statearr_24889_24950 = state_24883__$1;
(statearr_24889_24950[(1)] = (2));

} else {
var statearr_24890_24951 = state_24883__$1;
(statearr_24890_24951[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (24))){
var inst_24857 = (state_24883[(9)]);
var inst_24834 = (state_24883[(10)]);
var inst_24843 = (state_24883[(11)]);
var inst_24857__$1 = inst_24834.call(null,inst_24843);
var state_24883__$1 = (function (){var statearr_24891 = state_24883;
(statearr_24891[(9)] = inst_24857__$1);

return statearr_24891;
})();
if(cljs.core.truth_(inst_24857__$1)){
var statearr_24892_24952 = state_24883__$1;
(statearr_24892_24952[(1)] = (29));

} else {
var statearr_24893_24953 = state_24883__$1;
(statearr_24893_24953[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (4))){
var inst_24801 = (state_24883[(2)]);
var state_24883__$1 = state_24883;
if(cljs.core.truth_(inst_24801)){
var statearr_24894_24954 = state_24883__$1;
(statearr_24894_24954[(1)] = (8));

} else {
var statearr_24895_24955 = state_24883__$1;
(statearr_24895_24955[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (15))){
var inst_24828 = (state_24883[(2)]);
var state_24883__$1 = state_24883;
if(cljs.core.truth_(inst_24828)){
var statearr_24896_24956 = state_24883__$1;
(statearr_24896_24956[(1)] = (19));

} else {
var statearr_24897_24957 = state_24883__$1;
(statearr_24897_24957[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (21))){
var inst_24833 = (state_24883[(12)]);
var inst_24833__$1 = (state_24883[(2)]);
var inst_24834 = cljs.core.get.call(null,inst_24833__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24835 = cljs.core.get.call(null,inst_24833__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24836 = cljs.core.get.call(null,inst_24833__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_24883__$1 = (function (){var statearr_24898 = state_24883;
(statearr_24898[(13)] = inst_24835);

(statearr_24898[(12)] = inst_24833__$1);

(statearr_24898[(10)] = inst_24834);

return statearr_24898;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_24883__$1,(22),inst_24836);
} else {
if((state_val_24884 === (31))){
var inst_24865 = (state_24883[(2)]);
var state_24883__$1 = state_24883;
if(cljs.core.truth_(inst_24865)){
var statearr_24899_24958 = state_24883__$1;
(statearr_24899_24958[(1)] = (32));

} else {
var statearr_24900_24959 = state_24883__$1;
(statearr_24900_24959[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (32))){
var inst_24842 = (state_24883[(14)]);
var state_24883__$1 = state_24883;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24883__$1,(35),out,inst_24842);
} else {
if((state_val_24884 === (33))){
var inst_24833 = (state_24883[(12)]);
var inst_24810 = inst_24833;
var state_24883__$1 = (function (){var statearr_24901 = state_24883;
(statearr_24901[(7)] = inst_24810);

return statearr_24901;
})();
var statearr_24902_24960 = state_24883__$1;
(statearr_24902_24960[(2)] = null);

(statearr_24902_24960[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (13))){
var inst_24810 = (state_24883[(7)]);
var inst_24817 = inst_24810.cljs$lang$protocol_mask$partition0$;
var inst_24818 = (inst_24817 & (64));
var inst_24819 = inst_24810.cljs$core$ISeq$;
var inst_24820 = (cljs.core.PROTOCOL_SENTINEL === inst_24819);
var inst_24821 = (inst_24818) || (inst_24820);
var state_24883__$1 = state_24883;
if(cljs.core.truth_(inst_24821)){
var statearr_24903_24961 = state_24883__$1;
(statearr_24903_24961[(1)] = (16));

} else {
var statearr_24904_24962 = state_24883__$1;
(statearr_24904_24962[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (22))){
var inst_24842 = (state_24883[(14)]);
var inst_24843 = (state_24883[(11)]);
var inst_24841 = (state_24883[(2)]);
var inst_24842__$1 = cljs.core.nth.call(null,inst_24841,(0),null);
var inst_24843__$1 = cljs.core.nth.call(null,inst_24841,(1),null);
var inst_24844 = (inst_24842__$1 == null);
var inst_24845 = cljs.core._EQ_.call(null,inst_24843__$1,change);
var inst_24846 = (inst_24844) || (inst_24845);
var state_24883__$1 = (function (){var statearr_24905 = state_24883;
(statearr_24905[(14)] = inst_24842__$1);

(statearr_24905[(11)] = inst_24843__$1);

return statearr_24905;
})();
if(cljs.core.truth_(inst_24846)){
var statearr_24906_24963 = state_24883__$1;
(statearr_24906_24963[(1)] = (23));

} else {
var statearr_24907_24964 = state_24883__$1;
(statearr_24907_24964[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (36))){
var inst_24833 = (state_24883[(12)]);
var inst_24810 = inst_24833;
var state_24883__$1 = (function (){var statearr_24908 = state_24883;
(statearr_24908[(7)] = inst_24810);

return statearr_24908;
})();
var statearr_24909_24965 = state_24883__$1;
(statearr_24909_24965[(2)] = null);

(statearr_24909_24965[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (29))){
var inst_24857 = (state_24883[(9)]);
var state_24883__$1 = state_24883;
var statearr_24910_24966 = state_24883__$1;
(statearr_24910_24966[(2)] = inst_24857);

(statearr_24910_24966[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (6))){
var state_24883__$1 = state_24883;
var statearr_24911_24967 = state_24883__$1;
(statearr_24911_24967[(2)] = false);

(statearr_24911_24967[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (28))){
var inst_24853 = (state_24883[(2)]);
var inst_24854 = calc_state.call(null);
var inst_24810 = inst_24854;
var state_24883__$1 = (function (){var statearr_24912 = state_24883;
(statearr_24912[(7)] = inst_24810);

(statearr_24912[(15)] = inst_24853);

return statearr_24912;
})();
var statearr_24913_24968 = state_24883__$1;
(statearr_24913_24968[(2)] = null);

(statearr_24913_24968[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (25))){
var inst_24879 = (state_24883[(2)]);
var state_24883__$1 = state_24883;
var statearr_24914_24969 = state_24883__$1;
(statearr_24914_24969[(2)] = inst_24879);

(statearr_24914_24969[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (34))){
var inst_24877 = (state_24883[(2)]);
var state_24883__$1 = state_24883;
var statearr_24915_24970 = state_24883__$1;
(statearr_24915_24970[(2)] = inst_24877);

(statearr_24915_24970[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (17))){
var state_24883__$1 = state_24883;
var statearr_24916_24971 = state_24883__$1;
(statearr_24916_24971[(2)] = false);

(statearr_24916_24971[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (3))){
var state_24883__$1 = state_24883;
var statearr_24917_24972 = state_24883__$1;
(statearr_24917_24972[(2)] = false);

(statearr_24917_24972[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (12))){
var inst_24881 = (state_24883[(2)]);
var state_24883__$1 = state_24883;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24883__$1,inst_24881);
} else {
if((state_val_24884 === (2))){
var inst_24785 = (state_24883[(8)]);
var inst_24790 = inst_24785.cljs$lang$protocol_mask$partition0$;
var inst_24791 = (inst_24790 & (64));
var inst_24792 = inst_24785.cljs$core$ISeq$;
var inst_24793 = (cljs.core.PROTOCOL_SENTINEL === inst_24792);
var inst_24794 = (inst_24791) || (inst_24793);
var state_24883__$1 = state_24883;
if(cljs.core.truth_(inst_24794)){
var statearr_24918_24973 = state_24883__$1;
(statearr_24918_24973[(1)] = (5));

} else {
var statearr_24919_24974 = state_24883__$1;
(statearr_24919_24974[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (23))){
var inst_24842 = (state_24883[(14)]);
var inst_24848 = (inst_24842 == null);
var state_24883__$1 = state_24883;
if(cljs.core.truth_(inst_24848)){
var statearr_24920_24975 = state_24883__$1;
(statearr_24920_24975[(1)] = (26));

} else {
var statearr_24921_24976 = state_24883__$1;
(statearr_24921_24976[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (35))){
var inst_24868 = (state_24883[(2)]);
var state_24883__$1 = state_24883;
if(cljs.core.truth_(inst_24868)){
var statearr_24922_24977 = state_24883__$1;
(statearr_24922_24977[(1)] = (36));

} else {
var statearr_24923_24978 = state_24883__$1;
(statearr_24923_24978[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (19))){
var inst_24810 = (state_24883[(7)]);
var inst_24830 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24810);
var state_24883__$1 = state_24883;
var statearr_24924_24979 = state_24883__$1;
(statearr_24924_24979[(2)] = inst_24830);

(statearr_24924_24979[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (11))){
var inst_24810 = (state_24883[(7)]);
var inst_24814 = (inst_24810 == null);
var inst_24815 = cljs.core.not.call(null,inst_24814);
var state_24883__$1 = state_24883;
if(inst_24815){
var statearr_24925_24980 = state_24883__$1;
(statearr_24925_24980[(1)] = (13));

} else {
var statearr_24926_24981 = state_24883__$1;
(statearr_24926_24981[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (9))){
var inst_24785 = (state_24883[(8)]);
var state_24883__$1 = state_24883;
var statearr_24927_24982 = state_24883__$1;
(statearr_24927_24982[(2)] = inst_24785);

(statearr_24927_24982[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (5))){
var state_24883__$1 = state_24883;
var statearr_24928_24983 = state_24883__$1;
(statearr_24928_24983[(2)] = true);

(statearr_24928_24983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (14))){
var state_24883__$1 = state_24883;
var statearr_24929_24984 = state_24883__$1;
(statearr_24929_24984[(2)] = false);

(statearr_24929_24984[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (26))){
var inst_24843 = (state_24883[(11)]);
var inst_24850 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_24843);
var state_24883__$1 = state_24883;
var statearr_24930_24985 = state_24883__$1;
(statearr_24930_24985[(2)] = inst_24850);

(statearr_24930_24985[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (16))){
var state_24883__$1 = state_24883;
var statearr_24931_24986 = state_24883__$1;
(statearr_24931_24986[(2)] = true);

(statearr_24931_24986[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (38))){
var inst_24873 = (state_24883[(2)]);
var state_24883__$1 = state_24883;
var statearr_24932_24987 = state_24883__$1;
(statearr_24932_24987[(2)] = inst_24873);

(statearr_24932_24987[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (30))){
var inst_24835 = (state_24883[(13)]);
var inst_24834 = (state_24883[(10)]);
var inst_24843 = (state_24883[(11)]);
var inst_24860 = cljs.core.empty_QMARK_.call(null,inst_24834);
var inst_24861 = inst_24835.call(null,inst_24843);
var inst_24862 = cljs.core.not.call(null,inst_24861);
var inst_24863 = (inst_24860) && (inst_24862);
var state_24883__$1 = state_24883;
var statearr_24933_24988 = state_24883__$1;
(statearr_24933_24988[(2)] = inst_24863);

(statearr_24933_24988[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (10))){
var inst_24785 = (state_24883[(8)]);
var inst_24806 = (state_24883[(2)]);
var inst_24807 = cljs.core.get.call(null,inst_24806,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_24808 = cljs.core.get.call(null,inst_24806,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_24809 = cljs.core.get.call(null,inst_24806,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_24810 = inst_24785;
var state_24883__$1 = (function (){var statearr_24934 = state_24883;
(statearr_24934[(7)] = inst_24810);

(statearr_24934[(16)] = inst_24808);

(statearr_24934[(17)] = inst_24809);

(statearr_24934[(18)] = inst_24807);

return statearr_24934;
})();
var statearr_24935_24989 = state_24883__$1;
(statearr_24935_24989[(2)] = null);

(statearr_24935_24989[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (18))){
var inst_24825 = (state_24883[(2)]);
var state_24883__$1 = state_24883;
var statearr_24936_24990 = state_24883__$1;
(statearr_24936_24990[(2)] = inst_24825);

(statearr_24936_24990[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (37))){
var state_24883__$1 = state_24883;
var statearr_24937_24991 = state_24883__$1;
(statearr_24937_24991[(2)] = null);

(statearr_24937_24991[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24884 === (8))){
var inst_24785 = (state_24883[(8)]);
var inst_24803 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24785);
var state_24883__$1 = state_24883;
var statearr_24938_24992 = state_24883__$1;
(statearr_24938_24992[(2)] = inst_24803);

(statearr_24938_24992[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___24946,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__22336__auto__,c__23179__auto___24946,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__22337__auto__ = null;
var cljs$core$async$mix_$_state_machine__22337__auto____0 = (function (){
var statearr_24942 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24942[(0)] = cljs$core$async$mix_$_state_machine__22337__auto__);

(statearr_24942[(1)] = (1));

return statearr_24942;
});
var cljs$core$async$mix_$_state_machine__22337__auto____1 = (function (state_24883){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_24883);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e24943){if((e24943 instanceof Object)){
var ex__22340__auto__ = e24943;
var statearr_24944_24993 = state_24883;
(statearr_24944_24993[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24883);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24943;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24994 = state_24883;
state_24883 = G__24994;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__22337__auto__ = function(state_24883){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__22337__auto____1.call(this,state_24883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__22337__auto____0;
cljs$core$async$mix_$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__22337__auto____1;
return cljs$core$async$mix_$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___24946,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__23181__auto__ = (function (){var statearr_24945 = f__23180__auto__.call(null);
(statearr_24945[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___24946);

return statearr_24945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___24946,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__20948__auto__ = (((p == null))?null:p);
var m__20949__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__20949__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__20948__auto__ = (((p == null))?null:p);
var m__20949__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,p,v,ch);
} else {
var m__20949__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args24995 = [];
var len__21393__auto___24998 = arguments.length;
var i__21394__auto___24999 = (0);
while(true){
if((i__21394__auto___24999 < len__21393__auto___24998)){
args24995.push((arguments[i__21394__auto___24999]));

var G__25000 = (i__21394__auto___24999 + (1));
i__21394__auto___24999 = G__25000;
continue;
} else {
}
break;
}

var G__24997 = args24995.length;
switch (G__24997) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24995.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__20948__auto__ = (((p == null))?null:p);
var m__20949__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,p);
} else {
var m__20949__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__20948__auto__ = (((p == null))?null:p);
var m__20949__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__20948__auto__)]);
if(!((m__20949__auto__ == null))){
return m__20949__auto__.call(null,p,v);
} else {
var m__20949__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__20949__auto____$1 == null))){
return m__20949__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args25003 = [];
var len__21393__auto___25128 = arguments.length;
var i__21394__auto___25129 = (0);
while(true){
if((i__21394__auto___25129 < len__21393__auto___25128)){
args25003.push((arguments[i__21394__auto___25129]));

var G__25130 = (i__21394__auto___25129 + (1));
i__21394__auto___25129 = G__25130;
continue;
} else {
}
break;
}

var G__25005 = args25003.length;
switch (G__25005) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25003.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__20285__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__20285__auto__)){
return or__20285__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__20285__auto__,mults){
return (function (p1__25002_SHARP_){
if(cljs.core.truth_(p1__25002_SHARP_.call(null,topic))){
return p1__25002_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__25002_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__20285__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async25006 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25006 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta25007){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta25007 = meta25007;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25006.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_25008,meta25007__$1){
var self__ = this;
var _25008__$1 = this;
return (new cljs.core.async.t_cljs$core$async25006(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta25007__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25006.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_25008){
var self__ = this;
var _25008__$1 = this;
return self__.meta25007;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25006.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25006.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25006.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25006.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25006.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25006.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25006.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25006.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta25007","meta25007",-915971764,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async25006.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25006.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25006";

cljs.core.async.t_cljs$core$async25006.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async25006");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async25006 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async25006(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25007){
return (new cljs.core.async.t_cljs$core$async25006(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta25007));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async25006(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__23179__auto___25132 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___25132,mults,ensure_mult,p){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___25132,mults,ensure_mult,p){
return (function (state_25080){
var state_val_25081 = (state_25080[(1)]);
if((state_val_25081 === (7))){
var inst_25076 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
var statearr_25082_25133 = state_25080__$1;
(statearr_25082_25133[(2)] = inst_25076);

(statearr_25082_25133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (20))){
var state_25080__$1 = state_25080;
var statearr_25083_25134 = state_25080__$1;
(statearr_25083_25134[(2)] = null);

(statearr_25083_25134[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (1))){
var state_25080__$1 = state_25080;
var statearr_25084_25135 = state_25080__$1;
(statearr_25084_25135[(2)] = null);

(statearr_25084_25135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (24))){
var inst_25059 = (state_25080[(7)]);
var inst_25068 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_25059);
var state_25080__$1 = state_25080;
var statearr_25085_25136 = state_25080__$1;
(statearr_25085_25136[(2)] = inst_25068);

(statearr_25085_25136[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (4))){
var inst_25011 = (state_25080[(8)]);
var inst_25011__$1 = (state_25080[(2)]);
var inst_25012 = (inst_25011__$1 == null);
var state_25080__$1 = (function (){var statearr_25086 = state_25080;
(statearr_25086[(8)] = inst_25011__$1);

return statearr_25086;
})();
if(cljs.core.truth_(inst_25012)){
var statearr_25087_25137 = state_25080__$1;
(statearr_25087_25137[(1)] = (5));

} else {
var statearr_25088_25138 = state_25080__$1;
(statearr_25088_25138[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (15))){
var inst_25053 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
var statearr_25089_25139 = state_25080__$1;
(statearr_25089_25139[(2)] = inst_25053);

(statearr_25089_25139[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (21))){
var inst_25073 = (state_25080[(2)]);
var state_25080__$1 = (function (){var statearr_25090 = state_25080;
(statearr_25090[(9)] = inst_25073);

return statearr_25090;
})();
var statearr_25091_25140 = state_25080__$1;
(statearr_25091_25140[(2)] = null);

(statearr_25091_25140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (13))){
var inst_25035 = (state_25080[(10)]);
var inst_25037 = cljs.core.chunked_seq_QMARK_.call(null,inst_25035);
var state_25080__$1 = state_25080;
if(inst_25037){
var statearr_25092_25141 = state_25080__$1;
(statearr_25092_25141[(1)] = (16));

} else {
var statearr_25093_25142 = state_25080__$1;
(statearr_25093_25142[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (22))){
var inst_25065 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
if(cljs.core.truth_(inst_25065)){
var statearr_25094_25143 = state_25080__$1;
(statearr_25094_25143[(1)] = (23));

} else {
var statearr_25095_25144 = state_25080__$1;
(statearr_25095_25144[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (6))){
var inst_25059 = (state_25080[(7)]);
var inst_25011 = (state_25080[(8)]);
var inst_25061 = (state_25080[(11)]);
var inst_25059__$1 = topic_fn.call(null,inst_25011);
var inst_25060 = cljs.core.deref.call(null,mults);
var inst_25061__$1 = cljs.core.get.call(null,inst_25060,inst_25059__$1);
var state_25080__$1 = (function (){var statearr_25096 = state_25080;
(statearr_25096[(7)] = inst_25059__$1);

(statearr_25096[(11)] = inst_25061__$1);

return statearr_25096;
})();
if(cljs.core.truth_(inst_25061__$1)){
var statearr_25097_25145 = state_25080__$1;
(statearr_25097_25145[(1)] = (19));

} else {
var statearr_25098_25146 = state_25080__$1;
(statearr_25098_25146[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (25))){
var inst_25070 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
var statearr_25099_25147 = state_25080__$1;
(statearr_25099_25147[(2)] = inst_25070);

(statearr_25099_25147[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (17))){
var inst_25035 = (state_25080[(10)]);
var inst_25044 = cljs.core.first.call(null,inst_25035);
var inst_25045 = cljs.core.async.muxch_STAR_.call(null,inst_25044);
var inst_25046 = cljs.core.async.close_BANG_.call(null,inst_25045);
var inst_25047 = cljs.core.next.call(null,inst_25035);
var inst_25021 = inst_25047;
var inst_25022 = null;
var inst_25023 = (0);
var inst_25024 = (0);
var state_25080__$1 = (function (){var statearr_25100 = state_25080;
(statearr_25100[(12)] = inst_25022);

(statearr_25100[(13)] = inst_25024);

(statearr_25100[(14)] = inst_25023);

(statearr_25100[(15)] = inst_25046);

(statearr_25100[(16)] = inst_25021);

return statearr_25100;
})();
var statearr_25101_25148 = state_25080__$1;
(statearr_25101_25148[(2)] = null);

(statearr_25101_25148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (3))){
var inst_25078 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25080__$1,inst_25078);
} else {
if((state_val_25081 === (12))){
var inst_25055 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
var statearr_25102_25149 = state_25080__$1;
(statearr_25102_25149[(2)] = inst_25055);

(statearr_25102_25149[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (2))){
var state_25080__$1 = state_25080;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25080__$1,(4),ch);
} else {
if((state_val_25081 === (23))){
var state_25080__$1 = state_25080;
var statearr_25103_25150 = state_25080__$1;
(statearr_25103_25150[(2)] = null);

(statearr_25103_25150[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (19))){
var inst_25011 = (state_25080[(8)]);
var inst_25061 = (state_25080[(11)]);
var inst_25063 = cljs.core.async.muxch_STAR_.call(null,inst_25061);
var state_25080__$1 = state_25080;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25080__$1,(22),inst_25063,inst_25011);
} else {
if((state_val_25081 === (11))){
var inst_25035 = (state_25080[(10)]);
var inst_25021 = (state_25080[(16)]);
var inst_25035__$1 = cljs.core.seq.call(null,inst_25021);
var state_25080__$1 = (function (){var statearr_25104 = state_25080;
(statearr_25104[(10)] = inst_25035__$1);

return statearr_25104;
})();
if(inst_25035__$1){
var statearr_25105_25151 = state_25080__$1;
(statearr_25105_25151[(1)] = (13));

} else {
var statearr_25106_25152 = state_25080__$1;
(statearr_25106_25152[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (9))){
var inst_25057 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
var statearr_25107_25153 = state_25080__$1;
(statearr_25107_25153[(2)] = inst_25057);

(statearr_25107_25153[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (5))){
var inst_25018 = cljs.core.deref.call(null,mults);
var inst_25019 = cljs.core.vals.call(null,inst_25018);
var inst_25020 = cljs.core.seq.call(null,inst_25019);
var inst_25021 = inst_25020;
var inst_25022 = null;
var inst_25023 = (0);
var inst_25024 = (0);
var state_25080__$1 = (function (){var statearr_25108 = state_25080;
(statearr_25108[(12)] = inst_25022);

(statearr_25108[(13)] = inst_25024);

(statearr_25108[(14)] = inst_25023);

(statearr_25108[(16)] = inst_25021);

return statearr_25108;
})();
var statearr_25109_25154 = state_25080__$1;
(statearr_25109_25154[(2)] = null);

(statearr_25109_25154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (14))){
var state_25080__$1 = state_25080;
var statearr_25113_25155 = state_25080__$1;
(statearr_25113_25155[(2)] = null);

(statearr_25113_25155[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (16))){
var inst_25035 = (state_25080[(10)]);
var inst_25039 = cljs.core.chunk_first.call(null,inst_25035);
var inst_25040 = cljs.core.chunk_rest.call(null,inst_25035);
var inst_25041 = cljs.core.count.call(null,inst_25039);
var inst_25021 = inst_25040;
var inst_25022 = inst_25039;
var inst_25023 = inst_25041;
var inst_25024 = (0);
var state_25080__$1 = (function (){var statearr_25114 = state_25080;
(statearr_25114[(12)] = inst_25022);

(statearr_25114[(13)] = inst_25024);

(statearr_25114[(14)] = inst_25023);

(statearr_25114[(16)] = inst_25021);

return statearr_25114;
})();
var statearr_25115_25156 = state_25080__$1;
(statearr_25115_25156[(2)] = null);

(statearr_25115_25156[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (10))){
var inst_25022 = (state_25080[(12)]);
var inst_25024 = (state_25080[(13)]);
var inst_25023 = (state_25080[(14)]);
var inst_25021 = (state_25080[(16)]);
var inst_25029 = cljs.core._nth.call(null,inst_25022,inst_25024);
var inst_25030 = cljs.core.async.muxch_STAR_.call(null,inst_25029);
var inst_25031 = cljs.core.async.close_BANG_.call(null,inst_25030);
var inst_25032 = (inst_25024 + (1));
var tmp25110 = inst_25022;
var tmp25111 = inst_25023;
var tmp25112 = inst_25021;
var inst_25021__$1 = tmp25112;
var inst_25022__$1 = tmp25110;
var inst_25023__$1 = tmp25111;
var inst_25024__$1 = inst_25032;
var state_25080__$1 = (function (){var statearr_25116 = state_25080;
(statearr_25116[(12)] = inst_25022__$1);

(statearr_25116[(17)] = inst_25031);

(statearr_25116[(13)] = inst_25024__$1);

(statearr_25116[(14)] = inst_25023__$1);

(statearr_25116[(16)] = inst_25021__$1);

return statearr_25116;
})();
var statearr_25117_25157 = state_25080__$1;
(statearr_25117_25157[(2)] = null);

(statearr_25117_25157[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (18))){
var inst_25050 = (state_25080[(2)]);
var state_25080__$1 = state_25080;
var statearr_25118_25158 = state_25080__$1;
(statearr_25118_25158[(2)] = inst_25050);

(statearr_25118_25158[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25081 === (8))){
var inst_25024 = (state_25080[(13)]);
var inst_25023 = (state_25080[(14)]);
var inst_25026 = (inst_25024 < inst_25023);
var inst_25027 = inst_25026;
var state_25080__$1 = state_25080;
if(cljs.core.truth_(inst_25027)){
var statearr_25119_25159 = state_25080__$1;
(statearr_25119_25159[(1)] = (10));

} else {
var statearr_25120_25160 = state_25080__$1;
(statearr_25120_25160[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___25132,mults,ensure_mult,p))
;
return ((function (switch__22336__auto__,c__23179__auto___25132,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25124 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25124[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25124[(1)] = (1));

return statearr_25124;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25080){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25125){if((e25125 instanceof Object)){
var ex__22340__auto__ = e25125;
var statearr_25126_25161 = state_25080;
(statearr_25126_25161[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25080);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25125;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25162 = state_25080;
state_25080 = G__25162;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25080){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___25132,mults,ensure_mult,p))
})();
var state__23181__auto__ = (function (){var statearr_25127 = f__23180__auto__.call(null);
(statearr_25127[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___25132);

return statearr_25127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___25132,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args25163 = [];
var len__21393__auto___25166 = arguments.length;
var i__21394__auto___25167 = (0);
while(true){
if((i__21394__auto___25167 < len__21393__auto___25166)){
args25163.push((arguments[i__21394__auto___25167]));

var G__25168 = (i__21394__auto___25167 + (1));
i__21394__auto___25167 = G__25168;
continue;
} else {
}
break;
}

var G__25165 = args25163.length;
switch (G__25165) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25163.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args25170 = [];
var len__21393__auto___25173 = arguments.length;
var i__21394__auto___25174 = (0);
while(true){
if((i__21394__auto___25174 < len__21393__auto___25173)){
args25170.push((arguments[i__21394__auto___25174]));

var G__25175 = (i__21394__auto___25174 + (1));
i__21394__auto___25174 = G__25175;
continue;
} else {
}
break;
}

var G__25172 = args25170.length;
switch (G__25172) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25170.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args25177 = [];
var len__21393__auto___25248 = arguments.length;
var i__21394__auto___25249 = (0);
while(true){
if((i__21394__auto___25249 < len__21393__auto___25248)){
args25177.push((arguments[i__21394__auto___25249]));

var G__25250 = (i__21394__auto___25249 + (1));
i__21394__auto___25249 = G__25250;
continue;
} else {
}
break;
}

var G__25179 = args25177.length;
switch (G__25179) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25177.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__23179__auto___25252 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___25252,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___25252,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_25218){
var state_val_25219 = (state_25218[(1)]);
if((state_val_25219 === (7))){
var state_25218__$1 = state_25218;
var statearr_25220_25253 = state_25218__$1;
(statearr_25220_25253[(2)] = null);

(statearr_25220_25253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (1))){
var state_25218__$1 = state_25218;
var statearr_25221_25254 = state_25218__$1;
(statearr_25221_25254[(2)] = null);

(statearr_25221_25254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (4))){
var inst_25182 = (state_25218[(7)]);
var inst_25184 = (inst_25182 < cnt);
var state_25218__$1 = state_25218;
if(cljs.core.truth_(inst_25184)){
var statearr_25222_25255 = state_25218__$1;
(statearr_25222_25255[(1)] = (6));

} else {
var statearr_25223_25256 = state_25218__$1;
(statearr_25223_25256[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (15))){
var inst_25214 = (state_25218[(2)]);
var state_25218__$1 = state_25218;
var statearr_25224_25257 = state_25218__$1;
(statearr_25224_25257[(2)] = inst_25214);

(statearr_25224_25257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (13))){
var inst_25207 = cljs.core.async.close_BANG_.call(null,out);
var state_25218__$1 = state_25218;
var statearr_25225_25258 = state_25218__$1;
(statearr_25225_25258[(2)] = inst_25207);

(statearr_25225_25258[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (6))){
var state_25218__$1 = state_25218;
var statearr_25226_25259 = state_25218__$1;
(statearr_25226_25259[(2)] = null);

(statearr_25226_25259[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (3))){
var inst_25216 = (state_25218[(2)]);
var state_25218__$1 = state_25218;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25218__$1,inst_25216);
} else {
if((state_val_25219 === (12))){
var inst_25204 = (state_25218[(8)]);
var inst_25204__$1 = (state_25218[(2)]);
var inst_25205 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_25204__$1);
var state_25218__$1 = (function (){var statearr_25227 = state_25218;
(statearr_25227[(8)] = inst_25204__$1);

return statearr_25227;
})();
if(cljs.core.truth_(inst_25205)){
var statearr_25228_25260 = state_25218__$1;
(statearr_25228_25260[(1)] = (13));

} else {
var statearr_25229_25261 = state_25218__$1;
(statearr_25229_25261[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (2))){
var inst_25181 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_25182 = (0);
var state_25218__$1 = (function (){var statearr_25230 = state_25218;
(statearr_25230[(9)] = inst_25181);

(statearr_25230[(7)] = inst_25182);

return statearr_25230;
})();
var statearr_25231_25262 = state_25218__$1;
(statearr_25231_25262[(2)] = null);

(statearr_25231_25262[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (11))){
var inst_25182 = (state_25218[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_25218,(10),Object,null,(9));
var inst_25191 = chs__$1.call(null,inst_25182);
var inst_25192 = done.call(null,inst_25182);
var inst_25193 = cljs.core.async.take_BANG_.call(null,inst_25191,inst_25192);
var state_25218__$1 = state_25218;
var statearr_25232_25263 = state_25218__$1;
(statearr_25232_25263[(2)] = inst_25193);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25218__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (9))){
var inst_25182 = (state_25218[(7)]);
var inst_25195 = (state_25218[(2)]);
var inst_25196 = (inst_25182 + (1));
var inst_25182__$1 = inst_25196;
var state_25218__$1 = (function (){var statearr_25233 = state_25218;
(statearr_25233[(7)] = inst_25182__$1);

(statearr_25233[(10)] = inst_25195);

return statearr_25233;
})();
var statearr_25234_25264 = state_25218__$1;
(statearr_25234_25264[(2)] = null);

(statearr_25234_25264[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (5))){
var inst_25202 = (state_25218[(2)]);
var state_25218__$1 = (function (){var statearr_25235 = state_25218;
(statearr_25235[(11)] = inst_25202);

return statearr_25235;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25218__$1,(12),dchan);
} else {
if((state_val_25219 === (14))){
var inst_25204 = (state_25218[(8)]);
var inst_25209 = cljs.core.apply.call(null,f,inst_25204);
var state_25218__$1 = state_25218;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25218__$1,(16),out,inst_25209);
} else {
if((state_val_25219 === (16))){
var inst_25211 = (state_25218[(2)]);
var state_25218__$1 = (function (){var statearr_25236 = state_25218;
(statearr_25236[(12)] = inst_25211);

return statearr_25236;
})();
var statearr_25237_25265 = state_25218__$1;
(statearr_25237_25265[(2)] = null);

(statearr_25237_25265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (10))){
var inst_25186 = (state_25218[(2)]);
var inst_25187 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_25218__$1 = (function (){var statearr_25238 = state_25218;
(statearr_25238[(13)] = inst_25186);

return statearr_25238;
})();
var statearr_25239_25266 = state_25218__$1;
(statearr_25239_25266[(2)] = inst_25187);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25218__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25219 === (8))){
var inst_25200 = (state_25218[(2)]);
var state_25218__$1 = state_25218;
var statearr_25240_25267 = state_25218__$1;
(statearr_25240_25267[(2)] = inst_25200);

(statearr_25240_25267[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___25252,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__22336__auto__,c__23179__auto___25252,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25244 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25244[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25244[(1)] = (1));

return statearr_25244;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25218){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25218);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25245){if((e25245 instanceof Object)){
var ex__22340__auto__ = e25245;
var statearr_25246_25268 = state_25218;
(statearr_25246_25268[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25218);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25245;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25269 = state_25218;
state_25218 = G__25269;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25218){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25218);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___25252,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__23181__auto__ = (function (){var statearr_25247 = f__23180__auto__.call(null);
(statearr_25247[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___25252);

return statearr_25247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___25252,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args25271 = [];
var len__21393__auto___25329 = arguments.length;
var i__21394__auto___25330 = (0);
while(true){
if((i__21394__auto___25330 < len__21393__auto___25329)){
args25271.push((arguments[i__21394__auto___25330]));

var G__25331 = (i__21394__auto___25330 + (1));
i__21394__auto___25330 = G__25331;
continue;
} else {
}
break;
}

var G__25273 = args25271.length;
switch (G__25273) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25271.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23179__auto___25333 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___25333,out){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___25333,out){
return (function (state_25305){
var state_val_25306 = (state_25305[(1)]);
if((state_val_25306 === (7))){
var inst_25284 = (state_25305[(7)]);
var inst_25285 = (state_25305[(8)]);
var inst_25284__$1 = (state_25305[(2)]);
var inst_25285__$1 = cljs.core.nth.call(null,inst_25284__$1,(0),null);
var inst_25286 = cljs.core.nth.call(null,inst_25284__$1,(1),null);
var inst_25287 = (inst_25285__$1 == null);
var state_25305__$1 = (function (){var statearr_25307 = state_25305;
(statearr_25307[(9)] = inst_25286);

(statearr_25307[(7)] = inst_25284__$1);

(statearr_25307[(8)] = inst_25285__$1);

return statearr_25307;
})();
if(cljs.core.truth_(inst_25287)){
var statearr_25308_25334 = state_25305__$1;
(statearr_25308_25334[(1)] = (8));

} else {
var statearr_25309_25335 = state_25305__$1;
(statearr_25309_25335[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25306 === (1))){
var inst_25274 = cljs.core.vec.call(null,chs);
var inst_25275 = inst_25274;
var state_25305__$1 = (function (){var statearr_25310 = state_25305;
(statearr_25310[(10)] = inst_25275);

return statearr_25310;
})();
var statearr_25311_25336 = state_25305__$1;
(statearr_25311_25336[(2)] = null);

(statearr_25311_25336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25306 === (4))){
var inst_25275 = (state_25305[(10)]);
var state_25305__$1 = state_25305;
return cljs.core.async.ioc_alts_BANG_.call(null,state_25305__$1,(7),inst_25275);
} else {
if((state_val_25306 === (6))){
var inst_25301 = (state_25305[(2)]);
var state_25305__$1 = state_25305;
var statearr_25312_25337 = state_25305__$1;
(statearr_25312_25337[(2)] = inst_25301);

(statearr_25312_25337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25306 === (3))){
var inst_25303 = (state_25305[(2)]);
var state_25305__$1 = state_25305;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25305__$1,inst_25303);
} else {
if((state_val_25306 === (2))){
var inst_25275 = (state_25305[(10)]);
var inst_25277 = cljs.core.count.call(null,inst_25275);
var inst_25278 = (inst_25277 > (0));
var state_25305__$1 = state_25305;
if(cljs.core.truth_(inst_25278)){
var statearr_25314_25338 = state_25305__$1;
(statearr_25314_25338[(1)] = (4));

} else {
var statearr_25315_25339 = state_25305__$1;
(statearr_25315_25339[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25306 === (11))){
var inst_25275 = (state_25305[(10)]);
var inst_25294 = (state_25305[(2)]);
var tmp25313 = inst_25275;
var inst_25275__$1 = tmp25313;
var state_25305__$1 = (function (){var statearr_25316 = state_25305;
(statearr_25316[(11)] = inst_25294);

(statearr_25316[(10)] = inst_25275__$1);

return statearr_25316;
})();
var statearr_25317_25340 = state_25305__$1;
(statearr_25317_25340[(2)] = null);

(statearr_25317_25340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25306 === (9))){
var inst_25285 = (state_25305[(8)]);
var state_25305__$1 = state_25305;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25305__$1,(11),out,inst_25285);
} else {
if((state_val_25306 === (5))){
var inst_25299 = cljs.core.async.close_BANG_.call(null,out);
var state_25305__$1 = state_25305;
var statearr_25318_25341 = state_25305__$1;
(statearr_25318_25341[(2)] = inst_25299);

(statearr_25318_25341[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25306 === (10))){
var inst_25297 = (state_25305[(2)]);
var state_25305__$1 = state_25305;
var statearr_25319_25342 = state_25305__$1;
(statearr_25319_25342[(2)] = inst_25297);

(statearr_25319_25342[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25306 === (8))){
var inst_25286 = (state_25305[(9)]);
var inst_25284 = (state_25305[(7)]);
var inst_25285 = (state_25305[(8)]);
var inst_25275 = (state_25305[(10)]);
var inst_25289 = (function (){var cs = inst_25275;
var vec__25280 = inst_25284;
var v = inst_25285;
var c = inst_25286;
return ((function (cs,vec__25280,v,c,inst_25286,inst_25284,inst_25285,inst_25275,state_val_25306,c__23179__auto___25333,out){
return (function (p1__25270_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__25270_SHARP_);
});
;})(cs,vec__25280,v,c,inst_25286,inst_25284,inst_25285,inst_25275,state_val_25306,c__23179__auto___25333,out))
})();
var inst_25290 = cljs.core.filterv.call(null,inst_25289,inst_25275);
var inst_25275__$1 = inst_25290;
var state_25305__$1 = (function (){var statearr_25320 = state_25305;
(statearr_25320[(10)] = inst_25275__$1);

return statearr_25320;
})();
var statearr_25321_25343 = state_25305__$1;
(statearr_25321_25343[(2)] = null);

(statearr_25321_25343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___25333,out))
;
return ((function (switch__22336__auto__,c__23179__auto___25333,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25325 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25325[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25325[(1)] = (1));

return statearr_25325;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25305){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25305);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25326){if((e25326 instanceof Object)){
var ex__22340__auto__ = e25326;
var statearr_25327_25344 = state_25305;
(statearr_25327_25344[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25305);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25326;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25345 = state_25305;
state_25305 = G__25345;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25305){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___25333,out))
})();
var state__23181__auto__ = (function (){var statearr_25328 = f__23180__auto__.call(null);
(statearr_25328[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___25333);

return statearr_25328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___25333,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args25346 = [];
var len__21393__auto___25395 = arguments.length;
var i__21394__auto___25396 = (0);
while(true){
if((i__21394__auto___25396 < len__21393__auto___25395)){
args25346.push((arguments[i__21394__auto___25396]));

var G__25397 = (i__21394__auto___25396 + (1));
i__21394__auto___25396 = G__25397;
continue;
} else {
}
break;
}

var G__25348 = args25346.length;
switch (G__25348) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25346.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23179__auto___25399 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___25399,out){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___25399,out){
return (function (state_25372){
var state_val_25373 = (state_25372[(1)]);
if((state_val_25373 === (7))){
var inst_25354 = (state_25372[(7)]);
var inst_25354__$1 = (state_25372[(2)]);
var inst_25355 = (inst_25354__$1 == null);
var inst_25356 = cljs.core.not.call(null,inst_25355);
var state_25372__$1 = (function (){var statearr_25374 = state_25372;
(statearr_25374[(7)] = inst_25354__$1);

return statearr_25374;
})();
if(inst_25356){
var statearr_25375_25400 = state_25372__$1;
(statearr_25375_25400[(1)] = (8));

} else {
var statearr_25376_25401 = state_25372__$1;
(statearr_25376_25401[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25373 === (1))){
var inst_25349 = (0);
var state_25372__$1 = (function (){var statearr_25377 = state_25372;
(statearr_25377[(8)] = inst_25349);

return statearr_25377;
})();
var statearr_25378_25402 = state_25372__$1;
(statearr_25378_25402[(2)] = null);

(statearr_25378_25402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25373 === (4))){
var state_25372__$1 = state_25372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25372__$1,(7),ch);
} else {
if((state_val_25373 === (6))){
var inst_25367 = (state_25372[(2)]);
var state_25372__$1 = state_25372;
var statearr_25379_25403 = state_25372__$1;
(statearr_25379_25403[(2)] = inst_25367);

(statearr_25379_25403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25373 === (3))){
var inst_25369 = (state_25372[(2)]);
var inst_25370 = cljs.core.async.close_BANG_.call(null,out);
var state_25372__$1 = (function (){var statearr_25380 = state_25372;
(statearr_25380[(9)] = inst_25369);

return statearr_25380;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25372__$1,inst_25370);
} else {
if((state_val_25373 === (2))){
var inst_25349 = (state_25372[(8)]);
var inst_25351 = (inst_25349 < n);
var state_25372__$1 = state_25372;
if(cljs.core.truth_(inst_25351)){
var statearr_25381_25404 = state_25372__$1;
(statearr_25381_25404[(1)] = (4));

} else {
var statearr_25382_25405 = state_25372__$1;
(statearr_25382_25405[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25373 === (11))){
var inst_25349 = (state_25372[(8)]);
var inst_25359 = (state_25372[(2)]);
var inst_25360 = (inst_25349 + (1));
var inst_25349__$1 = inst_25360;
var state_25372__$1 = (function (){var statearr_25383 = state_25372;
(statearr_25383[(8)] = inst_25349__$1);

(statearr_25383[(10)] = inst_25359);

return statearr_25383;
})();
var statearr_25384_25406 = state_25372__$1;
(statearr_25384_25406[(2)] = null);

(statearr_25384_25406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25373 === (9))){
var state_25372__$1 = state_25372;
var statearr_25385_25407 = state_25372__$1;
(statearr_25385_25407[(2)] = null);

(statearr_25385_25407[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25373 === (5))){
var state_25372__$1 = state_25372;
var statearr_25386_25408 = state_25372__$1;
(statearr_25386_25408[(2)] = null);

(statearr_25386_25408[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25373 === (10))){
var inst_25364 = (state_25372[(2)]);
var state_25372__$1 = state_25372;
var statearr_25387_25409 = state_25372__$1;
(statearr_25387_25409[(2)] = inst_25364);

(statearr_25387_25409[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25373 === (8))){
var inst_25354 = (state_25372[(7)]);
var state_25372__$1 = state_25372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25372__$1,(11),out,inst_25354);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___25399,out))
;
return ((function (switch__22336__auto__,c__23179__auto___25399,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25391 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25391[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25391[(1)] = (1));

return statearr_25391;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25372){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25392){if((e25392 instanceof Object)){
var ex__22340__auto__ = e25392;
var statearr_25393_25410 = state_25372;
(statearr_25393_25410[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25372);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25392;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25411 = state_25372;
state_25372 = G__25411;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25372){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___25399,out))
})();
var state__23181__auto__ = (function (){var statearr_25394 = f__23180__auto__.call(null);
(statearr_25394[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___25399);

return statearr_25394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___25399,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async25419 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25419 = (function (f,ch,meta25420){
this.f = f;
this.ch = ch;
this.meta25420 = meta25420;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25419.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25421,meta25420__$1){
var self__ = this;
var _25421__$1 = this;
return (new cljs.core.async.t_cljs$core$async25419(self__.f,self__.ch,meta25420__$1));
});

cljs.core.async.t_cljs$core$async25419.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25421){
var self__ = this;
var _25421__$1 = this;
return self__.meta25420;
});

cljs.core.async.t_cljs$core$async25419.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25419.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25419.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25419.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25419.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async25422 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25422 = (function (f,ch,meta25420,_,fn1,meta25423){
this.f = f;
this.ch = ch;
this.meta25420 = meta25420;
this._ = _;
this.fn1 = fn1;
this.meta25423 = meta25423;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25422.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_25424,meta25423__$1){
var self__ = this;
var _25424__$1 = this;
return (new cljs.core.async.t_cljs$core$async25422(self__.f,self__.ch,self__.meta25420,self__._,self__.fn1,meta25423__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async25422.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_25424){
var self__ = this;
var _25424__$1 = this;
return self__.meta25423;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25422.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25422.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25422.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async25422.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__25412_SHARP_){
return f1.call(null,(((p1__25412_SHARP_ == null))?null:self__.f.call(null,p1__25412_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async25422.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25420","meta25420",-1605182175,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async25419","cljs.core.async/t_cljs$core$async25419",362098607,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta25423","meta25423",1015690450,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async25422.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25422.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25422";

cljs.core.async.t_cljs$core$async25422.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async25422");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async25422 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25422(f__$1,ch__$1,meta25420__$1,___$2,fn1__$1,meta25423){
return (new cljs.core.async.t_cljs$core$async25422(f__$1,ch__$1,meta25420__$1,___$2,fn1__$1,meta25423));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async25422(self__.f,self__.ch,self__.meta25420,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__20273__auto__ = ret;
if(cljs.core.truth_(and__20273__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__20273__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async25419.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25419.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async25419.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25420","meta25420",-1605182175,null)], null);
});

cljs.core.async.t_cljs$core$async25419.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25419.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25419";

cljs.core.async.t_cljs$core$async25419.cljs$lang$ctorPrWriter = (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async25419");
});

cljs.core.async.__GT_t_cljs$core$async25419 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async25419(f__$1,ch__$1,meta25420){
return (new cljs.core.async.t_cljs$core$async25419(f__$1,ch__$1,meta25420));
});

}

return (new cljs.core.async.t_cljs$core$async25419(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async25428 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25428 = (function (f,ch,meta25429){
this.f = f;
this.ch = ch;
this.meta25429 = meta25429;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25428.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25430,meta25429__$1){
var self__ = this;
var _25430__$1 = this;
return (new cljs.core.async.t_cljs$core$async25428(self__.f,self__.ch,meta25429__$1));
});

cljs.core.async.t_cljs$core$async25428.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25430){
var self__ = this;
var _25430__$1 = this;
return self__.meta25429;
});

cljs.core.async.t_cljs$core$async25428.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25428.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25428.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25428.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25428.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25428.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async25428.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25429","meta25429",1909378109,null)], null);
});

cljs.core.async.t_cljs$core$async25428.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25428.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25428";

cljs.core.async.t_cljs$core$async25428.cljs$lang$ctorPrWriter = (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async25428");
});

cljs.core.async.__GT_t_cljs$core$async25428 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async25428(f__$1,ch__$1,meta25429){
return (new cljs.core.async.t_cljs$core$async25428(f__$1,ch__$1,meta25429));
});

}

return (new cljs.core.async.t_cljs$core$async25428(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async25434 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25434 = (function (p,ch,meta25435){
this.p = p;
this.ch = ch;
this.meta25435 = meta25435;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async25434.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25436,meta25435__$1){
var self__ = this;
var _25436__$1 = this;
return (new cljs.core.async.t_cljs$core$async25434(self__.p,self__.ch,meta25435__$1));
});

cljs.core.async.t_cljs$core$async25434.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25436){
var self__ = this;
var _25436__$1 = this;
return self__.meta25435;
});

cljs.core.async.t_cljs$core$async25434.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25434.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25434.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async25434.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25434.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async25434.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25434.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async25434.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta25435","meta25435",882859023,null)], null);
});

cljs.core.async.t_cljs$core$async25434.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25434.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25434";

cljs.core.async.t_cljs$core$async25434.cljs$lang$ctorPrWriter = (function (this__20891__auto__,writer__20892__auto__,opt__20893__auto__){
return cljs.core._write.call(null,writer__20892__auto__,"cljs.core.async/t_cljs$core$async25434");
});

cljs.core.async.__GT_t_cljs$core$async25434 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async25434(p__$1,ch__$1,meta25435){
return (new cljs.core.async.t_cljs$core$async25434(p__$1,ch__$1,meta25435));
});

}

return (new cljs.core.async.t_cljs$core$async25434(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args25437 = [];
var len__21393__auto___25481 = arguments.length;
var i__21394__auto___25482 = (0);
while(true){
if((i__21394__auto___25482 < len__21393__auto___25481)){
args25437.push((arguments[i__21394__auto___25482]));

var G__25483 = (i__21394__auto___25482 + (1));
i__21394__auto___25482 = G__25483;
continue;
} else {
}
break;
}

var G__25439 = args25437.length;
switch (G__25439) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25437.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23179__auto___25485 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___25485,out){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___25485,out){
return (function (state_25460){
var state_val_25461 = (state_25460[(1)]);
if((state_val_25461 === (7))){
var inst_25456 = (state_25460[(2)]);
var state_25460__$1 = state_25460;
var statearr_25462_25486 = state_25460__$1;
(statearr_25462_25486[(2)] = inst_25456);

(statearr_25462_25486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25461 === (1))){
var state_25460__$1 = state_25460;
var statearr_25463_25487 = state_25460__$1;
(statearr_25463_25487[(2)] = null);

(statearr_25463_25487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25461 === (4))){
var inst_25442 = (state_25460[(7)]);
var inst_25442__$1 = (state_25460[(2)]);
var inst_25443 = (inst_25442__$1 == null);
var state_25460__$1 = (function (){var statearr_25464 = state_25460;
(statearr_25464[(7)] = inst_25442__$1);

return statearr_25464;
})();
if(cljs.core.truth_(inst_25443)){
var statearr_25465_25488 = state_25460__$1;
(statearr_25465_25488[(1)] = (5));

} else {
var statearr_25466_25489 = state_25460__$1;
(statearr_25466_25489[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25461 === (6))){
var inst_25442 = (state_25460[(7)]);
var inst_25447 = p.call(null,inst_25442);
var state_25460__$1 = state_25460;
if(cljs.core.truth_(inst_25447)){
var statearr_25467_25490 = state_25460__$1;
(statearr_25467_25490[(1)] = (8));

} else {
var statearr_25468_25491 = state_25460__$1;
(statearr_25468_25491[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25461 === (3))){
var inst_25458 = (state_25460[(2)]);
var state_25460__$1 = state_25460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25460__$1,inst_25458);
} else {
if((state_val_25461 === (2))){
var state_25460__$1 = state_25460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25460__$1,(4),ch);
} else {
if((state_val_25461 === (11))){
var inst_25450 = (state_25460[(2)]);
var state_25460__$1 = state_25460;
var statearr_25469_25492 = state_25460__$1;
(statearr_25469_25492[(2)] = inst_25450);

(statearr_25469_25492[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25461 === (9))){
var state_25460__$1 = state_25460;
var statearr_25470_25493 = state_25460__$1;
(statearr_25470_25493[(2)] = null);

(statearr_25470_25493[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25461 === (5))){
var inst_25445 = cljs.core.async.close_BANG_.call(null,out);
var state_25460__$1 = state_25460;
var statearr_25471_25494 = state_25460__$1;
(statearr_25471_25494[(2)] = inst_25445);

(statearr_25471_25494[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25461 === (10))){
var inst_25453 = (state_25460[(2)]);
var state_25460__$1 = (function (){var statearr_25472 = state_25460;
(statearr_25472[(8)] = inst_25453);

return statearr_25472;
})();
var statearr_25473_25495 = state_25460__$1;
(statearr_25473_25495[(2)] = null);

(statearr_25473_25495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25461 === (8))){
var inst_25442 = (state_25460[(7)]);
var state_25460__$1 = state_25460;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25460__$1,(11),out,inst_25442);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___25485,out))
;
return ((function (switch__22336__auto__,c__23179__auto___25485,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25477 = [null,null,null,null,null,null,null,null,null];
(statearr_25477[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25477[(1)] = (1));

return statearr_25477;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25460){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25478){if((e25478 instanceof Object)){
var ex__22340__auto__ = e25478;
var statearr_25479_25496 = state_25460;
(statearr_25479_25496[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25460);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25478;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25497 = state_25460;
state_25460 = G__25497;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25460){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___25485,out))
})();
var state__23181__auto__ = (function (){var statearr_25480 = f__23180__auto__.call(null);
(statearr_25480[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___25485);

return statearr_25480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___25485,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args25498 = [];
var len__21393__auto___25501 = arguments.length;
var i__21394__auto___25502 = (0);
while(true){
if((i__21394__auto___25502 < len__21393__auto___25501)){
args25498.push((arguments[i__21394__auto___25502]));

var G__25503 = (i__21394__auto___25502 + (1));
i__21394__auto___25502 = G__25503;
continue;
} else {
}
break;
}

var G__25500 = args25498.length;
switch (G__25500) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25498.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__23179__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto__){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto__){
return (function (state_25670){
var state_val_25671 = (state_25670[(1)]);
if((state_val_25671 === (7))){
var inst_25666 = (state_25670[(2)]);
var state_25670__$1 = state_25670;
var statearr_25672_25713 = state_25670__$1;
(statearr_25672_25713[(2)] = inst_25666);

(statearr_25672_25713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (20))){
var inst_25636 = (state_25670[(7)]);
var inst_25647 = (state_25670[(2)]);
var inst_25648 = cljs.core.next.call(null,inst_25636);
var inst_25622 = inst_25648;
var inst_25623 = null;
var inst_25624 = (0);
var inst_25625 = (0);
var state_25670__$1 = (function (){var statearr_25673 = state_25670;
(statearr_25673[(8)] = inst_25622);

(statearr_25673[(9)] = inst_25647);

(statearr_25673[(10)] = inst_25624);

(statearr_25673[(11)] = inst_25623);

(statearr_25673[(12)] = inst_25625);

return statearr_25673;
})();
var statearr_25674_25714 = state_25670__$1;
(statearr_25674_25714[(2)] = null);

(statearr_25674_25714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (1))){
var state_25670__$1 = state_25670;
var statearr_25675_25715 = state_25670__$1;
(statearr_25675_25715[(2)] = null);

(statearr_25675_25715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (4))){
var inst_25611 = (state_25670[(13)]);
var inst_25611__$1 = (state_25670[(2)]);
var inst_25612 = (inst_25611__$1 == null);
var state_25670__$1 = (function (){var statearr_25676 = state_25670;
(statearr_25676[(13)] = inst_25611__$1);

return statearr_25676;
})();
if(cljs.core.truth_(inst_25612)){
var statearr_25677_25716 = state_25670__$1;
(statearr_25677_25716[(1)] = (5));

} else {
var statearr_25678_25717 = state_25670__$1;
(statearr_25678_25717[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (15))){
var state_25670__$1 = state_25670;
var statearr_25682_25718 = state_25670__$1;
(statearr_25682_25718[(2)] = null);

(statearr_25682_25718[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (21))){
var state_25670__$1 = state_25670;
var statearr_25683_25719 = state_25670__$1;
(statearr_25683_25719[(2)] = null);

(statearr_25683_25719[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (13))){
var inst_25622 = (state_25670[(8)]);
var inst_25624 = (state_25670[(10)]);
var inst_25623 = (state_25670[(11)]);
var inst_25625 = (state_25670[(12)]);
var inst_25632 = (state_25670[(2)]);
var inst_25633 = (inst_25625 + (1));
var tmp25679 = inst_25622;
var tmp25680 = inst_25624;
var tmp25681 = inst_25623;
var inst_25622__$1 = tmp25679;
var inst_25623__$1 = tmp25681;
var inst_25624__$1 = tmp25680;
var inst_25625__$1 = inst_25633;
var state_25670__$1 = (function (){var statearr_25684 = state_25670;
(statearr_25684[(8)] = inst_25622__$1);

(statearr_25684[(10)] = inst_25624__$1);

(statearr_25684[(14)] = inst_25632);

(statearr_25684[(11)] = inst_25623__$1);

(statearr_25684[(12)] = inst_25625__$1);

return statearr_25684;
})();
var statearr_25685_25720 = state_25670__$1;
(statearr_25685_25720[(2)] = null);

(statearr_25685_25720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (22))){
var state_25670__$1 = state_25670;
var statearr_25686_25721 = state_25670__$1;
(statearr_25686_25721[(2)] = null);

(statearr_25686_25721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (6))){
var inst_25611 = (state_25670[(13)]);
var inst_25620 = f.call(null,inst_25611);
var inst_25621 = cljs.core.seq.call(null,inst_25620);
var inst_25622 = inst_25621;
var inst_25623 = null;
var inst_25624 = (0);
var inst_25625 = (0);
var state_25670__$1 = (function (){var statearr_25687 = state_25670;
(statearr_25687[(8)] = inst_25622);

(statearr_25687[(10)] = inst_25624);

(statearr_25687[(11)] = inst_25623);

(statearr_25687[(12)] = inst_25625);

return statearr_25687;
})();
var statearr_25688_25722 = state_25670__$1;
(statearr_25688_25722[(2)] = null);

(statearr_25688_25722[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (17))){
var inst_25636 = (state_25670[(7)]);
var inst_25640 = cljs.core.chunk_first.call(null,inst_25636);
var inst_25641 = cljs.core.chunk_rest.call(null,inst_25636);
var inst_25642 = cljs.core.count.call(null,inst_25640);
var inst_25622 = inst_25641;
var inst_25623 = inst_25640;
var inst_25624 = inst_25642;
var inst_25625 = (0);
var state_25670__$1 = (function (){var statearr_25689 = state_25670;
(statearr_25689[(8)] = inst_25622);

(statearr_25689[(10)] = inst_25624);

(statearr_25689[(11)] = inst_25623);

(statearr_25689[(12)] = inst_25625);

return statearr_25689;
})();
var statearr_25690_25723 = state_25670__$1;
(statearr_25690_25723[(2)] = null);

(statearr_25690_25723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (3))){
var inst_25668 = (state_25670[(2)]);
var state_25670__$1 = state_25670;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25670__$1,inst_25668);
} else {
if((state_val_25671 === (12))){
var inst_25656 = (state_25670[(2)]);
var state_25670__$1 = state_25670;
var statearr_25691_25724 = state_25670__$1;
(statearr_25691_25724[(2)] = inst_25656);

(statearr_25691_25724[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (2))){
var state_25670__$1 = state_25670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25670__$1,(4),in$);
} else {
if((state_val_25671 === (23))){
var inst_25664 = (state_25670[(2)]);
var state_25670__$1 = state_25670;
var statearr_25692_25725 = state_25670__$1;
(statearr_25692_25725[(2)] = inst_25664);

(statearr_25692_25725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (19))){
var inst_25651 = (state_25670[(2)]);
var state_25670__$1 = state_25670;
var statearr_25693_25726 = state_25670__$1;
(statearr_25693_25726[(2)] = inst_25651);

(statearr_25693_25726[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (11))){
var inst_25622 = (state_25670[(8)]);
var inst_25636 = (state_25670[(7)]);
var inst_25636__$1 = cljs.core.seq.call(null,inst_25622);
var state_25670__$1 = (function (){var statearr_25694 = state_25670;
(statearr_25694[(7)] = inst_25636__$1);

return statearr_25694;
})();
if(inst_25636__$1){
var statearr_25695_25727 = state_25670__$1;
(statearr_25695_25727[(1)] = (14));

} else {
var statearr_25696_25728 = state_25670__$1;
(statearr_25696_25728[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (9))){
var inst_25658 = (state_25670[(2)]);
var inst_25659 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_25670__$1 = (function (){var statearr_25697 = state_25670;
(statearr_25697[(15)] = inst_25658);

return statearr_25697;
})();
if(cljs.core.truth_(inst_25659)){
var statearr_25698_25729 = state_25670__$1;
(statearr_25698_25729[(1)] = (21));

} else {
var statearr_25699_25730 = state_25670__$1;
(statearr_25699_25730[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (5))){
var inst_25614 = cljs.core.async.close_BANG_.call(null,out);
var state_25670__$1 = state_25670;
var statearr_25700_25731 = state_25670__$1;
(statearr_25700_25731[(2)] = inst_25614);

(statearr_25700_25731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (14))){
var inst_25636 = (state_25670[(7)]);
var inst_25638 = cljs.core.chunked_seq_QMARK_.call(null,inst_25636);
var state_25670__$1 = state_25670;
if(inst_25638){
var statearr_25701_25732 = state_25670__$1;
(statearr_25701_25732[(1)] = (17));

} else {
var statearr_25702_25733 = state_25670__$1;
(statearr_25702_25733[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (16))){
var inst_25654 = (state_25670[(2)]);
var state_25670__$1 = state_25670;
var statearr_25703_25734 = state_25670__$1;
(statearr_25703_25734[(2)] = inst_25654);

(statearr_25703_25734[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25671 === (10))){
var inst_25623 = (state_25670[(11)]);
var inst_25625 = (state_25670[(12)]);
var inst_25630 = cljs.core._nth.call(null,inst_25623,inst_25625);
var state_25670__$1 = state_25670;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25670__$1,(13),out,inst_25630);
} else {
if((state_val_25671 === (18))){
var inst_25636 = (state_25670[(7)]);
var inst_25645 = cljs.core.first.call(null,inst_25636);
var state_25670__$1 = state_25670;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25670__$1,(20),out,inst_25645);
} else {
if((state_val_25671 === (8))){
var inst_25624 = (state_25670[(10)]);
var inst_25625 = (state_25670[(12)]);
var inst_25627 = (inst_25625 < inst_25624);
var inst_25628 = inst_25627;
var state_25670__$1 = state_25670;
if(cljs.core.truth_(inst_25628)){
var statearr_25704_25735 = state_25670__$1;
(statearr_25704_25735[(1)] = (10));

} else {
var statearr_25705_25736 = state_25670__$1;
(statearr_25705_25736[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto__))
;
return ((function (switch__22336__auto__,c__23179__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____0 = (function (){
var statearr_25709 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25709[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__);

(statearr_25709[(1)] = (1));

return statearr_25709;
});
var cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____1 = (function (state_25670){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25670);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25710){if((e25710 instanceof Object)){
var ex__22340__auto__ = e25710;
var statearr_25711_25737 = state_25670;
(statearr_25711_25737[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25670);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25710;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25738 = state_25670;
state_25670 = G__25738;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__ = function(state_25670){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____1.call(this,state_25670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__22337__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto__))
})();
var state__23181__auto__ = (function (){var statearr_25712 = f__23180__auto__.call(null);
(statearr_25712[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto__);

return statearr_25712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto__))
);

return c__23179__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args25739 = [];
var len__21393__auto___25742 = arguments.length;
var i__21394__auto___25743 = (0);
while(true){
if((i__21394__auto___25743 < len__21393__auto___25742)){
args25739.push((arguments[i__21394__auto___25743]));

var G__25744 = (i__21394__auto___25743 + (1));
i__21394__auto___25743 = G__25744;
continue;
} else {
}
break;
}

var G__25741 = args25739.length;
switch (G__25741) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25739.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args25746 = [];
var len__21393__auto___25749 = arguments.length;
var i__21394__auto___25750 = (0);
while(true){
if((i__21394__auto___25750 < len__21393__auto___25749)){
args25746.push((arguments[i__21394__auto___25750]));

var G__25751 = (i__21394__auto___25750 + (1));
i__21394__auto___25750 = G__25751;
continue;
} else {
}
break;
}

var G__25748 = args25746.length;
switch (G__25748) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25746.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args25753 = [];
var len__21393__auto___25804 = arguments.length;
var i__21394__auto___25805 = (0);
while(true){
if((i__21394__auto___25805 < len__21393__auto___25804)){
args25753.push((arguments[i__21394__auto___25805]));

var G__25806 = (i__21394__auto___25805 + (1));
i__21394__auto___25805 = G__25806;
continue;
} else {
}
break;
}

var G__25755 = args25753.length;
switch (G__25755) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25753.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23179__auto___25808 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___25808,out){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___25808,out){
return (function (state_25779){
var state_val_25780 = (state_25779[(1)]);
if((state_val_25780 === (7))){
var inst_25774 = (state_25779[(2)]);
var state_25779__$1 = state_25779;
var statearr_25781_25809 = state_25779__$1;
(statearr_25781_25809[(2)] = inst_25774);

(statearr_25781_25809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25780 === (1))){
var inst_25756 = null;
var state_25779__$1 = (function (){var statearr_25782 = state_25779;
(statearr_25782[(7)] = inst_25756);

return statearr_25782;
})();
var statearr_25783_25810 = state_25779__$1;
(statearr_25783_25810[(2)] = null);

(statearr_25783_25810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25780 === (4))){
var inst_25759 = (state_25779[(8)]);
var inst_25759__$1 = (state_25779[(2)]);
var inst_25760 = (inst_25759__$1 == null);
var inst_25761 = cljs.core.not.call(null,inst_25760);
var state_25779__$1 = (function (){var statearr_25784 = state_25779;
(statearr_25784[(8)] = inst_25759__$1);

return statearr_25784;
})();
if(inst_25761){
var statearr_25785_25811 = state_25779__$1;
(statearr_25785_25811[(1)] = (5));

} else {
var statearr_25786_25812 = state_25779__$1;
(statearr_25786_25812[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25780 === (6))){
var state_25779__$1 = state_25779;
var statearr_25787_25813 = state_25779__$1;
(statearr_25787_25813[(2)] = null);

(statearr_25787_25813[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25780 === (3))){
var inst_25776 = (state_25779[(2)]);
var inst_25777 = cljs.core.async.close_BANG_.call(null,out);
var state_25779__$1 = (function (){var statearr_25788 = state_25779;
(statearr_25788[(9)] = inst_25776);

return statearr_25788;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25779__$1,inst_25777);
} else {
if((state_val_25780 === (2))){
var state_25779__$1 = state_25779;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25779__$1,(4),ch);
} else {
if((state_val_25780 === (11))){
var inst_25759 = (state_25779[(8)]);
var inst_25768 = (state_25779[(2)]);
var inst_25756 = inst_25759;
var state_25779__$1 = (function (){var statearr_25789 = state_25779;
(statearr_25789[(7)] = inst_25756);

(statearr_25789[(10)] = inst_25768);

return statearr_25789;
})();
var statearr_25790_25814 = state_25779__$1;
(statearr_25790_25814[(2)] = null);

(statearr_25790_25814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25780 === (9))){
var inst_25759 = (state_25779[(8)]);
var state_25779__$1 = state_25779;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25779__$1,(11),out,inst_25759);
} else {
if((state_val_25780 === (5))){
var inst_25756 = (state_25779[(7)]);
var inst_25759 = (state_25779[(8)]);
var inst_25763 = cljs.core._EQ_.call(null,inst_25759,inst_25756);
var state_25779__$1 = state_25779;
if(inst_25763){
var statearr_25792_25815 = state_25779__$1;
(statearr_25792_25815[(1)] = (8));

} else {
var statearr_25793_25816 = state_25779__$1;
(statearr_25793_25816[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25780 === (10))){
var inst_25771 = (state_25779[(2)]);
var state_25779__$1 = state_25779;
var statearr_25794_25817 = state_25779__$1;
(statearr_25794_25817[(2)] = inst_25771);

(statearr_25794_25817[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25780 === (8))){
var inst_25756 = (state_25779[(7)]);
var tmp25791 = inst_25756;
var inst_25756__$1 = tmp25791;
var state_25779__$1 = (function (){var statearr_25795 = state_25779;
(statearr_25795[(7)] = inst_25756__$1);

return statearr_25795;
})();
var statearr_25796_25818 = state_25779__$1;
(statearr_25796_25818[(2)] = null);

(statearr_25796_25818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___25808,out))
;
return ((function (switch__22336__auto__,c__23179__auto___25808,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25800 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25800[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25800[(1)] = (1));

return statearr_25800;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25779){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25779);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25801){if((e25801 instanceof Object)){
var ex__22340__auto__ = e25801;
var statearr_25802_25819 = state_25779;
(statearr_25802_25819[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25779);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25801;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25820 = state_25779;
state_25779 = G__25820;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25779){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___25808,out))
})();
var state__23181__auto__ = (function (){var statearr_25803 = f__23180__auto__.call(null);
(statearr_25803[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___25808);

return statearr_25803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___25808,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args25821 = [];
var len__21393__auto___25891 = arguments.length;
var i__21394__auto___25892 = (0);
while(true){
if((i__21394__auto___25892 < len__21393__auto___25891)){
args25821.push((arguments[i__21394__auto___25892]));

var G__25893 = (i__21394__auto___25892 + (1));
i__21394__auto___25892 = G__25893;
continue;
} else {
}
break;
}

var G__25823 = args25821.length;
switch (G__25823) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25821.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23179__auto___25895 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___25895,out){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___25895,out){
return (function (state_25861){
var state_val_25862 = (state_25861[(1)]);
if((state_val_25862 === (7))){
var inst_25857 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25863_25896 = state_25861__$1;
(statearr_25863_25896[(2)] = inst_25857);

(statearr_25863_25896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (1))){
var inst_25824 = (new Array(n));
var inst_25825 = inst_25824;
var inst_25826 = (0);
var state_25861__$1 = (function (){var statearr_25864 = state_25861;
(statearr_25864[(7)] = inst_25826);

(statearr_25864[(8)] = inst_25825);

return statearr_25864;
})();
var statearr_25865_25897 = state_25861__$1;
(statearr_25865_25897[(2)] = null);

(statearr_25865_25897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (4))){
var inst_25829 = (state_25861[(9)]);
var inst_25829__$1 = (state_25861[(2)]);
var inst_25830 = (inst_25829__$1 == null);
var inst_25831 = cljs.core.not.call(null,inst_25830);
var state_25861__$1 = (function (){var statearr_25866 = state_25861;
(statearr_25866[(9)] = inst_25829__$1);

return statearr_25866;
})();
if(inst_25831){
var statearr_25867_25898 = state_25861__$1;
(statearr_25867_25898[(1)] = (5));

} else {
var statearr_25868_25899 = state_25861__$1;
(statearr_25868_25899[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (15))){
var inst_25851 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25869_25900 = state_25861__$1;
(statearr_25869_25900[(2)] = inst_25851);

(statearr_25869_25900[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (13))){
var state_25861__$1 = state_25861;
var statearr_25870_25901 = state_25861__$1;
(statearr_25870_25901[(2)] = null);

(statearr_25870_25901[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (6))){
var inst_25826 = (state_25861[(7)]);
var inst_25847 = (inst_25826 > (0));
var state_25861__$1 = state_25861;
if(cljs.core.truth_(inst_25847)){
var statearr_25871_25902 = state_25861__$1;
(statearr_25871_25902[(1)] = (12));

} else {
var statearr_25872_25903 = state_25861__$1;
(statearr_25872_25903[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (3))){
var inst_25859 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25861__$1,inst_25859);
} else {
if((state_val_25862 === (12))){
var inst_25825 = (state_25861[(8)]);
var inst_25849 = cljs.core.vec.call(null,inst_25825);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25861__$1,(15),out,inst_25849);
} else {
if((state_val_25862 === (2))){
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25861__$1,(4),ch);
} else {
if((state_val_25862 === (11))){
var inst_25841 = (state_25861[(2)]);
var inst_25842 = (new Array(n));
var inst_25825 = inst_25842;
var inst_25826 = (0);
var state_25861__$1 = (function (){var statearr_25873 = state_25861;
(statearr_25873[(7)] = inst_25826);

(statearr_25873[(10)] = inst_25841);

(statearr_25873[(8)] = inst_25825);

return statearr_25873;
})();
var statearr_25874_25904 = state_25861__$1;
(statearr_25874_25904[(2)] = null);

(statearr_25874_25904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (9))){
var inst_25825 = (state_25861[(8)]);
var inst_25839 = cljs.core.vec.call(null,inst_25825);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25861__$1,(11),out,inst_25839);
} else {
if((state_val_25862 === (5))){
var inst_25826 = (state_25861[(7)]);
var inst_25829 = (state_25861[(9)]);
var inst_25834 = (state_25861[(11)]);
var inst_25825 = (state_25861[(8)]);
var inst_25833 = (inst_25825[inst_25826] = inst_25829);
var inst_25834__$1 = (inst_25826 + (1));
var inst_25835 = (inst_25834__$1 < n);
var state_25861__$1 = (function (){var statearr_25875 = state_25861;
(statearr_25875[(12)] = inst_25833);

(statearr_25875[(11)] = inst_25834__$1);

return statearr_25875;
})();
if(cljs.core.truth_(inst_25835)){
var statearr_25876_25905 = state_25861__$1;
(statearr_25876_25905[(1)] = (8));

} else {
var statearr_25877_25906 = state_25861__$1;
(statearr_25877_25906[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (14))){
var inst_25854 = (state_25861[(2)]);
var inst_25855 = cljs.core.async.close_BANG_.call(null,out);
var state_25861__$1 = (function (){var statearr_25879 = state_25861;
(statearr_25879[(13)] = inst_25854);

return statearr_25879;
})();
var statearr_25880_25907 = state_25861__$1;
(statearr_25880_25907[(2)] = inst_25855);

(statearr_25880_25907[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (10))){
var inst_25845 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25881_25908 = state_25861__$1;
(statearr_25881_25908[(2)] = inst_25845);

(statearr_25881_25908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (8))){
var inst_25834 = (state_25861[(11)]);
var inst_25825 = (state_25861[(8)]);
var tmp25878 = inst_25825;
var inst_25825__$1 = tmp25878;
var inst_25826 = inst_25834;
var state_25861__$1 = (function (){var statearr_25882 = state_25861;
(statearr_25882[(7)] = inst_25826);

(statearr_25882[(8)] = inst_25825__$1);

return statearr_25882;
})();
var statearr_25883_25909 = state_25861__$1;
(statearr_25883_25909[(2)] = null);

(statearr_25883_25909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___25895,out))
;
return ((function (switch__22336__auto__,c__23179__auto___25895,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25887[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25887[(1)] = (1));

return statearr_25887;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25861){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25861);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25888){if((e25888 instanceof Object)){
var ex__22340__auto__ = e25888;
var statearr_25889_25910 = state_25861;
(statearr_25889_25910[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25861);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25888;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25911 = state_25861;
state_25861 = G__25911;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25861){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___25895,out))
})();
var state__23181__auto__ = (function (){var statearr_25890 = f__23180__auto__.call(null);
(statearr_25890[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___25895);

return statearr_25890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___25895,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args25912 = [];
var len__21393__auto___25986 = arguments.length;
var i__21394__auto___25987 = (0);
while(true){
if((i__21394__auto___25987 < len__21393__auto___25986)){
args25912.push((arguments[i__21394__auto___25987]));

var G__25988 = (i__21394__auto___25987 + (1));
i__21394__auto___25987 = G__25988;
continue;
} else {
}
break;
}

var G__25914 = args25912.length;
switch (G__25914) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25912.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__23179__auto___25990 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23179__auto___25990,out){
return (function (){
var f__23180__auto__ = (function (){var switch__22336__auto__ = ((function (c__23179__auto___25990,out){
return (function (state_25956){
var state_val_25957 = (state_25956[(1)]);
if((state_val_25957 === (7))){
var inst_25952 = (state_25956[(2)]);
var state_25956__$1 = state_25956;
var statearr_25958_25991 = state_25956__$1;
(statearr_25958_25991[(2)] = inst_25952);

(statearr_25958_25991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (1))){
var inst_25915 = [];
var inst_25916 = inst_25915;
var inst_25917 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_25956__$1 = (function (){var statearr_25959 = state_25956;
(statearr_25959[(7)] = inst_25917);

(statearr_25959[(8)] = inst_25916);

return statearr_25959;
})();
var statearr_25960_25992 = state_25956__$1;
(statearr_25960_25992[(2)] = null);

(statearr_25960_25992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (4))){
var inst_25920 = (state_25956[(9)]);
var inst_25920__$1 = (state_25956[(2)]);
var inst_25921 = (inst_25920__$1 == null);
var inst_25922 = cljs.core.not.call(null,inst_25921);
var state_25956__$1 = (function (){var statearr_25961 = state_25956;
(statearr_25961[(9)] = inst_25920__$1);

return statearr_25961;
})();
if(inst_25922){
var statearr_25962_25993 = state_25956__$1;
(statearr_25962_25993[(1)] = (5));

} else {
var statearr_25963_25994 = state_25956__$1;
(statearr_25963_25994[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (15))){
var inst_25946 = (state_25956[(2)]);
var state_25956__$1 = state_25956;
var statearr_25964_25995 = state_25956__$1;
(statearr_25964_25995[(2)] = inst_25946);

(statearr_25964_25995[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (13))){
var state_25956__$1 = state_25956;
var statearr_25965_25996 = state_25956__$1;
(statearr_25965_25996[(2)] = null);

(statearr_25965_25996[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (6))){
var inst_25916 = (state_25956[(8)]);
var inst_25941 = inst_25916.length;
var inst_25942 = (inst_25941 > (0));
var state_25956__$1 = state_25956;
if(cljs.core.truth_(inst_25942)){
var statearr_25966_25997 = state_25956__$1;
(statearr_25966_25997[(1)] = (12));

} else {
var statearr_25967_25998 = state_25956__$1;
(statearr_25967_25998[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (3))){
var inst_25954 = (state_25956[(2)]);
var state_25956__$1 = state_25956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25956__$1,inst_25954);
} else {
if((state_val_25957 === (12))){
var inst_25916 = (state_25956[(8)]);
var inst_25944 = cljs.core.vec.call(null,inst_25916);
var state_25956__$1 = state_25956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25956__$1,(15),out,inst_25944);
} else {
if((state_val_25957 === (2))){
var state_25956__$1 = state_25956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25956__$1,(4),ch);
} else {
if((state_val_25957 === (11))){
var inst_25920 = (state_25956[(9)]);
var inst_25924 = (state_25956[(10)]);
var inst_25934 = (state_25956[(2)]);
var inst_25935 = [];
var inst_25936 = inst_25935.push(inst_25920);
var inst_25916 = inst_25935;
var inst_25917 = inst_25924;
var state_25956__$1 = (function (){var statearr_25968 = state_25956;
(statearr_25968[(7)] = inst_25917);

(statearr_25968[(11)] = inst_25936);

(statearr_25968[(12)] = inst_25934);

(statearr_25968[(8)] = inst_25916);

return statearr_25968;
})();
var statearr_25969_25999 = state_25956__$1;
(statearr_25969_25999[(2)] = null);

(statearr_25969_25999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (9))){
var inst_25916 = (state_25956[(8)]);
var inst_25932 = cljs.core.vec.call(null,inst_25916);
var state_25956__$1 = state_25956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25956__$1,(11),out,inst_25932);
} else {
if((state_val_25957 === (5))){
var inst_25920 = (state_25956[(9)]);
var inst_25917 = (state_25956[(7)]);
var inst_25924 = (state_25956[(10)]);
var inst_25924__$1 = f.call(null,inst_25920);
var inst_25925 = cljs.core._EQ_.call(null,inst_25924__$1,inst_25917);
var inst_25926 = cljs.core.keyword_identical_QMARK_.call(null,inst_25917,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_25927 = (inst_25925) || (inst_25926);
var state_25956__$1 = (function (){var statearr_25970 = state_25956;
(statearr_25970[(10)] = inst_25924__$1);

return statearr_25970;
})();
if(cljs.core.truth_(inst_25927)){
var statearr_25971_26000 = state_25956__$1;
(statearr_25971_26000[(1)] = (8));

} else {
var statearr_25972_26001 = state_25956__$1;
(statearr_25972_26001[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (14))){
var inst_25949 = (state_25956[(2)]);
var inst_25950 = cljs.core.async.close_BANG_.call(null,out);
var state_25956__$1 = (function (){var statearr_25974 = state_25956;
(statearr_25974[(13)] = inst_25949);

return statearr_25974;
})();
var statearr_25975_26002 = state_25956__$1;
(statearr_25975_26002[(2)] = inst_25950);

(statearr_25975_26002[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (10))){
var inst_25939 = (state_25956[(2)]);
var state_25956__$1 = state_25956;
var statearr_25976_26003 = state_25956__$1;
(statearr_25976_26003[(2)] = inst_25939);

(statearr_25976_26003[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25957 === (8))){
var inst_25920 = (state_25956[(9)]);
var inst_25924 = (state_25956[(10)]);
var inst_25916 = (state_25956[(8)]);
var inst_25929 = inst_25916.push(inst_25920);
var tmp25973 = inst_25916;
var inst_25916__$1 = tmp25973;
var inst_25917 = inst_25924;
var state_25956__$1 = (function (){var statearr_25977 = state_25956;
(statearr_25977[(7)] = inst_25917);

(statearr_25977[(14)] = inst_25929);

(statearr_25977[(8)] = inst_25916__$1);

return statearr_25977;
})();
var statearr_25978_26004 = state_25956__$1;
(statearr_25978_26004[(2)] = null);

(statearr_25978_26004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23179__auto___25990,out))
;
return ((function (switch__22336__auto__,c__23179__auto___25990,out){
return (function() {
var cljs$core$async$state_machine__22337__auto__ = null;
var cljs$core$async$state_machine__22337__auto____0 = (function (){
var statearr_25982 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25982[(0)] = cljs$core$async$state_machine__22337__auto__);

(statearr_25982[(1)] = (1));

return statearr_25982;
});
var cljs$core$async$state_machine__22337__auto____1 = (function (state_25956){
while(true){
var ret_value__22338__auto__ = (function (){try{while(true){
var result__22339__auto__ = switch__22336__auto__.call(null,state_25956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__22339__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__22339__auto__;
}
break;
}
}catch (e25983){if((e25983 instanceof Object)){
var ex__22340__auto__ = e25983;
var statearr_25984_26005 = state_25956;
(statearr_25984_26005[(5)] = ex__22340__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25983;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__22338__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26006 = state_25956;
state_25956 = G__26006;
continue;
} else {
return ret_value__22338__auto__;
}
break;
}
});
cljs$core$async$state_machine__22337__auto__ = function(state_25956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__22337__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__22337__auto____1.call(this,state_25956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__22337__auto____0;
cljs$core$async$state_machine__22337__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__22337__auto____1;
return cljs$core$async$state_machine__22337__auto__;
})()
;})(switch__22336__auto__,c__23179__auto___25990,out))
})();
var state__23181__auto__ = (function (){var statearr_25985 = f__23180__auto__.call(null);
(statearr_25985[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__23179__auto___25990);

return statearr_25985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23181__auto__);
});})(c__23179__auto___25990,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1481743379311