# services

Bikeshedding Clojure service initialization fluff.

![](https://clojars.org/co.tomlee/services/latest-version.svg)

## Usage

    (ns my.app.services.http
      (:use aleph.http))

    (defn handler [ch req] ...)

    (defn start [conf]
      ;
      ; IMPORTANT: returns a function that can be used to stop the server!
      ;
      (start-http-server handler {:port (:port conf)}))

    (ns my.app
      (:use tomlee.services))

    (def conf {:port 1234
               :database {:db "foo_db"
                          :user "foo"}})

    (def my-services ['my.app.services.http])

    (defn failed-services [service-names]
      (System/exit 1))

    (defn -main [& args]
      ;
      ; N.B. failed-services callback is optional
      ;
      (start-services conf my-services failed-services))

## License

Copyright © 2014 Tom Lee

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
