(ns co.nclk.flax.main
  (:require [co.nclk.flax.core :refer :all :rename {evaluate e}]
            [clj-yaml.core :as yaml]))

(defn -main
  [& [file]]
  (let [srcs (-> file clojure.java.io/resource slurp yaml/parse-all e)]
    (->> srcs
      (reduce
        (fn [env src]
          (merge env (-> src (e env)))
          )
        {})
      clojure.pprint/pprint)
    ))
