;; Copyright © 2019, JUXT LTD.

(ns juxt.jinx.alpha.patterns)

(def addr-spec
  #"(?i)((?<localpart>^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+)@(?<domain>[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*))")

(def iaddr-spec
  #"(?i)((?<localpart>^[a-z0-9\x21\x23-\x27\x2A-\x2B\x2D\x2F\x3D\x3F\x5E-\x60\x7B-\x7E\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]+)@(?<domain>[a-z0-9\x21\x23-\x27\x2A-\x2B\x2D\x2F\x3D\x3F\x5E-\x60\x7B-\x7E\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef](?:[a-z0-9\x21\x23-\x27\x2A-\x2B\x2D\x2F\x3D\x3F\x5E-\x60\x7B-\x7E\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{0,61}[a-z0-9\x21\x23-\x27\x2A-\x2B\x2D\x2F\x3D\x3F\x5E-\x60\x7B-\x7E\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef])?(?:\.[a-z0-9\x21\x23-\x27\x2A-\x2B\x2D\x2F\x3D\x3F\x5E-\x60\x7B-\x7E\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef](?:[a-z0-9\x21\x23-\x27\x2A-\x2B\x2D\x2F\x3D\x3F\x5E-\x60\x7B-\x7E\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{0,61}[a-z0-9\x21\x23-\x27\x2A-\x2B\x2D\x2F\x3D\x3F\x5E-\x60\x7B-\x7E\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef])?)*))")

(def subdomain
  #"(?i)^[a-z\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef](?:[a-z0-9-\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{0,61}[a-z0-9\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef])?(?:\.[a-z0-9\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef](?:[a-z0-9-\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]{0,61}[a-z0-9\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef])?)*$")


(def IPv4address
  #"^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$")

(def IPv6address
  #"(?i)^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$")


(def URI
  #"(?i)^(?<scheme>[a-z][a-z0-9+\-.]*):(?://(?<authority>(?:(?<user>(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*)@)?(?:(?<host>\x5B(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\x5D|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*))?(?::(?<port>(?:\d*)))?)?)?(?<path>(?:/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?<query>(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*))?(?:#(?<fragment>(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*))?$")


(def relative-ref
  #"(?://(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-fA-F]+\.[A-Za-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=@]|%[0-9a-f]{2})+(?:/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)")



(def IRI
  #"(?i)^(?<scheme>[a-z][a-z0-9+\-.]*):(?://(?<authority>(?:(?<user>(?:[a-z0-9\-._~!$&'()*+,;=:\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]|%[0-9a-f]{2})*)@)?(?:(?<host>\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]|%[0-9a-f]{2})*))?(?::(?<port>(?:\d*)))?)?)?(?:(?<path>(?:/(?:[a-z0-9\x2D-\x2E\x5F\x7E\xA0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\x25[0-9a-f][0-9a-f]|[\x21\x24\x26-\x2C\x3B\x3D]|\x3A|\x40)*)*)|/(?:[a-z0-9\x2D-\x2E\x5F\x7E\xA0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\x25[0-9a-f][0-9a-f]|[\x21\x24[\x26-\x2C]\x3B\x3D]|\x3A|\x40)+(?:/(?:[a-z0-9\x2D-\x2E\x5F\x7E\xA0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\x25\d\d|[\x21\x24\x26-\x2C\x3B\x3D]|\x3A|\x40)*)*|(?:[a-z0-9\x2D-\x2E\x5F\x7E\xA0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\x25[0-9a-f][0-9a-f]|[\x21\x24\x26-\x2C\x3B\x3D]|\x3A|\x40)+(?:/(?:[a-z0-9\x2D-\x2E\x5F\x7E\xA0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\x25[0-9a-f][0-9a-f]|[\x21\x24[\x26-\x2C]\x3B\x3D]|\x3A|\x40)*)?)(?:\?(?<query>(?:[a-z0-9\-._~!$&'()*+,;=:@\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef/?]|%[0-9a-f]{2})*))?(?:#(?<fragment>(?:[a-z0-9\-._~!$&'()*+,;=:@\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef/?]|%[0-9a-f]{2})*))?")

(def irelative-ref
  #"(?i)(?://(?<authority>(?:(?<user>(?:[a-z0-9\-._~!$&'()*+,;=:\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]|%[0-9a-f]{2})*)@)?(?:(?<host>\x5B(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]+)\x5D|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]|%[0-9a-f]{2})*))?(?::(?<port>(?:\d*)))?)?)?(?<path>(?:/(?:[a-z0-9\-._~!$&'()*+,;=:@\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]|%[0-9a-f]{2})*)*|/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]|%[0-9a-f]{2})+(?:/(?:[a-z0-9\-._~!$&'()*+,;=:@\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]|%[0-9a-f]{2})+(?:/(?:[a-z0-9\-._~!$&'()*+,;=:@\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef]|%[0-9a-f]{2})*)*)(?:\?(?<query>(?:[a-z0-9\-._~!$&'()*+,;=:@\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef/?]|%[0-9a-f]{2})*))?(?:#(?<fragment>(?:[a-z0-9\-._~!$&'()*+,;=:@\x2d-\x2e\x5f\x7e\xa0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef/?]|%[0-9a-f]{2})*))?$")

(def json-pointer
  #"(?i)^(?:/(?:[a-z0-9+\u0000-\u001f\u007f\x20-\x2E\x3A-\x40\x5B-\x60\x7B-\x7D\x80-\uFFFF]|~0|~1)*)*$")

(def relative-json-pointer
  #"(?:0|[1-9][0-9]*)(?:#|(?:/(?:([^/~])|(~[01]))*)*)$")

(def iso-date-time
  #"(?i)^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d:\d\d)$")

(def iso-local-date
  #"^(\d\d\d\d)-(\d\d)-(\d\d)$")

(def iso-time
   #"(?i)^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d:\d\d)?$")

(defn parse
       "Parse a test string"
       [te instance]
       (case te
         "addr-spec-test"
         (if-let [[_ _ w n] (re-matches addr-spec instance)] [w n] "Not found")
         "iri-test"
         ;["http://user:password@example.com:8080/path/ererwer?query=value#fragment" "http" "user:password@example.com:8080" "user:password" "example.com" "8080" "/path/ererwer" "query=value" "fragment"]
         (if-let [[_ scheme _ user host port path query fragment] (re-matches IRI instance)] [scheme user host port path query fragment] "Not found")))
