/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.APersistentMap;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduceInit;
import clojure.lang.ISeq;
import clojure.lang.MapEntry;
import clojure.lang.PersistentArrayMap;
import clojure.lang.RT;
import clojure.lang.Util;
import ham_fisted.Casts;
import ham_fisted.IFnDef;
import ham_fisted.IMutList;
import ham_fisted.Reductions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class FastStruct
extends APersistentMap
implements IObj,
IReduceInit {
    public final Map slots;
    public final List vals;
    public final IPersistentMap ext;
    public final IPersistentMap meta;
    public final int sz;

    public FastStruct(IPersistentMap iPersistentMap, Map map, List list, IPersistentMap iPersistentMap2) {
        this.meta = iPersistentMap;
        this.ext = iPersistentMap2;
        this.slots = map;
        this.vals = list;
        this.sz = this.slots.size() + (this.ext == null ? 0 : this.ext.count());
    }

    public FastStruct(Map map, List list) {
        this((IPersistentMap)PersistentArrayMap.EMPTY, map, list, (IPersistentMap)PersistentArrayMap.EMPTY);
    }

    public int columnIndex(Object object) throws Exception {
        Object v = this.slots.get(object);
        if (v != null) {
            return RT.uncheckedIntCast(v);
        }
        throw new Exception("Key was not found");
    }

    public IObj withMeta(IPersistentMap iPersistentMap) {
        if (this.meta == iPersistentMap) {
            return this;
        }
        return new FastStruct(iPersistentMap, this.slots, this.vals, this.ext);
    }

    public IPersistentMap meta() {
        return this.meta;
    }

    public boolean containsKey(Object object) {
        return this.slots.containsKey(object) || this.ext.containsKey(object);
    }

    public IMapEntry entryAt(Object object) {
        Object v = this.slots.get(object);
        if (v != null) {
            return MapEntry.create((Object)object, this.vals.get(RT.uncheckedIntCast(v)));
        }
        return this.ext.entryAt(object);
    }

    public IPersistentMap assoc(Object object, Object object2) {
        Object v = this.slots.get(object);
        if (v != null) {
            int n = RT.uncheckedIntCast(v);
            ArrayList<Object> arrayList = new ArrayList<Object>(this.vals);
            arrayList.set(n, object2);
            return new FastStruct(this.meta, this.slots, Collections.unmodifiableList(arrayList), this.ext);
        }
        return new FastStruct(this.meta, this.slots, this.vals, this.ext.assoc(object, object2));
    }

    public Object valAt(Object object) {
        Object v = this.slots.get(object);
        if (v != null) {
            return this.vals.get((int)Casts.longCast(v));
        }
        return this.ext.valAt(object);
    }

    public Object valAt(Object object, Object object2) {
        Object v = this.slots.get(object);
        if (v != null) {
            return this.vals.get(RT.uncheckedIntCast(v));
        }
        return this.ext.valAt(object, object2);
    }

    public IPersistentMap assocEx(Object object, Object object2) {
        if (this.containsKey(object)) {
            throw Util.runtimeException((String)"Key already present");
        }
        return this.assoc(object, object2);
    }

    public IPersistentMap without(Object object) {
        if (this.slots.containsKey(object)) {
            LinkedHashMap linkedHashMap = new LinkedHashMap(this.slots);
            linkedHashMap.remove(object);
            return new FastStruct(this.meta, Collections.unmodifiableMap(linkedHashMap), this.vals, this.ext);
        }
        IPersistentMap iPersistentMap = this.ext.without(object);
        if (iPersistentMap == this.ext) {
            return this;
        }
        return new FastStruct(this.meta, this.slots, this.vals, iPersistentMap);
    }

    public Iterator iterator() {
        return new Iterator(){
            private Iterator ks;
            private Iterator extIter;
            {
                this.ks = FastStruct.this.slots.entrySet().iterator();
                this.extIter = FastStruct.this.ext == null ? null : FastStruct.this.ext.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.ks != null) {
                    if (this.ks.hasNext()) {
                        return true;
                    }
                    this.ks = null;
                }
                if (this.extIter != null) {
                    if (this.extIter.hasNext()) {
                        return true;
                    }
                    this.extIter = null;
                }
                return false;
            }

            public Object next() {
                if (this.ks != null) {
                    Map.Entry entry = (Map.Entry)this.ks.next();
                    int n = RT.uncheckedIntCast(entry.getValue());
                    return new MapEntry(entry.getKey(), FastStruct.this.vals.get(n));
                }
                if (this.extIter != null) {
                    return this.extIter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.sz;
    }

    public int count() {
        return this.sz;
    }

    public boolean equals(Object object) {
        return this.equiv(object);
    }

    public boolean equiv(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        if (object instanceof FastStruct && this.slots == ((FastStruct)((Object)object)).slots) {
            return Util.equiv((Object)this.vals, (Object)((FastStruct)((Object)object)).vals) && Util.equiv((Object)this.ext, (Object)((FastStruct)((Object)object)).ext);
        }
        for (Map.Entry entry : map.entrySet()) {
            Map.Entry entry2 = entry;
            IMapEntry iMapEntry = this.entryAt(entry2.getKey());
            if (iMapEntry != null && Util.equiv(entry2.getValue(), iMapEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    public ISeq seq() {
        return RT.chunkIteratorSeq((Iterator)this.iterator());
    }

    public IPersistentCollection empty() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.slots.size());
        for (int i = 0; i < this.slots.size(); ++i) {
            arrayList.add(null);
        }
        return new FastStruct(this.slots, arrayList);
    }

    public Object reduce(IFn iFn, Object object) {
        Iterator iterator = this.slots.entrySet().iterator();
        while (iterator.hasNext() && !RT.isReduced((Object)object)) {
            Map.Entry entry = iterator.next();
            long l = Casts.longCast(entry.getValue());
            object = iFn.invoke(object, (Object)new FMapEntry(entry.getKey(), this.vals.get((int)l)));
        }
        if (this.ext != null && !RT.isReduced((Object)object)) {
            return Reductions.serialReduction((IFn)iFn, (Object)object, (Object)this.ext);
        }
        return Reductions.unreduce((Object)object);
    }

    public static IFn createFactory(List list) {
        int n = list.size();
        if (n == 0) {
            throw new RuntimeException("No column names provided");
        }
        final LinkedHashMap linkedHashMap = new LinkedHashMap(n);
        for (int i = 0; i < n; ++i) {
            linkedHashMap.put(list.get(i), i);
        }
        final Map map = Collections.unmodifiableMap(linkedHashMap);
        if (list.size() != linkedHashMap.size()) {
            throw new RuntimeException("Duplicate colname name: " + String.valueOf(linkedHashMap));
        }
        return new IFnDef.OO(){

            public Object invoke(Object object) {
                if (!(object instanceof RandomAccess)) {
                    throw new RuntimeException("Values must be a random access list.");
                }
                List list = (List)object;
                if (linkedHashMap.size() != list.size()) {
                    throw new RuntimeException("Number of values: " + String.valueOf(list.size()) + " doesn't equal the number of keys: " + String.valueOf(linkedHashMap.size()));
                }
                return new FastStruct(map, list);
            }
        };
    }

    public static FastStruct createFromColumnNames(List list, List list2) {
        return (FastStruct)((Object)FastStruct.createFactory(list).invoke((Object)list2));
    }

    public static class FMapEntry
    implements IMutList,
    Map.Entry {
        public final Object k;
        public final Object v;
        int _hash;

        public FMapEntry(Object object, Object object2) {
            this.k = object;
            this.v = object2;
            this._hash = 0;
        }

        @Override
        public boolean equals(Object object) {
            return this.equiv(object);
        }

        @Override
        public int hashCode() {
            return this.hasheq();
        }

        public int hasheq() {
            if (this._hash == 0) {
                this._hash = super.hasheq();
            }
            return this._hash;
        }

        public Object setValue(Object object) {
            throw new RuntimeException("Cannot set value.");
        }

        public Object getKey() {
            return this.k;
        }

        public Object getValue() {
            return this.v;
        }

        public int size() {
            return 2;
        }

        public Object get(int n) {
            if (n == 0) {
                return this.k;
            }
            if (n == 1) {
                return this.v;
            }
            throw new RuntimeException("Index out of range: " + String.valueOf(n));
        }
    }
}

